document.addEventListener("DOMContentLoaded", () => {
  const products = [
    {
      id: 1,
      name: " Labortary Pliers ",
      category: "desk",
      price: "$45.00",
      shortDesc: "Handcrafted from solid American walnut.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 2,
      name: "Orthodontic Pliers",
      category: "desk",
      price: "$89.00",
      shortDesc: "Premium full-grain leather.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 3,
      name: "Podiatry Nail Nippers",
      category: "desk",
      price: "$65.00",
      shortDesc: "Solid machined brass.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 4,
      name: "Pen",
      category: "desk",
      price: "55.00",
      shortDesc: "Minimalist catch-all tray.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 5,
      name: "Pen",
      category: "desk",
      price: "120.00",
      shortDesc: "Ergonomic and stylish.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 6,
      name: "Pen",
      category: "tech",
      price: "25.00",
      shortDesc: "Absorbent merino wool felt.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 7,
      name: "Pen",
      category: "tech",
      price: "75.00",
      shortDesc: "Sleek and functional.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 8,
      name: "Pen",
      category: "tech",
      price: "40.00",
      shortDesc: "For small desk plants.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 9,
      name: "Pen",
      category: "tech",
      price: "35.00",
      shortDesc: "Wooden magnetic cable holders.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
    {
      id: 10,
      name: "Pen",
      category: "tech",
      price: "30.00",
      shortDesc: "For small office supplies.",
      longDesc:
        "Small, precise tools used to grip, bend, or hold materials during experiments or handling delicate lab equipment.",
      img: "https://img.freepik.com/premium-photo/nail-clippers-collection-isolated-white-background_42547-6019.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740"
    },
   
  ];

  const productGrid = document.getElementById("product-grid");
  const filterControls = document.getElementById("filter-controls");
  const galleryView = document.getElementById("product-gallery-view");
  const detailView = document.getElementById("product-detail-view");
  const detailContent = document.getElementById("detail-content");
  const backButton = document.getElementById("back-to-gallery");


  const renderProducts = (category = "all") => {
    productGrid.innerHTML = "";
    const filteredProducts = products.filter(
      (p) => category === "all" || p.category === category
    );

    filteredProducts.forEach((product) => {
      const card = document.createElement("article");
      card.className = "product-card";
      card.dataset.id = product.id;
      card.innerHTML = `
                        <div class="product-image-placeholder">
                        <img src=${product.img}>
                        </div>
                        <div class="product-info">
                            <span class="product-category">${
                              product.category === "desk"
                                ? "Medical Equipment"
                                : "IT Porducts"
                            }</span>
                            <h3 class="product-title">${product.name}</h3>
                            <p class="product-price">${product.price}</p>
                        </div>
                    `;
      productGrid.appendChild(card);
    });
  };

  const showDetailView = (productId) => {
    const product = products.find((p) => p.id == productId);
    if (!product) return;

    detailContent.innerHTML = `
                    <div class="detail-layout">
                        <div class="detail-image-placeholder">
                            <img src=${product.img} alt="${product.name} hight="70px">
                        </div>
                        <div class="detail-info">
                            <span class="product-category">${
                              product.category === "desk"
                                ? "Medical Equipment"
                                : "IT Porducts"
                            }</span>
                            <h2 class="product-title">${product.name}</h2>
                            <p class="product-price">${product.price}</p>
                            <p class="detail-description">${
                              product.longDesc
                            }</p>
                        </div>
                    </div>
                `;

    galleryView.classList.remove("active");
    detailView.classList.add("active");
    window.scrollTo(0, 0);
  };

  const showGalleryView = () => {
    detailView.classList.remove("active");
    galleryView.classList.add("active");
  };

  filterControls.addEventListener("click", (e) => {
    if (e.target.tagName === "BUTTON") {
      document.querySelector(".filter-btn.active").classList.remove("active");
      e.target.classList.add("active");
      renderProducts(e.target.dataset.category);
    }
  });

  productGrid.addEventListener("click", (e) => {
    const card = e.target.closest(".product-card");
    if (card) {
      showDetailView(card.dataset.id);
    }
  });

  backButton.addEventListener("click", showGalleryView);

  renderProducts();
});
