document.addEventListener("DOMContentLoaded", () => {
  const projectsData = {
    1: {
      category: "Communication Technology",
      title: "Teleconferencing System",
      overview:
        "Teleconferencing is a communication system that allows users in different locations to hold face-to-face meetings without being physically present. That project aims to develop or improve a system that supports video calls, audio communication, screen sharing, and file exchange over the internet.",
      solution:
        "We designed a teleconferencing platform that offers: <br>  ❖ High-quality video and audio <br> ❖ User-friendly interface <br> ❖ Screen sharing and chat options <br> ❖ Secure login & data encryption <br> ❖ Cross-platform compativility (mobile + desktop) <br> It is lightweight, fast, and ideal for organiztions needing a reliable virtual communication tool.",
    },
    2: {
      category: "Health Informatics",
      title: "TeleMedicine System",
      overview:
        "TeleMedicine is a digital platform that allows doctors andpatients to connect remotely using the internet. It helpsprovide medical consultations, diagnoses, and follow-upswithout visiting a hospital or clinic physically.",
      solution:
        'We designed a TeleMedicine  system that provides: <br> ❖ Secure doctor-patient vidio consultations <br> ❖ Patient registration & medical history management <br> ❖ Online appointment scheduling <br> ❖ Prescription generation and delivery <br> ❖ Real-time chat and notifications <br> ❖ Admin panel for managing doctors and patients <br> This systme reduces time, cost, and increases access to healthcare.',
    },
    3: {
      category: "IoT",
      title: " Smart Refrigerated Container System",
      overview:
        " Refrigerated container (also called reefers) are used totransport perishable goods like food, medicine, and chemicals.Temperature, humidity, and door access must be constantlymonitored to prevent spoilage or damage.",
      solution:
        "We developed a smart system that includes: <br> ❖ temperature & humidity sensors <br> ❖ GPS tracking <br> ❖ Real-time monitoring via web/mobile dashboard <br> ❖ Alert system if trmperature goes out of range <br> ❖ Data logging for analysis and reports <br> ❖ Solar-powered or battery-efficient hardware <br> Our solution improves safety, reduces spoilage, and ensures quality during transport.",
    },
  };

  const listView = document.getElementById("projects-list-view");
  const detailView = document.getElementById("project-detail-view");
  const detailWrapper = document.getElementById("detail-content-wrapper");
  const projectItems = document.querySelectorAll(".project-item");
  const backButton = document.getElementById("back-to-projects");

  const renderProjectDetails = (projectId) => {
    const data = projectsData[projectId];
    if (!data) return;

    detailWrapper.innerHTML = `
                    <header class="detail-header">
                        <div class="project-category">${data.category}</div>
                        <h2 class="project-title">${data.title}</h2>
                    </header>
                    <div class="detail-body">
                        <h3>Project Overview</h3>
                        <p>${data.overview}</p>
                        <h3>Our Solution</h3>
                        <p>${data.solution}</p>
                        <h3>Gallery</h3>
                        <div class="detail-gallery">
                            <div class="gallery-image"><img src="https://img.freepik.com/premium-vector/flat-3d-isometric-business-people-working-with-headset-call-center-service-customer-service-technical-support-concept_47328-842.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740" ></div>
                            <div class="gallery-image"><img src="https://img.freepik.com/premium-photo/customer-interaction-hub-with-integrated-feedback-collection-analysis-systems_995578-34158.jpg?ga=GA1.1.1298664766.1741234566&semt=ais_hybrid&w=740" </div>
                        </div>
                    </div>
                `;
  };

  const showDetailView = (projectId) => {
    renderProjectDetails(projectId);
    listView.classList.remove("active");
    detailView.classList.add("active");
    window.scrollTo(0, 0);
  };

  const showListView = () => {
    detailView.classList.remove("active");
    listView.classList.add("active");
  };

  projectItems.forEach((item) => {
    item.addEventListener("click", () => {
      showDetailView(item.dataset.projectId);
    });
  });

  backButton.addEventListener("click", showListView);
});
