<?php $__env->startSection("admin"); ?>
<div class="container-fluid pt-4 px-4">
    <div class="bg-light text-center rounded p-4">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h6 class="mb-0">Recent Host</h6>
            <a href="/AddHost">+</a>
        </div>
        <div class="table-responsive">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-dark">

                        <th scope="col">Name</th>
                        <th scope="col">Label</th>
                        <th scope="col">Web Space</th>
                        <th scope="col">Bandwith</th>
                        <th scope="col">Sub Domain</th>
                        <th scope="col">Email</th>
                        <th scope="col">Price</th>
                        <th scope="col">Host Amount</th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $hosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $host): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($host->name); ?></td>
                            <td><?php echo e($host->label); ?></td>
                            <td><?php echo e($host->web_space); ?></td>
                            <td><?php echo e($host->bandwith); ?></td>
                            <td><?php echo e($host->sub_domain); ?></td>
                            <td><?php echo e($host->email_id); ?></td>
                            <td><?php echo e($host->price); ?></td>
                            <td><?php echo e($host->hosting_amount); ?></td>
                            <td>
                        <a href="<?php echo e(route('host.edit', $host->id)); ?>" class="btn btn-warning">Edit</a>
                                            <a href="<?php echo e(route('host.delete', $host->id)); ?>" class="btn btn-danger">Delete</a>        
                    </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.adminLayout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Domain-Host-Project\resources\views/Hosts.blade.php ENDPATH**/ ?>