
<?php $__env->startSection("admin"); ?>
<div class="container mt-5">
    <h2>Domains List</h2>
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Year</th>
                <th>Raw New</th>
                <th>Transfer</th>
                <th>Register</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $domains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $domain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($domain->id); ?></td>
                    <td><?php echo e($domain->name); ?></td>
                    <td><?php echo e($domain->year); ?></td>
                    <td><?php echo e($domain->rawNew); ?></td>
                    <td><?php echo e($domain->transfer); ?></td>
                    <td><?php echo e($domain->register); ?></td>
                    <td>
                        <a href="<?php echo e(route('domains.edit', $domain->id)); ?>" class="btn btn-warning">Edit</a>
                        <form action="<?php echo e(route('domains.destroy', $domain->id)); ?>" method="POST"
                            style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <a href="<?php echo e(route('domains.create')); ?>" class="btn btn-primary">Add New Domain</a>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.adminLayout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Domain-Host-Project\resources\views/domains/index.blade.php ENDPATH**/ ?>