<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Company;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class DailyCompanyBackup extends Command
{
    protected $signature = 'backup:companies-daily {company_id?}';
    // protected $description = 'Perform daily backup of all companies data';

    public function handle()
    {
        $companyId = $this->argument('company_id') ?? getCompanyId();
        // $backupBasePath = 'C:/AutomaticBackup/';
       
        // foreach ($companies as $company) {
        //     try {
        //         $this->backupCompany($company, $backupBasePath);
        //         Log::info("Successfully backed up company: {$company->name}");
        //     } catch (\Exception $e) {
        //         Log::error("Failed to backup company {$company->name}: " . $e->getMessage());
        //     }
        // }
       
        // $this->info('Daily company backups completed successfully.');

        if(!$companyId){
            $this->error('No company ID or No logged in company');
            return;
        }

        $company = Company::find($companyId);
        if(!$company){
            $this->error('Company Not Found with ID: {$companyId}');
            return;
        }

        $this->backupCompany($company, 'C:/AutomaticBackup/');
    }

    protected function backupCompany($company, $basePath)
    {
        $database = env('DB_DATABASE');
        $user = env('DB_USERNAME', 'default_user');
        $password = env('DB_PASSWORD', 'default_password');
       
        $date = Carbon::now()->format('Y-m-d');
        $companyPath = "{$basePath}{$company->name}-{$company->id}/{$date}/";
        $timestamp = Carbon::now()->format('H-i-s');
        $filename = "backup-{$company->id}-{$timestamp}.sql";
        $storagePath = $companyPath . $filename;
       
        if (!is_dir($companyPath)) {
            mkdir($companyPath, 0777, true);
        }
       
        $tables = [
            'company_users', 'categories', 'company_profiles',
            'products', 'suppliers', 'purchases', 'stocks',
            'sales', 'sale_items', 'system_settings',
            'medicine_types', 'expenses', 'reversal_logs',
            'sale_payments',
        ];
       
        file_put_contents($storagePath, "");
       
        foreach ($tables as $table) {
            $command = "mysqldump -u {$user} --password=\"{$password}\" {$database} {$table} --where=\"company_id={$company->id}\" >> \"{$storagePath}\"";
            exec($command, $output, $resultCode);
           
            if ($resultCode !== 0) {
                throw new \Exception("Backup failed for table {$table}");
            }
        }
       
        // Compress the backup file
        $zipPath = str_replace('.sql', '.zip', $storagePath);
        $zipCommand = "zip -j \"{$zipPath}\" \"{$storagePath}\"";
        exec($zipCommand, $zipOutput, $zipResult);
       
        if ($zipResult === 0) {
            unlink($storagePath); // Remove the uncompressed file
        }
    }
}