<?php

namespace App\Http\Controllers;
use Illuminate\Http\JsonResponse; 
use App\Models\Company;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\Rules\Password as PasswordRule;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\RedirectResponse;
use Inertia\Response;
use Inertia\Inertia;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): Response
    {
        $companies = Company::all();
        return Inertia::render('SystemAdmin/Users', [
            'companies' => $companies,
            'userRole' => auth()->user()->role,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Company $company)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Company $company)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id): RedirectResponse
    {
        $company = Company::findOrFail($id);

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => ['required', 'email', Rule::unique('companies')->ignore($company->id)],
            'password' => 'nullable|string|min:8|confirmed',
            'is_locked' => 'required|boolean',
        ]);

        $updateData = [
            'name' => $validated['name'],
            'email' => $validated['email'],
            'is_locked' => $validated['is_locked'],
        ];

        if (!empty($validated['password'])) {
            $updateData['password'] = Hash::make($validated['password']);
        }

        $company->update($updateData);

        return redirect()->back()->with([
            'success' => __('Company updated successfully'),
            'updated_company' => $company->fresh() // Send fresh data back
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Company $company): RedirectResponse
    {

        Log::info('delete the company');
        try {
            $company->delete();
            return redirect()->back()->with('success', 'Company deleted successfully');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Failed to delete company');
        }
    }
}
