<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SaleItem;

class SaleItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $companyId = getCompanyId();

        $sales = SaleItem::where('company_id', $companyId)
        ->orderBy('sale_date', 'desc')->get();
        return response()->json($sales);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }


    public function filterSales(Request $request)
    {
        $companyId = getCompanyId();

        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'product_name' => 'nullable|string',
            'is_fully_paid' => 'nullable|boolean',
        ]);

        $query = SaleItem::where('company_id', $companyId)
            ->whereBetween('sale_date', [$request->start_date, $request->end_date]);

        if (!empty($request->product_name)) {
            $query->where('product_name', $request->product_name);
        }

        if (!is_null($request->is_fully_paid)) {
            $query->where('is_fully_paid', $request->is_fully_paid);
        }

        $sales = $query->orderBy('sale_date', 'desc')->get();

        return response()->json($sales);
    }
}
