<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User; // System Admin
use App\Models\Company; // Admin
use App\Models\CompanyUser; // User

class CheckUserRole
{
    public function handle(Request $request, Closure $next)
    {
        // Check for system admin role
        if (Auth::guard('web')->check()) {
            $user = Auth::guard('web')->user();
            if ($user instanceof User && $user->role === 'system_admin') {
                return $next($request);
            }
        }

        // Check for company admin role
        if (Auth::guard('admin')->check()) {
            $companyAdmin = Auth::guard('admin')->user();
            if ($companyAdmin instanceof Company && $companyAdmin->role === 'admin') {
                return $next($request);
            }
        }

        // Check for company user role
        if (Auth::guard('user')->check()) {
            $companyUser = Auth::guard('user')->user();
            if ($companyUser instanceof CompanyUser && $companyUser->role === 'sale_person') {
                return $next($request);
            }
            if ($companyUser instanceof CompanyUser && $companyUser->role === 'purchase_person') {
                return $next($request);
            }
        }

        // Redirect if user is not authenticated or role doesn't match
        return redirect('/'); // Redirect to home or any other page
    }
}
