<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class MultiGuardAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)

    {
        // Check if there is an authenticated user across any of the guards
        if (!Auth::guard('web')->check() && !Auth::guard('admin')->check() && !Auth::guard('user')->check()) {
            return redirect()->route('login'); // Redirect to login if no user is authenticated
        }

        return $next($request);
    }
}
