<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PreventRegisteredUsers
{
    public function handle(Request $request, Closure $next)
    {
        // Check if the user is authenticated and if they are trying to access the registration route
        if (Auth::check() && $request->is('register')) {
            // Check if the user has a specific role or condition
            $user = Auth::user();
            if ($user->role === 'sale_person' || $user->role === 'purchase_person') { // Adjust this condition based on your logic
                return redirect('/userdashboard'); // Redirect to user dashboard if they come from there
            }
        }

        return $next($request);
    }
}


