<?php

   namespace App\Http\Middleware;

   use Closure;
   use Illuminate\Http\Request;
   use Illuminate\Support\Facades\Auth;
   use Illuminate\Support\Facades\Route;
   use Illuminate\Support\Facades\Log;

   class RoleBasedRedirect
   {
       /**
        * Handle an incoming request.
        *
        * @param  \Illuminate\Http\Request  $request
        * @param  \Closure  $next
        * @return mixed
        */
       public function handle(Request $request, Closure $next)
       {

            if (Auth::guard('web')->check()) {
                $user = Auth::guard('web')->user();
            }
        
            if (Auth::guard('admin')->check()) {
                $user = Auth::guard('admin')->user();
            }
        
            if (Auth::guard('user')->check()) {
                $user = Auth::guard('user')->user();
            }

            $currentRoute = Route::currentRouteName();

           if ($user) {
               if ($user->role === 'system_admin') {
                   return redirect()->route('dashboard');
               }

               if (in_array($user->role, ['admin', 'sale_person', 'purchase_person']) && !str_starts_with($currentRoute, 'userdashboard')) {
                   return redirect()->route('userdashboard');
               }
           }

           return $next($request);
       }
   }