<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BackupFailureNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $companyName;
    public $errorMessage;

    public function __construct($companyName, $errorMessage)
    {
        $this->companyName = $companyName;
        $this->errorMessage = $errorMessage;
    }

    public function build()
    {
        return $this->subject("Backup Failed for {$this->companyName}")
                    ->view('emails.backup-failed');
    }
}
