<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Category extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = ['name', 'description', 'company_id'];

    // Relationship with company

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
    
}
