<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyProfile extends Model
{
    use HasFactory;

    protected $table = 'company_profiles';

    protected $fillable = [
        'company_id',
        'name',
        'logo',
        'address',
        'phone_number',
        'email',
        'website',
        'about',
    ];


    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    
}
