<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable; // Use Authenticatable for Laravel's auth system
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class CompanyUser extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = ['name', 'email', 'password', 'company_id', 'role', 'register_date', 'profile_image','address', 'phone_number', 'last_seen', 'is_locked'];

    // Relationship with company
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
}
