<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_image',
        'name',
        'purchase_price',
        'sales_price',
        'quantity',
        'manufacturing_date',
        'expiration_date',
        'barcode',
        'category_id',
        'medicine_type_id',
        'company_id',
    ];


    // Define the relationship with the Category model
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function medicineType()
    {
        return $this->belongsTo(MedicineType::class, 'medicine_type_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }

    public function suppliers()
    {
        return $this->belongsToMany(Supplier::class, 'product_supplier')
                    ->withTimestamps(); // If timestamps are used in the pivot table
    }

    public function purchases()
    {
        return $this->hasMany(Purchase::class);
    }

    public function stock()
    {
        return $this->hasOne(Stock::class, 'product_id', 'id');
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    


}
