<?php

namespace App\Models;
use Illuminate\Support\Facades\Log;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',
        'supplier_id',
        'company_id',
        'quantity',
        'purchase_price',
        'purchase_date',
    ];

    //============ for stock =============

    protected static function booted()
    {
        static::created(function ($purchase){
            $product = $purchase->product()->first();
            $stock = Stock::where('product_id', $purchase->product_id)->first();
            $companyId = getCompanyId();
            $settings = SystemSetting::where('company_id', $companyId)->first();
            $settings_stock_amount = $settings->stock_amount_status;

            if($stock){
                $stock->quantity += $purchase->quantity;

               $quantity = $stock->quantity;
            }
            else{
                $quantity = $purchase->quantity;

            }

            if($quantity == 0){
                $status = 'Out of Stock';
            }elseif($quantity < $settings_stock_amount){
                $status = 'Low Stock';
            }else{
                $status = 'High stock';
            }

            if($stock){
                $stock->status = $status;
                $stock->save();
            }else{
                Stock::create([
                    'product_id' => $purchase->product_id,
                    'company_id' => $product->company_id,
                    'supplier_id' => $purchase->supplier_id,
                    'product_name' => $product->name,
                    'product_image' => $product->product_image,
                    'sales_price' => $product->sales_price,
                    'quantity' => $purchase->quantity,
                    'status' => $status,
                ]);
            }
        });
    }

    /**
     * Relationships
     */

    // A purchase belongs to a product
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
    
}
