<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'contact_person',
        'phone_number',
        'email',
        'address',
        'join_date',
        'total_money',
        'received_money',
        'remaining_money',
        'company_id', // Assuming supplier belongs to a company
    ];

    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_supplier')
                    ->withTimestamps();
    }
    

    public function purchases()
    {
        return $this->hasMany(Purchase::class);
    }


    public function payments()
    {
        return $this->hasMany(Payment::class, 'supplier_id');
    }
    

}
