<?php 
use Illuminate\Database\Migrations\Migration; 
use Illuminate\Database\Schema\Blueprint; 
use Illuminate\Support\Facades\Schema; 

class CreateSalesTable extends Migration { 
    
    public function up() { 
        
        Schema::create('sales', function (Blueprint $table) {
             $table->id();
             $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
             $table->string('customer_name');
             $table->string('phone_number');
             $table->string('customer_type')->default('walk-in');
             $table->string('email')->nullable();
             $table->string('address')->nullable();
             $table->uuid('partial_customer_id')->nullable()->index();
             $table->date('sale_date');
             $table->decimal('total_amount', 10, 2); 
             $table->decimal('amount_paid', 10, 2); 
             $table->json('products');
             $table->timestamps();
         });  
    } 
            
    public function down() 
    {  
        Schema::dropIfExists('sales'); 
    }
 }
