import {
  require_lodash,
  require_lodash2
} from "./chunk-JVRU4SBD.js";
import {
  require_cjs,
  require_lib
} from "./chunk-4V7ARJ2H.js";
import {
  axios_default
} from "./chunk-WRI7VC4W.js";
import "./chunk-5ZUCWV5W.js";
import {
  computed,
  createSSRApp,
  defineComponent,
  h,
  isReactive,
  markRaw,
  reactive,
  ref,
  shallowRef,
  watch
} from "./chunk-DKCQFKF6.js";
import {
  __commonJS,
  __toESM
} from "./chunk-EWTE5DHJ.js";

// node_modules/nprogress/nprogress.js
var require_nprogress = __commonJS({
  "node_modules/nprogress/nprogress.js"(exports, module) {
    (function(root, factory) {
      if (typeof define === "function" && define.amd) {
        define(factory);
      } else if (typeof exports === "object") {
        module.exports = factory();
      } else {
        root.NProgress = factory();
      }
    })(exports, function() {
      var NProgress = {};
      NProgress.version = "0.2.0";
      var Settings = NProgress.settings = {
        minimum: 0.08,
        easing: "ease",
        positionUsing: "",
        speed: 200,
        trickle: true,
        trickleRate: 0.02,
        trickleSpeed: 800,
        showSpinner: true,
        barSelector: '[role="bar"]',
        spinnerSelector: '[role="spinner"]',
        parent: "body",
        template: '<div class="bar" role="bar"><div class="peg"></div></div><div class="spinner" role="spinner"><div class="spinner-icon"></div></div>'
      };
      NProgress.configure = function(options) {
        var key, value;
        for (key in options) {
          value = options[key];
          if (value !== void 0 && options.hasOwnProperty(key)) Settings[key] = value;
        }
        return this;
      };
      NProgress.status = null;
      NProgress.set = function(n) {
        var started = NProgress.isStarted();
        n = clamp(n, Settings.minimum, 1);
        NProgress.status = n === 1 ? null : n;
        var progress = NProgress.render(!started), bar = progress.querySelector(Settings.barSelector), speed = Settings.speed, ease = Settings.easing;
        progress.offsetWidth;
        queue(function(next) {
          if (Settings.positionUsing === "") Settings.positionUsing = NProgress.getPositioningCSS();
          css(bar, barPositionCSS(n, speed, ease));
          if (n === 1) {
            css(progress, {
              transition: "none",
              opacity: 1
            });
            progress.offsetWidth;
            setTimeout(function() {
              css(progress, {
                transition: "all " + speed + "ms linear",
                opacity: 0
              });
              setTimeout(function() {
                NProgress.remove();
                next();
              }, speed);
            }, speed);
          } else {
            setTimeout(next, speed);
          }
        });
        return this;
      };
      NProgress.isStarted = function() {
        return typeof NProgress.status === "number";
      };
      NProgress.start = function() {
        if (!NProgress.status) NProgress.set(0);
        var work = function() {
          setTimeout(function() {
            if (!NProgress.status) return;
            NProgress.trickle();
            work();
          }, Settings.trickleSpeed);
        };
        if (Settings.trickle) work();
        return this;
      };
      NProgress.done = function(force) {
        if (!force && !NProgress.status) return this;
        return NProgress.inc(0.3 + 0.5 * Math.random()).set(1);
      };
      NProgress.inc = function(amount) {
        var n = NProgress.status;
        if (!n) {
          return NProgress.start();
        } else {
          if (typeof amount !== "number") {
            amount = (1 - n) * clamp(Math.random() * n, 0.1, 0.95);
          }
          n = clamp(n + amount, 0, 0.994);
          return NProgress.set(n);
        }
      };
      NProgress.trickle = function() {
        return NProgress.inc(Math.random() * Settings.trickleRate);
      };
      (function() {
        var initial = 0, current = 0;
        NProgress.promise = function($promise) {
          if (!$promise || $promise.state() === "resolved") {
            return this;
          }
          if (current === 0) {
            NProgress.start();
          }
          initial++;
          current++;
          $promise.always(function() {
            current--;
            if (current === 0) {
              initial = 0;
              NProgress.done();
            } else {
              NProgress.set((initial - current) / initial);
            }
          });
          return this;
        };
      })();
      NProgress.render = function(fromStart) {
        if (NProgress.isRendered()) return document.getElementById("nprogress");
        addClass(document.documentElement, "nprogress-busy");
        var progress = document.createElement("div");
        progress.id = "nprogress";
        progress.innerHTML = Settings.template;
        var bar = progress.querySelector(Settings.barSelector), perc = fromStart ? "-100" : toBarPerc(NProgress.status || 0), parent = document.querySelector(Settings.parent), spinner;
        css(bar, {
          transition: "all 0 linear",
          transform: "translate3d(" + perc + "%,0,0)"
        });
        if (!Settings.showSpinner) {
          spinner = progress.querySelector(Settings.spinnerSelector);
          spinner && removeElement(spinner);
        }
        if (parent != document.body) {
          addClass(parent, "nprogress-custom-parent");
        }
        parent.appendChild(progress);
        return progress;
      };
      NProgress.remove = function() {
        removeClass(document.documentElement, "nprogress-busy");
        removeClass(document.querySelector(Settings.parent), "nprogress-custom-parent");
        var progress = document.getElementById("nprogress");
        progress && removeElement(progress);
      };
      NProgress.isRendered = function() {
        return !!document.getElementById("nprogress");
      };
      NProgress.getPositioningCSS = function() {
        var bodyStyle = document.body.style;
        var vendorPrefix = "WebkitTransform" in bodyStyle ? "Webkit" : "MozTransform" in bodyStyle ? "Moz" : "msTransform" in bodyStyle ? "ms" : "OTransform" in bodyStyle ? "O" : "";
        if (vendorPrefix + "Perspective" in bodyStyle) {
          return "translate3d";
        } else if (vendorPrefix + "Transform" in bodyStyle) {
          return "translate";
        } else {
          return "margin";
        }
      };
      function clamp(n, min, max) {
        if (n < min) return min;
        if (n > max) return max;
        return n;
      }
      function toBarPerc(n) {
        return (-1 + n) * 100;
      }
      function barPositionCSS(n, speed, ease) {
        var barCSS;
        if (Settings.positionUsing === "translate3d") {
          barCSS = { transform: "translate3d(" + toBarPerc(n) + "%,0,0)" };
        } else if (Settings.positionUsing === "translate") {
          barCSS = { transform: "translate(" + toBarPerc(n) + "%,0)" };
        } else {
          barCSS = { "margin-left": toBarPerc(n) + "%" };
        }
        barCSS.transition = "all " + speed + "ms " + ease;
        return barCSS;
      }
      var queue = /* @__PURE__ */ function() {
        var pending = [];
        function next() {
          var fn = pending.shift();
          if (fn) {
            fn(next);
          }
        }
        return function(fn) {
          pending.push(fn);
          if (pending.length == 1) next();
        };
      }();
      var css = /* @__PURE__ */ function() {
        var cssPrefixes = ["Webkit", "O", "Moz", "ms"], cssProps = {};
        function camelCase(string) {
          return string.replace(/^-ms-/, "ms-").replace(/-([\da-z])/gi, function(match, letter) {
            return letter.toUpperCase();
          });
        }
        function getVendorProp(name) {
          var style = document.body.style;
          if (name in style) return name;
          var i = cssPrefixes.length, capName = name.charAt(0).toUpperCase() + name.slice(1), vendorName;
          while (i--) {
            vendorName = cssPrefixes[i] + capName;
            if (vendorName in style) return vendorName;
          }
          return name;
        }
        function getStyleProp(name) {
          name = camelCase(name);
          return cssProps[name] || (cssProps[name] = getVendorProp(name));
        }
        function applyCss(element, prop, value) {
          prop = getStyleProp(prop);
          element.style[prop] = value;
        }
        return function(element, properties) {
          var args = arguments, prop, value;
          if (args.length == 2) {
            for (prop in properties) {
              value = properties[prop];
              if (value !== void 0 && properties.hasOwnProperty(prop)) applyCss(element, prop, value);
            }
          } else {
            applyCss(element, args[1], args[2]);
          }
        };
      }();
      function hasClass(element, name) {
        var list = typeof element == "string" ? element : classList(element);
        return list.indexOf(" " + name + " ") >= 0;
      }
      function addClass(element, name) {
        var oldList = classList(element), newList = oldList + name;
        if (hasClass(oldList, name)) return;
        element.className = newList.substring(1);
      }
      function removeClass(element, name) {
        var oldList = classList(element), newList;
        if (!hasClass(element, name)) return;
        newList = oldList.replace(" " + name + " ", " ");
        element.className = newList.substring(1, newList.length - 1);
      }
      function classList(element) {
        return (" " + (element.className || "") + " ").replace(/\s+/gi, " ");
      }
      function removeElement(element) {
        element && element.parentNode && element.parentNode.removeChild(element);
      }
      return NProgress;
    });
  }
});

// node_modules/@inertiajs/core/dist/index.esm.js
var import_deepmerge = __toESM(require_cjs());
var O = __toESM(require_lib());
var import_nprogress = __toESM(require_nprogress());
function T(t, e) {
  let i;
  return function(...r) {
    clearTimeout(i), i = setTimeout(() => t.apply(this, r), e);
  };
}
function f(t, e) {
  return document.dispatchEvent(new CustomEvent(`inertia:${t}`, e));
}
var H = (t) => f("before", { cancelable: true, detail: { visit: t } });
var q = (t) => f("error", { detail: { errors: t } });
var $ = (t) => f("exception", { cancelable: true, detail: { exception: t } });
var N = (t) => f("finish", { detail: { visit: t } });
var W = (t) => f("invalid", { cancelable: true, detail: { response: t } });
var P = (t) => f("navigate", { detail: { page: t } });
var K = (t) => f("progress", { detail: { progress: t } });
var X = (t) => f("start", { detail: { visit: t } });
var B = (t) => f("success", { detail: { page: t } });
function I(t) {
  return t instanceof File || t instanceof Blob || t instanceof FileList && t.length > 0 || t instanceof FormData && Array.from(t.values()).some((e) => I(e)) || typeof t == "object" && t !== null && Object.values(t).some((e) => I(e));
}
function k(t, e = new FormData(), i = null) {
  t = t || {};
  for (let r in t) Object.prototype.hasOwnProperty.call(t, r) && z(e, J(i, r), t[r]);
  return e;
}
function J(t, e) {
  return t ? t + "[" + e + "]" : e;
}
function z(t, e, i) {
  if (Array.isArray(i)) return Array.from(i.keys()).forEach((r) => z(t, J(e, r.toString()), i[r]));
  if (i instanceof Date) return t.append(e, i.toISOString());
  if (i instanceof File) return t.append(e, i, i.name);
  if (i instanceof Blob) return t.append(e, i);
  if (typeof i == "boolean") return t.append(e, i ? "1" : "0");
  if (typeof i == "string") return t.append(e, i);
  if (typeof i == "number") return t.append(e, `${i}`);
  if (i == null) return t.append(e, "");
  k(i, t, e);
}
var _ = { modal: null, listener: null, show(t) {
  typeof t == "object" && (t = `All Inertia requests must receive a valid Inertia response, however a plain JSON response was received.<hr>${JSON.stringify(t)}`);
  let e = document.createElement("html");
  e.innerHTML = t, e.querySelectorAll("a").forEach((r) => r.setAttribute("target", "_top")), this.modal = document.createElement("div"), this.modal.style.position = "fixed", this.modal.style.width = "100vw", this.modal.style.height = "100vh", this.modal.style.padding = "50px", this.modal.style.boxSizing = "border-box", this.modal.style.backgroundColor = "rgba(0, 0, 0, .6)", this.modal.style.zIndex = 2e5, this.modal.addEventListener("click", () => this.hide());
  let i = document.createElement("iframe");
  if (i.style.backgroundColor = "white", i.style.borderRadius = "5px", i.style.width = "100%", i.style.height = "100%", this.modal.appendChild(i), document.body.prepend(this.modal), document.body.style.overflow = "hidden", !i.contentWindow) throw new Error("iframe not yet ready.");
  i.contentWindow.document.open(), i.contentWindow.document.write(e.outerHTML), i.contentWindow.document.close(), this.listener = this.hideOnEscape.bind(this), document.addEventListener("keydown", this.listener);
}, hide() {
  this.modal.outerHTML = "", this.modal = null, document.body.style.overflow = "visible", document.removeEventListener("keydown", this.listener);
}, hideOnEscape(t) {
  t.keyCode === 27 && this.hide();
} };
function b(t) {
  return new URL(t.toString(), window.location.toString());
}
function D(t, e, i, r = "brackets") {
  let s = /^https?:\/\//.test(e.toString()), l = s || e.toString().startsWith("/"), h2 = !l && !e.toString().startsWith("#") && !e.toString().startsWith("?"), g2 = e.toString().includes("?") || t === "get" && Object.keys(i).length, m = e.toString().includes("#"), c2 = new URL(e.toString(), "http://localhost");
  return t === "get" && Object.keys(i).length && (c2.search = O.stringify((0, import_deepmerge.default)(O.parse(c2.search, { ignoreQueryPrefix: true }), i), { encodeValuesOnly: true, arrayFormat: r }), i = {}), [[s ? `${c2.protocol}//${c2.host}` : "", l ? c2.pathname : "", h2 ? c2.pathname.substring(1) : "", g2 ? c2.search : "", m ? c2.hash : ""].join(""), i];
}
function E(t) {
  return t = new URL(t.href), t.hash = "", t;
}
var C = typeof window > "u";
var Y = !C && /CriOS/.test(window.navigator.userAgent);
var Z = (t) => {
  requestAnimationFrame(() => {
    requestAnimationFrame(t);
  });
};
var F = class {
  constructor() {
    this.visitId = null;
  }
  init({ initialPage: e, resolveComponent: i, swapComponent: r }) {
    this.page = e, this.resolveComponent = i, this.swapComponent = r, this.setNavigationType(), this.clearRememberedStateOnReload(), this.isBackForwardVisit() ? this.handleBackForwardVisit(this.page) : this.isLocationVisit() ? this.handleLocationVisit(this.page) : this.handleInitialPageVisit(this.page), this.setupEventListeners();
  }
  setNavigationType() {
    this.navigationType = window.performance && window.performance.getEntriesByType && window.performance.getEntriesByType("navigation").length > 0 ? window.performance.getEntriesByType("navigation")[0].type : "navigate";
  }
  clearRememberedStateOnReload() {
    var _a;
    this.navigationType === "reload" && ((_a = window.history.state) == null ? void 0 : _a.rememberedState) && delete window.history.state.rememberedState;
  }
  handleInitialPageVisit(e) {
    let i = window.location.hash;
    this.page.url.includes(i) || (this.page.url += i), this.setPage(e, { preserveScroll: true, preserveState: true }).then(() => P(e));
  }
  setupEventListeners() {
    window.addEventListener("popstate", this.handlePopstateEvent.bind(this)), document.addEventListener("scroll", T(this.handleScrollEvent.bind(this), 100), true);
  }
  scrollRegions() {
    return document.querySelectorAll("[scroll-region]");
  }
  handleScrollEvent(e) {
    typeof e.target.hasAttribute == "function" && e.target.hasAttribute("scroll-region") && this.saveScrollPositions();
  }
  saveScrollPositions() {
    this.replaceState({ ...this.page, scrollRegions: Array.from(this.scrollRegions()).map((e) => ({ top: e.scrollTop, left: e.scrollLeft })) });
  }
  resetScrollPositions() {
    Z(() => {
      var _a;
      window.scrollTo(0, 0), this.scrollRegions().forEach((e) => {
        typeof e.scrollTo == "function" ? e.scrollTo(0, 0) : (e.scrollTop = 0, e.scrollLeft = 0);
      }), this.saveScrollPositions(), window.location.hash && ((_a = document.getElementById(window.location.hash.slice(1))) == null ? void 0 : _a.scrollIntoView());
    });
  }
  restoreScrollPositions() {
    Z(() => {
      this.page.scrollRegions && this.scrollRegions().forEach((e, i) => {
        let r = this.page.scrollRegions[i];
        if (r) typeof e.scrollTo == "function" ? e.scrollTo(r.left, r.top) : (e.scrollTop = r.top, e.scrollLeft = r.left);
        else return;
      });
    });
  }
  isBackForwardVisit() {
    return window.history.state && this.navigationType === "back_forward";
  }
  handleBackForwardVisit(e) {
    window.history.state.version = e.version, this.setPage(window.history.state, { preserveScroll: true, preserveState: true }).then(() => {
      this.restoreScrollPositions(), P(e);
    });
  }
  locationVisit(e, i) {
    try {
      let r = { preserveScroll: i };
      window.sessionStorage.setItem("inertiaLocationVisit", JSON.stringify(r)), window.location.href = e.href, E(window.location).href === E(e).href && window.location.reload();
    } catch {
      return false;
    }
  }
  isLocationVisit() {
    try {
      return window.sessionStorage.getItem("inertiaLocationVisit") !== null;
    } catch {
      return false;
    }
  }
  handleLocationVisit(e) {
    var _a, _b;
    let i = JSON.parse(window.sessionStorage.getItem("inertiaLocationVisit") || "");
    window.sessionStorage.removeItem("inertiaLocationVisit"), e.url += window.location.hash, e.rememberedState = ((_a = window.history.state) == null ? void 0 : _a.rememberedState) ?? {}, e.scrollRegions = ((_b = window.history.state) == null ? void 0 : _b.scrollRegions) ?? [], this.setPage(e, { preserveScroll: i.preserveScroll, preserveState: true }).then(() => {
      i.preserveScroll && this.restoreScrollPositions(), P(e);
    });
  }
  isLocationVisitResponse(e) {
    return !!(e && e.status === 409 && e.headers["x-inertia-location"]);
  }
  isInertiaResponse(e) {
    return !!(e == null ? void 0 : e.headers["x-inertia"]);
  }
  createVisitId() {
    return this.visitId = {}, this.visitId;
  }
  cancelVisit(e, { cancelled: i = false, interrupted: r = false }) {
    e && !e.completed && !e.cancelled && !e.interrupted && (e.cancelToken.abort(), e.onCancel(), e.completed = false, e.cancelled = i, e.interrupted = r, N(e), e.onFinish(e));
  }
  finishVisit(e) {
    !e.cancelled && !e.interrupted && (e.completed = true, e.cancelled = false, e.interrupted = false, N(e), e.onFinish(e));
  }
  resolvePreserveOption(e, i) {
    return typeof e == "function" ? e(i) : e === "errors" ? Object.keys(i.props.errors || {}).length > 0 : e;
  }
  cancel() {
    this.activeVisit && this.cancelVisit(this.activeVisit, { cancelled: true });
  }
  visit(e, { method: i = "get", data: r = {}, replace: s = false, preserveScroll: l = false, preserveState: h2 = false, only: g2 = [], except: m = [], headers: c2 = {}, errorBag: o = "", forceFormData: v = false, onCancelToken: L2 = () => {
  }, onBefore: d2 = () => {
  }, onStart: p = () => {
  }, onProgress: x2 = () => {
  }, onFinish: y = () => {
  }, onCancel: ne = () => {
  }, onSuccess: U = () => {
  }, onError: G = () => {
  }, queryStringArrayFormat: A = "brackets" } = {}) {
    let S = typeof e == "string" ? b(e) : e;
    if ((I(r) || v) && !(r instanceof FormData) && (r = k(r)), !(r instanceof FormData)) {
      let [n, a] = D(i, S, r, A);
      S = b(n), r = a;
    }
    let R2 = { url: S, method: i, data: r, replace: s, preserveScroll: l, preserveState: h2, only: g2, except: m, headers: c2, errorBag: o, forceFormData: v, queryStringArrayFormat: A, cancelled: false, completed: false, interrupted: false };
    if (d2(R2) === false || !H(R2)) return;
    this.activeVisit && this.cancelVisit(this.activeVisit, { interrupted: true }), this.saveScrollPositions();
    let M2 = this.createVisitId();
    this.activeVisit = { ...R2, onCancelToken: L2, onBefore: d2, onStart: p, onProgress: x2, onFinish: y, onCancel: ne, onSuccess: U, onError: G, queryStringArrayFormat: A, cancelToken: new AbortController() }, L2({ cancel: () => {
      this.activeVisit && this.cancelVisit(this.activeVisit, { cancelled: true });
    } }), X(R2), p(R2);
    let j2 = !!(g2.length || m.length);
    axios_default({ method: i, url: E(S).href, data: i === "get" ? {} : r, params: i === "get" ? r : {}, signal: this.activeVisit.cancelToken.signal, headers: { ...c2, Accept: "text/html, application/xhtml+xml", "X-Requested-With": "XMLHttpRequest", "X-Inertia": true, ...j2 ? { "X-Inertia-Partial-Component": this.page.component } : {}, ...g2.length ? { "X-Inertia-Partial-Data": g2.join(",") } : {}, ...m.length ? { "X-Inertia-Partial-Except": m.join(",") } : {}, ...o && o.length ? { "X-Inertia-Error-Bag": o } : {}, ...this.page.version ? { "X-Inertia-Version": this.page.version } : {} }, onUploadProgress: (n) => {
      r instanceof FormData && (n.percentage = n.progress ? Math.round(n.progress * 100) : 0, K(n), x2(n));
    } }).then((n) => {
      var _a;
      if (!this.isInertiaResponse(n)) return Promise.reject({ response: n });
      let a = n.data;
      j2 && a.component === this.page.component && (a.props = { ...this.page.props, ...a.props }), l = this.resolvePreserveOption(l, a), h2 = this.resolvePreserveOption(h2, a), h2 && ((_a = window.history.state) == null ? void 0 : _a.rememberedState) && a.component === this.page.component && (a.rememberedState = window.history.state.rememberedState);
      let w = S, V = b(a.url);
      return w.hash && !V.hash && E(w).href === V.href && (V.hash = w.hash, a.url = V.href), this.setPage(a, { visitId: M2, replace: s, preserveScroll: l, preserveState: h2 });
    }).then(() => {
      let n = this.page.props.errors || {};
      if (Object.keys(n).length > 0) {
        let a = o ? n[o] ? n[o] : {} : n;
        return q(a), G(a);
      }
      return B(this.page), U(this.page);
    }).catch((n) => {
      if (this.isInertiaResponse(n.response)) return this.setPage(n.response.data, { visitId: M2 });
      if (this.isLocationVisitResponse(n.response)) {
        let a = b(n.response.headers["x-inertia-location"]), w = S;
        w.hash && !a.hash && E(w).href === a.href && (a.hash = w.hash), this.locationVisit(a, l === true);
      } else if (n.response) W(n.response) && _.show(n.response.data);
      else return Promise.reject(n);
    }).then(() => {
      this.activeVisit && this.finishVisit(this.activeVisit);
    }).catch((n) => {
      if (!axios_default.isCancel(n)) {
        let a = $(n);
        if (this.activeVisit && this.finishVisit(this.activeVisit), a) return Promise.reject(n);
      }
    });
  }
  setPage(e, { visitId: i = this.createVisitId(), replace: r = false, preserveScroll: s = false, preserveState: l = false } = {}) {
    return Promise.resolve(this.resolveComponent(e.component)).then((h2) => {
      i === this.visitId && (e.scrollRegions = this.page.scrollRegions || [], e.rememberedState = e.rememberedState || {}, r = r || b(e.url).href === window.location.href, r ? this.replaceState(e) : this.pushState(e), this.swapComponent({ component: h2, page: e, preserveState: l }).then(() => {
        s ? this.restoreScrollPositions() : this.resetScrollPositions(), r || P(e);
      }));
    });
  }
  pushState(e) {
    this.page = e, Y ? setTimeout(() => window.history.pushState(e, "", e.url)) : window.history.pushState(e, "", e.url);
  }
  replaceState(e) {
    this.page = e, Y ? setTimeout(() => window.history.replaceState(e, "", e.url)) : window.history.replaceState(e, "", e.url);
  }
  handlePopstateEvent(e) {
    if (e.state !== null) {
      let i = e.state, r = this.createVisitId();
      Promise.resolve(this.resolveComponent(i.component)).then((s) => {
        r === this.visitId && (this.page = i, this.swapComponent({ component: s, page: i, preserveState: false }).then(() => {
          this.restoreScrollPositions(), P(i);
        }));
      });
    } else {
      let i = b(this.page.url);
      i.hash = window.location.hash, this.replaceState({ ...this.page, url: i.href }), this.resetScrollPositions();
    }
  }
  get(e, i = {}, r = {}) {
    return this.visit(e, { ...r, method: "get", data: i });
  }
  reload(e = {}) {
    return this.visit(window.location.href, { ...e, preserveScroll: true, preserveState: true });
  }
  replace(e, i = {}) {
    return console.warn(`Inertia.replace() has been deprecated and will be removed in a future release. Please use Inertia.${i.method ?? "get"}() instead.`), this.visit(e, { preserveState: true, ...i, replace: true });
  }
  post(e, i = {}, r = {}) {
    return this.visit(e, { preserveState: true, ...r, method: "post", data: i });
  }
  put(e, i = {}, r = {}) {
    return this.visit(e, { preserveState: true, ...r, method: "put", data: i });
  }
  patch(e, i = {}, r = {}) {
    return this.visit(e, { preserveState: true, ...r, method: "patch", data: i });
  }
  delete(e, i = {}) {
    return this.visit(e, { preserveState: true, ...i, method: "delete" });
  }
  remember(e, i = "default") {
    var _a;
    C || this.replaceState({ ...this.page, rememberedState: { ...(_a = this.page) == null ? void 0 : _a.rememberedState, [i]: e } });
  }
  restore(e = "default") {
    var _a, _b;
    if (!C) return (_b = (_a = window.history.state) == null ? void 0 : _a.rememberedState) == null ? void 0 : _b[e];
  }
  on(e, i) {
    if (C) return () => {
    };
    let r = (s) => {
      let l = i(s);
      s.cancelable && !s.defaultPrevented && l === false && s.preventDefault();
    };
    return document.addEventListener(`inertia:${e}`, r), () => document.removeEventListener(`inertia:${e}`, r);
  }
};
var se = { buildDOMElement(t) {
  let e = document.createElement("template");
  e.innerHTML = t;
  let i = e.content.firstChild;
  if (!t.startsWith("<script ")) return i;
  let r = document.createElement("script");
  return r.innerHTML = i.innerHTML, i.getAttributeNames().forEach((s) => {
    r.setAttribute(s, i.getAttribute(s) || "");
  }), r;
}, isInertiaManagedElement(t) {
  return t.nodeType === Node.ELEMENT_NODE && t.getAttribute("inertia") !== null;
}, findMatchingElementIndex(t, e) {
  let i = t.getAttribute("inertia");
  return i !== null ? e.findIndex((r) => r.getAttribute("inertia") === i) : -1;
}, update: T(function(t) {
  let e = t.map((r) => this.buildDOMElement(r));
  Array.from(document.head.childNodes).filter((r) => this.isInertiaManagedElement(r)).forEach((r) => {
    var _a, _b;
    let s = this.findMatchingElementIndex(r, e);
    if (s === -1) {
      (_a = r == null ? void 0 : r.parentNode) == null ? void 0 : _a.removeChild(r);
      return;
    }
    let l = e.splice(s, 1)[0];
    l && !r.isEqualNode(l) && ((_b = r == null ? void 0 : r.parentNode) == null ? void 0 : _b.replaceChild(l, r));
  }), e.forEach((r) => document.head.appendChild(r));
}, 1) };
function ee(t, e, i) {
  let r = {}, s = 0;
  function l() {
    let o = s += 1;
    return r[o] = [], o.toString();
  }
  function h2(o) {
    o === null || Object.keys(r).indexOf(o) === -1 || (delete r[o], c2());
  }
  function g2(o, v = []) {
    o !== null && Object.keys(r).indexOf(o) > -1 && (r[o] = v), c2();
  }
  function m() {
    let o = e(""), v = { ...o ? { title: `<title inertia="">${o}</title>` } : {} }, L2 = Object.values(r).reduce((d2, p) => d2.concat(p), []).reduce((d2, p) => {
      if (p.indexOf("<") === -1) return d2;
      if (p.indexOf("<title ") === 0) {
        let y = p.match(/(<title [^>]+>)(.*?)(<\/title>)/);
        return d2.title = y ? `${y[1]}${e(y[2])}${y[3]}` : p, d2;
      }
      let x2 = p.match(/ inertia="[^"]+"/);
      return x2 ? d2[x2[0]] = p : d2[Object.keys(d2).length] = p, d2;
    }, v);
    return Object.values(L2);
  }
  function c2() {
    t ? i(m()) : se.update(m());
  }
  return c2(), { forceUpdate: c2, createProvider: function() {
    let o = l();
    return { update: (v) => g2(o, v), disconnect: () => h2(o) };
  } };
}
var te = null;
function ae(t) {
  document.addEventListener("inertia:start", le.bind(null, t)), document.addEventListener("inertia:progress", ce), document.addEventListener("inertia:finish", de);
}
function le(t) {
  te = setTimeout(() => import_nprogress.default.start(), t);
}
function ce(t) {
  var _a;
  import_nprogress.default.isStarted() && ((_a = t.detail.progress) == null ? void 0 : _a.percentage) && import_nprogress.default.set(Math.max(import_nprogress.default.status, t.detail.progress.percentage / 100 * 0.9));
}
function de(t) {
  if (clearTimeout(te), import_nprogress.default.isStarted()) t.detail.visit.completed ? import_nprogress.default.done() : t.detail.visit.interrupted ? import_nprogress.default.set(0) : t.detail.visit.cancelled && (import_nprogress.default.done(), import_nprogress.default.remove());
  else return;
}
function pe(t) {
  let e = document.createElement("style");
  e.type = "text/css", e.textContent = `
    #nprogress {
      pointer-events: none;
    }

    #nprogress .bar {
      background: ${t};

      position: fixed;
      z-index: 1031;
      top: 0;
      left: 0;

      width: 100%;
      height: 2px;
    }

    #nprogress .peg {
      display: block;
      position: absolute;
      right: 0px;
      width: 100px;
      height: 100%;
      box-shadow: 0 0 10px ${t}, 0 0 5px ${t};
      opacity: 1.0;

      -webkit-transform: rotate(3deg) translate(0px, -4px);
          -ms-transform: rotate(3deg) translate(0px, -4px);
              transform: rotate(3deg) translate(0px, -4px);
    }

    #nprogress .spinner {
      display: block;
      position: fixed;
      z-index: 1031;
      top: 15px;
      right: 15px;
    }

    #nprogress .spinner-icon {
      width: 18px;
      height: 18px;
      box-sizing: border-box;

      border: solid 2px transparent;
      border-top-color: ${t};
      border-left-color: ${t};
      border-radius: 50%;

      -webkit-animation: nprogress-spinner 400ms linear infinite;
              animation: nprogress-spinner 400ms linear infinite;
    }

    .nprogress-custom-parent {
      overflow: hidden;
      position: relative;
    }

    .nprogress-custom-parent #nprogress .spinner,
    .nprogress-custom-parent #nprogress .bar {
      position: absolute;
    }

    @-webkit-keyframes nprogress-spinner {
      0%   { -webkit-transform: rotate(0deg); }
      100% { -webkit-transform: rotate(360deg); }
    }
    @keyframes nprogress-spinner {
      0%   { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  `, document.head.appendChild(e);
}
function ie({ delay: t = 250, color: e = "#29d", includeCSS: i = true, showSpinner: r = false } = {}) {
  ae(t), import_nprogress.default.configure({ showSpinner: r }), i && pe(e);
}
function re(t) {
  let e = t.currentTarget.tagName.toLowerCase() === "a";
  return !(t.target && (t == null ? void 0 : t.target).isContentEditable || t.defaultPrevented || e && t.altKey || e && t.ctrlKey || e && t.metaKey || e && t.shiftKey || e && "button" in t && t.button !== 0);
}
var Ne = new F();

// node_modules/@inertiajs/vue3/dist/index.esm.js
var import_lodash = __toESM(require_lodash());
var import_lodash2 = __toESM(require_lodash());
var import_lodash3 = __toESM(require_lodash2());
var import_lodash4 = __toESM(require_lodash());
var M = { created() {
  if (!this.$options.remember) return;
  Array.isArray(this.$options.remember) && (this.$options.remember = { data: this.$options.remember }), typeof this.$options.remember == "string" && (this.$options.remember = { data: [this.$options.remember] }), typeof this.$options.remember.data == "string" && (this.$options.remember = { data: [this.$options.remember.data] });
  let e = this.$options.remember.key instanceof Function ? this.$options.remember.key.call(this) : this.$options.remember.key, o = Ne.restore(e), n = this.$options.remember.data.filter((t) => !(this[t] !== null && typeof this[t] == "object" && this[t].__rememberable === false)), p = (t) => this[t] !== null && typeof this[t] == "object" && typeof this[t].__remember == "function" && typeof this[t].__restore == "function";
  n.forEach((t) => {
    this[t] !== void 0 && o !== void 0 && o[t] !== void 0 && (p(t) ? this[t].__restore(o[t]) : this[t] = o[t]), this.$watch(t, () => {
      Ne.remember(n.reduce((a, l) => ({ ...a, [l]: (0, import_lodash.default)(p(l) ? this[l].__remember() : this[l]) }), {}), e);
    }, { immediate: true, deep: true });
  });
} };
var D2 = M;
function T2(e, o) {
  let n = typeof e == "string" ? e : null, p = typeof e == "string" ? o : e, t = n ? Ne.restore(n) : null, a = typeof p == "object" ? (0, import_lodash2.default)(p) : (0, import_lodash2.default)(p()), l = null, f2 = null, h2 = (r) => r, y = reactive({ ...t ? t.data : (0, import_lodash2.default)(a), isDirty: false, errors: t ? t.errors : {}, hasErrors: false, processing: false, progress: null, wasSuccessful: false, recentlySuccessful: false, data() {
    return Object.keys(a).reduce((r, s) => (r[s] = this[s], r), {});
  }, transform(r) {
    return h2 = r, this;
  }, defaults(r, s) {
    if (typeof p == "function") throw new Error("You cannot call `defaults()` when using a function to define your form data.");
    return typeof r > "u" ? (a = this.data(), this.isDirty = false) : a = Object.assign({}, (0, import_lodash2.default)(a), typeof r == "string" ? { [r]: s } : r), this;
  }, reset(...r) {
    let s = typeof p == "object" ? (0, import_lodash2.default)(a) : (0, import_lodash2.default)(p()), i = (0, import_lodash2.default)(s);
    return r.length === 0 ? (a = i, Object.assign(this, s)) : Object.keys(s).filter((m) => r.includes(m)).forEach((m) => {
      a[m] = i[m], this[m] = s[m];
    }), this;
  }, setError(r, s) {
    return Object.assign(this.errors, typeof r == "string" ? { [r]: s } : r), this.hasErrors = Object.keys(this.errors).length > 0, this;
  }, clearErrors(...r) {
    return this.errors = Object.keys(this.errors).reduce((s, i) => ({ ...s, ...r.length > 0 && !r.includes(i) ? { [i]: this.errors[i] } : {} }), {}), this.hasErrors = Object.keys(this.errors).length > 0, this;
  }, submit(r, s, i = {}) {
    let m = h2(this.data()), b2 = { ...i, onCancelToken: (u2) => {
      if (l = u2, i.onCancelToken) return i.onCancelToken(u2);
    }, onBefore: (u2) => {
      if (this.wasSuccessful = false, this.recentlySuccessful = false, clearTimeout(f2), i.onBefore) return i.onBefore(u2);
    }, onStart: (u2) => {
      if (this.processing = true, i.onStart) return i.onStart(u2);
    }, onProgress: (u2) => {
      if (this.progress = u2, i.onProgress) return i.onProgress(u2);
    }, onSuccess: async (u2) => {
      this.processing = false, this.progress = null, this.clearErrors(), this.wasSuccessful = true, this.recentlySuccessful = true, f2 = setTimeout(() => this.recentlySuccessful = false, 2e3);
      let N2 = i.onSuccess ? await i.onSuccess(u2) : null;
      return a = (0, import_lodash2.default)(this.data()), this.isDirty = false, N2;
    }, onError: (u2) => {
      if (this.processing = false, this.progress = null, this.clearErrors().setError(u2), i.onError) return i.onError(u2);
    }, onCancel: () => {
      if (this.processing = false, this.progress = null, i.onCancel) return i.onCancel();
    }, onFinish: (u2) => {
      if (this.processing = false, this.progress = null, l = null, i.onFinish) return i.onFinish(u2);
    } };
    r === "delete" ? Ne.delete(s, { ...b2, data: m }) : Ne[r](s, m, b2);
  }, get(r, s) {
    this.submit("get", r, s);
  }, post(r, s) {
    this.submit("post", r, s);
  }, put(r, s) {
    this.submit("put", r, s);
  }, patch(r, s) {
    this.submit("patch", r, s);
  }, delete(r, s) {
    this.submit("delete", r, s);
  }, cancel() {
    l && l.cancel();
  }, __rememberable: n === null, __remember() {
    return { data: this.data(), errors: this.errors };
  }, __restore(r) {
    Object.assign(this, r.data), this.setError(r.errors);
  } });
  return watch(y, (r) => {
    y.isDirty = !(0, import_lodash3.default)(y.data(), a), n && Ne.remember((0, import_lodash2.default)(r.__remember()), n);
  }, { immediate: true, deep: true }), y;
}
var c = ref(null);
var d = ref(null);
var x = shallowRef(null);
var F2 = ref(null);
var k2 = null;
var W2 = defineComponent({ name: "Inertia", props: { initialPage: { type: Object, required: true }, initialComponent: { type: Object, required: false }, resolveComponent: { type: Function, required: false }, titleCallback: { type: Function, required: false, default: (e) => e }, onHeadUpdate: { type: Function, required: false, default: () => () => {
} } }, setup({ initialPage: e, initialComponent: o, resolveComponent: n, titleCallback: p, onHeadUpdate: t }) {
  c.value = o ? markRaw(o) : null, d.value = e, F2.value = null;
  let a = typeof window > "u";
  return k2 = ee(a, p, t), a || (Ne.init({ initialPage: e, resolveComponent: n, swapComponent: async (l) => {
    c.value = markRaw(l.component), d.value = l.page, F2.value = l.preserveState ? F2.value : Date.now();
  } }), Ne.on("navigate", () => k2.forceUpdate())), () => {
    if (c.value) {
      c.value.inheritAttrs = !!c.value.inheritAttrs;
      let l = h(c.value, { ...d.value.props, key: F2.value });
      return x.value && (c.value.layout = x.value, x.value = null), c.value.layout ? typeof c.value.layout == "function" ? c.value.layout(h, l) : (Array.isArray(c.value.layout) ? c.value.layout : [c.value.layout]).concat(l).reverse().reduce((f2, h2) => (h2.inheritAttrs = !!h2.inheritAttrs, h(h2, { ...d.value.props }, () => f2))) : l;
    }
  };
} });
var E2 = W2;
var $2 = { install(e) {
  Ne.form = T2, Object.defineProperty(e.config.globalProperties, "$inertia", { get: () => Ne }), Object.defineProperty(e.config.globalProperties, "$page", { get: () => d.value }), Object.defineProperty(e.config.globalProperties, "$headManager", { get: () => k2 }), e.mixin(D2);
} };
function Q() {
  return reactive({ props: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.props;
  }), url: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.url;
  }), component: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.component;
  }), version: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.version;
  }), scrollRegions: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.scrollRegions;
  }), rememberedState: computed(() => {
    var _a;
    return (_a = d.value) == null ? void 0 : _a.rememberedState;
  }) });
}
async function j({ id: e = "app", resolve: o, setup: n, title: p, progress: t = {}, page: a, render: l }) {
  let f2 = typeof window > "u", h2 = f2 ? null : document.getElementById(e), y = a || JSON.parse(h2.dataset.page), r = (m) => Promise.resolve(o(m)).then((b2) => b2.default || b2), s = [], i = await r(y.component).then((m) => n({ el: h2, App: E2, props: { initialPage: y, initialComponent: m, resolveComponent: r, titleCallback: p, onHeadUpdate: f2 ? (b2) => s = b2 : null }, plugin: $2 }));
  if (!f2 && t && ie(t), f2) {
    let m = await l(createSSRApp({ render: () => h("div", { id: e, "data-page": JSON.stringify(y), innerHTML: i ? l(i) : "" }) }));
    return { head: s, body: m };
  }
}
var X2 = defineComponent({ props: { title: { type: String, required: false } }, data() {
  return { provider: this.$headManager.createProvider() };
}, beforeUnmount() {
  this.provider.disconnect();
}, methods: { isUnaryTag(e) {
  return ["area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"].indexOf(e.type) > -1;
}, renderTagStart(e) {
  e.props = e.props || {}, e.props.inertia = e.props["head-key"] !== void 0 ? e.props["head-key"] : "";
  let o = Object.keys(e.props).reduce((n, p) => {
    let t = e.props[p];
    return ["key", "head-key"].includes(p) ? n : t === "" ? n + ` ${p}` : n + ` ${p}="${t}"`;
  }, "");
  return `<${e.type}${o}>`;
}, renderTagChildren(e) {
  return typeof e.children == "string" ? e.children : e.children.reduce((o, n) => o + this.renderTag(n), "");
}, isFunctionNode(e) {
  return typeof e.type == "function";
}, isComponentNode(e) {
  return typeof e.type == "object";
}, isCommentNode(e) {
  return /(comment|cmt)/i.test(e.type.toString());
}, isFragmentNode(e) {
  return /(fragment|fgt|symbol\(\))/i.test(e.type.toString());
}, isTextNode(e) {
  return /(text|txt)/i.test(e.type.toString());
}, renderTag(e) {
  if (this.isTextNode(e)) return e.children;
  if (this.isFragmentNode(e)) return "";
  if (this.isCommentNode(e)) return "";
  let o = this.renderTagStart(e);
  return e.children && (o += this.renderTagChildren(e)), this.isUnaryTag(e) || (o += `</${e.type}>`), o;
}, addTitleElement(e) {
  return this.title && !e.find((o) => o.startsWith("<title")) && e.push(`<title inertia>${this.title}</title>`), e;
}, renderNodes(e) {
  return this.addTitleElement(e.flatMap((o) => this.resolveNode(o)).map((o) => this.renderTag(o)).filter((o) => o));
}, resolveNode(e) {
  return this.isFunctionNode(e) ? this.resolveNode(e.type()) : this.isComponentNode(e) ? (console.warn("Using components in the <Head> component is not supported."), []) : this.isTextNode(e) && e.children ? e : this.isFragmentNode(e) && e.children ? e.children.flatMap((o) => this.resolveNode(o)) : this.isCommentNode(e) ? [] : e;
} }, render() {
  this.provider.update(this.renderNodes(this.$slots.default ? this.$slots.default() : []));
} });
var Z2 = X2;
var se2 = defineComponent({ name: "Link", props: { as: { type: String, default: "a" }, data: { type: Object, default: () => ({}) }, href: { type: String, required: true }, method: { type: String, default: "get" }, replace: { type: Boolean, default: false }, preserveScroll: { type: Boolean, default: false }, preserveState: { type: Boolean, default: null }, only: { type: Array, default: () => [] }, except: { type: Array, default: () => [] }, headers: { type: Object, default: () => ({}) }, queryStringArrayFormat: { type: String, default: "brackets" } }, setup(e, { slots: o, attrs: n }) {
  return () => {
    let p = e.as.toLowerCase(), t = e.method.toLowerCase(), [a, l] = D(t, e.href || "", e.data, e.queryStringArrayFormat);
    return p === "a" && t !== "get" && console.warn(`Creating POST/PUT/PATCH/DELETE <a> links is discouraged as it causes "Open Link in New Tab/Window" accessibility issues.

Please specify a more appropriate element using the "as" attribute. For example:

<Link href="${a}" method="${t}" as="button">...</Link>`), h(e.as, { ...n, ...p === "a" ? { href: a } : {}, onClick: (f2) => {
      re(f2) && (f2.preventDefault(), Ne.visit(a, { data: l, method: t, replace: e.replace, preserveScroll: e.preserveScroll, preserveState: e.preserveState ?? t !== "get", only: e.only, except: e.except, headers: e.headers, onCancelToken: n.onCancelToken || (() => ({})), onBefore: n.onBefore || (() => ({})), onStart: n.onStart || (() => ({})), onProgress: n.onProgress || (() => ({})), onFinish: n.onFinish || (() => ({})), onCancel: n.onCancel || (() => ({})), onSuccess: n.onSuccess || (() => ({})), onError: n.onError || (() => ({})) }));
    } }, o);
  };
} });
var ie2 = se2;
function O2(e, o) {
  if (typeof e == "object" && e !== null && e.__rememberable === false) return e;
  let n = Ne.restore(o), p = isReactive(e) ? reactive : ref, t = typeof e.__remember == "function" && typeof e.__restore == "function", a = p(n === void 0 ? e : t ? e.__restore(n) : n);
  return watch(a, (l) => {
    Ne.remember((0, import_lodash4.default)(t ? e.__remember() : l), o);
  }, { immediate: true, deep: true }), a;
}
export {
  Z2 as Head,
  ie2 as Link,
  j as createInertiaApp,
  Ne as router,
  T2 as useForm,
  Q as usePage,
  O2 as useRemember
};
/*! Bundled license information:

nprogress/nprogress.js:
  (* NProgress, (c) 2013, 2014 Rico Sta. Cruz - http://ricostacruz.com/nprogress
   * @license MIT *)
*/
//# sourceMappingURL=@inertiajs_vue3.js.map
