(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../Core/Utils/Constants.js"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EventDispatcher = void 0;
    const Constants_js_1 = require("../Core/Utils/Constants.js");
    class EventDispatcher {
        constructor() {
            this._listeners = new Map();
        }
        addEventListener(type, listener) {
            this.removeEventListener(type, listener);
            let arr = this._listeners.get(type);
            if (!arr) {
                arr = [];
                this._listeners.set(type, arr);
            }
            arr.push(listener);
        }
        dispatchEvent(type, args) {
            const listeners = this._listeners.get(type);
            listeners?.forEach(handler => handler(args));
        }
        hasEventListener(type) {
            return !!this._listeners.get(type);
        }
        removeAllEventListeners(type) {
            if (!type) {
                this._listeners = new Map();
            }
            else {
                this._listeners.delete(type);
            }
        }
        removeEventListener(type, listener) {
            const arr = this._listeners.get(type);
            if (!arr) {
                return;
            }
            const length = arr.length, idx = arr.indexOf(listener);
            if (idx < Constants_js_1.minIndex) {
                return;
            }
            if (length === Constants_js_1.deleteCount) {
                this._listeners.delete(type);
            }
            else {
                arr.splice(idx, Constants_js_1.deleteCount);
            }
        }
    }
    exports.EventDispatcher = EventDispatcher;
});
