/*!
 * Author : Matteo Bruni
 * MIT license: https://opensource.org/licenses/MIT
 * Demo / Generator : https://particles.js.org/
 * GitHub : https://www.github.com/matteobruni/tsparticles
 * How to use? : Check the GitHub README
 * v3.9.1
 */
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("@tsparticles/engine"));
	else if(typeof define === 'function' && define.amd)
		define(["@tsparticles/engine"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("@tsparticles/engine")) : factory(root["window"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, (__WEBPACK_EXTERNAL_MODULE__tsparticles_engine__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./dist/browser/Bubbler.js":
/*!*********************************!*\
  !*** ./dist/browser/Bubbler.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubbler: () => (/* binding */ Bubbler)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Bubble.js */ \"./dist/browser/Options/Classes/Bubble.js\");\n/* harmony import */ var _Enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums.js */ \"./dist/browser/Enums.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Utils.js */ \"./dist/browser/Utils.js\");\n\n\n\n\nconst bubbleMode = \"bubble\",\n  minDistance = 0,\n  defaultClickTime = 0,\n  double = 2,\n  defaultOpacity = 1,\n  ratioOffset = 1,\n  defaultBubbleValue = 0,\n  minRatio = 0,\n  half = 0.5,\n  defaultRatio = 1;\nclass Bubbler extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container, engine) {\n    super(container);\n    this._clickBubble = () => {\n      const container = this.container,\n        options = container.actualOptions,\n        mouseClickPos = container.interactivity.mouse.clickPosition,\n        bubbleOptions = options.interactivity.modes.bubble;\n      if (!bubbleOptions || !mouseClickPos) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      const distance = container.retina.bubbleModeDistance;\n      if (!distance || distance < minDistance) {\n        return;\n      }\n      const query = container.particles.quadTree.queryCircle(mouseClickPos, distance, p => this.isEnabled(p)),\n        {\n          bubble\n        } = container;\n      for (const particle of query) {\n        if (!bubble.clicking) {\n          continue;\n        }\n        particle.bubble.inRange = !bubble.durationEnd;\n        const pos = particle.getPosition(),\n          distMouse = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, mouseClickPos),\n          timeSpent = (new Date().getTime() - (container.interactivity.mouse.clickTime ?? defaultClickTime)) / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds;\n        if (timeSpent > bubbleOptions.duration) {\n          bubble.durationEnd = true;\n        }\n        if (timeSpent > bubbleOptions.duration * double) {\n          bubble.clicking = false;\n          bubble.durationEnd = false;\n        }\n        const sizeData = {\n          bubbleObj: {\n            optValue: container.retina.bubbleModeSize,\n            value: particle.bubble.radius\n          },\n          particlesObj: {\n            optValue: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.size.value) * container.retina.pixelRatio,\n            value: particle.size.value\n          },\n          type: _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size\n        };\n        this._process(particle, distMouse, timeSpent, sizeData);\n        const opacityData = {\n          bubbleObj: {\n            optValue: bubbleOptions.opacity,\n            value: particle.bubble.opacity\n          },\n          particlesObj: {\n            optValue: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.opacity.value),\n            value: particle.opacity?.value ?? defaultOpacity\n          },\n          type: _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity\n        };\n        this._process(particle, distMouse, timeSpent, opacityData);\n        if (!bubble.durationEnd && distMouse <= distance) {\n          this._hoverBubbleColor(particle, distMouse);\n        } else {\n          delete particle.bubble.color;\n        }\n      }\n    };\n    this._hoverBubble = () => {\n      const container = this.container,\n        mousePos = container.interactivity.mouse.position,\n        distance = container.retina.bubbleModeDistance;\n      if (!distance || distance < minDistance || !mousePos) {\n        return;\n      }\n      const query = container.particles.quadTree.queryCircle(mousePos, distance, p => this.isEnabled(p));\n      for (const particle of query) {\n        particle.bubble.inRange = true;\n        const pos = particle.getPosition(),\n          pointDistance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, mousePos),\n          ratio = ratioOffset - pointDistance / distance;\n        if (pointDistance <= distance) {\n          if (ratio >= minRatio && container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent) {\n            this._hoverBubbleSize(particle, ratio);\n            this._hoverBubbleOpacity(particle, ratio);\n            this._hoverBubbleColor(particle, ratio);\n          }\n        } else {\n          this.reset(particle);\n        }\n        if (container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseLeaveEvent) {\n          this.reset(particle);\n        }\n      }\n    };\n    this._hoverBubbleColor = (particle, ratio, divBubble) => {\n      const options = this.container.actualOptions,\n        bubbleOptions = divBubble ?? options.interactivity.modes.bubble;\n      if (!bubbleOptions) {\n        return;\n      }\n      if (!particle.bubble.finalColor) {\n        const modeColor = bubbleOptions.color;\n        if (!modeColor) {\n          return;\n        }\n        const bubbleColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(modeColor);\n        particle.bubble.finalColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, bubbleColor);\n      }\n      if (!particle.bubble.finalColor) {\n        return;\n      }\n      if (bubbleOptions.mix) {\n        particle.bubble.color = undefined;\n        const pColor = particle.getFillColor();\n        particle.bubble.color = pColor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rgbToHsl)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.colorMix)(pColor, particle.bubble.finalColor, ratioOffset - ratio, ratio)) : particle.bubble.finalColor;\n      } else {\n        particle.bubble.color = particle.bubble.finalColor;\n      }\n    };\n    this._hoverBubbleOpacity = (particle, ratio, divBubble) => {\n      const container = this.container,\n        options = container.actualOptions,\n        modeOpacity = divBubble?.opacity ?? options.interactivity.modes.bubble?.opacity;\n      if (!modeOpacity) {\n        return;\n      }\n      const optOpacity = particle.options.opacity.value,\n        pOpacity = particle.opacity?.value ?? defaultOpacity,\n        opacity = (0,_Utils_js__WEBPACK_IMPORTED_MODULE_3__.calculateBubbleValue)(pOpacity, modeOpacity, (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(optOpacity), ratio);\n      if (opacity !== undefined) {\n        particle.bubble.opacity = opacity;\n      }\n    };\n    this._hoverBubbleSize = (particle, ratio, divBubble) => {\n      const container = this.container,\n        modeSize = divBubble?.size ? divBubble.size * container.retina.pixelRatio : container.retina.bubbleModeSize;\n      if (modeSize === undefined) {\n        return;\n      }\n      const optSize = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.size.value) * container.retina.pixelRatio,\n        pSize = particle.size.value,\n        size = (0,_Utils_js__WEBPACK_IMPORTED_MODULE_3__.calculateBubbleValue)(pSize, modeSize, optSize, ratio);\n      if (size !== undefined) {\n        particle.bubble.radius = size;\n      }\n    };\n    this._process = (particle, distMouse, timeSpent, data) => {\n      const container = this.container,\n        bubbleParam = data.bubbleObj.optValue,\n        options = container.actualOptions,\n        bubbleOptions = options.interactivity.modes.bubble;\n      if (!bubbleOptions || bubbleParam === undefined) {\n        return;\n      }\n      const bubbleDuration = bubbleOptions.duration,\n        bubbleDistance = container.retina.bubbleModeDistance,\n        particlesParam = data.particlesObj.optValue,\n        pObjBubble = data.bubbleObj.value,\n        pObj = data.particlesObj.value ?? defaultBubbleValue,\n        type = data.type;\n      if (!bubbleDistance || bubbleDistance < minDistance || bubbleParam === particlesParam) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      if (container.bubble.durationEnd) {\n        if (pObjBubble) {\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n            delete particle.bubble.radius;\n          }\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n            delete particle.bubble.opacity;\n          }\n        }\n      } else {\n        if (distMouse <= bubbleDistance) {\n          const obj = pObjBubble ?? pObj;\n          if (obj !== bubbleParam) {\n            const value = pObj - timeSpent * (pObj - bubbleParam) / bubbleDuration;\n            if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n              particle.bubble.radius = value;\n            }\n            if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n              particle.bubble.opacity = value;\n            }\n          }\n        } else {\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n            delete particle.bubble.radius;\n          }\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n            delete particle.bubble.opacity;\n          }\n        }\n      }\n    };\n    this._singleSelectorHover = (delta, selector, div) => {\n      const container = this.container,\n        selectors = document.querySelectorAll(selector),\n        bubble = container.actualOptions.interactivity.modes.bubble;\n      if (!bubble || !selectors.length) {\n        return;\n      }\n      selectors.forEach(item => {\n        const elem = item,\n          pxRatio = container.retina.pixelRatio,\n          pos = {\n            x: (elem.offsetLeft + elem.offsetWidth * half) * pxRatio,\n            y: (elem.offsetTop + elem.offsetHeight * half) * pxRatio\n          },\n          repulseRadius = elem.offsetWidth * half * pxRatio,\n          area = div.type === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DivType.circle ? new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos.x, pos.y, repulseRadius) : new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(elem.offsetLeft * pxRatio, elem.offsetTop * pxRatio, elem.offsetWidth * pxRatio, elem.offsetHeight * pxRatio),\n          query = container.particles.quadTree.query(area, p => this.isEnabled(p));\n        for (const particle of query) {\n          if (!area.contains(particle.getPosition())) {\n            continue;\n          }\n          particle.bubble.inRange = true;\n          const divs = bubble.divs,\n            divBubble = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divMode)(divs, elem);\n          if (!particle.bubble.div || particle.bubble.div !== elem) {\n            this.clear(particle, delta, true);\n            particle.bubble.div = elem;\n          }\n          this._hoverBubbleSize(particle, defaultRatio, divBubble);\n          this._hoverBubbleOpacity(particle, defaultRatio, divBubble);\n          this._hoverBubbleColor(particle, defaultRatio, divBubble);\n        }\n      });\n    };\n    this._engine = engine;\n    if (!container.bubble) {\n      container.bubble = {};\n    }\n    this.handleClickMode = mode => {\n      if (mode !== bubbleMode) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      container.bubble.clicking = true;\n    };\n  }\n  clear(particle, delta, force) {\n    if (particle.bubble.inRange && !force) {\n      return;\n    }\n    delete particle.bubble.div;\n    delete particle.bubble.opacity;\n    delete particle.bubble.radius;\n    delete particle.bubble.color;\n  }\n  init() {\n    const container = this.container,\n      bubble = container.actualOptions.interactivity.modes.bubble;\n    if (!bubble) {\n      return;\n    }\n    container.retina.bubbleModeDistance = bubble.distance * container.retina.pixelRatio;\n    if (bubble.size !== undefined) {\n      container.retina.bubbleModeSize = bubble.size * container.retina.pixelRatio;\n    }\n  }\n  interact(delta) {\n    const options = this.container.actualOptions,\n      events = options.interactivity.events,\n      onHover = events.onHover,\n      onClick = events.onClick,\n      hoverEnabled = onHover.enable,\n      hoverMode = onHover.mode,\n      clickEnabled = onClick.enable,\n      clickMode = onClick.mode,\n      divs = events.onDiv;\n    if (hoverEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, hoverMode)) {\n      this._hoverBubble();\n    } else if (clickEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, clickMode)) {\n      this._clickBubble();\n    } else {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divModeExecute)(bubbleMode, divs, (selector, div) => this._singleSelectorHover(delta, selector, div));\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events,\n      {\n        onClick,\n        onDiv,\n        onHover\n      } = events,\n      divBubble = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isDivModeEnabled)(bubbleMode, onDiv);\n    if (!(divBubble || onHover.enable && !!mouse.position || onClick.enable && mouse.clickPosition)) {\n      return false;\n    }\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, onHover.mode) || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, onClick.mode) || divBubble;\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.bubble) {\n      options.bubble = new _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_1__.Bubble();\n    }\n    for (const source of sources) {\n      options.bubble.load(source?.bubble);\n    }\n  }\n  reset(particle) {\n    particle.bubble.inRange = false;\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Bubbler.js?\n}");

/***/ }),

/***/ "./dist/browser/Enums.js":
/*!*******************************!*\
  !*** ./dist/browser/Enums.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ProcessBubbleType: () => (/* binding */ ProcessBubbleType)\n/* harmony export */ });\nvar ProcessBubbleType;\n(function (ProcessBubbleType) {\n  ProcessBubbleType[\"color\"] = \"color\";\n  ProcessBubbleType[\"opacity\"] = \"opacity\";\n  ProcessBubbleType[\"size\"] = \"size\";\n})(ProcessBubbleType || (ProcessBubbleType = {}));\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Enums.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/Bubble.js":
/*!************************************************!*\
  !*** ./dist/browser/Options/Classes/Bubble.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubble: () => (/* binding */ Bubble)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BubbleBase.js */ \"./dist/browser/Options/Classes/BubbleBase.js\");\n/* harmony import */ var _BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BubbleDiv.js */ \"./dist/browser/Options/Classes/BubbleDiv.js\");\n\n\n\nclass Bubble extends _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase {\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    this.divs = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.divs, div => {\n      const tmp = new _BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__.BubbleDiv();\n      tmp.load(div);\n      return tmp;\n    });\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Options/Classes/Bubble.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/BubbleBase.js":
/*!****************************************************!*\
  !*** ./dist/browser/Options/Classes/BubbleBase.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BubbleBase: () => (/* binding */ BubbleBase)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nclass BubbleBase {\n  constructor() {\n    this.distance = 200;\n    this.duration = 0.4;\n    this.mix = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.duration !== undefined) {\n      this.duration = data.duration;\n    }\n    if (data.mix !== undefined) {\n      this.mix = data.mix;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    if (data.color !== undefined) {\n      const sourceColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(this.color) ? undefined : this.color;\n      this.color = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.color, color => {\n        return _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(sourceColor, color);\n      });\n    }\n    if (data.size !== undefined) {\n      this.size = data.size;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Options/Classes/BubbleBase.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/BubbleDiv.js":
/*!***************************************************!*\
  !*** ./dist/browser/Options/Classes/BubbleDiv.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BubbleDiv: () => (/* binding */ BubbleDiv)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BubbleBase.js */ \"./dist/browser/Options/Classes/BubbleBase.js\");\n\n\nclass BubbleDiv extends _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase {\n  constructor() {\n    super();\n    this.selectors = [];\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.selectors !== undefined) {\n      this.selectors = data.selectors;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Options/Classes/BubbleDiv.js?\n}");

/***/ }),

/***/ "./dist/browser/Utils.js":
/*!*******************************!*\
  !*** ./dist/browser/Utils.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   calculateBubbleValue: () => (/* binding */ calculateBubbleValue)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nfunction calculateBubbleValue(particleValue, modeValue, optionsValue, ratio) {\n  if (modeValue >= optionsValue) {\n    const value = particleValue + (modeValue - optionsValue) * ratio;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(value, particleValue, modeValue);\n  } else if (modeValue < optionsValue) {\n    const value = particleValue - (optionsValue - modeValue) * ratio;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(value, modeValue, particleValue);\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/Utils.js?\n}");

/***/ }),

/***/ "./dist/browser/index.js":
/*!*******************************!*\
  !*** ./dist/browser/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubble: () => (/* reexport safe */ _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_3__.Bubble),\n/* harmony export */   BubbleBase: () => (/* reexport safe */ _Options_Classes_BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase),\n/* harmony export */   BubbleDiv: () => (/* reexport safe */ _Options_Classes_BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__.BubbleDiv),\n/* harmony export */   loadExternalBubbleInteraction: () => (/* binding */ loadExternalBubbleInteraction)\n/* harmony export */ });\n/* harmony import */ var _Bubbler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Bubbler.js */ \"./dist/browser/Bubbler.js\");\n/* harmony import */ var _Options_Classes_BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/BubbleBase.js */ \"./dist/browser/Options/Classes/BubbleBase.js\");\n/* harmony import */ var _Options_Classes_BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/BubbleDiv.js */ \"./dist/browser/Options/Classes/BubbleDiv.js\");\n/* harmony import */ var _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Classes/Bubble.js */ \"./dist/browser/Options/Classes/Bubble.js\");\n\nasync function loadExternalBubbleInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalBubble\", container => {\n    return Promise.resolve(new _Bubbler_js__WEBPACK_IMPORTED_MODULE_0__.Bubbler(container, engine));\n  }, refresh);\n}\n\n\n\n\n\n\n\n//# sourceURL=webpack://@tsparticles/interaction-external-bubble/./dist/browser/index.js?\n}");

/***/ }),

/***/ "@tsparticles/engine":
/*!*********************************************************************************************************************************!*\
  !*** external {"commonjs":"@tsparticles/engine","commonjs2":"@tsparticles/engine","amd":"@tsparticles/engine","root":"window"} ***!
  \*********************************************************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__tsparticles_engine__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./dist/browser/index.js");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});