/*!
 * Author : Matteo Bruni
 * MIT license: https://opensource.org/licenses/MIT
 * Demo / Generator : https://particles.js.org/
 * GitHub : https://www.github.com/matteobruni/tsparticles
 * How to use? : Check the GitHub README
 * v3.9.1
 */
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("@tsparticles/engine"));
	else if(typeof define === 'function' && define.amd)
		define(["@tsparticles/engine"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("@tsparticles/engine")) : factory(root["window"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, (__WEBPACK_EXTERNAL_MODULE__tsparticles_engine__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./dist/browser/AbsorberInstance.js":
/*!******************************************!*\
  !*** ./dist/browser/AbsorberInstance.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberInstance: () => (/* binding */ AbsorberInstance)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Absorber.js */ \"./dist/browser/Options/Classes/Absorber.js\");\n\n\nconst squareExp = 2,\n  absorbFactor = 0.033,\n  minOrbitLength = 0,\n  minRadius = 0,\n  minMass = 0,\n  minAngle = 0,\n  double = 2,\n  maxAngle = Math.PI * double,\n  minVelocity = 0;\nclass AbsorberInstance {\n  constructor(absorbers, container, engine, options, position) {\n    this._calcPosition = () => {\n      const exactPosition = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calcPositionOrRandomFromSizeRanged)({\n        size: this._container.canvas.size,\n        position: this.options.position\n      });\n      return _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(exactPosition.x, exactPosition.y);\n    };\n    this._updateParticlePosition = (particle, v) => {\n      if (particle.destroyed) {\n        return;\n      }\n      const container = this._container,\n        canvasSize = container.canvas.size;\n      if (particle.needsNewPosition) {\n        const newPosition = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calcPositionOrRandomFromSize)({\n          size: canvasSize\n        });\n        particle.position.setTo(newPosition);\n        particle.velocity.setTo(particle.initialVelocity);\n        particle.absorberOrbit = undefined;\n        particle.needsNewPosition = false;\n      }\n      if (this.options.orbits) {\n        if (particle.absorberOrbit === undefined) {\n          particle.absorberOrbit = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n          particle.absorberOrbit.length = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(particle.getPosition(), this.position);\n          particle.absorberOrbit.angle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * maxAngle;\n        }\n        if (particle.absorberOrbit.length <= this.size && !this.options.destroy) {\n          const minSize = Math.min(canvasSize.width, canvasSize.height),\n            offset = 1,\n            randomOffset = 0.1,\n            randomFactor = 0.2;\n          particle.absorberOrbit.length = minSize * (offset + ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * randomFactor - randomOffset));\n        }\n        if (particle.absorberOrbitDirection === undefined) {\n          particle.absorberOrbitDirection = particle.velocity.x >= minVelocity ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise : _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.counterClockwise;\n        }\n        const orbitRadius = particle.absorberOrbit.length,\n          orbitAngle = particle.absorberOrbit.angle,\n          orbitDirection = particle.absorberOrbitDirection;\n        particle.velocity.setTo(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin);\n        const updateFunc = {\n          x: orbitDirection === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise ? Math.cos : Math.sin,\n          y: orbitDirection === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise ? Math.sin : Math.cos\n        };\n        particle.position.x = this.position.x + orbitRadius * updateFunc.x(orbitAngle);\n        particle.position.y = this.position.y + orbitRadius * updateFunc.y(orbitAngle);\n        particle.absorberOrbit.length -= v.length;\n        particle.absorberOrbit.angle += (particle.retina.moveSpeed ?? minVelocity) * container.retina.pixelRatio / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator * container.retina.reduceFactor;\n      } else {\n        const addV = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n        addV.length = v.length;\n        addV.angle = v.angle;\n        particle.velocity.addTo(addV);\n      }\n    };\n    this._absorbers = absorbers;\n    this._container = container;\n    this._engine = engine;\n    this.initialPosition = position ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(position.x, position.y) : undefined;\n    if (options instanceof _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber) {\n      this.options = options;\n    } else {\n      this.options = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n      this.options.load(options);\n    }\n    this.dragging = false;\n    this.name = this.options.name;\n    this.opacity = this.options.opacity;\n    this.size = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.size.value) * container.retina.pixelRatio;\n    this.mass = this.size * this.options.size.density * container.retina.reduceFactor;\n    const limit = this.options.size.limit;\n    this.limit = {\n      radius: limit.radius * container.retina.pixelRatio * container.retina.reduceFactor,\n      mass: limit.mass\n    };\n    this.color = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, this.options.color) ?? {\n      b: 0,\n      g: 0,\n      r: 0\n    };\n    this.position = this.initialPosition?.copy() ?? this._calcPosition();\n  }\n  attract(particle) {\n    const container = this._container,\n      options = this.options;\n    if (options.draggable) {\n      const mouse = container.interactivity.mouse;\n      if (mouse.clicking && mouse.downPosition) {\n        const mouseDist = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(this.position, mouse.downPosition);\n        if (mouseDist <= this.size) {\n          this.dragging = true;\n        }\n      } else {\n        this.dragging = false;\n      }\n      if (this.dragging && mouse.position) {\n        this.position.x = mouse.position.x;\n        this.position.y = mouse.position.y;\n      }\n    }\n    const pos = particle.getPosition(),\n      {\n        dx,\n        dy,\n        distance\n      } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(this.position, pos),\n      v = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(dx, dy);\n    v.length = this.mass / Math.pow(distance, squareExp) * container.retina.reduceFactor;\n    if (distance < this.size + particle.getRadius()) {\n      const sizeFactor = particle.getRadius() * absorbFactor * container.retina.pixelRatio;\n      if (this.size > particle.getRadius() && distance < this.size - particle.getRadius() || particle.absorberOrbit !== undefined && particle.absorberOrbit.length < minOrbitLength) {\n        if (options.destroy) {\n          particle.destroy();\n        } else {\n          particle.needsNewPosition = true;\n          this._updateParticlePosition(particle, v);\n        }\n      } else {\n        if (options.destroy) {\n          particle.size.value -= sizeFactor;\n        }\n        this._updateParticlePosition(particle, v);\n      }\n      if (this.limit.radius <= minRadius || this.size < this.limit.radius) {\n        this.size += sizeFactor;\n      }\n      if (this.limit.mass <= minMass || this.mass < this.limit.mass) {\n        this.mass += sizeFactor * this.options.size.density * container.retina.reduceFactor;\n      }\n    } else {\n      this._updateParticlePosition(particle, v);\n    }\n  }\n  draw(context) {\n    context.translate(this.position.x, this.position.y);\n    context.beginPath();\n    context.arc(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, this.size, minAngle, maxAngle, false);\n    context.closePath();\n    context.fillStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(this.color, this.opacity);\n    context.fill();\n  }\n  resize() {\n    const initialPosition = this.initialPosition;\n    this.position = initialPosition && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(initialPosition, this._container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin) ? initialPosition : this._calcPosition();\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/AbsorberInstance.js?\n}");

/***/ }),

/***/ "./dist/browser/Absorbers.js":
/*!***********************************!*\
  !*** ./dist/browser/Absorbers.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Absorbers: () => (/* binding */ Absorbers)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"./dist/browser/Enums/AbsorberClickMode.js\");\n/* harmony import */ var _AbsorberInstance_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbsorberInstance.js */ \"./dist/browser/AbsorberInstance.js\");\n\n\n\nconst defaultIndex = 0;\nclass Absorbers {\n  constructor(container, engine) {\n    this._container = container;\n    this._engine = engine;\n    this.array = [];\n    this.absorbers = [];\n    this.interactivityAbsorbers = [];\n    container.getAbsorber = idxOrName => idxOrName === undefined || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(idxOrName) ? this.array[idxOrName ?? defaultIndex] : this.array.find(t => t.name === idxOrName);\n    container.addAbsorber = async (options, position) => this.addAbsorber(options, position);\n  }\n  async addAbsorber(options, position) {\n    const absorber = new _AbsorberInstance_js__WEBPACK_IMPORTED_MODULE_2__.AbsorberInstance(this, this._container, this._engine, options, position);\n    this.array.push(absorber);\n    return Promise.resolve(absorber);\n  }\n  draw(context) {\n    for (const absorber of this.array) {\n      absorber.draw(context);\n    }\n  }\n  handleClickMode(mode) {\n    const absorberOptions = this.absorbers,\n      modeAbsorbers = this.interactivityAbsorbers;\n    if (mode === _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberClickMode.absorber) {\n      const absorbersModeOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(modeAbsorbers),\n        absorbersOptions = absorbersModeOptions ?? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(absorberOptions),\n        aPosition = this._container.interactivity.mouse.clickPosition;\n      void this.addAbsorber(absorbersOptions, aPosition);\n    }\n  }\n  async init() {\n    this.absorbers = this._container.actualOptions.absorbers;\n    this.interactivityAbsorbers = this._container.actualOptions.interactivity.modes.absorbers;\n    const promises = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(this.absorbers, async absorber => {\n      await this.addAbsorber(absorber);\n    });\n    if (promises instanceof Array) {\n      await Promise.all(promises);\n    } else {\n      await promises;\n    }\n  }\n  particleUpdate(particle) {\n    for (const absorber of this.array) {\n      absorber.attract(particle);\n      if (particle.destroyed) {\n        break;\n      }\n    }\n  }\n  removeAbsorber(absorber) {\n    const index = this.array.indexOf(absorber),\n      deleteCount = 1;\n    if (index >= defaultIndex) {\n      this.array.splice(index, deleteCount);\n    }\n  }\n  resize() {\n    for (const absorber of this.array) {\n      absorber.resize();\n    }\n  }\n  stop() {\n    this.array = [];\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/Absorbers.js?\n}");

/***/ }),

/***/ "./dist/browser/AbsorbersPlugin.js":
/*!*****************************************!*\
  !*** ./dist/browser/AbsorbersPlugin.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorbersPlugin: () => (/* binding */ AbsorbersPlugin)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Absorber.js */ \"./dist/browser/Options/Classes/Absorber.js\");\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"./dist/browser/Enums/AbsorberClickMode.js\");\n/* harmony import */ var _Absorbers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Absorbers.js */ \"./dist/browser/Absorbers.js\");\n\n\n\n\nclass AbsorbersPlugin {\n  constructor(engine) {\n    this.id = \"absorbers\";\n    this._engine = engine;\n  }\n  async getPlugin(container) {\n    return Promise.resolve(new _Absorbers_js__WEBPACK_IMPORTED_MODULE_3__.Absorbers(container, this._engine));\n  }\n  loadOptions(options, source) {\n    if (!this.needsPlugin(options) && !this.needsPlugin(source)) {\n      return;\n    }\n    if (source?.absorbers) {\n      options.absorbers = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(source.absorbers, absorber => {\n        const tmp = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n        tmp.load(absorber);\n        return tmp;\n      });\n    }\n    options.interactivity.modes.absorbers = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(source?.interactivity?.modes?.absorbers, absorber => {\n      const tmp = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n      tmp.load(absorber);\n      return tmp;\n    });\n  }\n  needsPlugin(options) {\n    if (!options) {\n      return false;\n    }\n    const absorbers = options.absorbers;\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(absorbers)) {\n      return !!absorbers.length;\n    } else if (absorbers) {\n      return true;\n    } else if (options.interactivity?.events?.onClick?.mode && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(_Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__.AbsorberClickMode.absorber, options.interactivity.events.onClick.mode)) {\n      return true;\n    }\n    return false;\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/AbsorbersPlugin.js?\n}");

/***/ }),

/***/ "./dist/browser/Enums/AbsorberClickMode.js":
/*!*************************************************!*\
  !*** ./dist/browser/Enums/AbsorberClickMode.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberClickMode: () => (/* binding */ AbsorberClickMode)\n/* harmony export */ });\nvar AbsorberClickMode;\n(function (AbsorberClickMode) {\n  AbsorberClickMode[\"absorber\"] = \"absorber\";\n})(AbsorberClickMode || (AbsorberClickMode = {}));\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/Enums/AbsorberClickMode.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/Absorber.js":
/*!**************************************************!*\
  !*** ./dist/browser/Options/Classes/Absorber.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Absorber: () => (/* binding */ Absorber)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _AbsorberSize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AbsorberSize.js */ \"./dist/browser/Options/Classes/AbsorberSize.js\");\n\n\nclass Absorber {\n  constructor() {\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#000000\";\n    this.draggable = false;\n    this.opacity = 1;\n    this.destroy = true;\n    this.orbits = false;\n    this.size = new _AbsorberSize_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberSize();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.draggable !== undefined) {\n      this.draggable = data.draggable;\n    }\n    this.name = data.name;\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    if (data.position !== undefined) {\n      this.position = {};\n      if (data.position.x !== undefined) {\n        this.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.x);\n      }\n      if (data.position.y !== undefined) {\n        this.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.y);\n      }\n    }\n    if (data.size !== undefined) {\n      this.size.load(data.size);\n    }\n    if (data.destroy !== undefined) {\n      this.destroy = data.destroy;\n    }\n    if (data.orbits !== undefined) {\n      this.orbits = data.orbits;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/Options/Classes/Absorber.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/AbsorberSize.js":
/*!******************************************************!*\
  !*** ./dist/browser/Options/Classes/AbsorberSize.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberSize: () => (/* binding */ AbsorberSize)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _AbsorberSizeLimit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AbsorberSizeLimit.js */ \"./dist/browser/Options/Classes/AbsorberSizeLimit.js\");\n\n\nclass AbsorberSize extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.density = 5;\n    this.value = 50;\n    this.limit = new _AbsorberSizeLimit_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberSizeLimit();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    if (data.density !== undefined) {\n      this.density = data.density;\n    }\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(data.limit)) {\n      this.limit.radius = data.limit;\n    } else {\n      this.limit.load(data.limit);\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/Options/Classes/AbsorberSize.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/AbsorberSizeLimit.js":
/*!***********************************************************!*\
  !*** ./dist/browser/Options/Classes/AbsorberSizeLimit.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberSizeLimit: () => (/* binding */ AbsorberSizeLimit)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nclass AbsorberSizeLimit {\n  constructor() {\n    this.radius = 0;\n    this.mass = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.mass !== undefined) {\n      this.mass = data.mass;\n    }\n    if (data.radius !== undefined) {\n      this.radius = data.radius;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/Options/Classes/AbsorberSizeLimit.js?\n}");

/***/ }),

/***/ "./dist/browser/index.js":
/*!*******************************!*\
  !*** ./dist/browser/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberClickMode: () => (/* reexport safe */ _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberClickMode),\n/* harmony export */   loadAbsorbersPlugin: () => (/* binding */ loadAbsorbersPlugin)\n/* harmony export */ });\n/* harmony import */ var _AbsorbersPlugin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AbsorbersPlugin.js */ \"./dist/browser/AbsorbersPlugin.js\");\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"./dist/browser/Enums/AbsorberClickMode.js\");\n\nasync function loadAbsorbersPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addPlugin(new _AbsorbersPlugin_js__WEBPACK_IMPORTED_MODULE_0__.AbsorbersPlugin(engine), refresh);\n}\n\n\n\n//# sourceURL=webpack://@tsparticles/plugin-absorbers/./dist/browser/index.js?\n}");

/***/ }),

/***/ "@tsparticles/engine":
/*!*********************************************************************************************************************************!*\
  !*** external {"commonjs":"@tsparticles/engine","commonjs2":"@tsparticles/engine","amd":"@tsparticles/engine","root":"window"} ***!
  \*********************************************************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__tsparticles_engine__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./dist/browser/index.js");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});