"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadEasingQuadPlugin = loadEasingQuadPlugin;
const engine_1 = require("@tsparticles/engine");
async function loadEasingQuadPlugin(engine, refresh = true) {
    engine.checkVersion("3.9.1");
    await engine.addEasing(engine_1.EasingType.easeInQuad, value => value ** 2, false);
    await engine.addEasing(engine_1.EasingType.easeOutQuad, value => 1 - (1 - value) ** 2, false);
    await engine.addEasing(engine_1.EasingType.easeInOutQuad, value => (value < 0.5 ? 2 * value ** 2 : 1 - (-2 * value + 2) ** 2 / 2), false);
    await engine.refresh(refresh);
}
