import { EasingType } from "@tsparticles/engine";
export async function loadEasingQuadPlugin(engine, refresh = true) {
    engine.checkVersion("3.9.1");
    await engine.addEasing(EasingType.easeInQuad, value => value ** 2, false);
    await engine.addEasing(EasingType.easeOutQuad, value => 1 - (1 - value) ** 2, false);
    await engine.addEasing(EasingType.easeInOutQuad, value => (value < 0.5 ? 2 * value ** 2 : 1 - (-2 * value + 2) ** 2 / 2), false);
    await engine.refresh(refresh);
}
