(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "@tsparticles/engine"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.updateWobble = updateWobble;
    const engine_1 = require("@tsparticles/engine");
    const defaultDistance = 0, double = 2, doublePI = Math.PI * double, distanceFactor = 60;
    function updateWobble(particle, delta) {
        const { wobble: wobbleOptions } = particle.options, { container, wobble } = particle;
        if (!wobbleOptions?.enable || !wobble) {
            return;
        }
        const reduceFactor = container.retina.reduceFactor, angleSpeed = wobble.angleSpeed * delta.factor * reduceFactor, moveSpeed = wobble.moveSpeed * delta.factor * reduceFactor, distance = (moveSpeed * (particle.retina.wobbleDistance ?? defaultDistance)) /
            (engine_1.millisecondsToSeconds / distanceFactor), max = doublePI, { position } = particle;
        wobble.angle += angleSpeed;
        if (wobble.angle > max) {
            wobble.angle -= max;
        }
        position.x += distance * Math.cos(wobble.angle);
        position.y += distance * Math.abs(Math.sin(wobble.angle));
    }
});
