/*!
 * Author : Matteo Bruni
 * MIT license: https://opensource.org/licenses/MIT
 * Demo / Generator : https://particles.js.org/
 * GitHub : https://www.github.com/matteobruni/tsparticles
 * How to use? : Check the GitHub README
 * v3.9.1
 */
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "../../engine/dist/browser/Core/Canvas.js":
/*!************************************************!*\
  !*** ../../engine/dist/browser/Core/Canvas.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Canvas: () => (/* binding */ Canvas)\n/* harmony export */ });\n/* harmony import */ var _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Utils/CanvasUtils.js */ \"../../engine/dist/browser/Utils/CanvasUtils.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Utils/ColorUtils.js */ \"../../engine/dist/browser/Utils/ColorUtils.js\");\n\n\n\n\nfunction setTransformValue(factor, newFactor, key) {\n  const newValue = newFactor[key];\n  if (newValue !== undefined) {\n    factor[key] = (factor[key] ?? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.defaultTransformValue) * newValue;\n  }\n}\nfunction setStyle(canvas, style, important = false) {\n  if (!style) {\n    return;\n  }\n  const element = canvas;\n  if (!element) {\n    return;\n  }\n  const elementStyle = element.style;\n  if (!elementStyle) {\n    return;\n  }\n  const keys = new Set();\n  for (const key in elementStyle) {\n    if (!Object.prototype.hasOwnProperty.call(elementStyle, key)) {\n      continue;\n    }\n    keys.add(elementStyle[key]);\n  }\n  for (const key in style) {\n    if (!Object.prototype.hasOwnProperty.call(style, key)) {\n      continue;\n    }\n    keys.add(style[key]);\n  }\n  for (const key of keys) {\n    const value = style.getPropertyValue(key);\n    if (!value) {\n      elementStyle.removeProperty(key);\n    } else {\n      elementStyle.setProperty(key, value, important ? \"important\" : \"\");\n    }\n  }\n}\nclass Canvas {\n  constructor(container, engine) {\n    this.container = container;\n    this._applyPostDrawUpdaters = particle => {\n      for (const updater of this._postDrawUpdaters) {\n        updater.afterDraw?.(particle);\n      }\n    };\n    this._applyPreDrawUpdaters = (ctx, particle, radius, zOpacity, colorStyles, transform) => {\n      for (const updater of this._preDrawUpdaters) {\n        if (updater.getColorStyles) {\n          const {\n            fill,\n            stroke\n          } = updater.getColorStyles(particle, ctx, radius, zOpacity);\n          if (fill) {\n            colorStyles.fill = fill;\n          }\n          if (stroke) {\n            colorStyles.stroke = stroke;\n          }\n        }\n        if (updater.getTransformValues) {\n          const updaterTransform = updater.getTransformValues(particle);\n          for (const key in updaterTransform) {\n            setTransformValue(transform, updaterTransform, key);\n          }\n        }\n        updater.beforeDraw?.(particle);\n      }\n    };\n    this._applyResizePlugins = () => {\n      for (const plugin of this._resizePlugins) {\n        plugin.resize?.();\n      }\n    };\n    this._getPluginParticleColors = particle => {\n      let fColor, sColor;\n      for (const plugin of this._colorPlugins) {\n        if (!fColor && plugin.particleFillColor) {\n          fColor = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.rangeColorToHsl)(this._engine, plugin.particleFillColor(particle));\n        }\n        if (!sColor && plugin.particleStrokeColor) {\n          sColor = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.rangeColorToHsl)(this._engine, plugin.particleStrokeColor(particle));\n        }\n        if (fColor && sColor) {\n          break;\n        }\n      }\n      return [fColor, sColor];\n    };\n    this._initCover = async () => {\n      const options = this.container.actualOptions,\n        cover = options.backgroundMask.cover,\n        color = cover.color;\n      if (color) {\n        const coverRgb = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.rangeColorToRgb)(this._engine, color);\n        if (coverRgb) {\n          const coverColor = {\n            ...coverRgb,\n            a: cover.opacity\n          };\n          this._coverColorStyle = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.getStyleFromRgb)(coverColor, coverColor.a);\n        }\n      } else {\n        await new Promise((resolve, reject) => {\n          if (!cover.image) {\n            return;\n          }\n          const img = document.createElement(\"img\");\n          img.addEventListener(\"load\", () => {\n            this._coverImage = {\n              image: img,\n              opacity: cover.opacity\n            };\n            resolve();\n          });\n          img.addEventListener(\"error\", evt => {\n            reject(evt.error);\n          });\n          img.src = cover.image;\n        });\n      }\n    };\n    this._initStyle = () => {\n      const element = this.element,\n        options = this.container.actualOptions;\n      if (!element) {\n        return;\n      }\n      if (this._fullScreen) {\n        this._setFullScreenStyle();\n      } else {\n        this._resetOriginalStyle();\n      }\n      for (const key in options.style) {\n        if (!key || !options.style || !Object.prototype.hasOwnProperty.call(options.style, key)) {\n          continue;\n        }\n        const value = options.style[key];\n        if (!value) {\n          continue;\n        }\n        element.style.setProperty(key, value, \"important\");\n      }\n    };\n    this._initTrail = async () => {\n      const options = this.container.actualOptions,\n        trail = options.particles.move.trail,\n        trailFill = trail.fill;\n      if (!trail.enable) {\n        return;\n      }\n      const opacity = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.inverseFactorNumerator / trail.length;\n      if (trailFill.color) {\n        const fillColor = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.rangeColorToRgb)(this._engine, trailFill.color);\n        if (!fillColor) {\n          return;\n        }\n        this._trailFill = {\n          color: {\n            ...fillColor\n          },\n          opacity\n        };\n      } else {\n        await new Promise((resolve, reject) => {\n          if (!trailFill.image) {\n            return;\n          }\n          const img = document.createElement(\"img\");\n          img.addEventListener(\"load\", () => {\n            this._trailFill = {\n              image: img,\n              opacity\n            };\n            resolve();\n          });\n          img.addEventListener(\"error\", evt => {\n            reject(evt.error);\n          });\n          img.src = trailFill.image;\n        });\n      }\n    };\n    this._paintBase = baseColor => {\n      this.draw(ctx => (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.paintBase)(ctx, this.size, baseColor));\n    };\n    this._paintImage = (image, opacity) => {\n      this.draw(ctx => (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.paintImage)(ctx, this.size, image, opacity));\n    };\n    this._repairStyle = () => {\n      const element = this.element;\n      if (!element) {\n        return;\n      }\n      this._safeMutationObserver(observer => observer.disconnect());\n      this._initStyle();\n      this.initBackground();\n      const pointerEvents = this._pointerEvents;\n      element.style.pointerEvents = pointerEvents;\n      element.setAttribute(\"pointer-events\", pointerEvents);\n      this._safeMutationObserver(observer => {\n        if (!element || !(element instanceof Node)) {\n          return;\n        }\n        observer.observe(element, {\n          attributes: true\n        });\n      });\n    };\n    this._resetOriginalStyle = () => {\n      const element = this.element,\n        originalStyle = this._originalStyle;\n      if (!element || !originalStyle) {\n        return;\n      }\n      setStyle(element, originalStyle, true);\n    };\n    this._safeMutationObserver = callback => {\n      if (!this._mutationObserver) {\n        return;\n      }\n      callback(this._mutationObserver);\n    };\n    this._setFullScreenStyle = () => {\n      const element = this.element;\n      if (!element) {\n        return;\n      }\n      setStyle(element, (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getFullScreenStyle)(this.container.actualOptions.fullScreen.zIndex), true);\n    };\n    this._engine = engine;\n    this._standardSize = {\n      height: 0,\n      width: 0\n    };\n    const pxRatio = container.retina.pixelRatio,\n      stdSize = this._standardSize;\n    this.size = {\n      height: stdSize.height * pxRatio,\n      width: stdSize.width * pxRatio\n    };\n    this._context = null;\n    this._generated = false;\n    this._preDrawUpdaters = [];\n    this._postDrawUpdaters = [];\n    this._resizePlugins = [];\n    this._colorPlugins = [];\n    this._pointerEvents = \"none\";\n  }\n  get _fullScreen() {\n    return this.container.actualOptions.fullScreen.enable;\n  }\n  clear() {\n    const options = this.container.actualOptions,\n      trail = options.particles.move.trail,\n      trailFill = this._trailFill;\n    if (options.backgroundMask.enable) {\n      this.paint();\n    } else if (trail.enable && trail.length > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.minimumLength && trailFill) {\n      if (trailFill.color) {\n        this._paintBase((0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.getStyleFromRgb)(trailFill.color, trailFill.opacity));\n      } else if (trailFill.image) {\n        this._paintImage(trailFill.image, trailFill.opacity);\n      }\n    } else if (options.clear) {\n      this.draw(ctx => {\n        (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.clear)(ctx, this.size);\n      });\n    }\n  }\n  destroy() {\n    this.stop();\n    if (this._generated) {\n      const element = this.element;\n      element?.remove();\n      this.element = undefined;\n    } else {\n      this._resetOriginalStyle();\n    }\n    this._preDrawUpdaters = [];\n    this._postDrawUpdaters = [];\n    this._resizePlugins = [];\n    this._colorPlugins = [];\n  }\n  draw(cb) {\n    const ctx = this._context;\n    if (!ctx) {\n      return;\n    }\n    return cb(ctx);\n  }\n  drawAsync(cb) {\n    const ctx = this._context;\n    if (!ctx) {\n      return undefined;\n    }\n    return cb(ctx);\n  }\n  drawParticle(particle, delta) {\n    if (particle.spawning || particle.destroyed) {\n      return;\n    }\n    const radius = particle.getRadius();\n    if (radius <= _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.minimumSize) {\n      return;\n    }\n    const pfColor = particle.getFillColor(),\n      psColor = particle.getStrokeColor() ?? pfColor;\n    let [fColor, sColor] = this._getPluginParticleColors(particle);\n    if (!fColor) {\n      fColor = pfColor;\n    }\n    if (!sColor) {\n      sColor = psColor;\n    }\n    if (!fColor && !sColor) {\n      return;\n    }\n    this.draw(ctx => {\n      const container = this.container,\n        options = container.actualOptions,\n        zIndexOptions = particle.options.zIndex,\n        zIndexFactor = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.zIndexFactorOffset - particle.zIndexFactor,\n        zOpacityFactor = zIndexFactor ** zIndexOptions.opacityRate,\n        opacity = particle.bubble.opacity ?? particle.opacity?.value ?? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.defaultOpacity,\n        strokeOpacity = particle.strokeOpacity ?? opacity,\n        zOpacity = opacity * zOpacityFactor,\n        zStrokeOpacity = strokeOpacity * zOpacityFactor,\n        transform = {},\n        colorStyles = {\n          fill: fColor ? (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.getStyleFromHsl)(fColor, zOpacity) : undefined\n        };\n      colorStyles.stroke = sColor ? (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.getStyleFromHsl)(sColor, zStrokeOpacity) : colorStyles.fill;\n      this._applyPreDrawUpdaters(ctx, particle, radius, zOpacity, colorStyles, transform);\n      (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.drawParticle)({\n        container,\n        context: ctx,\n        particle,\n        delta,\n        colorStyles,\n        backgroundMask: options.backgroundMask.enable,\n        composite: options.backgroundMask.composite,\n        radius: radius * zIndexFactor ** zIndexOptions.sizeRate,\n        opacity: zOpacity,\n        shadow: particle.options.shadow,\n        transform\n      });\n      this._applyPostDrawUpdaters(particle);\n    });\n  }\n  drawParticlePlugin(plugin, particle, delta) {\n    this.draw(ctx => (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.drawParticlePlugin)(ctx, plugin, particle, delta));\n  }\n  drawPlugin(plugin, delta) {\n    this.draw(ctx => (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.drawPlugin)(ctx, plugin, delta));\n  }\n  async init() {\n    this._safeMutationObserver(obs => obs.disconnect());\n    this._mutationObserver = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.safeMutationObserver)(records => {\n      for (const record of records) {\n        if (record.type === \"attributes\" && record.attributeName === \"style\") {\n          this._repairStyle();\n        }\n      }\n    });\n    this.resize();\n    this._initStyle();\n    await this._initCover();\n    try {\n      await this._initTrail();\n    } catch (e) {\n      (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getLogger)().error(e);\n    }\n    this.initBackground();\n    this._safeMutationObserver(obs => {\n      if (!this.element || !(this.element instanceof Node)) {\n        return;\n      }\n      obs.observe(this.element, {\n        attributes: true\n      });\n    });\n    this.initUpdaters();\n    this.initPlugins();\n    this.paint();\n  }\n  initBackground() {\n    const options = this.container.actualOptions,\n      background = options.background,\n      element = this.element;\n    if (!element) {\n      return;\n    }\n    const elementStyle = element.style;\n    if (!elementStyle) {\n      return;\n    }\n    if (background.color) {\n      const color = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.rangeColorToRgb)(this._engine, background.color);\n      elementStyle.backgroundColor = color ? (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_3__.getStyleFromRgb)(color, background.opacity) : \"\";\n    } else {\n      elementStyle.backgroundColor = \"\";\n    }\n    elementStyle.backgroundImage = background.image || \"\";\n    elementStyle.backgroundPosition = background.position || \"\";\n    elementStyle.backgroundRepeat = background.repeat || \"\";\n    elementStyle.backgroundSize = background.size || \"\";\n  }\n  initPlugins() {\n    this._resizePlugins = [];\n    for (const plugin of this.container.plugins.values()) {\n      if (plugin.resize) {\n        this._resizePlugins.push(plugin);\n      }\n      if (plugin.particleFillColor ?? plugin.particleStrokeColor) {\n        this._colorPlugins.push(plugin);\n      }\n    }\n  }\n  initUpdaters() {\n    this._preDrawUpdaters = [];\n    this._postDrawUpdaters = [];\n    for (const updater of this.container.particles.updaters) {\n      if (updater.afterDraw) {\n        this._postDrawUpdaters.push(updater);\n      }\n      if (updater.getColorStyles ?? updater.getTransformValues ?? updater.beforeDraw) {\n        this._preDrawUpdaters.push(updater);\n      }\n    }\n  }\n  loadCanvas(canvas) {\n    if (this._generated && this.element) {\n      this.element.remove();\n    }\n    this._generated = canvas.dataset && _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.generatedAttribute in canvas.dataset ? canvas.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.generatedAttribute] === \"true\" : this._generated;\n    this.element = canvas;\n    this.element.ariaHidden = \"true\";\n    this._originalStyle = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.cloneStyle)(this.element.style);\n    const standardSize = this._standardSize;\n    standardSize.height = canvas.offsetHeight;\n    standardSize.width = canvas.offsetWidth;\n    const pxRatio = this.container.retina.pixelRatio,\n      retinaSize = this.size;\n    canvas.height = retinaSize.height = standardSize.height * pxRatio;\n    canvas.width = retinaSize.width = standardSize.width * pxRatio;\n    this._context = this.element.getContext(\"2d\");\n    this._safeMutationObserver(obs => obs.disconnect());\n    this.container.retina.init();\n    this.initBackground();\n    this._safeMutationObserver(obs => {\n      if (!this.element || !(this.element instanceof Node)) {\n        return;\n      }\n      obs.observe(this.element, {\n        attributes: true\n      });\n    });\n  }\n  paint() {\n    const options = this.container.actualOptions;\n    this.draw(ctx => {\n      if (options.backgroundMask.enable && options.backgroundMask.cover) {\n        (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.clear)(ctx, this.size);\n        if (this._coverImage) {\n          this._paintImage(this._coverImage.image, this._coverImage.opacity);\n        } else if (this._coverColorStyle) {\n          this._paintBase(this._coverColorStyle);\n        } else {\n          this._paintBase();\n        }\n      } else {\n        this._paintBase();\n      }\n    });\n  }\n  resize() {\n    if (!this.element) {\n      return false;\n    }\n    const container = this.container,\n      currentSize = container.canvas._standardSize,\n      newSize = {\n        width: this.element.offsetWidth,\n        height: this.element.offsetHeight\n      },\n      pxRatio = container.retina.pixelRatio,\n      retinaSize = {\n        width: newSize.width * pxRatio,\n        height: newSize.height * pxRatio\n      };\n    if (newSize.height === currentSize.height && newSize.width === currentSize.width && retinaSize.height === this.element.height && retinaSize.width === this.element.width) {\n      return false;\n    }\n    const oldSize = {\n      ...currentSize\n    };\n    currentSize.height = newSize.height;\n    currentSize.width = newSize.width;\n    const canvasSize = this.size;\n    this.element.width = canvasSize.width = retinaSize.width;\n    this.element.height = canvasSize.height = retinaSize.height;\n    if (this.container.started) {\n      container.particles.setResizeFactor({\n        width: currentSize.width / oldSize.width,\n        height: currentSize.height / oldSize.height\n      });\n    }\n    return true;\n  }\n  setPointerEvents(type) {\n    const element = this.element;\n    if (!element) {\n      return;\n    }\n    this._pointerEvents = type;\n    this._repairStyle();\n  }\n  stop() {\n    this._safeMutationObserver(obs => obs.disconnect());\n    this._mutationObserver = undefined;\n    this.draw(ctx => (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_0__.clear)(ctx, this.size));\n  }\n  async windowResize() {\n    if (!this.element || !this.resize()) {\n      return;\n    }\n    const container = this.container,\n      needsRefresh = container.updateActualOptions();\n    container.particles.setDensity();\n    this._applyResizePlugins();\n    if (needsRefresh) {\n      await container.refresh();\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Canvas.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Container.js":
/*!***************************************************!*\
  !*** ../../engine/dist/browser/Core/Container.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Container: () => (/* binding */ Container)\n/* harmony export */ });\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Canvas_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Canvas.js */ \"../../engine/dist/browser/Core/Canvas.js\");\n/* harmony import */ var _Utils_EventListeners_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Utils/EventListeners.js */ \"../../engine/dist/browser/Core/Utils/EventListeners.js\");\n/* harmony import */ var _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Enums/Types/EventType.js */ \"../../engine/dist/browser/Enums/Types/EventType.js\");\n/* harmony import */ var _Options_Classes_Options_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Options/Classes/Options.js */ \"../../engine/dist/browser/Options/Classes/Options.js\");\n/* harmony import */ var _Particles_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Particles.js */ \"../../engine/dist/browser/Core/Particles.js\");\n/* harmony import */ var _Retina_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Retina.js */ \"../../engine/dist/browser/Core/Retina.js\");\n/* harmony import */ var _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Utils/OptionsUtils.js */ \"../../engine/dist/browser/Utils/OptionsUtils.js\");\n\n\n\n\n\n\n\n\n\n\nfunction guardCheck(container) {\n  return container && !container.destroyed;\n}\nfunction initDelta(value, fpsLimit = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultFps, smooth = false) {\n  return {\n    value,\n    factor: smooth ? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultFps / fpsLimit : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultFps * value / _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds\n  };\n}\nfunction loadContainerOptions(engine, container, ...sourceOptionsArr) {\n  const options = new _Options_Classes_Options_js__WEBPACK_IMPORTED_MODULE_6__.Options(engine, container);\n  (0,_Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_9__.loadOptions)(options, ...sourceOptionsArr);\n  return options;\n}\nclass Container {\n  constructor(engine, id, sourceOptions) {\n    this._intersectionManager = entries => {\n      if (!guardCheck(this) || !this.actualOptions.pauseOnOutsideViewport) {\n        return;\n      }\n      for (const entry of entries) {\n        if (entry.target !== this.interactivity.element) {\n          continue;\n        }\n        if (entry.isIntersecting) {\n          void this.play();\n        } else {\n          this.pause();\n        }\n      }\n    };\n    this._nextFrame = timestamp => {\n      try {\n        if (!this._smooth && this._lastFrameTime !== undefined && timestamp < this._lastFrameTime + _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds / this.fpsLimit) {\n          this.draw(false);\n          return;\n        }\n        this._lastFrameTime ??= timestamp;\n        const delta = initDelta(timestamp - this._lastFrameTime, this.fpsLimit, this._smooth);\n        this.addLifeTime(delta.value);\n        this._lastFrameTime = timestamp;\n        if (delta.value > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds) {\n          this.draw(false);\n          return;\n        }\n        this.particles.draw(delta);\n        if (!this.alive()) {\n          this.destroy();\n          return;\n        }\n        if (this.animationStatus) {\n          this.draw(false);\n        }\n      } catch (e) {\n        (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__.getLogger)().error(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.errorPrefix} in animation loop`, e);\n      }\n    };\n    this._engine = engine;\n    this.id = Symbol(id);\n    this.fpsLimit = 120;\n    this._smooth = false;\n    this._delay = 0;\n    this._duration = 0;\n    this._lifeTime = 0;\n    this._firstStart = true;\n    this.started = false;\n    this.destroyed = false;\n    this._paused = true;\n    this._lastFrameTime = 0;\n    this.zLayers = 100;\n    this.pageHidden = false;\n    this._clickHandlers = new Map();\n    this._sourceOptions = sourceOptions;\n    this._initialSourceOptions = sourceOptions;\n    this.retina = new _Retina_js__WEBPACK_IMPORTED_MODULE_8__.Retina(this);\n    this.canvas = new _Canvas_js__WEBPACK_IMPORTED_MODULE_3__.Canvas(this, this._engine);\n    this.particles = new _Particles_js__WEBPACK_IMPORTED_MODULE_7__.Particles(this._engine, this);\n    this.pathGenerators = new Map();\n    this.interactivity = {\n      mouse: {\n        clicking: false,\n        inside: false\n      }\n    };\n    this.plugins = new Map();\n    this.effectDrawers = new Map();\n    this.shapeDrawers = new Map();\n    this._options = loadContainerOptions(this._engine, this);\n    this.actualOptions = loadContainerOptions(this._engine, this);\n    this._eventListeners = new _Utils_EventListeners_js__WEBPACK_IMPORTED_MODULE_4__.EventListeners(this);\n    this._intersectionObserver = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__.safeIntersectionObserver)(entries => this._intersectionManager(entries));\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerBuilt, {\n      container: this\n    });\n  }\n  get animationStatus() {\n    return !this._paused && !this.pageHidden && guardCheck(this);\n  }\n  get options() {\n    return this._options;\n  }\n  get sourceOptions() {\n    return this._sourceOptions;\n  }\n  addClickHandler(callback) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    const el = this.interactivity.element;\n    if (!el) {\n      return;\n    }\n    const clickOrTouchHandler = (e, pos, radius) => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        const pxRatio = this.retina.pixelRatio,\n          posRetina = {\n            x: pos.x * pxRatio,\n            y: pos.y * pxRatio\n          },\n          particles = this.particles.quadTree.queryCircle(posRetina, radius * pxRatio);\n        callback(e, particles);\n      },\n      clickHandler = e => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        const mouseEvent = e,\n          pos = {\n            x: mouseEvent.offsetX || mouseEvent.clientX,\n            y: mouseEvent.offsetY || mouseEvent.clientY\n          };\n        clickOrTouchHandler(e, pos, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.clickRadius);\n      },\n      touchStartHandler = () => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        touched = true;\n        touchMoved = false;\n      },\n      touchMoveHandler = () => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        touchMoved = true;\n      },\n      touchEndHandler = e => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        if (touched && !touchMoved) {\n          const touchEvent = e;\n          let lastTouch = touchEvent.touches[touchEvent.touches.length - _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.touchEndLengthOffset];\n          if (!lastTouch) {\n            lastTouch = touchEvent.changedTouches[touchEvent.changedTouches.length - _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.touchEndLengthOffset];\n            if (!lastTouch) {\n              return;\n            }\n          }\n          const element = this.canvas.element,\n            canvasRect = element ? element.getBoundingClientRect() : undefined,\n            pos = {\n              x: lastTouch.clientX - (canvasRect ? canvasRect.left : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.minCoordinate),\n              y: lastTouch.clientY - (canvasRect ? canvasRect.top : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.minCoordinate)\n            };\n          clickOrTouchHandler(e, pos, Math.max(lastTouch.radiusX, lastTouch.radiusY));\n        }\n        touched = false;\n        touchMoved = false;\n      },\n      touchCancelHandler = () => {\n        if (!guardCheck(this)) {\n          return;\n        }\n        touched = false;\n        touchMoved = false;\n      };\n    let touched = false,\n      touchMoved = false;\n    this._clickHandlers.set(\"click\", clickHandler);\n    this._clickHandlers.set(\"touchstart\", touchStartHandler);\n    this._clickHandlers.set(\"touchmove\", touchMoveHandler);\n    this._clickHandlers.set(\"touchend\", touchEndHandler);\n    this._clickHandlers.set(\"touchcancel\", touchCancelHandler);\n    for (const [key, handler] of this._clickHandlers) {\n      el.addEventListener(key, handler);\n    }\n  }\n  addLifeTime(value) {\n    this._lifeTime += value;\n  }\n  addPath(key, generator, override = false) {\n    if (!guardCheck(this) || !override && this.pathGenerators.has(key)) {\n      return false;\n    }\n    this.pathGenerators.set(key, generator);\n    return true;\n  }\n  alive() {\n    return !this._duration || this._lifeTime <= this._duration;\n  }\n  clearClickHandlers() {\n    if (!guardCheck(this)) {\n      return;\n    }\n    for (const [key, handler] of this._clickHandlers) {\n      this.interactivity.element?.removeEventListener(key, handler);\n    }\n    this._clickHandlers.clear();\n  }\n  destroy(remove = true) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    this.stop();\n    this.clearClickHandlers();\n    this.particles.destroy();\n    this.canvas.destroy();\n    for (const effectDrawer of this.effectDrawers.values()) {\n      effectDrawer.destroy?.(this);\n    }\n    for (const shapeDrawer of this.shapeDrawers.values()) {\n      shapeDrawer.destroy?.(this);\n    }\n    for (const key of this.effectDrawers.keys()) {\n      this.effectDrawers.delete(key);\n    }\n    for (const key of this.shapeDrawers.keys()) {\n      this.shapeDrawers.delete(key);\n    }\n    this._engine.clearPlugins(this);\n    this.destroyed = true;\n    if (remove) {\n      const mainArr = this._engine.items,\n        idx = mainArr.findIndex(t => t === this);\n      if (idx >= _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.removeMinIndex) {\n        mainArr.splice(idx, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.removeDeleteCount);\n      }\n    }\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerDestroyed, {\n      container: this\n    });\n  }\n  draw(force) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    let refreshTime = force;\n    const frame = timestamp => {\n      if (refreshTime) {\n        this._lastFrameTime = undefined;\n        refreshTime = false;\n      }\n      this._nextFrame(timestamp);\n    };\n    this._drawAnimationFrame = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.animate)(timestamp => frame(timestamp));\n  }\n  async export(type, options = {}) {\n    for (const plugin of this.plugins.values()) {\n      if (!plugin.export) {\n        continue;\n      }\n      const res = await plugin.export(type, options);\n      if (!res.supported) {\n        continue;\n      }\n      return res.blob;\n    }\n    (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__.getLogger)().error(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.errorPrefix} - Export plugin with type ${type} not found`);\n  }\n  handleClickMode(mode) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    this.particles.handleClickMode(mode);\n    for (const plugin of this.plugins.values()) {\n      plugin.handleClickMode?.(mode);\n    }\n  }\n  async init() {\n    if (!guardCheck(this)) {\n      return;\n    }\n    const effects = this._engine.getSupportedEffects();\n    for (const type of effects) {\n      const drawer = this._engine.getEffectDrawer(type);\n      if (drawer) {\n        this.effectDrawers.set(type, drawer);\n      }\n    }\n    const shapes = this._engine.getSupportedShapes();\n    for (const type of shapes) {\n      const drawer = this._engine.getShapeDrawer(type);\n      if (drawer) {\n        this.shapeDrawers.set(type, drawer);\n      }\n    }\n    await this.particles.initPlugins();\n    this._options = loadContainerOptions(this._engine, this, this._initialSourceOptions, this.sourceOptions);\n    this.actualOptions = loadContainerOptions(this._engine, this, this._options);\n    const availablePlugins = await this._engine.getAvailablePlugins(this);\n    for (const [id, plugin] of availablePlugins) {\n      this.plugins.set(id, plugin);\n    }\n    this.retina.init();\n    await this.canvas.init();\n    this.updateActualOptions();\n    this.canvas.initBackground();\n    this.canvas.resize();\n    const {\n      zLayers,\n      duration,\n      delay,\n      fpsLimit,\n      smooth\n    } = this.actualOptions;\n    this.zLayers = zLayers;\n    this._duration = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(duration) * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds;\n    this._delay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(delay) * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds;\n    this._lifeTime = 0;\n    this.fpsLimit = fpsLimit > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.minFpsLimit ? fpsLimit : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultFpsLimit;\n    this._smooth = smooth;\n    for (const drawer of this.effectDrawers.values()) {\n      await drawer.init?.(this);\n    }\n    for (const drawer of this.shapeDrawers.values()) {\n      await drawer.init?.(this);\n    }\n    for (const plugin of this.plugins.values()) {\n      await plugin.init?.();\n    }\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerInit, {\n      container: this\n    });\n    await this.particles.init();\n    this.particles.setDensity();\n    for (const plugin of this.plugins.values()) {\n      plugin.particlesSetup?.();\n    }\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.particlesSetup, {\n      container: this\n    });\n  }\n  async loadTheme(name) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    this._currentTheme = name;\n    await this.refresh();\n  }\n  pause() {\n    if (!guardCheck(this)) {\n      return;\n    }\n    if (this._drawAnimationFrame !== undefined) {\n      (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.cancelAnimation)(this._drawAnimationFrame);\n      delete this._drawAnimationFrame;\n    }\n    if (this._paused) {\n      return;\n    }\n    for (const plugin of this.plugins.values()) {\n      plugin.pause?.();\n    }\n    if (!this.pageHidden) {\n      this._paused = true;\n    }\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerPaused, {\n      container: this\n    });\n  }\n  play(force) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    const needsUpdate = this._paused || force;\n    if (this._firstStart && !this.actualOptions.autoPlay) {\n      this._firstStart = false;\n      return;\n    }\n    if (this._paused) {\n      this._paused = false;\n    }\n    if (needsUpdate) {\n      for (const plugin of this.plugins.values()) {\n        if (plugin.play) {\n          plugin.play();\n        }\n      }\n    }\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerPlay, {\n      container: this\n    });\n    this.draw(needsUpdate ?? false);\n  }\n  async refresh() {\n    if (!guardCheck(this)) {\n      return;\n    }\n    this.stop();\n    return this.start();\n  }\n  async reset(sourceOptions) {\n    if (!guardCheck(this)) {\n      return;\n    }\n    this._initialSourceOptions = sourceOptions;\n    this._sourceOptions = sourceOptions;\n    this._options = loadContainerOptions(this._engine, this, this._initialSourceOptions, this.sourceOptions);\n    this.actualOptions = loadContainerOptions(this._engine, this, this._options);\n    return this.refresh();\n  }\n  async start() {\n    if (!guardCheck(this) || this.started) {\n      return;\n    }\n    await this.init();\n    this.started = true;\n    await new Promise(resolve => {\n      const start = async () => {\n        this._eventListeners.addListeners();\n        if (this.interactivity.element instanceof HTMLElement && this._intersectionObserver) {\n          this._intersectionObserver.observe(this.interactivity.element);\n        }\n        for (const plugin of this.plugins.values()) {\n          await plugin.start?.();\n        }\n        this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerStarted, {\n          container: this\n        });\n        this.play();\n        resolve();\n      };\n      this._delayTimeout = setTimeout(() => void start(), this._delay);\n    });\n  }\n  stop() {\n    if (!guardCheck(this) || !this.started) {\n      return;\n    }\n    if (this._delayTimeout) {\n      clearTimeout(this._delayTimeout);\n      delete this._delayTimeout;\n    }\n    this._firstStart = true;\n    this.started = false;\n    this._eventListeners.removeListeners();\n    this.pause();\n    this.particles.clear();\n    this.canvas.stop();\n    if (this.interactivity.element instanceof HTMLElement && this._intersectionObserver) {\n      this._intersectionObserver.unobserve(this.interactivity.element);\n    }\n    for (const plugin of this.plugins.values()) {\n      plugin.stop?.();\n    }\n    for (const key of this.plugins.keys()) {\n      this.plugins.delete(key);\n    }\n    this._sourceOptions = this._options;\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.containerStopped, {\n      container: this\n    });\n  }\n  updateActualOptions() {\n    this.actualOptions.responsive = [];\n    const newMaxWidth = this.actualOptions.setResponsive(this.canvas.size.width, this.retina.pixelRatio, this._options);\n    this.actualOptions.setTheme(this._currentTheme);\n    if (this._responsiveMaxWidth === newMaxWidth) {\n      return false;\n    }\n    this._responsiveMaxWidth = newMaxWidth;\n    return true;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Container.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Engine.js":
/*!************************************************!*\
  !*** ../../engine/dist/browser/Core/Engine.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Engine: () => (/* binding */ Engine)\n/* harmony export */ });\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Container_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Container.js */ \"../../engine/dist/browser/Core/Container.js\");\n/* harmony import */ var _Utils_EventDispatcher_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Utils/EventDispatcher.js */ \"../../engine/dist/browser/Utils/EventDispatcher.js\");\n/* harmony import */ var _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Enums/Types/EventType.js */ \"../../engine/dist/browser/Enums/Types/EventType.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\n\n\n\nasync function getItemsFromInitializer(container, map, initializers, force = false) {\n  let res = map.get(container);\n  if (!res || force) {\n    res = await Promise.all([...initializers.values()].map(t => t(container)));\n    map.set(container, res);\n  }\n  return res;\n}\nasync function getDataFromUrl(data) {\n  const url = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.itemFromSingleOrMultiple)(data.url, data.index);\n  if (!url) {\n    return data.fallback;\n  }\n  const response = await fetch(url);\n  if (response.ok) {\n    return await response.json();\n  }\n  (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getLogger)().error(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} ${response.status} while retrieving config file`);\n  return data.fallback;\n}\nconst getCanvasFromContainer = domContainer => {\n    let canvasEl;\n    if (domContainer instanceof HTMLCanvasElement || domContainer.tagName.toLowerCase() === _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasTag) {\n      canvasEl = domContainer;\n      if (!canvasEl.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute]) {\n        canvasEl.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute] = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedFalse;\n      }\n    } else {\n      const existingCanvases = domContainer.getElementsByTagName(_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasTag);\n      if (existingCanvases.length) {\n        canvasEl = existingCanvases[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasFirstIndex];\n        canvasEl.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute] = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedFalse;\n      } else {\n        canvasEl = document.createElement(_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasTag);\n        canvasEl.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute] = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedTrue;\n        domContainer.appendChild(canvasEl);\n      }\n    }\n    const fullPercent = \"100%\";\n    if (!canvasEl.style.width) {\n      canvasEl.style.width = fullPercent;\n    }\n    if (!canvasEl.style.height) {\n      canvasEl.style.height = fullPercent;\n    }\n    return canvasEl;\n  },\n  getDomContainer = (id, source) => {\n    let domContainer = source ?? document.getElementById(id);\n    if (domContainer) {\n      return domContainer;\n    }\n    domContainer = document.createElement(\"div\");\n    domContainer.id = id;\n    domContainer.dataset[_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute] = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedTrue;\n    document.body.append(domContainer);\n    return domContainer;\n  };\nclass Engine {\n  constructor() {\n    this._configs = new Map();\n    this._domArray = [];\n    this._eventDispatcher = new _Utils_EventDispatcher_js__WEBPACK_IMPORTED_MODULE_3__.EventDispatcher();\n    this._initialized = false;\n    this.plugins = [];\n    this.colorManagers = new Map();\n    this.easingFunctions = new Map();\n    this._initializers = {\n      interactors: new Map(),\n      movers: new Map(),\n      updaters: new Map()\n    };\n    this.interactors = new Map();\n    this.movers = new Map();\n    this.updaters = new Map();\n    this.presets = new Map();\n    this.effectDrawers = new Map();\n    this.shapeDrawers = new Map();\n    this.pathGenerators = new Map();\n  }\n  get configs() {\n    const res = {};\n    for (const [name, config] of this._configs) {\n      res[name] = config;\n    }\n    return res;\n  }\n  get items() {\n    return this._domArray;\n  }\n  get version() {\n    return \"3.9.1\";\n  }\n  async addColorManager(manager, refresh = true) {\n    this.colorManagers.set(manager.key, manager);\n    await this.refresh(refresh);\n  }\n  addConfig(config) {\n    const key = config.key ?? config.name ?? \"default\";\n    this._configs.set(key, config);\n    this._eventDispatcher.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_4__.EventType.configAdded, {\n      data: {\n        name: key,\n        config\n      }\n    });\n  }\n  async addEasing(name, easing, refresh = true) {\n    if (this.getEasing(name)) {\n      return;\n    }\n    this.easingFunctions.set(name, easing);\n    await this.refresh(refresh);\n  }\n  async addEffect(effect, drawer, refresh = true) {\n    (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.executeOnSingleOrMultiple)(effect, type => {\n      if (!this.getEffectDrawer(type)) {\n        this.effectDrawers.set(type, drawer);\n      }\n    });\n    await this.refresh(refresh);\n  }\n  addEventListener(type, listener) {\n    this._eventDispatcher.addEventListener(type, listener);\n  }\n  async addInteractor(name, interactorInitializer, refresh = true) {\n    this._initializers.interactors.set(name, interactorInitializer);\n    await this.refresh(refresh);\n  }\n  async addMover(name, moverInitializer, refresh = true) {\n    this._initializers.movers.set(name, moverInitializer);\n    await this.refresh(refresh);\n  }\n  async addParticleUpdater(name, updaterInitializer, refresh = true) {\n    this._initializers.updaters.set(name, updaterInitializer);\n    await this.refresh(refresh);\n  }\n  async addPathGenerator(name, generator, refresh = true) {\n    if (!this.getPathGenerator(name)) {\n      this.pathGenerators.set(name, generator);\n    }\n    await this.refresh(refresh);\n  }\n  async addPlugin(plugin, refresh = true) {\n    if (!this.getPlugin(plugin.id)) {\n      this.plugins.push(plugin);\n    }\n    await this.refresh(refresh);\n  }\n  async addPreset(preset, options, override = false, refresh = true) {\n    if (override || !this.getPreset(preset)) {\n      this.presets.set(preset, options);\n    }\n    await this.refresh(refresh);\n  }\n  async addShape(drawer, refresh = true) {\n    for (const validType of drawer.validTypes) {\n      if (this.getShapeDrawer(validType)) {\n        continue;\n      }\n      this.shapeDrawers.set(validType, drawer);\n    }\n    await this.refresh(refresh);\n  }\n  checkVersion(pluginVersion) {\n    if (this.version === pluginVersion) {\n      return;\n    }\n    throw new Error(`The tsParticles version is different from the loaded plugins version. Engine version: ${this.version}. Plugin version: ${pluginVersion}`);\n  }\n  clearPlugins(container) {\n    this.updaters.delete(container);\n    this.movers.delete(container);\n    this.interactors.delete(container);\n  }\n  dispatchEvent(type, args) {\n    this._eventDispatcher.dispatchEvent(type, args);\n  }\n  dom() {\n    return this.items;\n  }\n  domItem(index) {\n    return this.item(index);\n  }\n  async getAvailablePlugins(container) {\n    const res = new Map();\n    for (const plugin of this.plugins) {\n      if (plugin.needsPlugin(container.actualOptions)) {\n        res.set(plugin.id, await plugin.getPlugin(container));\n      }\n    }\n    return res;\n  }\n  getEasing(name) {\n    return this.easingFunctions.get(name) ?? (value => value);\n  }\n  getEffectDrawer(type) {\n    return this.effectDrawers.get(type);\n  }\n  async getInteractors(container, force = false) {\n    return getItemsFromInitializer(container, this.interactors, this._initializers.interactors, force);\n  }\n  async getMovers(container, force = false) {\n    return getItemsFromInitializer(container, this.movers, this._initializers.movers, force);\n  }\n  getPathGenerator(type) {\n    return this.pathGenerators.get(type);\n  }\n  getPlugin(plugin) {\n    return this.plugins.find(t => t.id === plugin);\n  }\n  getPreset(preset) {\n    return this.presets.get(preset);\n  }\n  getShapeDrawer(type) {\n    return this.shapeDrawers.get(type);\n  }\n  getSupportedEffects() {\n    return this.effectDrawers.keys();\n  }\n  getSupportedShapes() {\n    return this.shapeDrawers.keys();\n  }\n  async getUpdaters(container, force = false) {\n    return getItemsFromInitializer(container, this.updaters, this._initializers.updaters, force);\n  }\n  init() {\n    if (this._initialized) {\n      return;\n    }\n    this._initialized = true;\n  }\n  item(index) {\n    const {\n        items\n      } = this,\n      item = items[index];\n    if (!item || item.destroyed) {\n      items.splice(index, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.removeDeleteCount);\n      return;\n    }\n    return item;\n  }\n  async load(params) {\n    const id = params.id ?? params.element?.id ?? `tsparticles${Math.floor((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_5__.getRandom)() * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.loadRandomFactor)}`,\n      {\n        index,\n        url\n      } = params,\n      options = url ? await getDataFromUrl({\n        fallback: params.options,\n        url,\n        index\n      }) : params.options,\n      currentOptions = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.itemFromSingleOrMultiple)(options, index),\n      {\n        items\n      } = this,\n      oldIndex = items.findIndex(v => v.id.description === id),\n      newItem = new _Container_js__WEBPACK_IMPORTED_MODULE_2__.Container(this, id, currentOptions);\n    if (oldIndex >= _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.loadMinIndex) {\n      const old = this.item(oldIndex),\n        deleteCount = old ? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.one : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.none;\n      if (old && !old.destroyed) {\n        old.destroy(false);\n      }\n      items.splice(oldIndex, deleteCount, newItem);\n    } else {\n      items.push(newItem);\n    }\n    const domContainer = getDomContainer(id, params.element),\n      canvasEl = getCanvasFromContainer(domContainer);\n    newItem.canvas.loadCanvas(canvasEl);\n    await newItem.start();\n    return newItem;\n  }\n  loadOptions(options, sourceOptions) {\n    this.plugins.forEach(plugin => plugin.loadOptions?.(options, sourceOptions));\n  }\n  loadParticlesOptions(container, options, ...sourceOptions) {\n    const updaters = this.updaters.get(container);\n    if (!updaters) {\n      return;\n    }\n    updaters.forEach(updater => updater.loadOptions?.(options, ...sourceOptions));\n  }\n  async refresh(refresh = true) {\n    if (!refresh) {\n      return;\n    }\n    await Promise.all(this.items.map(t => t.refresh()));\n  }\n  removeEventListener(type, listener) {\n    this._eventDispatcher.removeEventListener(type, listener);\n  }\n  setOnClickHandler(callback) {\n    const {\n      items\n    } = this;\n    if (!items.length) {\n      throw new Error(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} can only set click handlers after calling tsParticles.load()`);\n    }\n    items.forEach(item => item.addClickHandler(callback));\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Engine.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/Colors.js":
/*!***********************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/Colors.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/Colors.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IBounds.js":
/*!************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IBounds.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IBounds.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IBubbleParticleData.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IBubbleParticleData.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IBubbleParticleData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/ICircleBouncer.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/ICircleBouncer.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/ICircleBouncer.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IColorManager.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IColorManager.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IColorManager.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IContainerInteractivity.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IContainerInteractivity.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IContainerInteractivity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IContainerPlugin.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IContainerPlugin.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IContainerPlugin.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/ICoordinates.js":
/*!*****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/ICoordinates.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/ICoordinates.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IDelta.js":
/*!***********************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IDelta.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IDelta.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IDimension.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IDimension.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IDimension.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IDistance.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IDistance.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IDistance.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IDrawParticleParams.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IDrawParticleParams.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IDrawParticleParams.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IEffectDrawer.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IEffectDrawer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IEffectDrawer.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IExternalInteractor.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IExternalInteractor.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IExternalInteractor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IInteractor.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IInteractor.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IInteractor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/ILoadParams.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/ILoadParams.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/ILoadParams.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IMouseData.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IMouseData.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IMouseData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IMovePathGenerator.js":
/*!***********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IMovePathGenerator.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IMovePathGenerator.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleColorStyle.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleColorStyle.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleColorStyle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleHslAnimation.js":
/*!**************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleHslAnimation.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleHslAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleLife.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleLife.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleLife.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleMover.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleMover.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleMover.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleRetinaProps.js":
/*!*************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleRetinaProps.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleRetinaProps.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleRoll.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleRoll.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleRoll.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleTransformValues.js":
/*!*****************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleTransformValues.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleTransformValues.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleUpdater.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleUpdater.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleUpdater.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticleValueAnimation.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticleValueAnimation.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticleValueAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IParticlesInteractor.js":
/*!*************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IParticlesInteractor.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IParticlesInteractor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IPlugin.js":
/*!************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IPlugin.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IPlugin.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IPositionFromSizeParams.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IPositionFromSizeParams.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IPositionFromSizeParams.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IRangeValue.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IRangeValue.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IRangeValue.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IRectSideResult.js":
/*!********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IRectSideResult.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IRectSideResult.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IShapeDrawData.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IShapeDrawData.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IShapeDrawData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IShapeDrawer.js":
/*!*****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IShapeDrawer.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IShapeDrawer.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/IShapeValues.js":
/*!*****************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/IShapeValues.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/IShapeValues.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/ISlowParticleData.js":
/*!**********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/ISlowParticleData.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/ISlowParticleData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Interfaces/ITrailFillData.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Interfaces/ITrailFillData.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Interfaces/ITrailFillData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Particle.js":
/*!**************************************************!*\
  !*** ../../engine/dist/browser/Core/Particle.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Particle: () => (/* binding */ Particle)\n/* harmony export */ });\n/* harmony import */ var _Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils/Vectors.js */ \"../../engine/dist/browser/Core/Utils/Vectors.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Utils/ColorUtils.js */ \"../../engine/dist/browser/Utils/ColorUtils.js\");\n/* harmony import */ var _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Enums/Types/EventType.js */ \"../../engine/dist/browser/Enums/Types/EventType.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Options/Classes/Interactivity/Interactivity.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js\");\n/* harmony import */ var _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Enums/Directions/MoveDirection.js */ \"../../engine/dist/browser/Enums/Directions/MoveDirection.js\");\n/* harmony import */ var _Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Enums/Modes/OutMode.js */ \"../../engine/dist/browser/Enums/Modes/OutMode.js\");\n/* harmony import */ var _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Enums/Types/ParticleOutType.js */ \"../../engine/dist/browser/Enums/Types/ParticleOutType.js\");\n/* harmony import */ var _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Enums/Modes/PixelMode.js */ \"../../engine/dist/browser/Enums/Modes/PixelMode.js\");\n/* harmony import */ var _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Utils/CanvasUtils.js */ \"../../engine/dist/browser/Utils/CanvasUtils.js\");\n/* harmony import */ var _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Utils/OptionsUtils.js */ \"../../engine/dist/browser/Utils/OptionsUtils.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\nfunction loadEffectData(effect, effectOptions, id, reduceDuplicates) {\n  const effectData = effectOptions.options[effect];\n  if (!effectData) {\n    return;\n  }\n  return (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.deepExtend)({\n    close: effectOptions.close,\n    fill: effectOptions.fill\n  }, (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(effectData, id, reduceDuplicates));\n}\nfunction loadShapeData(shape, shapeOptions, id, reduceDuplicates) {\n  const shapeData = shapeOptions.options[shape];\n  if (!shapeData) {\n    return;\n  }\n  return (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.deepExtend)({\n    close: shapeOptions.close,\n    fill: shapeOptions.fill\n  }, (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(shapeData, id, reduceDuplicates));\n}\nfunction fixOutMode(data) {\n  if (!(0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.isInArray)(data.outMode, data.checkModes)) {\n    return;\n  }\n  const diameter = data.radius * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.double;\n  if (data.coord > data.maxCoord - diameter) {\n    data.setCb(-data.radius);\n  } else if (data.coord < diameter) {\n    data.setCb(data.radius);\n  }\n}\nclass Particle {\n  constructor(engine, container) {\n    this.container = container;\n    this._calcPosition = (container, position, zIndex, tryCount = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.defaultRetryCount) => {\n      for (const plugin of container.plugins.values()) {\n        const pluginPos = plugin.particlePosition !== undefined ? plugin.particlePosition(position, this) : undefined;\n        if (pluginPos) {\n          return _Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_0__.Vector3d.create(pluginPos.x, pluginPos.y, zIndex);\n        }\n      }\n      const canvasSize = container.canvas.size,\n        exactPosition = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.calcExactPositionOrRandomFromSize)({\n          size: canvasSize,\n          position: position\n        }),\n        pos = _Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_0__.Vector3d.create(exactPosition.x, exactPosition.y, zIndex),\n        radius = this.getRadius(),\n        outModes = this.options.move.outModes,\n        fixHorizontal = outMode => {\n          fixOutMode({\n            outMode,\n            checkModes: [_Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_8__.OutMode.bounce],\n            coord: pos.x,\n            maxCoord: container.canvas.size.width,\n            setCb: value => pos.x += value,\n            radius\n          });\n        },\n        fixVertical = outMode => {\n          fixOutMode({\n            outMode,\n            checkModes: [_Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_8__.OutMode.bounce],\n            coord: pos.y,\n            maxCoord: container.canvas.size.height,\n            setCb: value => pos.y += value,\n            radius\n          });\n        };\n      fixHorizontal(outModes.left ?? outModes.default);\n      fixHorizontal(outModes.right ?? outModes.default);\n      fixVertical(outModes.top ?? outModes.default);\n      fixVertical(outModes.bottom ?? outModes.default);\n      if (this._checkOverlap(pos, tryCount)) {\n        return this._calcPosition(container, undefined, zIndex, tryCount + _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.tryCountIncrement);\n      }\n      return pos;\n    };\n    this._calculateVelocity = () => {\n      const baseVelocity = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getParticleBaseVelocity)(this.direction),\n        res = baseVelocity.copy(),\n        moveOptions = this.options.move;\n      if (moveOptions.direction === _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_7__.MoveDirection.inside || moveOptions.direction === _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_7__.MoveDirection.outside) {\n        return res;\n      }\n      const rad = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.degToRad)((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.angle.value)),\n        radOffset = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.degToRad)((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.angle.offset)),\n        range = {\n          left: radOffset - rad * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.half,\n          right: radOffset + rad * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.half\n        };\n      if (!moveOptions.straight) {\n        res.angle += (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.randomInRange)((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(range.left, range.right));\n      }\n      if (moveOptions.random && typeof moveOptions.speed === \"number\") {\n        res.length *= (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRandom)();\n      }\n      return res;\n    };\n    this._checkOverlap = (pos, tryCount = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.defaultRetryCount) => {\n      const collisionsOptions = this.options.collisions,\n        radius = this.getRadius();\n      if (!collisionsOptions.enable) {\n        return false;\n      }\n      const overlapOptions = collisionsOptions.overlap;\n      if (overlapOptions.enable) {\n        return false;\n      }\n      const retries = overlapOptions.retries;\n      if (retries >= _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.minRetries && tryCount > retries) {\n        throw new Error(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.errorPrefix} particle is overlapping and can't be placed`);\n      }\n      return !!this.container.particles.find(particle => (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getDistance)(pos, particle.position) < radius + particle.getRadius());\n    };\n    this._getRollColor = color => {\n      if (!color || !this.roll || !this.backColor && !this.roll.alter) {\n        return color;\n      }\n      const backFactor = this.roll.horizontal && this.roll.vertical ? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.double * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.rollFactor : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.rollFactor,\n        backSum = this.roll.horizontal ? Math.PI * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.half : _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.none,\n        rolled = Math.floor(((this.roll.angle ?? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.none) + backSum) / (Math.PI / backFactor)) % _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.double;\n      if (!rolled) {\n        return color;\n      }\n      if (this.backColor) {\n        return this.backColor;\n      }\n      if (this.roll.alter) {\n        return (0,_Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_11__.alterHsl)(color, this.roll.alter.type, this.roll.alter.value);\n      }\n      return color;\n    };\n    this._initPosition = position => {\n      const container = this.container,\n        zIndexValue = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(this.options.zIndex.value);\n      this.position = this._calcPosition(container, position, (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.clamp)(zIndexValue, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.minZ, container.zLayers));\n      this.initialPosition = this.position.copy();\n      const canvasSize = container.canvas.size;\n      this.moveCenter = {\n        ...(0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.getPosition)(this.options.move.center, canvasSize),\n        radius: this.options.move.center.radius ?? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.defaultRadius,\n        mode: this.options.move.center.mode ?? _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_10__.PixelMode.percent\n      };\n      this.direction = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getParticleDirectionAngle)(this.options.move.direction, this.position, this.moveCenter);\n      switch (this.options.move.direction) {\n        case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_7__.MoveDirection.inside:\n          this.outType = _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_9__.ParticleOutType.inside;\n          break;\n        case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_7__.MoveDirection.outside:\n          this.outType = _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_9__.ParticleOutType.outside;\n          break;\n      }\n      this.offset = _Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n    };\n    this._engine = engine;\n  }\n  destroy(override) {\n    if (this.unbreakable || this.destroyed) {\n      return;\n    }\n    this.destroyed = true;\n    this.bubble.inRange = false;\n    this.slow.inRange = false;\n    const container = this.container,\n      pathGenerator = this.pathGenerator,\n      shapeDrawer = container.shapeDrawers.get(this.shape);\n    shapeDrawer?.particleDestroy?.(this);\n    for (const plugin of container.plugins.values()) {\n      plugin.particleDestroyed?.(this, override);\n    }\n    for (const updater of container.particles.updaters) {\n      updater.particleDestroyed?.(this, override);\n    }\n    pathGenerator?.reset(this);\n    this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_5__.EventType.particleDestroyed, {\n      container: this.container,\n      data: {\n        particle: this\n      }\n    });\n  }\n  draw(delta) {\n    const container = this.container,\n      canvas = container.canvas;\n    for (const plugin of container.plugins.values()) {\n      canvas.drawParticlePlugin(plugin, this, delta);\n    }\n    canvas.drawParticle(this, delta);\n  }\n  getFillColor() {\n    return this._getRollColor(this.bubble.color ?? (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_4__.getHslFromAnimation)(this.color));\n  }\n  getMass() {\n    return this.getRadius() ** _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp * Math.PI * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.half;\n  }\n  getPosition() {\n    return {\n      x: this.position.x + this.offset.x,\n      y: this.position.y + this.offset.y,\n      z: this.position.z\n    };\n  }\n  getRadius() {\n    return this.bubble.radius ?? this.size.value;\n  }\n  getStrokeColor() {\n    return this._getRollColor(this.bubble.color ?? (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_4__.getHslFromAnimation)(this.strokeColor));\n  }\n  init(id, position, overrideOptions, group) {\n    const container = this.container,\n      engine = this._engine;\n    this.id = id;\n    this.group = group;\n    this.effectClose = true;\n    this.effectFill = true;\n    this.shapeClose = true;\n    this.shapeFill = true;\n    this.pathRotation = false;\n    this.lastPathTime = 0;\n    this.destroyed = false;\n    this.unbreakable = false;\n    this.isRotating = false;\n    this.rotation = 0;\n    this.misplaced = false;\n    this.retina = {\n      maxDistance: {}\n    };\n    this.outType = _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_9__.ParticleOutType.normal;\n    this.ignoresResizeRatio = true;\n    const pxRatio = container.retina.pixelRatio,\n      mainOptions = container.actualOptions,\n      particlesOptions = (0,_Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_12__.loadParticlesOptions)(this._engine, container, mainOptions.particles),\n      {\n        reduceDuplicates\n      } = particlesOptions,\n      effectType = particlesOptions.effect.type,\n      shapeType = particlesOptions.shape.type;\n    this.effect = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(effectType, this.id, reduceDuplicates);\n    this.shape = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(shapeType, this.id, reduceDuplicates);\n    const effectOptions = particlesOptions.effect,\n      shapeOptions = particlesOptions.shape;\n    if (overrideOptions) {\n      if (overrideOptions.effect?.type) {\n        const overrideEffectType = overrideOptions.effect.type,\n          effect = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(overrideEffectType, this.id, reduceDuplicates);\n        if (effect) {\n          this.effect = effect;\n          effectOptions.load(overrideOptions.effect);\n        }\n      }\n      if (overrideOptions.shape?.type) {\n        const overrideShapeType = overrideOptions.shape.type,\n          shape = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.itemFromSingleOrMultiple)(overrideShapeType, this.id, reduceDuplicates);\n        if (shape) {\n          this.shape = shape;\n          shapeOptions.load(overrideOptions.shape);\n        }\n      }\n    }\n    if (this.effect === _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.randomColorValue) {\n      const availableEffects = [...this.container.effectDrawers.keys()];\n      this.effect = availableEffects[Math.floor((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRandom)() * availableEffects.length)];\n    }\n    if (this.shape === _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.randomColorValue) {\n      const availableShapes = [...this.container.shapeDrawers.keys()];\n      this.shape = availableShapes[Math.floor((0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRandom)() * availableShapes.length)];\n    }\n    this.effectData = loadEffectData(this.effect, effectOptions, this.id, reduceDuplicates);\n    this.shapeData = loadShapeData(this.shape, shapeOptions, this.id, reduceDuplicates);\n    particlesOptions.load(overrideOptions);\n    const effectData = this.effectData;\n    if (effectData) {\n      particlesOptions.load(effectData.particles);\n    }\n    const shapeData = this.shapeData;\n    if (shapeData) {\n      particlesOptions.load(shapeData.particles);\n    }\n    const interactivity = new _Options_Classes_Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_6__.Interactivity(engine, container);\n    interactivity.load(container.actualOptions.interactivity);\n    interactivity.load(particlesOptions.interactivity);\n    this.interactivity = interactivity;\n    this.effectFill = effectData?.fill ?? particlesOptions.effect.fill;\n    this.effectClose = effectData?.close ?? particlesOptions.effect.close;\n    this.shapeFill = shapeData?.fill ?? particlesOptions.shape.fill;\n    this.shapeClose = shapeData?.close ?? particlesOptions.shape.close;\n    this.options = particlesOptions;\n    const pathOptions = this.options.move.path;\n    this.pathDelay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(pathOptions.delay.value) * _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.millisecondsToSeconds;\n    if (pathOptions.generator) {\n      this.pathGenerator = this._engine.getPathGenerator(pathOptions.generator);\n      if (this.pathGenerator && container.addPath(pathOptions.generator, this.pathGenerator)) {\n        this.pathGenerator.init(container);\n      }\n    }\n    container.retina.initParticle(this);\n    this.size = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_3__.initParticleNumericAnimationValue)(this.options.size, pxRatio);\n    this.bubble = {\n      inRange: false\n    };\n    this.slow = {\n      inRange: false,\n      factor: 1\n    };\n    this._initPosition(position);\n    this.initialVelocity = this._calculateVelocity();\n    this.velocity = this.initialVelocity.copy();\n    this.moveDecay = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_2__.decayOffset - (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(this.options.move.decay);\n    const particles = container.particles;\n    particles.setLastZIndex(this.position.z);\n    this.zIndexFactor = this.position.z / container.zLayers;\n    this.sides = 24;\n    let effectDrawer = container.effectDrawers.get(this.effect);\n    if (!effectDrawer) {\n      effectDrawer = this._engine.getEffectDrawer(this.effect);\n      if (effectDrawer) {\n        container.effectDrawers.set(this.effect, effectDrawer);\n      }\n    }\n    if (effectDrawer?.loadEffect) {\n      effectDrawer.loadEffect(this);\n    }\n    let shapeDrawer = container.shapeDrawers.get(this.shape);\n    if (!shapeDrawer) {\n      shapeDrawer = this._engine.getShapeDrawer(this.shape);\n      if (shapeDrawer) {\n        container.shapeDrawers.set(this.shape, shapeDrawer);\n      }\n    }\n    if (shapeDrawer?.loadShape) {\n      shapeDrawer.loadShape(this);\n    }\n    const sideCountFunc = shapeDrawer?.getSidesCount;\n    if (sideCountFunc) {\n      this.sides = sideCountFunc(this);\n    }\n    this.spawning = false;\n    this.shadowColor = (0,_Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_4__.rangeColorToRgb)(this._engine, this.options.shadow.color);\n    for (const updater of particles.updaters) {\n      updater.init(this);\n    }\n    for (const mover of particles.movers) {\n      mover.init?.(this);\n    }\n    effectDrawer?.particleInit?.(container, this);\n    shapeDrawer?.particleInit?.(container, this);\n    for (const plugin of container.plugins.values()) {\n      plugin.particleCreated?.(this);\n    }\n  }\n  isInsideCanvas() {\n    const radius = this.getRadius(),\n      canvasSize = this.container.canvas.size,\n      position = this.position;\n    return position.x >= -radius && position.y >= -radius && position.y <= canvasSize.height + radius && position.x <= canvasSize.width + radius;\n  }\n  isVisible() {\n    return !this.destroyed && !this.spawning && this.isInsideCanvas();\n  }\n  reset() {\n    for (const updater of this.container.particles.updaters) {\n      updater.reset?.(this);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Particle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Particles.js":
/*!***************************************************!*\
  !*** ../../engine/dist/browser/Core/Particles.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Particles: () => (/* binding */ Particles)\n/* harmony export */ });\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Enums/Types/EventType.js */ \"../../engine/dist/browser/Enums/Types/EventType.js\");\n/* harmony import */ var _Utils_InteractionManager_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Utils/InteractionManager.js */ \"../../engine/dist/browser/Core/Utils/InteractionManager.js\");\n/* harmony import */ var _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Enums/Modes/LimitMode.js */ \"../../engine/dist/browser/Enums/Modes/LimitMode.js\");\n/* harmony import */ var _Particle_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Particle.js */ \"../../engine/dist/browser/Core/Particle.js\");\n/* harmony import */ var _Utils_Point_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Utils/Point.js */ \"../../engine/dist/browser/Core/Utils/Point.js\");\n/* harmony import */ var _Utils_QuadTree_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Utils/QuadTree.js */ \"../../engine/dist/browser/Core/Utils/QuadTree.js\");\n/* harmony import */ var _Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Utils/Ranges.js */ \"../../engine/dist/browser/Core/Utils/Ranges.js\");\n\n\n\n\n\n\n\n\n\nconst qTreeRectangle = canvasSize => {\n  const {\n    height,\n    width\n  } = canvasSize;\n  return new _Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_8__.Rectangle(_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.posOffset * width, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.posOffset * height, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sizeFactor * width, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sizeFactor * height);\n};\nclass Particles {\n  constructor(engine, container) {\n    this._addToPool = (...particles) => {\n      this._pool.push(...particles);\n    };\n    this._applyDensity = (options, manualCount, group, groupOptions) => {\n      const numberOptions = options.number;\n      if (!options.number.density?.enable) {\n        if (group === undefined) {\n          this._limit = numberOptions.limit.value;\n        } else if (groupOptions?.number.limit?.value ?? numberOptions.limit.value) {\n          this._groupLimits.set(group, groupOptions?.number.limit?.value ?? numberOptions.limit.value);\n        }\n        return;\n      }\n      const densityFactor = this._initDensityFactor(numberOptions.density),\n        optParticlesNumber = numberOptions.value,\n        optParticlesLimit = numberOptions.limit.value > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minLimit ? numberOptions.limit.value : optParticlesNumber,\n        particlesNumber = Math.min(optParticlesNumber, optParticlesLimit) * densityFactor + manualCount,\n        particlesCount = Math.min(this.count, this.filter(t => t.group === group).length);\n      if (group === undefined) {\n        this._limit = numberOptions.limit.value * densityFactor;\n      } else {\n        this._groupLimits.set(group, numberOptions.limit.value * densityFactor);\n      }\n      if (particlesCount < particlesNumber) {\n        this.push(Math.abs(particlesNumber - particlesCount), undefined, options, group);\n      } else if (particlesCount > particlesNumber) {\n        this.removeQuantity(particlesCount - particlesNumber, group);\n      }\n    };\n    this._initDensityFactor = densityOptions => {\n      const container = this._container;\n      if (!container.canvas.element || !densityOptions.enable) {\n        return _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultDensityFactor;\n      }\n      const canvas = container.canvas.element,\n        pxRatio = container.retina.pixelRatio;\n      return canvas.width * canvas.height / (densityOptions.height * densityOptions.width * pxRatio ** _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.squareExp);\n    };\n    this._pushParticle = (position, overrideOptions, group, initializer) => {\n      try {\n        let particle = this._pool.pop();\n        if (!particle) {\n          particle = new _Particle_js__WEBPACK_IMPORTED_MODULE_5__.Particle(this._engine, this._container);\n        }\n        particle.init(this._nextId, position, overrideOptions, group);\n        let canAdd = true;\n        if (initializer) {\n          canAdd = initializer(particle);\n        }\n        if (!canAdd) {\n          return;\n        }\n        this._array.push(particle);\n        this._zArray.push(particle);\n        this._nextId++;\n        this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_2__.EventType.particleAdded, {\n          container: this._container,\n          data: {\n            particle\n          }\n        });\n        return particle;\n      } catch (e) {\n        (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getLogger)().warning(`${_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} adding particle: ${e}`);\n      }\n    };\n    this._removeParticle = (index, group, override) => {\n      const particle = this._array[index];\n      if (!particle || particle.group !== group) {\n        return false;\n      }\n      const zIdx = this._zArray.indexOf(particle);\n      this._array.splice(index, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.deleteCount);\n      this._zArray.splice(zIdx, _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.deleteCount);\n      particle.destroy(override);\n      this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_2__.EventType.particleRemoved, {\n        container: this._container,\n        data: {\n          particle\n        }\n      });\n      this._addToPool(particle);\n      return true;\n    };\n    this._engine = engine;\n    this._container = container;\n    this._nextId = 0;\n    this._array = [];\n    this._zArray = [];\n    this._pool = [];\n    this._limit = 0;\n    this._groupLimits = new Map();\n    this._needsSort = false;\n    this._lastZIndex = 0;\n    this._interactionManager = new _Utils_InteractionManager_js__WEBPACK_IMPORTED_MODULE_3__.InteractionManager(engine, container);\n    this._pluginsInitialized = false;\n    const canvasSize = container.canvas.size;\n    this.quadTree = new _Utils_QuadTree_js__WEBPACK_IMPORTED_MODULE_7__.QuadTree(qTreeRectangle(canvasSize), _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.qTreeCapacity);\n    this.movers = [];\n    this.updaters = [];\n  }\n  get count() {\n    return this._array.length;\n  }\n  addManualParticles() {\n    const container = this._container,\n      options = container.actualOptions;\n    options.manualParticles.forEach(p => this.addParticle(p.position ? (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getPosition)(p.position, container.canvas.size) : undefined, p.options));\n  }\n  addParticle(position, overrideOptions, group, initializer) {\n    const limitMode = this._container.actualOptions.particles.number.limit.mode,\n      limit = group === undefined ? this._limit : this._groupLimits.get(group) ?? this._limit,\n      currentCount = this.count;\n    if (limit > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minLimit) {\n      switch (limitMode) {\n        case _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_4__.LimitMode.delete:\n          {\n            const countToRemove = currentCount + _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.countOffset - limit;\n            if (countToRemove > _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minCount) {\n              this.removeQuantity(countToRemove);\n            }\n            break;\n          }\n        case _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_4__.LimitMode.wait:\n          if (currentCount >= limit) {\n            return;\n          }\n          break;\n      }\n    }\n    return this._pushParticle(position, overrideOptions, group, initializer);\n  }\n  clear() {\n    this._array = [];\n    this._zArray = [];\n    this._pluginsInitialized = false;\n  }\n  destroy() {\n    this._array = [];\n    this._zArray = [];\n    this.movers = [];\n    this.updaters = [];\n  }\n  draw(delta) {\n    const container = this._container,\n      canvas = container.canvas;\n    canvas.clear();\n    this.update(delta);\n    for (const plugin of container.plugins.values()) {\n      canvas.drawPlugin(plugin, delta);\n    }\n    for (const p of this._zArray) {\n      p.draw(delta);\n    }\n  }\n  filter(condition) {\n    return this._array.filter(condition);\n  }\n  find(condition) {\n    return this._array.find(condition);\n  }\n  get(index) {\n    return this._array[index];\n  }\n  handleClickMode(mode) {\n    this._interactionManager.handleClickMode(mode);\n  }\n  async init() {\n    const container = this._container,\n      options = container.actualOptions;\n    this._lastZIndex = 0;\n    this._needsSort = false;\n    await this.initPlugins();\n    let handled = false;\n    for (const plugin of container.plugins.values()) {\n      handled = plugin.particlesInitialization?.() ?? handled;\n      if (handled) {\n        break;\n      }\n    }\n    this.addManualParticles();\n    if (!handled) {\n      const particlesOptions = options.particles,\n        groups = particlesOptions.groups;\n      for (const group in groups) {\n        const groupOptions = groups[group];\n        for (let i = this.count, j = 0; j < groupOptions.number?.value && i < particlesOptions.number.value; i++, j++) {\n          this.addParticle(undefined, groupOptions, group);\n        }\n      }\n      for (let i = this.count; i < particlesOptions.number.value; i++) {\n        this.addParticle();\n      }\n    }\n  }\n  async initPlugins() {\n    if (this._pluginsInitialized) {\n      return;\n    }\n    const container = this._container;\n    this.movers = await this._engine.getMovers(container, true);\n    this.updaters = await this._engine.getUpdaters(container, true);\n    await this._interactionManager.init();\n    for (const pathGenerator of container.pathGenerators.values()) {\n      pathGenerator.init(container);\n    }\n  }\n  push(nb, mouse, overrideOptions, group) {\n    for (let i = 0; i < nb; i++) {\n      this.addParticle(mouse?.position, overrideOptions, group);\n    }\n  }\n  async redraw() {\n    this.clear();\n    await this.init();\n    this.draw({\n      value: 0,\n      factor: 0\n    });\n  }\n  remove(particle, group, override) {\n    this.removeAt(this._array.indexOf(particle), undefined, group, override);\n  }\n  removeAt(index, quantity = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRemoveQuantity, group, override) {\n    if (index < _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minIndex || index > this.count) {\n      return;\n    }\n    let deleted = 0;\n    for (let i = index; deleted < quantity && i < this.count; i++) {\n      if (this._removeParticle(i, group, override)) {\n        i--;\n        deleted++;\n      }\n    }\n  }\n  removeQuantity(quantity, group) {\n    this.removeAt(_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minIndex, quantity, group);\n  }\n  setDensity() {\n    const options = this._container.actualOptions,\n      groups = options.particles.groups,\n      manualCount = options.manualParticles.length;\n    for (const group in groups) {\n      this._applyDensity(groups[group], manualCount, group);\n    }\n    this._applyDensity(options.particles, manualCount);\n  }\n  setLastZIndex(zIndex) {\n    this._lastZIndex = zIndex;\n    this._needsSort = this._needsSort || this._lastZIndex < zIndex;\n  }\n  setResizeFactor(factor) {\n    this._resizeFactor = factor;\n  }\n  update(delta) {\n    const container = this._container,\n      particlesToDelete = new Set();\n    this.quadTree = new _Utils_QuadTree_js__WEBPACK_IMPORTED_MODULE_7__.QuadTree(qTreeRectangle(container.canvas.size), _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.qTreeCapacity);\n    for (const pathGenerator of container.pathGenerators.values()) {\n      pathGenerator.update();\n    }\n    for (const plugin of container.plugins.values()) {\n      plugin.update?.(delta);\n    }\n    const resizeFactor = this._resizeFactor;\n    for (const particle of this._array) {\n      if (resizeFactor && !particle.ignoresResizeRatio) {\n        particle.position.x *= resizeFactor.width;\n        particle.position.y *= resizeFactor.height;\n        particle.initialPosition.x *= resizeFactor.width;\n        particle.initialPosition.y *= resizeFactor.height;\n      }\n      particle.ignoresResizeRatio = false;\n      this._interactionManager.reset(particle);\n      for (const plugin of this._container.plugins.values()) {\n        if (particle.destroyed) {\n          break;\n        }\n        plugin.particleUpdate?.(particle, delta);\n      }\n      for (const mover of this.movers) {\n        if (mover.isEnabled(particle)) {\n          mover.move(particle, delta);\n        }\n      }\n      if (particle.destroyed) {\n        particlesToDelete.add(particle);\n        continue;\n      }\n      this.quadTree.insert(new _Utils_Point_js__WEBPACK_IMPORTED_MODULE_6__.Point(particle.getPosition(), particle));\n    }\n    if (particlesToDelete.size) {\n      const checkDelete = p => !particlesToDelete.has(p);\n      this._array = this.filter(checkDelete);\n      this._zArray = this._zArray.filter(checkDelete);\n      for (const particle of particlesToDelete) {\n        this._engine.dispatchEvent(_Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_2__.EventType.particleRemoved, {\n          container: this._container,\n          data: {\n            particle\n          }\n        });\n      }\n      this._addToPool(...particlesToDelete);\n    }\n    this._interactionManager.externalInteract(delta);\n    for (const particle of this._array) {\n      for (const updater of this.updaters) {\n        updater.update(particle, delta);\n      }\n      if (!particle.destroyed && !particle.spawning) {\n        this._interactionManager.particlesInteract(particle, delta);\n      }\n    }\n    delete this._resizeFactor;\n    if (this._needsSort) {\n      const zArray = this._zArray;\n      zArray.sort((a, b) => b.position.z - a.position.z || a.id - b.id);\n      this._lastZIndex = zArray[zArray.length - _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lengthOffset].position.z;\n      this._needsSort = false;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Particles.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Retina.js":
/*!************************************************!*\
  !*** ../../engine/dist/browser/Core/Retina.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Retina: () => (/* binding */ Retina)\n/* harmony export */ });\n/* harmony import */ var _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n\n\n\nclass Retina {\n  constructor(container) {\n    this.container = container;\n    this.pixelRatio = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRatio;\n    this.reduceFactor = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultReduceFactor;\n  }\n  init() {\n    const container = this.container,\n      options = container.actualOptions;\n    this.pixelRatio = !options.detectRetina || (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_2__.isSsr)() ? _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRatio : devicePixelRatio;\n    this.reduceFactor = _Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultReduceFactor;\n    const ratio = this.pixelRatio,\n      canvas = container.canvas;\n    if (canvas.element) {\n      const element = canvas.element;\n      canvas.size.width = element.offsetWidth * ratio;\n      canvas.size.height = element.offsetHeight * ratio;\n    }\n    const particles = options.particles,\n      moveOptions = particles.move;\n    this.maxSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.gravity.maxSpeed) * ratio;\n    this.sizeAnimationSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(particles.size.animation.speed) * ratio;\n  }\n  initParticle(particle) {\n    const options = particle.options,\n      ratio = this.pixelRatio,\n      moveOptions = options.move,\n      moveDistance = moveOptions.distance,\n      props = particle.retina;\n    props.moveDrift = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.drift) * ratio;\n    props.moveSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.speed) * ratio;\n    props.sizeAnimationSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(options.size.animation.speed) * ratio;\n    const maxDistance = props.maxDistance;\n    maxDistance.horizontal = moveDistance.horizontal !== undefined ? moveDistance.horizontal * ratio : undefined;\n    maxDistance.vertical = moveDistance.vertical !== undefined ? moveDistance.vertical * ratio : undefined;\n    props.maxSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getRangeValue)(moveOptions.gravity.maxSpeed) * ratio;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Retina.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/Constants.js":
/*!*********************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/Constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   canvasFirstIndex: () => (/* binding */ canvasFirstIndex),\n/* harmony export */   canvasTag: () => (/* binding */ canvasTag),\n/* harmony export */   clickRadius: () => (/* binding */ clickRadius),\n/* harmony export */   countOffset: () => (/* binding */ countOffset),\n/* harmony export */   decayOffset: () => (/* binding */ decayOffset),\n/* harmony export */   defaultAlpha: () => (/* binding */ defaultAlpha),\n/* harmony export */   defaultAngle: () => (/* binding */ defaultAngle),\n/* harmony export */   defaultDensityFactor: () => (/* binding */ defaultDensityFactor),\n/* harmony export */   defaultFps: () => (/* binding */ defaultFps),\n/* harmony export */   defaultFpsLimit: () => (/* binding */ defaultFpsLimit),\n/* harmony export */   defaultLoops: () => (/* binding */ defaultLoops),\n/* harmony export */   defaultOpacity: () => (/* binding */ defaultOpacity),\n/* harmony export */   defaultRadius: () => (/* binding */ defaultRadius),\n/* harmony export */   defaultRatio: () => (/* binding */ defaultRatio),\n/* harmony export */   defaultReduceFactor: () => (/* binding */ defaultReduceFactor),\n/* harmony export */   defaultRemoveQuantity: () => (/* binding */ defaultRemoveQuantity),\n/* harmony export */   defaultRetryCount: () => (/* binding */ defaultRetryCount),\n/* harmony export */   defaultRgbMin: () => (/* binding */ defaultRgbMin),\n/* harmony export */   defaultTime: () => (/* binding */ defaultTime),\n/* harmony export */   defaultTransform: () => (/* binding */ defaultTransform),\n/* harmony export */   defaultTransformValue: () => (/* binding */ defaultTransformValue),\n/* harmony export */   defaultVelocity: () => (/* binding */ defaultVelocity),\n/* harmony export */   deleteCount: () => (/* binding */ deleteCount),\n/* harmony export */   double: () => (/* binding */ double),\n/* harmony export */   doublePI: () => (/* binding */ doublePI),\n/* harmony export */   empty: () => (/* binding */ empty),\n/* harmony export */   errorPrefix: () => (/* binding */ errorPrefix),\n/* harmony export */   generatedAttribute: () => (/* binding */ generatedAttribute),\n/* harmony export */   generatedFalse: () => (/* binding */ generatedFalse),\n/* harmony export */   generatedTrue: () => (/* binding */ generatedTrue),\n/* harmony export */   hMax: () => (/* binding */ hMax),\n/* harmony export */   hMin: () => (/* binding */ hMin),\n/* harmony export */   hPhase: () => (/* binding */ hPhase),\n/* harmony export */   half: () => (/* binding */ half),\n/* harmony export */   identity: () => (/* binding */ identity),\n/* harmony export */   inverseFactorNumerator: () => (/* binding */ inverseFactorNumerator),\n/* harmony export */   lFactor: () => (/* binding */ lFactor),\n/* harmony export */   lMax: () => (/* binding */ lMax),\n/* harmony export */   lMin: () => (/* binding */ lMin),\n/* harmony export */   lengthOffset: () => (/* binding */ lengthOffset),\n/* harmony export */   loadMinIndex: () => (/* binding */ loadMinIndex),\n/* harmony export */   loadRandomFactor: () => (/* binding */ loadRandomFactor),\n/* harmony export */   manualCount: () => (/* binding */ manualCount),\n/* harmony export */   manualDefaultPosition: () => (/* binding */ manualDefaultPosition),\n/* harmony export */   midColorValue: () => (/* binding */ midColorValue),\n/* harmony export */   millisecondsToSeconds: () => (/* binding */ millisecondsToSeconds),\n/* harmony export */   minCoordinate: () => (/* binding */ minCoordinate),\n/* harmony export */   minCount: () => (/* binding */ minCount),\n/* harmony export */   minFpsLimit: () => (/* binding */ minFpsLimit),\n/* harmony export */   minIndex: () => (/* binding */ minIndex),\n/* harmony export */   minLimit: () => (/* binding */ minLimit),\n/* harmony export */   minRetries: () => (/* binding */ minRetries),\n/* harmony export */   minStrokeWidth: () => (/* binding */ minStrokeWidth),\n/* harmony export */   minVelocity: () => (/* binding */ minVelocity),\n/* harmony export */   minZ: () => (/* binding */ minZ),\n/* harmony export */   minimumLength: () => (/* binding */ minimumLength),\n/* harmony export */   minimumSize: () => (/* binding */ minimumSize),\n/* harmony export */   mouseDownEvent: () => (/* binding */ mouseDownEvent),\n/* harmony export */   mouseLeaveEvent: () => (/* binding */ mouseLeaveEvent),\n/* harmony export */   mouseMoveEvent: () => (/* binding */ mouseMoveEvent),\n/* harmony export */   mouseOutEvent: () => (/* binding */ mouseOutEvent),\n/* harmony export */   mouseUpEvent: () => (/* binding */ mouseUpEvent),\n/* harmony export */   none: () => (/* binding */ none),\n/* harmony export */   one: () => (/* binding */ one),\n/* harmony export */   originPoint: () => (/* binding */ originPoint),\n/* harmony export */   percentDenominator: () => (/* binding */ percentDenominator),\n/* harmony export */   phaseNumerator: () => (/* binding */ phaseNumerator),\n/* harmony export */   posOffset: () => (/* binding */ posOffset),\n/* harmony export */   qTreeCapacity: () => (/* binding */ qTreeCapacity),\n/* harmony export */   quarter: () => (/* binding */ quarter),\n/* harmony export */   randomColorValue: () => (/* binding */ randomColorValue),\n/* harmony export */   removeDeleteCount: () => (/* binding */ removeDeleteCount),\n/* harmony export */   removeMinIndex: () => (/* binding */ removeMinIndex),\n/* harmony export */   resizeEvent: () => (/* binding */ resizeEvent),\n/* harmony export */   rgbFactor: () => (/* binding */ rgbFactor),\n/* harmony export */   rgbMax: () => (/* binding */ rgbMax),\n/* harmony export */   rollFactor: () => (/* binding */ rollFactor),\n/* harmony export */   sMax: () => (/* binding */ sMax),\n/* harmony export */   sMin: () => (/* binding */ sMin),\n/* harmony export */   sNormalizedOffset: () => (/* binding */ sNormalizedOffset),\n/* harmony export */   sextuple: () => (/* binding */ sextuple),\n/* harmony export */   sizeFactor: () => (/* binding */ sizeFactor),\n/* harmony export */   squareExp: () => (/* binding */ squareExp),\n/* harmony export */   subdivideCount: () => (/* binding */ subdivideCount),\n/* harmony export */   threeQuarter: () => (/* binding */ threeQuarter),\n/* harmony export */   touchCancelEvent: () => (/* binding */ touchCancelEvent),\n/* harmony export */   touchDelay: () => (/* binding */ touchDelay),\n/* harmony export */   touchEndEvent: () => (/* binding */ touchEndEvent),\n/* harmony export */   touchEndLengthOffset: () => (/* binding */ touchEndLengthOffset),\n/* harmony export */   touchMoveEvent: () => (/* binding */ touchMoveEvent),\n/* harmony export */   touchStartEvent: () => (/* binding */ touchStartEvent),\n/* harmony export */   triple: () => (/* binding */ triple),\n/* harmony export */   tryCountIncrement: () => (/* binding */ tryCountIncrement),\n/* harmony export */   visibilityChangeEvent: () => (/* binding */ visibilityChangeEvent),\n/* harmony export */   zIndexFactorOffset: () => (/* binding */ zIndexFactorOffset)\n/* harmony export */ });\nconst generatedAttribute = \"generated\",\n  mouseDownEvent = \"pointerdown\",\n  mouseUpEvent = \"pointerup\",\n  mouseLeaveEvent = \"pointerleave\",\n  mouseOutEvent = \"pointerout\",\n  mouseMoveEvent = \"pointermove\",\n  touchStartEvent = \"touchstart\",\n  touchEndEvent = \"touchend\",\n  touchMoveEvent = \"touchmove\",\n  touchCancelEvent = \"touchcancel\",\n  resizeEvent = \"resize\",\n  visibilityChangeEvent = \"visibilitychange\",\n  errorPrefix = \"tsParticles - Error\",\n  percentDenominator = 100,\n  half = 0.5,\n  millisecondsToSeconds = 1000,\n  originPoint = {\n    x: 0,\n    y: 0,\n    z: 0\n  },\n  defaultTransform = {\n    a: 1,\n    b: 0,\n    c: 0,\n    d: 1\n  },\n  randomColorValue = \"random\",\n  midColorValue = \"mid\",\n  double = 2,\n  doublePI = Math.PI * double,\n  defaultFps = 60,\n  defaultAlpha = 1,\n  generatedTrue = \"true\",\n  generatedFalse = \"false\",\n  canvasTag = \"canvas\",\n  defaultRetryCount = 0,\n  squareExp = 2,\n  qTreeCapacity = 4,\n  defaultRemoveQuantity = 1,\n  defaultRatio = 1,\n  defaultReduceFactor = 1,\n  subdivideCount = 4,\n  inverseFactorNumerator = 1.0,\n  rgbMax = 255,\n  hMax = 360,\n  sMax = 100,\n  lMax = 100,\n  hMin = 0,\n  sMin = 0,\n  hPhase = 60,\n  empty = 0,\n  quarter = 0.25,\n  threeQuarter = half + quarter,\n  minVelocity = 0,\n  defaultTransformValue = 1,\n  minimumSize = 0,\n  minimumLength = 0,\n  zIndexFactorOffset = 1,\n  defaultOpacity = 1,\n  clickRadius = 1,\n  touchEndLengthOffset = 1,\n  minCoordinate = 0,\n  removeDeleteCount = 1,\n  removeMinIndex = 0,\n  defaultFpsLimit = 120,\n  minFpsLimit = 0,\n  canvasFirstIndex = 0,\n  loadRandomFactor = 10000,\n  loadMinIndex = 0,\n  one = 1,\n  none = 0,\n  decayOffset = 1,\n  tryCountIncrement = 1,\n  minRetries = 0,\n  rollFactor = 1,\n  minZ = 0,\n  defaultRadius = 0,\n  posOffset = -quarter,\n  sizeFactor = 1.5,\n  minLimit = 0,\n  countOffset = 1,\n  minCount = 0,\n  minIndex = 0,\n  manualCount = 0,\n  lengthOffset = 1,\n  defaultDensityFactor = 1,\n  deleteCount = 1,\n  touchDelay = 500,\n  manualDefaultPosition = 50,\n  defaultAngle = 0,\n  identity = 1,\n  minStrokeWidth = 0,\n  lFactor = 1,\n  lMin = 0,\n  rgbFactor = 255,\n  triple = 3,\n  sextuple = 6,\n  sNormalizedOffset = 1,\n  phaseNumerator = 1,\n  defaultRgbMin = 0,\n  defaultVelocity = 0,\n  defaultLoops = 0,\n  defaultTime = 0;\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/Constants.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/EventListeners.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/EventListeners.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EventListeners: () => (/* binding */ EventListeners)\n/* harmony export */ });\n/* harmony import */ var _Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Enums/InteractivityDetect.js */ \"../../engine/dist/browser/Enums/InteractivityDetect.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\nfunction manageListener(element, event, handler, add, options) {\n  if (add) {\n    let addOptions = {\n      passive: true\n    };\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isBoolean)(options)) {\n      addOptions.capture = options;\n    } else if (options !== undefined) {\n      addOptions = options;\n    }\n    element.addEventListener(event, handler, addOptions);\n  } else {\n    const removeOptions = options;\n    element.removeEventListener(event, handler, removeOptions);\n  }\n}\nclass EventListeners {\n  constructor(container) {\n    this.container = container;\n    this._doMouseTouchClick = e => {\n      const container = this.container,\n        options = container.actualOptions;\n      if (this._canPush) {\n        const mouseInteractivity = container.interactivity.mouse,\n          mousePos = mouseInteractivity.position;\n        if (!mousePos) {\n          return;\n        }\n        mouseInteractivity.clickPosition = {\n          ...mousePos\n        };\n        mouseInteractivity.clickTime = new Date().getTime();\n        const onClick = options.interactivity.events.onClick;\n        (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.executeOnSingleOrMultiple)(onClick.mode, mode => this.container.handleClickMode(mode));\n      }\n      if (e.type === \"touchend\") {\n        setTimeout(() => this._mouseTouchFinish(), _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchDelay);\n      }\n    };\n    this._handleThemeChange = e => {\n      const mediaEvent = e,\n        container = this.container,\n        options = container.options,\n        defaultThemes = options.defaultThemes,\n        themeName = mediaEvent.matches ? defaultThemes.dark : defaultThemes.light,\n        theme = options.themes.find(theme => theme.name === themeName);\n      if (theme?.default.auto) {\n        void container.loadTheme(themeName);\n      }\n    };\n    this._handleVisibilityChange = () => {\n      const container = this.container,\n        options = container.actualOptions;\n      this._mouseTouchFinish();\n      if (!options.pauseOnBlur) {\n        return;\n      }\n      if (document?.hidden) {\n        container.pageHidden = true;\n        container.pause();\n      } else {\n        container.pageHidden = false;\n        if (container.animationStatus) {\n          void container.play(true);\n        } else {\n          void container.draw(true);\n        }\n      }\n    };\n    this._handleWindowResize = () => {\n      if (this._resizeTimeout) {\n        clearTimeout(this._resizeTimeout);\n        delete this._resizeTimeout;\n      }\n      const handleResize = async () => {\n        const canvas = this.container.canvas;\n        await canvas?.windowResize();\n      };\n      this._resizeTimeout = setTimeout(() => void handleResize(), this.container.actualOptions.interactivity.events.resize.delay * _Constants_js__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds);\n    };\n    this._manageInteractivityListeners = (mouseLeaveTmpEvent, add) => {\n      const handlers = this._handlers,\n        container = this.container,\n        options = container.actualOptions,\n        interactivityEl = container.interactivity.element;\n      if (!interactivityEl) {\n        return;\n      }\n      const html = interactivityEl,\n        canvas = container.canvas;\n      canvas.setPointerEvents(html === canvas.element ? \"initial\" : \"none\");\n      if (!(options.interactivity.events.onHover.enable || options.interactivity.events.onClick.enable)) {\n        return;\n      }\n      manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent, handlers.mouseMove, add);\n      manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchStartEvent, handlers.touchStart, add);\n      manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchMoveEvent, handlers.touchMove, add);\n      if (!options.interactivity.events.onClick.enable) {\n        manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchEndEvent, handlers.touchEnd, add);\n      } else {\n        manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchEndEvent, handlers.touchEndClick, add);\n        manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseUpEvent, handlers.mouseUp, add);\n        manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseDownEvent, handlers.mouseDown, add);\n      }\n      manageListener(interactivityEl, mouseLeaveTmpEvent, handlers.mouseLeave, add);\n      manageListener(interactivityEl, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchCancelEvent, handlers.touchCancel, add);\n    };\n    this._manageListeners = add => {\n      const handlers = this._handlers,\n        container = this.container,\n        options = container.actualOptions,\n        detectType = options.interactivity.detectsOn,\n        canvasEl = container.canvas.element;\n      let mouseLeaveTmpEvent = _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseLeaveEvent;\n      if (detectType === _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_2__.InteractivityDetect.window) {\n        container.interactivity.element = window;\n        mouseLeaveTmpEvent = _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseOutEvent;\n      } else if (detectType === _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_2__.InteractivityDetect.parent && canvasEl) {\n        container.interactivity.element = canvasEl.parentElement ?? canvasEl.parentNode;\n      } else {\n        container.interactivity.element = canvasEl;\n      }\n      this._manageMediaMatch(add);\n      this._manageResize(add);\n      this._manageInteractivityListeners(mouseLeaveTmpEvent, add);\n      if (document) {\n        manageListener(document, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.visibilityChangeEvent, handlers.visibilityChange, add, false);\n      }\n    };\n    this._manageMediaMatch = add => {\n      const handlers = this._handlers,\n        mediaMatch = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.safeMatchMedia)(\"(prefers-color-scheme: dark)\");\n      if (!mediaMatch) {\n        return;\n      }\n      if (mediaMatch.addEventListener !== undefined) {\n        manageListener(mediaMatch, \"change\", handlers.themeChange, add);\n        return;\n      }\n      if (mediaMatch.addListener === undefined) {\n        return;\n      }\n      if (add) {\n        mediaMatch.addListener(handlers.oldThemeChange);\n      } else {\n        mediaMatch.removeListener(handlers.oldThemeChange);\n      }\n    };\n    this._manageResize = add => {\n      const handlers = this._handlers,\n        container = this.container,\n        options = container.actualOptions;\n      if (!options.interactivity.events.resize) {\n        return;\n      }\n      if (typeof ResizeObserver === \"undefined\") {\n        manageListener(window, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.resizeEvent, handlers.resize, add);\n        return;\n      }\n      const canvasEl = container.canvas.element;\n      if (this._resizeObserver && !add) {\n        if (canvasEl) {\n          this._resizeObserver.unobserve(canvasEl);\n        }\n        this._resizeObserver.disconnect();\n        delete this._resizeObserver;\n      } else if (!this._resizeObserver && add && canvasEl) {\n        this._resizeObserver = new ResizeObserver(entries => {\n          const entry = entries.find(e => e.target === canvasEl);\n          if (!entry) {\n            return;\n          }\n          this._handleWindowResize();\n        });\n        this._resizeObserver.observe(canvasEl);\n      }\n    };\n    this._mouseDown = () => {\n      const {\n        interactivity\n      } = this.container;\n      if (!interactivity) {\n        return;\n      }\n      const {\n        mouse\n      } = interactivity;\n      mouse.clicking = true;\n      mouse.downPosition = mouse.position;\n    };\n    this._mouseTouchClick = e => {\n      const container = this.container,\n        options = container.actualOptions,\n        {\n          mouse\n        } = container.interactivity;\n      mouse.inside = true;\n      let handled = false;\n      const mousePosition = mouse.position;\n      if (!mousePosition || !options.interactivity.events.onClick.enable) {\n        return;\n      }\n      for (const plugin of container.plugins.values()) {\n        if (!plugin.clickPositionValid) {\n          continue;\n        }\n        handled = plugin.clickPositionValid(mousePosition);\n        if (handled) {\n          break;\n        }\n      }\n      if (!handled) {\n        this._doMouseTouchClick(e);\n      }\n      mouse.clicking = false;\n    };\n    this._mouseTouchFinish = () => {\n      const interactivity = this.container.interactivity;\n      if (!interactivity) {\n        return;\n      }\n      const mouse = interactivity.mouse;\n      delete mouse.position;\n      delete mouse.clickPosition;\n      delete mouse.downPosition;\n      interactivity.status = _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseLeaveEvent;\n      mouse.inside = false;\n      mouse.clicking = false;\n    };\n    this._mouseTouchMove = e => {\n      const container = this.container,\n        options = container.actualOptions,\n        interactivity = container.interactivity,\n        canvasEl = container.canvas.element;\n      if (!interactivity?.element) {\n        return;\n      }\n      interactivity.mouse.inside = true;\n      let pos;\n      if (e.type.startsWith(\"pointer\")) {\n        this._canPush = true;\n        const mouseEvent = e;\n        if (interactivity.element === window) {\n          if (canvasEl) {\n            const clientRect = canvasEl.getBoundingClientRect();\n            pos = {\n              x: mouseEvent.clientX - clientRect.left,\n              y: mouseEvent.clientY - clientRect.top\n            };\n          }\n        } else if (options.interactivity.detectsOn === _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_2__.InteractivityDetect.parent) {\n          const source = mouseEvent.target,\n            target = mouseEvent.currentTarget;\n          if (source && target && canvasEl) {\n            const sourceRect = source.getBoundingClientRect(),\n              targetRect = target.getBoundingClientRect(),\n              canvasRect = canvasEl.getBoundingClientRect();\n            pos = {\n              x: mouseEvent.offsetX + _Constants_js__WEBPACK_IMPORTED_MODULE_0__.double * sourceRect.left - (targetRect.left + canvasRect.left),\n              y: mouseEvent.offsetY + _Constants_js__WEBPACK_IMPORTED_MODULE_0__.double * sourceRect.top - (targetRect.top + canvasRect.top)\n            };\n          } else {\n            pos = {\n              x: mouseEvent.offsetX ?? mouseEvent.clientX,\n              y: mouseEvent.offsetY ?? mouseEvent.clientY\n            };\n          }\n        } else if (mouseEvent.target === canvasEl) {\n          pos = {\n            x: mouseEvent.offsetX ?? mouseEvent.clientX,\n            y: mouseEvent.offsetY ?? mouseEvent.clientY\n          };\n        }\n      } else {\n        this._canPush = e.type !== \"touchmove\";\n        if (canvasEl) {\n          const touchEvent = e,\n            lastTouch = touchEvent.touches[touchEvent.touches.length - _Constants_js__WEBPACK_IMPORTED_MODULE_0__.lengthOffset],\n            canvasRect = canvasEl.getBoundingClientRect();\n          pos = {\n            x: lastTouch.clientX - (canvasRect.left ?? _Constants_js__WEBPACK_IMPORTED_MODULE_0__.minCoordinate),\n            y: lastTouch.clientY - (canvasRect.top ?? _Constants_js__WEBPACK_IMPORTED_MODULE_0__.minCoordinate)\n          };\n        }\n      }\n      const pxRatio = container.retina.pixelRatio;\n      if (pos) {\n        pos.x *= pxRatio;\n        pos.y *= pxRatio;\n      }\n      interactivity.mouse.position = pos;\n      interactivity.status = _Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent;\n    };\n    this._touchEnd = e => {\n      const evt = e,\n        touches = Array.from(evt.changedTouches);\n      for (const touch of touches) {\n        this._touches.delete(touch.identifier);\n      }\n      this._mouseTouchFinish();\n    };\n    this._touchEndClick = e => {\n      const evt = e,\n        touches = Array.from(evt.changedTouches);\n      for (const touch of touches) {\n        this._touches.delete(touch.identifier);\n      }\n      this._mouseTouchClick(e);\n    };\n    this._touchStart = e => {\n      const evt = e,\n        touches = Array.from(evt.changedTouches);\n      for (const touch of touches) {\n        this._touches.set(touch.identifier, performance.now());\n      }\n      this._mouseTouchMove(e);\n    };\n    this._canPush = true;\n    this._touches = new Map();\n    this._handlers = {\n      mouseDown: () => this._mouseDown(),\n      mouseLeave: () => this._mouseTouchFinish(),\n      mouseMove: e => this._mouseTouchMove(e),\n      mouseUp: e => this._mouseTouchClick(e),\n      touchStart: e => this._touchStart(e),\n      touchMove: e => this._mouseTouchMove(e),\n      touchEnd: e => this._touchEnd(e),\n      touchCancel: e => this._touchEnd(e),\n      touchEndClick: e => this._touchEndClick(e),\n      visibilityChange: () => this._handleVisibilityChange(),\n      themeChange: e => this._handleThemeChange(e),\n      oldThemeChange: e => this._handleThemeChange(e),\n      resize: () => {\n        this._handleWindowResize();\n      }\n    };\n  }\n  addListeners() {\n    this._manageListeners(true);\n  }\n  removeListeners() {\n    this._manageListeners(false);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/EventListeners.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/ExternalInteractorBase.js":
/*!**********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/ExternalInteractorBase.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ExternalInteractorBase: () => (/* binding */ ExternalInteractorBase)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Types/InteractorType.js */ \"../../engine/dist/browser/Enums/Types/InteractorType.js\");\n\nclass ExternalInteractorBase {\n  constructor(container) {\n    this.type = _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__.InteractorType.external;\n    this.container = container;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/ExternalInteractorBase.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/InteractionManager.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/InteractionManager.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InteractionManager: () => (/* binding */ InteractionManager)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Types/InteractorType.js */ \"../../engine/dist/browser/Enums/Types/InteractorType.js\");\n\nclass InteractionManager {\n  constructor(engine, container) {\n    this.container = container;\n    this._engine = engine;\n    this._interactors = [];\n    this._externalInteractors = [];\n    this._particleInteractors = [];\n  }\n  externalInteract(delta) {\n    for (const interactor of this._externalInteractors) {\n      if (interactor.isEnabled()) {\n        interactor.interact(delta);\n      }\n    }\n  }\n  handleClickMode(mode) {\n    for (const interactor of this._externalInteractors) {\n      interactor.handleClickMode?.(mode);\n    }\n  }\n  async init() {\n    this._interactors = await this._engine.getInteractors(this.container, true);\n    this._externalInteractors = [];\n    this._particleInteractors = [];\n    for (const interactor of this._interactors) {\n      switch (interactor.type) {\n        case _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__.InteractorType.external:\n          this._externalInteractors.push(interactor);\n          break;\n        case _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__.InteractorType.particles:\n          this._particleInteractors.push(interactor);\n          break;\n      }\n      interactor.init();\n    }\n  }\n  particlesInteract(particle, delta) {\n    for (const interactor of this._externalInteractors) {\n      interactor.clear(particle, delta);\n    }\n    for (const interactor of this._particleInteractors) {\n      if (interactor.isEnabled(particle)) {\n        interactor.interact(particle, delta);\n      }\n    }\n  }\n  reset(particle) {\n    for (const interactor of this._externalInteractors) {\n      if (interactor.isEnabled()) {\n        interactor.reset(particle);\n      }\n    }\n    for (const interactor of this._particleInteractors) {\n      if (interactor.isEnabled(particle)) {\n        interactor.reset(particle);\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/InteractionManager.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/ParticlesInteractorBase.js":
/*!***********************************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/ParticlesInteractorBase.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesInteractorBase: () => (/* binding */ ParticlesInteractorBase)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Types/InteractorType.js */ \"../../engine/dist/browser/Enums/Types/InteractorType.js\");\n\nclass ParticlesInteractorBase {\n  constructor(container) {\n    this.type = _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_0__.InteractorType.particles;\n    this.container = container;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/ParticlesInteractorBase.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/Point.js":
/*!*****************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/Point.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Point: () => (/* binding */ Point)\n/* harmony export */ });\nclass Point {\n  constructor(position, particle) {\n    this.position = position;\n    this.particle = particle;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/Point.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/QuadTree.js":
/*!********************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/QuadTree.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   QuadTree: () => (/* binding */ QuadTree)\n/* harmony export */ });\n/* harmony import */ var _Ranges_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Ranges.js */ \"../../engine/dist/browser/Core/Utils/Ranges.js\");\n/* harmony import */ var _Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\nclass QuadTree {\n  constructor(rectangle, capacity) {\n    this.rectangle = rectangle;\n    this.capacity = capacity;\n    this._subdivide = () => {\n      const {\n          x,\n          y\n        } = this.rectangle.position,\n        {\n          width,\n          height\n        } = this.rectangle.size,\n        {\n          capacity\n        } = this;\n      for (let i = 0; i < _Constants_js__WEBPACK_IMPORTED_MODULE_1__.subdivideCount; i++) {\n        const fixedIndex = i % _Constants_js__WEBPACK_IMPORTED_MODULE_1__.double;\n        this._subs.push(new QuadTree(new _Ranges_js__WEBPACK_IMPORTED_MODULE_0__.Rectangle(x + width * _Constants_js__WEBPACK_IMPORTED_MODULE_1__.half * fixedIndex, y + height * _Constants_js__WEBPACK_IMPORTED_MODULE_1__.half * (Math.round(i * _Constants_js__WEBPACK_IMPORTED_MODULE_1__.half) - fixedIndex), width * _Constants_js__WEBPACK_IMPORTED_MODULE_1__.half, height * _Constants_js__WEBPACK_IMPORTED_MODULE_1__.half), capacity));\n      }\n      this._divided = true;\n    };\n    this._points = [];\n    this._divided = false;\n    this._subs = [];\n  }\n  insert(point) {\n    if (!this.rectangle.contains(point.position)) {\n      return false;\n    }\n    if (this._points.length < this.capacity) {\n      this._points.push(point);\n      return true;\n    }\n    if (!this._divided) {\n      this._subdivide();\n    }\n    return this._subs.some(sub => sub.insert(point));\n  }\n  query(range, check) {\n    const res = [];\n    if (!range.intersects(this.rectangle)) {\n      return [];\n    }\n    for (const p of this._points) {\n      if (!range.contains(p.position) && (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.getDistance)(range.position, p.position) > p.particle.getRadius() && (!check || check(p.particle))) {\n        continue;\n      }\n      res.push(p.particle);\n    }\n    if (this._divided) {\n      for (const sub of this._subs) {\n        res.push(...sub.query(range, check));\n      }\n    }\n    return res;\n  }\n  queryCircle(position, radius, check) {\n    return this.query(new _Ranges_js__WEBPACK_IMPORTED_MODULE_0__.Circle(position.x, position.y, radius), check);\n  }\n  queryRectangle(position, size, check) {\n    return this.query(new _Ranges_js__WEBPACK_IMPORTED_MODULE_0__.Rectangle(position.x, position.y, size.width, size.height), check);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/QuadTree.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/Ranges.js":
/*!******************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/Ranges.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BaseRange: () => (/* binding */ BaseRange),\n/* harmony export */   Circle: () => (/* binding */ Circle),\n/* harmony export */   Rectangle: () => (/* binding */ Rectangle)\n/* harmony export */ });\n/* harmony import */ var _Types_RangeType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Types/RangeType.js */ \"../../engine/dist/browser/Types/RangeType.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n\n\n\nclass BaseRange {\n  constructor(x, y, type) {\n    this.position = {\n      x: x,\n      y: y\n    };\n    this.type = type;\n  }\n}\nclass Circle extends BaseRange {\n  constructor(x, y, radius) {\n    super(x, y, _Types_RangeType_js__WEBPACK_IMPORTED_MODULE_0__.RangeType.circle);\n    this.radius = radius;\n  }\n  contains(point) {\n    return (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.getDistance)(point, this.position) <= this.radius;\n  }\n  intersects(range) {\n    const pos1 = this.position,\n      pos2 = range.position,\n      distPos = {\n        x: Math.abs(pos2.x - pos1.x),\n        y: Math.abs(pos2.y - pos1.y)\n      },\n      r = this.radius;\n    if (range instanceof Circle || range.type === _Types_RangeType_js__WEBPACK_IMPORTED_MODULE_0__.RangeType.circle) {\n      const circleRange = range,\n        rSum = r + circleRange.radius,\n        dist = Math.sqrt(distPos.x ** _Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp + distPos.y ** _Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp);\n      return rSum > dist;\n    } else if (range instanceof Rectangle || range.type === _Types_RangeType_js__WEBPACK_IMPORTED_MODULE_0__.RangeType.rectangle) {\n      const rectRange = range,\n        {\n          width,\n          height\n        } = rectRange.size,\n        edges = Math.pow(distPos.x - width, _Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp) + Math.pow(distPos.y - height, _Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp);\n      return edges <= r ** _Constants_js__WEBPACK_IMPORTED_MODULE_2__.squareExp || distPos.x <= r + width && distPos.y <= r + height || distPos.x <= width || distPos.y <= height;\n    }\n    return false;\n  }\n}\nclass Rectangle extends BaseRange {\n  constructor(x, y, width, height) {\n    super(x, y, _Types_RangeType_js__WEBPACK_IMPORTED_MODULE_0__.RangeType.rectangle);\n    this.size = {\n      height: height,\n      width: width\n    };\n  }\n  contains(point) {\n    const w = this.size.width,\n      h = this.size.height,\n      pos = this.position;\n    return point.x >= pos.x && point.x <= pos.x + w && point.y >= pos.y && point.y <= pos.y + h;\n  }\n  intersects(range) {\n    if (range instanceof Circle) {\n      return range.intersects(this);\n    }\n    const w = this.size.width,\n      h = this.size.height,\n      pos1 = this.position,\n      pos2 = range.position,\n      size2 = range instanceof Rectangle ? range.size : {\n        width: 0,\n        height: 0\n      },\n      w2 = size2.width,\n      h2 = size2.height;\n    return pos2.x < pos1.x + w && pos2.x + w2 > pos1.x && pos2.y < pos1.y + h && pos2.y + h2 > pos1.y;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/Ranges.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Core/Utils/Vectors.js":
/*!*******************************************************!*\
  !*** ../../engine/dist/browser/Core/Utils/Vectors.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Vector: () => (/* binding */ Vector),\n/* harmony export */   Vector3d: () => (/* binding */ Vector3d)\n/* harmony export */ });\n/* harmony import */ var _Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass Vector3d {\n  constructor(xOrCoords, y, z) {\n    this._updateFromAngle = (angle, length) => {\n      this.x = Math.cos(angle) * length;\n      this.y = Math.sin(angle) * length;\n    };\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNumber)(xOrCoords) && xOrCoords) {\n      this.x = xOrCoords.x;\n      this.y = xOrCoords.y;\n      const coords3d = xOrCoords;\n      this.z = coords3d.z ? coords3d.z : _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z;\n    } else if (xOrCoords !== undefined && y !== undefined) {\n      this.x = xOrCoords;\n      this.y = y;\n      this.z = z ?? _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z;\n    } else {\n      throw new Error(`${_Constants_js__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} Vector3d not initialized correctly`);\n    }\n  }\n  static get origin() {\n    return Vector3d.create(_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z);\n  }\n  get angle() {\n    return Math.atan2(this.y, this.x);\n  }\n  set angle(angle) {\n    this._updateFromAngle(angle, this.length);\n  }\n  get length() {\n    return Math.sqrt(this.getLengthSq());\n  }\n  set length(length) {\n    this._updateFromAngle(this.angle, length);\n  }\n  static clone(source) {\n    return Vector3d.create(source.x, source.y, source.z);\n  }\n  static create(x, y, z) {\n    return new Vector3d(x, y, z);\n  }\n  add(v) {\n    return Vector3d.create(this.x + v.x, this.y + v.y, this.z + v.z);\n  }\n  addTo(v) {\n    this.x += v.x;\n    this.y += v.y;\n    this.z += v.z;\n  }\n  copy() {\n    return Vector3d.clone(this);\n  }\n  distanceTo(v) {\n    return this.sub(v).length;\n  }\n  distanceToSq(v) {\n    return this.sub(v).getLengthSq();\n  }\n  div(n) {\n    return Vector3d.create(this.x / n, this.y / n, this.z / n);\n  }\n  divTo(n) {\n    this.x /= n;\n    this.y /= n;\n    this.z /= n;\n  }\n  getLengthSq() {\n    return this.x ** _Constants_js__WEBPACK_IMPORTED_MODULE_0__.squareExp + this.y ** _Constants_js__WEBPACK_IMPORTED_MODULE_0__.squareExp;\n  }\n  mult(n) {\n    return Vector3d.create(this.x * n, this.y * n, this.z * n);\n  }\n  multTo(n) {\n    this.x *= n;\n    this.y *= n;\n    this.z *= n;\n  }\n  normalize() {\n    const length = this.length;\n    if (length != _Constants_js__WEBPACK_IMPORTED_MODULE_0__.none) {\n      this.multTo(_Constants_js__WEBPACK_IMPORTED_MODULE_0__.inverseFactorNumerator / length);\n    }\n  }\n  rotate(angle) {\n    return Vector3d.create(this.x * Math.cos(angle) - this.y * Math.sin(angle), this.x * Math.sin(angle) + this.y * Math.cos(angle), _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z);\n  }\n  setTo(c) {\n    this.x = c.x;\n    this.y = c.y;\n    const v3d = c;\n    this.z = v3d.z ? v3d.z : _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z;\n  }\n  sub(v) {\n    return Vector3d.create(this.x - v.x, this.y - v.y, this.z - v.z);\n  }\n  subFrom(v) {\n    this.x -= v.x;\n    this.y -= v.y;\n    this.z -= v.z;\n  }\n}\nclass Vector extends Vector3d {\n  constructor(xOrCoords, y) {\n    super(xOrCoords, y, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.z);\n  }\n  static get origin() {\n    return Vector.create(_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.y);\n  }\n  static clone(source) {\n    return Vector.create(source.x, source.y);\n  }\n  static create(x, y) {\n    return new Vector(x, y);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Core/Utils/Vectors.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/AnimationStatus.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/AnimationStatus.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AnimationStatus: () => (/* binding */ AnimationStatus)\n/* harmony export */ });\nvar AnimationStatus;\n(function (AnimationStatus) {\n  AnimationStatus[\"increasing\"] = \"increasing\";\n  AnimationStatus[\"decreasing\"] = \"decreasing\";\n})(AnimationStatus || (AnimationStatus = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/AnimationStatus.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Directions/MoveDirection.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Directions/MoveDirection.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveDirection: () => (/* binding */ MoveDirection)\n/* harmony export */ });\nvar MoveDirection;\n(function (MoveDirection) {\n  MoveDirection[\"bottom\"] = \"bottom\";\n  MoveDirection[\"bottomLeft\"] = \"bottom-left\";\n  MoveDirection[\"bottomRight\"] = \"bottom-right\";\n  MoveDirection[\"left\"] = \"left\";\n  MoveDirection[\"none\"] = \"none\";\n  MoveDirection[\"right\"] = \"right\";\n  MoveDirection[\"top\"] = \"top\";\n  MoveDirection[\"topLeft\"] = \"top-left\";\n  MoveDirection[\"topRight\"] = \"top-right\";\n  MoveDirection[\"outside\"] = \"outside\";\n  MoveDirection[\"inside\"] = \"inside\";\n})(MoveDirection || (MoveDirection = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Directions/MoveDirection.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Directions/OutModeDirection.js":
/*!**********************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Directions/OutModeDirection.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OutModeDirection: () => (/* binding */ OutModeDirection)\n/* harmony export */ });\nvar OutModeDirection;\n(function (OutModeDirection) {\n  OutModeDirection[\"bottom\"] = \"bottom\";\n  OutModeDirection[\"left\"] = \"left\";\n  OutModeDirection[\"right\"] = \"right\";\n  OutModeDirection[\"top\"] = \"top\";\n})(OutModeDirection || (OutModeDirection = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Directions/OutModeDirection.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Directions/RotateDirection.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Directions/RotateDirection.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RotateDirection: () => (/* binding */ RotateDirection)\n/* harmony export */ });\nvar RotateDirection;\n(function (RotateDirection) {\n  RotateDirection[\"clockwise\"] = \"clockwise\";\n  RotateDirection[\"counterClockwise\"] = \"counter-clockwise\";\n  RotateDirection[\"random\"] = \"random\";\n})(RotateDirection || (RotateDirection = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Directions/RotateDirection.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/InteractivityDetect.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Enums/InteractivityDetect.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InteractivityDetect: () => (/* binding */ InteractivityDetect)\n/* harmony export */ });\nvar InteractivityDetect;\n(function (InteractivityDetect) {\n  InteractivityDetect[\"canvas\"] = \"canvas\";\n  InteractivityDetect[\"parent\"] = \"parent\";\n  InteractivityDetect[\"window\"] = \"window\";\n})(InteractivityDetect || (InteractivityDetect = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/InteractivityDetect.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/AnimationMode.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/AnimationMode.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AnimationMode: () => (/* binding */ AnimationMode)\n/* harmony export */ });\nvar AnimationMode;\n(function (AnimationMode) {\n  AnimationMode[\"auto\"] = \"auto\";\n  AnimationMode[\"increase\"] = \"increase\";\n  AnimationMode[\"decrease\"] = \"decrease\";\n  AnimationMode[\"random\"] = \"random\";\n})(AnimationMode || (AnimationMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/AnimationMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/CollisionMode.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/CollisionMode.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CollisionMode: () => (/* binding */ CollisionMode)\n/* harmony export */ });\nvar CollisionMode;\n(function (CollisionMode) {\n  CollisionMode[\"absorb\"] = \"absorb\";\n  CollisionMode[\"bounce\"] = \"bounce\";\n  CollisionMode[\"destroy\"] = \"destroy\";\n})(CollisionMode || (CollisionMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/CollisionMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/LimitMode.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/LimitMode.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LimitMode: () => (/* binding */ LimitMode)\n/* harmony export */ });\nvar LimitMode;\n(function (LimitMode) {\n  LimitMode[\"delete\"] = \"delete\";\n  LimitMode[\"wait\"] = \"wait\";\n})(LimitMode || (LimitMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/LimitMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/OutMode.js":
/*!********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/OutMode.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OutMode: () => (/* binding */ OutMode)\n/* harmony export */ });\nvar OutMode;\n(function (OutMode) {\n  OutMode[\"bounce\"] = \"bounce\";\n  OutMode[\"none\"] = \"none\";\n  OutMode[\"out\"] = \"out\";\n  OutMode[\"destroy\"] = \"destroy\";\n  OutMode[\"split\"] = \"split\";\n})(OutMode || (OutMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/OutMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/PixelMode.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/PixelMode.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PixelMode: () => (/* binding */ PixelMode)\n/* harmony export */ });\nvar PixelMode;\n(function (PixelMode) {\n  PixelMode[\"precise\"] = \"precise\";\n  PixelMode[\"percent\"] = \"percent\";\n})(PixelMode || (PixelMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/PixelMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/ResponsiveMode.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/ResponsiveMode.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ResponsiveMode: () => (/* binding */ ResponsiveMode)\n/* harmony export */ });\nvar ResponsiveMode;\n(function (ResponsiveMode) {\n  ResponsiveMode[\"screen\"] = \"screen\";\n  ResponsiveMode[\"canvas\"] = \"canvas\";\n})(ResponsiveMode || (ResponsiveMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/ResponsiveMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Modes/ThemeMode.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Modes/ThemeMode.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ThemeMode: () => (/* binding */ ThemeMode)\n/* harmony export */ });\nvar ThemeMode;\n(function (ThemeMode) {\n  ThemeMode[\"any\"] = \"any\";\n  ThemeMode[\"dark\"] = \"dark\";\n  ThemeMode[\"light\"] = \"light\";\n})(ThemeMode || (ThemeMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Modes/ThemeMode.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/AlterType.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/AlterType.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AlterType: () => (/* binding */ AlterType)\n/* harmony export */ });\nvar AlterType;\n(function (AlterType) {\n  AlterType[\"darken\"] = \"darken\";\n  AlterType[\"enlighten\"] = \"enlighten\";\n})(AlterType || (AlterType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/AlterType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/DestroyType.js":
/*!************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/DestroyType.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DestroyType: () => (/* binding */ DestroyType)\n/* harmony export */ });\nvar DestroyType;\n(function (DestroyType) {\n  DestroyType[\"none\"] = \"none\";\n  DestroyType[\"max\"] = \"max\";\n  DestroyType[\"min\"] = \"min\";\n})(DestroyType || (DestroyType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/DestroyType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/DivType.js":
/*!********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/DivType.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DivType: () => (/* binding */ DivType)\n/* harmony export */ });\nvar DivType;\n(function (DivType) {\n  DivType[\"circle\"] = \"circle\";\n  DivType[\"rectangle\"] = \"rectangle\";\n})(DivType || (DivType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/DivType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/EasingType.js":
/*!***********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/EasingType.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EasingType: () => (/* binding */ EasingType)\n/* harmony export */ });\nvar EasingType;\n(function (EasingType) {\n  EasingType[\"easeInBack\"] = \"ease-in-back\";\n  EasingType[\"easeInCirc\"] = \"ease-in-circ\";\n  EasingType[\"easeInCubic\"] = \"ease-in-cubic\";\n  EasingType[\"easeInLinear\"] = \"ease-in-linear\";\n  EasingType[\"easeInQuad\"] = \"ease-in-quad\";\n  EasingType[\"easeInQuart\"] = \"ease-in-quart\";\n  EasingType[\"easeInQuint\"] = \"ease-in-quint\";\n  EasingType[\"easeInExpo\"] = \"ease-in-expo\";\n  EasingType[\"easeInSine\"] = \"ease-in-sine\";\n  EasingType[\"easeOutBack\"] = \"ease-out-back\";\n  EasingType[\"easeOutCirc\"] = \"ease-out-circ\";\n  EasingType[\"easeOutCubic\"] = \"ease-out-cubic\";\n  EasingType[\"easeOutLinear\"] = \"ease-out-linear\";\n  EasingType[\"easeOutQuad\"] = \"ease-out-quad\";\n  EasingType[\"easeOutQuart\"] = \"ease-out-quart\";\n  EasingType[\"easeOutQuint\"] = \"ease-out-quint\";\n  EasingType[\"easeOutExpo\"] = \"ease-out-expo\";\n  EasingType[\"easeOutSine\"] = \"ease-out-sine\";\n  EasingType[\"easeInOutBack\"] = \"ease-in-out-back\";\n  EasingType[\"easeInOutCirc\"] = \"ease-in-out-circ\";\n  EasingType[\"easeInOutCubic\"] = \"ease-in-out-cubic\";\n  EasingType[\"easeInOutLinear\"] = \"ease-in-out-linear\";\n  EasingType[\"easeInOutQuad\"] = \"ease-in-out-quad\";\n  EasingType[\"easeInOutQuart\"] = \"ease-in-out-quart\";\n  EasingType[\"easeInOutQuint\"] = \"ease-in-out-quint\";\n  EasingType[\"easeInOutExpo\"] = \"ease-in-out-expo\";\n  EasingType[\"easeInOutSine\"] = \"ease-in-out-sine\";\n})(EasingType || (EasingType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/EasingType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/EventType.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/EventType.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EventType: () => (/* binding */ EventType)\n/* harmony export */ });\nvar EventType;\n(function (EventType) {\n  EventType[\"configAdded\"] = \"configAdded\";\n  EventType[\"containerInit\"] = \"containerInit\";\n  EventType[\"particlesSetup\"] = \"particlesSetup\";\n  EventType[\"containerStarted\"] = \"containerStarted\";\n  EventType[\"containerStopped\"] = \"containerStopped\";\n  EventType[\"containerDestroyed\"] = \"containerDestroyed\";\n  EventType[\"containerPaused\"] = \"containerPaused\";\n  EventType[\"containerPlay\"] = \"containerPlay\";\n  EventType[\"containerBuilt\"] = \"containerBuilt\";\n  EventType[\"particleAdded\"] = \"particleAdded\";\n  EventType[\"particleDestroyed\"] = \"particleDestroyed\";\n  EventType[\"particleRemoved\"] = \"particleRemoved\";\n})(EventType || (EventType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/EventType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/GradientType.js":
/*!*************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/GradientType.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GradientType: () => (/* binding */ GradientType)\n/* harmony export */ });\nvar GradientType;\n(function (GradientType) {\n  GradientType[\"linear\"] = \"linear\";\n  GradientType[\"radial\"] = \"radial\";\n  GradientType[\"random\"] = \"random\";\n})(GradientType || (GradientType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/GradientType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/InteractorType.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/InteractorType.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InteractorType: () => (/* binding */ InteractorType)\n/* harmony export */ });\nvar InteractorType;\n(function (InteractorType) {\n  InteractorType[\"external\"] = \"external\";\n  InteractorType[\"particles\"] = \"particles\";\n})(InteractorType || (InteractorType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/InteractorType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/ParticleOutType.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/ParticleOutType.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticleOutType: () => (/* binding */ ParticleOutType)\n/* harmony export */ });\nvar ParticleOutType;\n(function (ParticleOutType) {\n  ParticleOutType[\"normal\"] = \"normal\";\n  ParticleOutType[\"inside\"] = \"inside\";\n  ParticleOutType[\"outside\"] = \"outside\";\n})(ParticleOutType || (ParticleOutType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/ParticleOutType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Enums/Types/StartValueType.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Enums/Types/StartValueType.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StartValueType: () => (/* binding */ StartValueType)\n/* harmony export */ });\nvar StartValueType;\n(function (StartValueType) {\n  StartValueType[\"max\"] = \"max\";\n  StartValueType[\"min\"] = \"min\";\n  StartValueType[\"random\"] = \"random\";\n})(StartValueType || (StartValueType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Enums/Types/StartValueType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/AnimatableColor.js":
/*!********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/AnimatableColor.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AnimatableColor: () => (/* binding */ AnimatableColor)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _HslAnimation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./HslAnimation.js */ \"../../engine/dist/browser/Options/Classes/HslAnimation.js\");\n/* harmony import */ var _OptionsColor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n\n\n\nclass AnimatableColor extends _OptionsColor_js__WEBPACK_IMPORTED_MODULE_2__.OptionsColor {\n  constructor() {\n    super();\n    this.animation = new _HslAnimation_js__WEBPACK_IMPORTED_MODULE_1__.HslAnimation();\n  }\n  static create(source, data) {\n    const color = new AnimatableColor();\n    color.load(source);\n    if (data !== undefined) {\n      if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isString)(data) || (0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isArray)(data)) {\n        color.load({\n          value: data\n        });\n      } else {\n        color.load(data);\n      }\n    }\n    return color;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    const colorAnimation = data.animation;\n    if (colorAnimation !== undefined) {\n      if (colorAnimation.enable !== undefined) {\n        this.animation.h.load(colorAnimation);\n      } else {\n        this.animation.load(data.animation);\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/AnimatableColor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/AnimationOptions.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/AnimationOptions.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AnimationOptions: () => (/* binding */ AnimationOptions),\n/* harmony export */   RangedAnimationOptions: () => (/* binding */ RangedAnimationOptions)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Modes/AnimationMode.js */ \"../../engine/dist/browser/Enums/Modes/AnimationMode.js\");\n/* harmony import */ var _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Enums/Types/StartValueType.js */ \"../../engine/dist/browser/Enums/Types/StartValueType.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\n\nclass AnimationOptions {\n  constructor() {\n    this.count = 0;\n    this.enable = false;\n    this.speed = 1;\n    this.decay = 0;\n    this.delay = 0;\n    this.sync = false;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.count !== undefined) {\n      this.count = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_3__.setRangeValue)(data.count);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.speed !== undefined) {\n      this.speed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_3__.setRangeValue)(data.speed);\n    }\n    if (data.decay !== undefined) {\n      this.decay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_3__.setRangeValue)(data.decay);\n    }\n    if (data.delay !== undefined) {\n      this.delay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_3__.setRangeValue)(data.delay);\n    }\n    if (data.sync !== undefined) {\n      this.sync = data.sync;\n    }\n  }\n}\nclass RangedAnimationOptions extends AnimationOptions {\n  constructor() {\n    super();\n    this.mode = _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_0__.AnimationMode.auto;\n    this.startValue = _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_1__.StartValueType.random;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.startValue !== undefined) {\n      this.startValue = data.startValue;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/AnimationOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Background/Background.js":
/*!**************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Background/Background.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Background: () => (/* binding */ Background)\n/* harmony export */ });\n/* harmony import */ var _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass Background {\n  constructor() {\n    this.color = new _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"\";\n    this.image = \"\";\n    this.position = \"\";\n    this.repeat = \"\";\n    this.size = \"\";\n    this.opacity = 1;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.image !== undefined) {\n      this.image = data.image;\n    }\n    if (data.position !== undefined) {\n      this.position = data.position;\n    }\n    if (data.repeat !== undefined) {\n      this.repeat = data.repeat;\n    }\n    if (data.size !== undefined) {\n      this.size = data.size;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Background/Background.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMask.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMask.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BackgroundMask: () => (/* binding */ BackgroundMask)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _BackgroundMaskCover_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BackgroundMaskCover.js */ \"../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMaskCover.js\");\n\n\nclass BackgroundMask {\n  constructor() {\n    this.composite = \"destination-out\";\n    this.cover = new _BackgroundMaskCover_js__WEBPACK_IMPORTED_MODULE_1__.BackgroundMaskCover();\n    this.enable = false;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.composite !== undefined) {\n      this.composite = data.composite;\n    }\n    if (data.cover !== undefined) {\n      const cover = data.cover,\n        color = (0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isString)(data.cover) ? {\n          color: data.cover\n        } : data.cover;\n      this.cover.load(cover.color !== undefined || cover.image !== undefined ? cover : {\n        color: color\n      });\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMask.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMaskCover.js":
/*!***************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMaskCover.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BackgroundMaskCover: () => (/* binding */ BackgroundMaskCover)\n/* harmony export */ });\n/* harmony import */ var _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass BackgroundMaskCover {\n  constructor() {\n    this.opacity = 1;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.image !== undefined) {\n      this.image = data.image;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMaskCover.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/ColorAnimation.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/ColorAnimation.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ColorAnimation: () => (/* binding */ ColorAnimation)\n/* harmony export */ });\n/* harmony import */ var _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AnimationOptions.js */ \"../../engine/dist/browser/Options/Classes/AnimationOptions.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\nclass ColorAnimation extends _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_0__.AnimationOptions {\n  constructor() {\n    super();\n    this.offset = 0;\n    this.sync = true;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.offset !== undefined) {\n      this.offset = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue)(data.offset);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/ColorAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/FullScreen/FullScreen.js":
/*!**************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/FullScreen/FullScreen.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FullScreen: () => (/* binding */ FullScreen)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass FullScreen {\n  constructor() {\n    this.enable = true;\n    this.zIndex = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.zIndex !== undefined) {\n      this.zIndex = data.zIndex;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/FullScreen/FullScreen.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/HslAnimation.js":
/*!*****************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/HslAnimation.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   HslAnimation: () => (/* binding */ HslAnimation)\n/* harmony export */ });\n/* harmony import */ var _ColorAnimation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ColorAnimation.js */ \"../../engine/dist/browser/Options/Classes/ColorAnimation.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass HslAnimation {\n  constructor() {\n    this.h = new _ColorAnimation_js__WEBPACK_IMPORTED_MODULE_0__.ColorAnimation();\n    this.s = new _ColorAnimation_js__WEBPACK_IMPORTED_MODULE_0__.ColorAnimation();\n    this.l = new _ColorAnimation_js__WEBPACK_IMPORTED_MODULE_0__.ColorAnimation();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    this.h.load(data.h);\n    this.s.load(data.s);\n    this.l.load(data.l);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/HslAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/ClickEvent.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/ClickEvent.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ClickEvent: () => (/* binding */ ClickEvent)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass ClickEvent {\n  constructor() {\n    this.enable = false;\n    this.mode = [];\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/ClickEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/DivEvent.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/DivEvent.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DivEvent: () => (/* binding */ DivEvent)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_DivType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Types/DivType.js */ \"../../engine/dist/browser/Enums/Types/DivType.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass DivEvent {\n  constructor() {\n    this.selectors = [];\n    this.enable = false;\n    this.mode = [];\n    this.type = _Enums_Types_DivType_js__WEBPACK_IMPORTED_MODULE_0__.DivType.circle;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.selectors !== undefined) {\n      this.selectors = data.selectors;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.type !== undefined) {\n      this.type = data.type;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/DivEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/Events.js":
/*!********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/Events.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Events: () => (/* binding */ Events)\n/* harmony export */ });\n/* harmony import */ var _ClickEvent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ClickEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/ClickEvent.js\");\n/* harmony import */ var _DivEvent_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DivEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/DivEvent.js\");\n/* harmony import */ var _HoverEvent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./HoverEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/HoverEvent.js\");\n/* harmony import */ var _ResizeEvent_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ResizeEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/ResizeEvent.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\n\n\nclass Events {\n  constructor() {\n    this.onClick = new _ClickEvent_js__WEBPACK_IMPORTED_MODULE_0__.ClickEvent();\n    this.onDiv = new _DivEvent_js__WEBPACK_IMPORTED_MODULE_1__.DivEvent();\n    this.onHover = new _HoverEvent_js__WEBPACK_IMPORTED_MODULE_2__.HoverEvent();\n    this.resize = new _ResizeEvent_js__WEBPACK_IMPORTED_MODULE_3__.ResizeEvent();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_5__.isNull)(data)) {\n      return;\n    }\n    this.onClick.load(data.onClick);\n    const onDiv = data.onDiv;\n    if (onDiv !== undefined) {\n      this.onDiv = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_4__.executeOnSingleOrMultiple)(onDiv, t => {\n        const tmp = new _DivEvent_js__WEBPACK_IMPORTED_MODULE_1__.DivEvent();\n        tmp.load(t);\n        return tmp;\n      });\n    }\n    this.onHover.load(data.onHover);\n    this.resize.load(data.resize);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/Events.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/HoverEvent.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/HoverEvent.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   HoverEvent: () => (/* binding */ HoverEvent)\n/* harmony export */ });\n/* harmony import */ var _Parallax_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Parallax.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/Parallax.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass HoverEvent {\n  constructor() {\n    this.enable = false;\n    this.mode = [];\n    this.parallax = new _Parallax_js__WEBPACK_IMPORTED_MODULE_0__.Parallax();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    this.parallax.load(data.parallax);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/HoverEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/Parallax.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/Parallax.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Parallax: () => (/* binding */ Parallax)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass Parallax {\n  constructor() {\n    this.enable = false;\n    this.force = 2;\n    this.smooth = 10;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.force !== undefined) {\n      this.force = data.force;\n    }\n    if (data.smooth !== undefined) {\n      this.smooth = data.smooth;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/Parallax.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Events/ResizeEvent.js":
/*!*************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Events/ResizeEvent.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ResizeEvent: () => (/* binding */ ResizeEvent)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass ResizeEvent {\n  constructor() {\n    this.delay = 0.5;\n    this.enable = true;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.delay !== undefined) {\n      this.delay = data.delay;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Events/ResizeEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js":
/*!********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Interactivity: () => (/* binding */ Interactivity)\n/* harmony export */ });\n/* harmony import */ var _Events_Events_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Events/Events.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/Events.js\");\n/* harmony import */ var _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Enums/InteractivityDetect.js */ \"../../engine/dist/browser/Enums/InteractivityDetect.js\");\n/* harmony import */ var _Modes_Modes_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Modes/Modes.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Modes/Modes.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\nclass Interactivity {\n  constructor(engine, container) {\n    this.detectsOn = _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_1__.InteractivityDetect.window;\n    this.events = new _Events_Events_js__WEBPACK_IMPORTED_MODULE_0__.Events();\n    this.modes = new _Modes_Modes_js__WEBPACK_IMPORTED_MODULE_2__.Modes(engine, container);\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNull)(data)) {\n      return;\n    }\n    const detectsOn = data.detectsOn;\n    if (detectsOn !== undefined) {\n      this.detectsOn = detectsOn;\n    }\n    this.events.load(data.events);\n    this.modes.load(data.modes);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Interactivity/Modes/Modes.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Interactivity/Modes/Modes.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Modes: () => (/* binding */ Modes)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass Modes {\n  constructor(engine, container) {\n    this._engine = engine;\n    this._container = container;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (!this._container) {\n      return;\n    }\n    const interactors = this._engine.interactors.get(this._container);\n    if (!interactors) {\n      return;\n    }\n    for (const interactor of interactors) {\n      if (!interactor.loadModeOptions) {\n        continue;\n      }\n      interactor.loadModeOptions(this, data);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Interactivity/Modes/Modes.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/ManualParticle.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/ManualParticle.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ManualParticle: () => (/* binding */ ManualParticle)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Modes/PixelMode.js */ \"../../engine/dist/browser/Enums/Modes/PixelMode.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n\n\n\n\nclass ManualParticle {\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.position) {\n      this.position = {\n        x: data.position.x ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_3__.manualDefaultPosition,\n        y: data.position.y ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_3__.manualDefaultPosition,\n        mode: data.position.mode ?? _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_0__.PixelMode.percent\n      };\n    }\n    if (data.options) {\n      this.options = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.deepExtend)({}, data.options);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/ManualParticle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Options.js":
/*!************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Options.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Options: () => (/* binding */ Options)\n/* harmony export */ });\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Background_Background_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Background/Background.js */ \"../../engine/dist/browser/Options/Classes/Background/Background.js\");\n/* harmony import */ var _BackgroundMask_BackgroundMask_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BackgroundMask/BackgroundMask.js */ \"../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMask.js\");\n/* harmony import */ var _FullScreen_FullScreen_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FullScreen/FullScreen.js */ \"../../engine/dist/browser/Options/Classes/FullScreen/FullScreen.js\");\n/* harmony import */ var _Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Interactivity/Interactivity.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js\");\n/* harmony import */ var _ManualParticle_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ManualParticle.js */ \"../../engine/dist/browser/Options/Classes/ManualParticle.js\");\n/* harmony import */ var _Responsive_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Responsive.js */ \"../../engine/dist/browser/Options/Classes/Responsive.js\");\n/* harmony import */ var _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Enums/Modes/ResponsiveMode.js */ \"../../engine/dist/browser/Enums/Modes/ResponsiveMode.js\");\n/* harmony import */ var _Theme_Theme_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Theme/Theme.js */ \"../../engine/dist/browser/Options/Classes/Theme/Theme.js\");\n/* harmony import */ var _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Enums/Modes/ThemeMode.js */ \"../../engine/dist/browser/Enums/Modes/ThemeMode.js\");\n/* harmony import */ var _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../Utils/OptionsUtils.js */ \"../../engine/dist/browser/Utils/OptionsUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass Options {\n  constructor(engine, container) {\n    this._findDefaultTheme = mode => {\n      return this.themes.find(theme => theme.default.value && theme.default.mode === mode) ?? this.themes.find(theme => theme.default.value && theme.default.mode === _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__.ThemeMode.any);\n    };\n    this._importPreset = preset => {\n      this.load(this._engine.getPreset(preset));\n    };\n    this._engine = engine;\n    this._container = container;\n    this.autoPlay = true;\n    this.background = new _Background_Background_js__WEBPACK_IMPORTED_MODULE_2__.Background();\n    this.backgroundMask = new _BackgroundMask_BackgroundMask_js__WEBPACK_IMPORTED_MODULE_3__.BackgroundMask();\n    this.clear = true;\n    this.defaultThemes = {};\n    this.delay = 0;\n    this.fullScreen = new _FullScreen_FullScreen_js__WEBPACK_IMPORTED_MODULE_4__.FullScreen();\n    this.detectRetina = true;\n    this.duration = 0;\n    this.fpsLimit = 120;\n    this.interactivity = new _Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_5__.Interactivity(engine, container);\n    this.manualParticles = [];\n    this.particles = (0,_Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_11__.loadParticlesOptions)(this._engine, this._container);\n    this.pauseOnBlur = true;\n    this.pauseOnOutsideViewport = true;\n    this.responsive = [];\n    this.smooth = false;\n    this.style = {};\n    this.themes = [];\n    this.zLayers = 100;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.preset !== undefined) {\n      (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.preset, preset => this._importPreset(preset));\n    }\n    if (data.autoPlay !== undefined) {\n      this.autoPlay = data.autoPlay;\n    }\n    if (data.clear !== undefined) {\n      this.clear = data.clear;\n    }\n    if (data.key !== undefined) {\n      this.key = data.key;\n    }\n    if (data.name !== undefined) {\n      this.name = data.name;\n    }\n    if (data.delay !== undefined) {\n      this.delay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_12__.setRangeValue)(data.delay);\n    }\n    const detectRetina = data.detectRetina;\n    if (detectRetina !== undefined) {\n      this.detectRetina = detectRetina;\n    }\n    if (data.duration !== undefined) {\n      this.duration = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_12__.setRangeValue)(data.duration);\n    }\n    const fpsLimit = data.fpsLimit;\n    if (fpsLimit !== undefined) {\n      this.fpsLimit = fpsLimit;\n    }\n    if (data.pauseOnBlur !== undefined) {\n      this.pauseOnBlur = data.pauseOnBlur;\n    }\n    if (data.pauseOnOutsideViewport !== undefined) {\n      this.pauseOnOutsideViewport = data.pauseOnOutsideViewport;\n    }\n    if (data.zLayers !== undefined) {\n      this.zLayers = data.zLayers;\n    }\n    this.background.load(data.background);\n    const fullScreen = data.fullScreen;\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isBoolean)(fullScreen)) {\n      this.fullScreen.enable = fullScreen;\n    } else {\n      this.fullScreen.load(fullScreen);\n    }\n    this.backgroundMask.load(data.backgroundMask);\n    this.interactivity.load(data.interactivity);\n    if (data.manualParticles) {\n      this.manualParticles = data.manualParticles.map(t => {\n        const tmp = new _ManualParticle_js__WEBPACK_IMPORTED_MODULE_6__.ManualParticle();\n        tmp.load(t);\n        return tmp;\n      });\n    }\n    this.particles.load(data.particles);\n    this.style = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(this.style, data.style);\n    this._engine.loadOptions(this, data);\n    if (data.smooth !== undefined) {\n      this.smooth = data.smooth;\n    }\n    const interactors = this._engine.interactors.get(this._container);\n    if (interactors) {\n      for (const interactor of interactors) {\n        if (interactor.loadOptions) {\n          interactor.loadOptions(this, data);\n        }\n      }\n    }\n    if (data.responsive !== undefined) {\n      for (const responsive of data.responsive) {\n        const optResponsive = new _Responsive_js__WEBPACK_IMPORTED_MODULE_7__.Responsive();\n        optResponsive.load(responsive);\n        this.responsive.push(optResponsive);\n      }\n    }\n    this.responsive.sort((a, b) => a.maxWidth - b.maxWidth);\n    if (data.themes !== undefined) {\n      for (const theme of data.themes) {\n        const existingTheme = this.themes.find(t => t.name === theme.name);\n        if (!existingTheme) {\n          const optTheme = new _Theme_Theme_js__WEBPACK_IMPORTED_MODULE_9__.Theme();\n          optTheme.load(theme);\n          this.themes.push(optTheme);\n        } else {\n          existingTheme.load(theme);\n        }\n      }\n    }\n    this.defaultThemes.dark = this._findDefaultTheme(_Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__.ThemeMode.dark)?.name;\n    this.defaultThemes.light = this._findDefaultTheme(_Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__.ThemeMode.light)?.name;\n  }\n  setResponsive(width, pxRatio, defaultOptions) {\n    this.load(defaultOptions);\n    const responsiveOptions = this.responsive.find(t => t.mode === _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_8__.ResponsiveMode.screen && screen ? t.maxWidth > screen.availWidth : t.maxWidth * pxRatio > width);\n    this.load(responsiveOptions?.options);\n    return responsiveOptions?.maxWidth;\n  }\n  setTheme(name) {\n    if (name) {\n      const chosenTheme = this.themes.find(theme => theme.name === name);\n      if (chosenTheme) {\n        this.load(chosenTheme.options);\n      }\n    } else {\n      const mediaMatch = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.safeMatchMedia)(\"(prefers-color-scheme: dark)\"),\n        clientDarkMode = mediaMatch?.matches,\n        defaultTheme = this._findDefaultTheme(clientDarkMode ? _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__.ThemeMode.dark : _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_10__.ThemeMode.light);\n      if (defaultTheme) {\n        this.load(defaultTheme.options);\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Options.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/OptionsColor.js":
/*!*****************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/OptionsColor.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OptionsColor: () => (/* binding */ OptionsColor)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass OptionsColor {\n  constructor() {\n    this.value = \"\";\n  }\n  static create(source, data) {\n    const color = new OptionsColor();\n    color.load(source);\n    if (data !== undefined) {\n      if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isString)(data) || (0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isArray)(data)) {\n        color.load({\n          value: data\n        });\n      } else {\n        color.load(data);\n      }\n    }\n    return color;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data.value)) {\n      this.value = data.value;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/OptionsColor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js":
/*!*************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesBounce: () => (/* binding */ ParticlesBounce)\n/* harmony export */ });\n/* harmony import */ var _ParticlesBounceFactor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ParticlesBounceFactor.js */ \"../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounceFactor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass ParticlesBounce {\n  constructor() {\n    this.horizontal = new _ParticlesBounceFactor_js__WEBPACK_IMPORTED_MODULE_0__.ParticlesBounceFactor();\n    this.vertical = new _ParticlesBounceFactor_js__WEBPACK_IMPORTED_MODULE_0__.ParticlesBounceFactor();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    this.horizontal.load(data.horizontal);\n    this.vertical.load(data.vertical);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounceFactor.js":
/*!*******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounceFactor.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesBounceFactor: () => (/* binding */ ParticlesBounceFactor)\n/* harmony export */ });\n/* harmony import */ var _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n\nclass ParticlesBounceFactor extends _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.value = 1;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounceFactor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Collisions/Collisions.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Collisions/Collisions.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Collisions: () => (/* binding */ Collisions)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_CollisionMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Modes/CollisionMode.js */ \"../../engine/dist/browser/Enums/Modes/CollisionMode.js\");\n/* harmony import */ var _CollisionsAbsorb_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CollisionsAbsorb.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsAbsorb.js\");\n/* harmony import */ var _CollisionsOverlap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CollisionsOverlap.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsOverlap.js\");\n/* harmony import */ var _Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Bounce/ParticlesBounce.js */ \"../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\n\n\n\nclass Collisions {\n  constructor() {\n    this.absorb = new _CollisionsAbsorb_js__WEBPACK_IMPORTED_MODULE_1__.CollisionsAbsorb();\n    this.bounce = new _Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_3__.ParticlesBounce();\n    this.enable = false;\n    this.maxSpeed = 50;\n    this.mode = _Enums_Modes_CollisionMode_js__WEBPACK_IMPORTED_MODULE_0__.CollisionMode.bounce;\n    this.overlap = new _CollisionsOverlap_js__WEBPACK_IMPORTED_MODULE_2__.CollisionsOverlap();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_4__.isNull)(data)) {\n      return;\n    }\n    this.absorb.load(data.absorb);\n    this.bounce.load(data.bounce);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.maxSpeed !== undefined) {\n      this.maxSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_5__.setRangeValue)(data.maxSpeed);\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    this.overlap.load(data.overlap);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Collisions/Collisions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsAbsorb.js":
/*!******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsAbsorb.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CollisionsAbsorb: () => (/* binding */ CollisionsAbsorb)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass CollisionsAbsorb {\n  constructor() {\n    this.speed = 2;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.speed !== undefined) {\n      this.speed = data.speed;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsAbsorb.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsOverlap.js":
/*!*******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsOverlap.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CollisionsOverlap: () => (/* binding */ CollisionsOverlap)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass CollisionsOverlap {\n  constructor() {\n    this.enable = true;\n    this.retries = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.retries !== undefined) {\n      this.retries = data.retries;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsOverlap.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Effect/Effect.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Effect/Effect.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Effect: () => (/* binding */ Effect)\n/* harmony export */ });\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass Effect {\n  constructor() {\n    this.close = true;\n    this.fill = true;\n    this.options = {};\n    this.type = [];\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    const options = data.options;\n    if (options !== undefined) {\n      for (const effect in options) {\n        const item = options[effect];\n        if (item) {\n          this.options[effect] = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(this.options[effect] ?? {}, item);\n        }\n      }\n    }\n    if (data.close !== undefined) {\n      this.close = data.close;\n    }\n    if (data.fill !== undefined) {\n      this.fill = data.fill;\n    }\n    if (data.type !== undefined) {\n      this.type = data.type;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Effect/Effect.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/Move.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/Move.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Move: () => (/* binding */ Move)\n/* harmony export */ });\n/* harmony import */ var _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Directions/MoveDirection.js */ \"../../engine/dist/browser/Enums/Directions/MoveDirection.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _MoveAngle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MoveAngle.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveAngle.js\");\n/* harmony import */ var _MoveAttract_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MoveAttract.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveAttract.js\");\n/* harmony import */ var _MoveCenter_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MoveCenter.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveCenter.js\");\n/* harmony import */ var _MoveGravity_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MoveGravity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveGravity.js\");\n/* harmony import */ var _Path_MovePath_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Path/MovePath.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Path/MovePath.js\");\n/* harmony import */ var _MoveTrail_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MoveTrail.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrail.js\");\n/* harmony import */ var _OutModes_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./OutModes.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/OutModes.js\");\n/* harmony import */ var _Spin_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Spin.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Spin.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\n\n\n\n\n\n\n\n\nclass Move {\n  constructor() {\n    this.angle = new _MoveAngle_js__WEBPACK_IMPORTED_MODULE_2__.MoveAngle();\n    this.attract = new _MoveAttract_js__WEBPACK_IMPORTED_MODULE_3__.MoveAttract();\n    this.center = new _MoveCenter_js__WEBPACK_IMPORTED_MODULE_4__.MoveCenter();\n    this.decay = 0;\n    this.distance = {};\n    this.direction = _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.none;\n    this.drift = 0;\n    this.enable = false;\n    this.gravity = new _MoveGravity_js__WEBPACK_IMPORTED_MODULE_5__.MoveGravity();\n    this.path = new _Path_MovePath_js__WEBPACK_IMPORTED_MODULE_6__.MovePath();\n    this.outModes = new _OutModes_js__WEBPACK_IMPORTED_MODULE_8__.OutModes();\n    this.random = false;\n    this.size = false;\n    this.speed = 2;\n    this.spin = new _Spin_js__WEBPACK_IMPORTED_MODULE_9__.Spin();\n    this.straight = false;\n    this.trail = new _MoveTrail_js__WEBPACK_IMPORTED_MODULE_7__.MoveTrail();\n    this.vibrate = false;\n    this.warp = false;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    this.angle.load((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNumber)(data.angle) ? {\n      value: data.angle\n    } : data.angle);\n    this.attract.load(data.attract);\n    this.center.load(data.center);\n    if (data.decay !== undefined) {\n      this.decay = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_10__.setRangeValue)(data.decay);\n    }\n    if (data.direction !== undefined) {\n      this.direction = data.direction;\n    }\n    if (data.distance !== undefined) {\n      this.distance = (0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNumber)(data.distance) ? {\n        horizontal: data.distance,\n        vertical: data.distance\n      } : {\n        ...data.distance\n      };\n    }\n    if (data.drift !== undefined) {\n      this.drift = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_10__.setRangeValue)(data.drift);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    this.gravity.load(data.gravity);\n    const outModes = data.outModes;\n    if (outModes !== undefined) {\n      if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isObject)(outModes)) {\n        this.outModes.load(outModes);\n      } else {\n        this.outModes.load({\n          default: outModes\n        });\n      }\n    }\n    this.path.load(data.path);\n    if (data.random !== undefined) {\n      this.random = data.random;\n    }\n    if (data.size !== undefined) {\n      this.size = data.size;\n    }\n    if (data.speed !== undefined) {\n      this.speed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_10__.setRangeValue)(data.speed);\n    }\n    this.spin.load(data.spin);\n    if (data.straight !== undefined) {\n      this.straight = data.straight;\n    }\n    this.trail.load(data.trail);\n    if (data.vibrate !== undefined) {\n      this.vibrate = data.vibrate;\n    }\n    if (data.warp !== undefined) {\n      this.warp = data.warp;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/Move.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveAngle.js":
/*!*****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveAngle.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveAngle: () => (/* binding */ MoveAngle)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\nclass MoveAngle {\n  constructor() {\n    this.offset = 0;\n    this.value = 90;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.offset !== undefined) {\n      this.offset = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(data.offset);\n    }\n    if (data.value !== undefined) {\n      this.value = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(data.value);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveAngle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveAttract.js":
/*!*******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveAttract.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveAttract: () => (/* binding */ MoveAttract)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\nclass MoveAttract {\n  constructor() {\n    this.distance = 200;\n    this.enable = false;\n    this.rotate = {\n      x: 3000,\n      y: 3000\n    };\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(data.distance);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.rotate) {\n      const rotateX = data.rotate.x;\n      if (rotateX !== undefined) {\n        this.rotate.x = rotateX;\n      }\n      const rotateY = data.rotate.y;\n      if (rotateY !== undefined) {\n        this.rotate.y = rotateY;\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveAttract.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveCenter.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveCenter.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveCenter: () => (/* binding */ MoveCenter)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Modes/PixelMode.js */ \"../../engine/dist/browser/Enums/Modes/PixelMode.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass MoveCenter {\n  constructor() {\n    this.x = 50;\n    this.y = 50;\n    this.mode = _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_0__.PixelMode.percent;\n    this.radius = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.x !== undefined) {\n      this.x = data.x;\n    }\n    if (data.y !== undefined) {\n      this.y = data.y;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.radius !== undefined) {\n      this.radius = data.radius;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveCenter.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveGravity.js":
/*!*******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveGravity.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveGravity: () => (/* binding */ MoveGravity)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\nclass MoveGravity {\n  constructor() {\n    this.acceleration = 9.81;\n    this.enable = false;\n    this.inverse = false;\n    this.maxSpeed = 50;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.acceleration !== undefined) {\n      this.acceleration = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(data.acceleration);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.inverse !== undefined) {\n      this.inverse = data.inverse;\n    }\n    if (data.maxSpeed !== undefined) {\n      this.maxSpeed = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_1__.setRangeValue)(data.maxSpeed);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveGravity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrail.js":
/*!*****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrail.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveTrail: () => (/* binding */ MoveTrail)\n/* harmony export */ });\n/* harmony import */ var _MoveTrailFill_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MoveTrailFill.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrailFill.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass MoveTrail {\n  constructor() {\n    this.enable = false;\n    this.length = 10;\n    this.fill = new _MoveTrailFill_js__WEBPACK_IMPORTED_MODULE_0__.MoveTrailFill();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.fill !== undefined) {\n      this.fill.load(data.fill);\n    }\n    if (data.length !== undefined) {\n      this.length = data.length;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrail.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrailFill.js":
/*!*********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrailFill.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MoveTrailFill: () => (/* binding */ MoveTrailFill)\n/* harmony export */ });\n/* harmony import */ var _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass MoveTrailFill {\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.image !== undefined) {\n      this.image = data.image;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrailFill.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/OutModes.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/OutModes.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OutModes: () => (/* binding */ OutModes)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Modes/OutMode.js */ \"../../engine/dist/browser/Enums/Modes/OutMode.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass OutModes {\n  constructor() {\n    this.default = _Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_0__.OutMode.out;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.default !== undefined) {\n      this.default = data.default;\n    }\n    this.bottom = data.bottom ?? data.default;\n    this.left = data.left ?? data.default;\n    this.right = data.right ?? data.default;\n    this.top = data.top ?? data.default;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/OutModes.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/Path/MovePath.js":
/*!*********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/Path/MovePath.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MovePath: () => (/* binding */ MovePath)\n/* harmony export */ });\n/* harmony import */ var _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass MovePath {\n  constructor() {\n    this.clamp = true;\n    this.delay = new _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom();\n    this.enable = false;\n    this.options = {};\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.clamp !== undefined) {\n      this.clamp = data.clamp;\n    }\n    this.delay.load(data.delay);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    this.generator = data.generator;\n    if (data.options) {\n      this.options = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.deepExtend)(this.options, data.options);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/Path/MovePath.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Move/Spin.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Move/Spin.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Spin: () => (/* binding */ Spin)\n/* harmony export */ });\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\nclass Spin {\n  constructor() {\n    this.acceleration = 0;\n    this.enable = false;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.acceleration !== undefined) {\n      this.acceleration = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue)(data.acceleration);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.position) {\n      this.position = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, data.position);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Move/Spin.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesDensity.js":
/*!**************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesDensity.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesDensity: () => (/* binding */ ParticlesDensity)\n/* harmony export */ });\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\nclass ParticlesDensity {\n  constructor() {\n    this.enable = false;\n    this.width = 1920;\n    this.height = 1080;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    const width = data.width;\n    if (width !== undefined) {\n      this.width = width;\n    }\n    const height = data.height;\n    if (height !== undefined) {\n      this.height = height;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesDensity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumber.js":
/*!*************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumber.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesNumber: () => (/* binding */ ParticlesNumber)\n/* harmony export */ });\n/* harmony import */ var _ParticlesDensity_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ParticlesDensity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesDensity.js\");\n/* harmony import */ var _ParticlesNumberLimit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParticlesNumberLimit.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumberLimit.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass ParticlesNumber {\n  constructor() {\n    this.density = new _ParticlesDensity_js__WEBPACK_IMPORTED_MODULE_0__.ParticlesDensity();\n    this.limit = new _ParticlesNumberLimit_js__WEBPACK_IMPORTED_MODULE_1__.ParticlesNumberLimit();\n    this.value = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    this.density.load(data.density);\n    this.limit.load(data.limit);\n    if (data.value !== undefined) {\n      this.value = data.value;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumber.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumberLimit.js":
/*!******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumberLimit.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesNumberLimit: () => (/* binding */ ParticlesNumberLimit)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Modes/LimitMode.js */ \"../../engine/dist/browser/Enums/Modes/LimitMode.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass ParticlesNumberLimit {\n  constructor() {\n    this.mode = _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_0__.LimitMode.delete;\n    this.value = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.value !== undefined) {\n      this.value = data.value;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumberLimit.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Opacity/Opacity.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Opacity/Opacity.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Opacity: () => (/* binding */ Opacity)\n/* harmony export */ });\n/* harmony import */ var _OpacityAnimation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OpacityAnimation.js */ \"../../engine/dist/browser/Options/Classes/Particles/Opacity/OpacityAnimation.js\");\n/* harmony import */ var _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass Opacity extends _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_1__.RangedAnimationValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _OpacityAnimation_js__WEBPACK_IMPORTED_MODULE_0__.OpacityAnimation();\n    this.value = 1;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    const animation = data.animation;\n    if (animation !== undefined) {\n      this.animation.load(animation);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Opacity/Opacity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Opacity/OpacityAnimation.js":
/*!***************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Opacity/OpacityAnimation.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpacityAnimation: () => (/* binding */ OpacityAnimation)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Types/DestroyType.js */ \"../../engine/dist/browser/Enums/Types/DestroyType.js\");\n/* harmony import */ var _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../AnimationOptions.js */ \"../../engine/dist/browser/Options/Classes/AnimationOptions.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass OpacityAnimation extends _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_1__.RangedAnimationOptions {\n  constructor() {\n    super();\n    this.destroy = _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_0__.DestroyType.none;\n    this.speed = 2;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.destroy !== undefined) {\n      this.destroy = data.destroy;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Opacity/OpacityAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/ParticlesOptions.js":
/*!*******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/ParticlesOptions.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParticlesOptions: () => (/* binding */ ParticlesOptions)\n/* harmony export */ });\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _AnimatableColor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AnimatableColor.js */ \"../../engine/dist/browser/Options/Classes/AnimatableColor.js\");\n/* harmony import */ var _Collisions_Collisions_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Collisions/Collisions.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/Collisions.js\");\n/* harmony import */ var _Effect_Effect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Effect/Effect.js */ \"../../engine/dist/browser/Options/Classes/Particles/Effect/Effect.js\");\n/* harmony import */ var _Move_Move_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Move/Move.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Move.js\");\n/* harmony import */ var _Opacity_Opacity_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Opacity/Opacity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Opacity/Opacity.js\");\n/* harmony import */ var _Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Bounce/ParticlesBounce.js */ \"../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js\");\n/* harmony import */ var _Number_ParticlesNumber_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Number/ParticlesNumber.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumber.js\");\n/* harmony import */ var _Shadow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Shadow.js */ \"../../engine/dist/browser/Options/Classes/Particles/Shadow.js\");\n/* harmony import */ var _Shape_Shape_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Shape/Shape.js */ \"../../engine/dist/browser/Options/Classes/Particles/Shape/Shape.js\");\n/* harmony import */ var _Size_Size_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Size/Size.js */ \"../../engine/dist/browser/Options/Classes/Particles/Size/Size.js\");\n/* harmony import */ var _Stroke_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Stroke.js */ \"../../engine/dist/browser/Options/Classes/Particles/Stroke.js\");\n/* harmony import */ var _ZIndex_ZIndex_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ZIndex/ZIndex.js */ \"../../engine/dist/browser/Options/Classes/Particles/ZIndex/ZIndex.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass ParticlesOptions {\n  constructor(engine, container) {\n    this._engine = engine;\n    this._container = container;\n    this.bounce = new _Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_6__.ParticlesBounce();\n    this.collisions = new _Collisions_Collisions_js__WEBPACK_IMPORTED_MODULE_2__.Collisions();\n    this.color = new _AnimatableColor_js__WEBPACK_IMPORTED_MODULE_1__.AnimatableColor();\n    this.color.value = \"#fff\";\n    this.effect = new _Effect_Effect_js__WEBPACK_IMPORTED_MODULE_3__.Effect();\n    this.groups = {};\n    this.move = new _Move_Move_js__WEBPACK_IMPORTED_MODULE_4__.Move();\n    this.number = new _Number_ParticlesNumber_js__WEBPACK_IMPORTED_MODULE_7__.ParticlesNumber();\n    this.opacity = new _Opacity_Opacity_js__WEBPACK_IMPORTED_MODULE_5__.Opacity();\n    this.reduceDuplicates = false;\n    this.shadow = new _Shadow_js__WEBPACK_IMPORTED_MODULE_8__.Shadow();\n    this.shape = new _Shape_Shape_js__WEBPACK_IMPORTED_MODULE_9__.Shape();\n    this.size = new _Size_Size_js__WEBPACK_IMPORTED_MODULE_10__.Size();\n    this.stroke = new _Stroke_js__WEBPACK_IMPORTED_MODULE_11__.Stroke();\n    this.zIndex = new _ZIndex_ZIndex_js__WEBPACK_IMPORTED_MODULE_12__.ZIndex();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_13__.isNull)(data)) {\n      return;\n    }\n    if (data.groups !== undefined) {\n      for (const group of Object.keys(data.groups)) {\n        if (!Object.hasOwn(data.groups, group)) {\n          continue;\n        }\n        const item = data.groups[group];\n        if (item !== undefined) {\n          this.groups[group] = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(this.groups[group] ?? {}, item);\n        }\n      }\n    }\n    if (data.reduceDuplicates !== undefined) {\n      this.reduceDuplicates = data.reduceDuplicates;\n    }\n    this.bounce.load(data.bounce);\n    this.color.load(_AnimatableColor_js__WEBPACK_IMPORTED_MODULE_1__.AnimatableColor.create(this.color, data.color));\n    this.effect.load(data.effect);\n    this.move.load(data.move);\n    this.number.load(data.number);\n    this.opacity.load(data.opacity);\n    this.shape.load(data.shape);\n    this.size.load(data.size);\n    this.shadow.load(data.shadow);\n    this.zIndex.load(data.zIndex);\n    this.collisions.load(data.collisions);\n    if (data.interactivity !== undefined) {\n      this.interactivity = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, data.interactivity);\n    }\n    const strokeToLoad = data.stroke;\n    if (strokeToLoad) {\n      this.stroke = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(strokeToLoad, t => {\n        const tmp = new _Stroke_js__WEBPACK_IMPORTED_MODULE_11__.Stroke();\n        tmp.load(t);\n        return tmp;\n      });\n    }\n    if (this._container) {\n      const updaters = this._engine.updaters.get(this._container);\n      if (updaters) {\n        for (const updater of updaters) {\n          if (updater.loadOptions) {\n            updater.loadOptions(this, data);\n          }\n        }\n      }\n      const interactors = this._engine.interactors.get(this._container);\n      if (interactors) {\n        for (const interactor of interactors) {\n          if (interactor.loadParticlesOptions) {\n            interactor.loadParticlesOptions(this, data);\n          }\n        }\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/ParticlesOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Shadow.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Shadow.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Shadow: () => (/* binding */ Shadow)\n/* harmony export */ });\n/* harmony import */ var _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass Shadow {\n  constructor() {\n    this.blur = 0;\n    this.color = new _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.enable = false;\n    this.offset = {\n      x: 0,\n      y: 0\n    };\n    this.color.value = \"#000\";\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.blur !== undefined) {\n      this.blur = data.blur;\n    }\n    this.color = _OptionsColor_js__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.offset === undefined) {\n      return;\n    }\n    if (data.offset.x !== undefined) {\n      this.offset.x = data.offset.x;\n    }\n    if (data.offset.y !== undefined) {\n      this.offset.y = data.offset.y;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Shadow.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Shape/Shape.js":
/*!**************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Shape/Shape.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Shape: () => (/* binding */ Shape)\n/* harmony export */ });\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass Shape {\n  constructor() {\n    this.close = true;\n    this.fill = true;\n    this.options = {};\n    this.type = \"circle\";\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    const options = data.options;\n    if (options !== undefined) {\n      for (const shape in options) {\n        const item = options[shape];\n        if (item) {\n          this.options[shape] = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(this.options[shape] ?? {}, item);\n        }\n      }\n    }\n    if (data.close !== undefined) {\n      this.close = data.close;\n    }\n    if (data.fill !== undefined) {\n      this.fill = data.fill;\n    }\n    if (data.type !== undefined) {\n      this.type = data.type;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Shape/Shape.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Size/Size.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Size/Size.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Size: () => (/* binding */ Size)\n/* harmony export */ });\n/* harmony import */ var _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n/* harmony import */ var _SizeAnimation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SizeAnimation.js */ \"../../engine/dist/browser/Options/Classes/Particles/Size/SizeAnimation.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass Size extends _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__.RangedAnimationValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _SizeAnimation_js__WEBPACK_IMPORTED_MODULE_1__.SizeAnimation();\n    this.value = 3;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    const animation = data.animation;\n    if (animation !== undefined) {\n      this.animation.load(animation);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Size/Size.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Size/SizeAnimation.js":
/*!*********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Size/SizeAnimation.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SizeAnimation: () => (/* binding */ SizeAnimation)\n/* harmony export */ });\n/* harmony import */ var _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../Enums/Types/DestroyType.js */ \"../../engine/dist/browser/Enums/Types/DestroyType.js\");\n/* harmony import */ var _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../AnimationOptions.js */ \"../../engine/dist/browser/Options/Classes/AnimationOptions.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass SizeAnimation extends _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_1__.RangedAnimationOptions {\n  constructor() {\n    super();\n    this.destroy = _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_0__.DestroyType.none;\n    this.speed = 5;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.destroy !== undefined) {\n      this.destroy = data.destroy;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Size/SizeAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/Stroke.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/Stroke.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Stroke: () => (/* binding */ Stroke)\n/* harmony export */ });\n/* harmony import */ var _AnimatableColor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../AnimatableColor.js */ \"../../engine/dist/browser/Options/Classes/AnimatableColor.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\nclass Stroke {\n  constructor() {\n    this.width = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _AnimatableColor_js__WEBPACK_IMPORTED_MODULE_0__.AnimatableColor.create(this.color, data.color);\n    }\n    if (data.width !== undefined) {\n      this.width = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue)(data.width);\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue)(data.opacity);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/Stroke.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Particles/ZIndex/ZIndex.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Particles/ZIndex/ZIndex.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ZIndex: () => (/* binding */ ZIndex)\n/* harmony export */ });\n/* harmony import */ var _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass ZIndex extends _ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.opacityRate = 1;\n    this.sizeRate = 1;\n    this.velocityRate = 1;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.opacityRate !== undefined) {\n      this.opacityRate = data.opacityRate;\n    }\n    if (data.sizeRate !== undefined) {\n      this.sizeRate = data.sizeRate;\n    }\n    if (data.velocityRate !== undefined) {\n      this.velocityRate = data.velocityRate;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Particles/ZIndex/ZIndex.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Responsive.js":
/*!***************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Responsive.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Responsive: () => (/* binding */ Responsive)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Enums/Modes/ResponsiveMode.js */ \"../../engine/dist/browser/Enums/Modes/ResponsiveMode.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass Responsive {\n  constructor() {\n    this.maxWidth = Infinity;\n    this.options = {};\n    this.mode = _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_0__.ResponsiveMode.canvas;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data.maxWidth)) {\n      this.maxWidth = data.maxWidth;\n    }\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data.mode)) {\n      if (data.mode === _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_0__.ResponsiveMode.screen) {\n        this.mode = _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_0__.ResponsiveMode.screen;\n      } else {\n        this.mode = _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_0__.ResponsiveMode.canvas;\n      }\n    }\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data.options)) {\n      this.options = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.deepExtend)({}, data.options);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Responsive.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Theme/Theme.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Theme/Theme.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Theme: () => (/* binding */ Theme)\n/* harmony export */ });\n/* harmony import */ var _ThemeDefault_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ThemeDefault.js */ \"../../engine/dist/browser/Options/Classes/Theme/ThemeDefault.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\nclass Theme {\n  constructor() {\n    this.name = \"\";\n    this.default = new _ThemeDefault_js__WEBPACK_IMPORTED_MODULE_0__.ThemeDefault();\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(data)) {\n      return;\n    }\n    if (data.name !== undefined) {\n      this.name = data.name;\n    }\n    this.default.load(data.default);\n    if (data.options !== undefined) {\n      this.options = (0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.deepExtend)({}, data.options);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Theme/Theme.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/Theme/ThemeDefault.js":
/*!***********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/Theme/ThemeDefault.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ThemeDefault: () => (/* binding */ ThemeDefault)\n/* harmony export */ });\n/* harmony import */ var _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../Enums/Modes/ThemeMode.js */ \"../../engine/dist/browser/Enums/Modes/ThemeMode.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\nclass ThemeDefault {\n  constructor() {\n    this.auto = false;\n    this.mode = _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_0__.ThemeMode.any;\n    this.value = false;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (data.auto !== undefined) {\n      this.auto = data.auto;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.value !== undefined) {\n      this.value = data.value;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/Theme/ThemeDefault.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Classes/ValueWithRandom.js":
/*!********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Classes/ValueWithRandom.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AnimationValueWithRandom: () => (/* binding */ AnimationValueWithRandom),\n/* harmony export */   RangedAnimationValueWithRandom: () => (/* binding */ RangedAnimationValueWithRandom),\n/* harmony export */   ValueWithRandom: () => (/* binding */ ValueWithRandom)\n/* harmony export */ });\n/* harmony import */ var _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AnimationOptions.js */ \"../../engine/dist/browser/Options/Classes/AnimationOptions.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n\n\n\nclass ValueWithRandom {\n  constructor() {\n    this.value = 0;\n  }\n  load(data) {\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    if (!(0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data.value)) {\n      this.value = (0,_Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue)(data.value);\n    }\n  }\n}\nclass AnimationValueWithRandom extends ValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_0__.AnimationOptions();\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_1__.isNull)(data)) {\n      return;\n    }\n    const animation = data.animation;\n    if (animation !== undefined) {\n      this.animation.load(animation);\n    }\n  }\n}\nclass RangedAnimationValueWithRandom extends AnimationValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _AnimationOptions_js__WEBPACK_IMPORTED_MODULE_0__.RangedAnimationOptions();\n  }\n  load(data) {\n    super.load(data);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Classes/ValueWithRandom.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Background/IBackground.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Background/IBackground.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Background/IBackground.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMask.js":
/*!**************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMask.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMask.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMaskCover.js":
/*!*******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMaskCover.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMaskCover.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/FullScreen/IFullScreen.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/FullScreen/IFullScreen.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/FullScreen/IFullScreen.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IAnimatable.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IAnimatable.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IAnimatable.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IAnimatableColor.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IAnimatableColor.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IAnimatableColor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IAnimation.js":
/*!******************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IAnimation.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IColorAnimation.js":
/*!***********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IColorAnimation.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IColorAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IHslAnimation.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IHslAnimation.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IHslAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IManualParticle.js":
/*!***********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IManualParticle.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IManualParticle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IOptionLoader.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IOptionLoader.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IOptionLoader.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IOptions.js":
/*!****************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IOptions.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IOptionsColor.js":
/*!*********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IOptionsColor.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IOptionsColor.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IResponsive.js":
/*!*******************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IResponsive.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IResponsive.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/IValueWithRandom.js":
/*!************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/IValueWithRandom.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/IValueWithRandom.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IClickEvent.js":
/*!****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IClickEvent.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IClickEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IDivEvent.js":
/*!**************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IDivEvent.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IDivEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IEvents.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IEvents.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IEvents.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IHoverEvent.js":
/*!****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IHoverEvent.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IHoverEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IParallax.js":
/*!**************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IParallax.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IParallax.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IResizeEvent.js":
/*!*****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IResizeEvent.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IResizeEvent.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/IInteractivity.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/IInteractivity.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/IInteractivity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModeDiv.js":
/*!************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModeDiv.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModeDiv.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModes.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModes.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModes.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Bounce/IParticlesBounce.js":
/*!*****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Bounce/IParticlesBounce.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Bounce/IParticlesBounce.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisions.js":
/*!****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisions.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsAbsorb.js":
/*!**********************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsAbsorb.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsAbsorb.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsOverlap.js":
/*!***********************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsOverlap.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsOverlap.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Effect/IEffect.js":
/*!********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Effect/IEffect.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Effect/IEffect.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/IParticlesOptions.js":
/*!***********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/IParticlesOptions.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/IParticlesOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/IShadow.js":
/*!*************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/IShadow.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/IShadow.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/IStroke.js":
/*!*************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/IStroke.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/IStroke.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMove.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMove.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMove.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAngle.js":
/*!*********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAngle.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAngle.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAttract.js":
/*!***********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAttract.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAttract.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveCenter.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveCenter.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveCenter.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveGravity.js":
/*!***********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveGravity.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveGravity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveTrail.js":
/*!*********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveTrail.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveTrail.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/IOutModes.js":
/*!********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/IOutModes.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/IOutModes.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/ISpin.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/ISpin.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/ISpin.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Move/Path/IMovePath.js":
/*!*************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Move/Path/IMovePath.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Move/Path/IMovePath.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesDensity.js":
/*!******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesDensity.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesDensity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumber.js":
/*!*****************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumber.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumber.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumberLimit.js":
/*!**********************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumberLimit.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumberLimit.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacity.js":
/*!**********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacity.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacity.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacityAnimation.js":
/*!*******************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacityAnimation.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacityAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Shape/IShape.js":
/*!******************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Shape/IShape.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Shape/IShape.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Size/ISize.js":
/*!****************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Size/ISize.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Size/ISize.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/Size/ISizeAnimation.js":
/*!*************************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/Size/ISizeAnimation.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/Size/ISizeAnimation.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Particles/ZIndex/IZIndex.js":
/*!********************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Particles/ZIndex/IZIndex.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Particles/ZIndex/IZIndex.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Theme/ITheme.js":
/*!********************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Theme/ITheme.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Theme/ITheme.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Options/Interfaces/Theme/IThemeDefault.js":
/*!***************************************************************************!*\
  !*** ../../engine/dist/browser/Options/Interfaces/Theme/IThemeDefault.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Options/Interfaces/Theme/IThemeDefault.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/CustomEventArgs.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Types/CustomEventArgs.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/CustomEventArgs.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/CustomEventListener.js":
/*!**************************************************************!*\
  !*** ../../engine/dist/browser/Types/CustomEventListener.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/CustomEventListener.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/ExportResult.js":
/*!*******************************************************!*\
  !*** ../../engine/dist/browser/Types/ExportResult.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/ExportResult.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/ISourceOptions.js":
/*!*********************************************************!*\
  !*** ../../engine/dist/browser/Types/ISourceOptions.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/ISourceOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/ParticlesGroups.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Types/ParticlesGroups.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/ParticlesGroups.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/PathOptions.js":
/*!******************************************************!*\
  !*** ../../engine/dist/browser/Types/PathOptions.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/PathOptions.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/RangeType.js":
/*!****************************************************!*\
  !*** ../../engine/dist/browser/Types/RangeType.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RangeType: () => (/* binding */ RangeType)\n/* harmony export */ });\nvar RangeType;\n(function (RangeType) {\n  RangeType[\"circle\"] = \"circle\";\n  RangeType[\"rectangle\"] = \"rectangle\";\n})(RangeType || (RangeType = {}));\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/RangeType.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/RangeValue.js":
/*!*****************************************************!*\
  !*** ../../engine/dist/browser/Types/RangeValue.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/RangeValue.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/RecursivePartial.js":
/*!***********************************************************!*\
  !*** ../../engine/dist/browser/Types/RecursivePartial.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/RecursivePartial.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/ShapeData.js":
/*!****************************************************!*\
  !*** ../../engine/dist/browser/Types/ShapeData.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/ShapeData.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Types/SingleOrMultiple.js":
/*!***********************************************************!*\
  !*** ../../engine/dist/browser/Types/SingleOrMultiple.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Types/SingleOrMultiple.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/CanvasUtils.js":
/*!******************************************************!*\
  !*** ../../engine/dist/browser/Utils/CanvasUtils.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   alterHsl: () => (/* binding */ alterHsl),\n/* harmony export */   clear: () => (/* binding */ clear),\n/* harmony export */   drawEffect: () => (/* binding */ drawEffect),\n/* harmony export */   drawLine: () => (/* binding */ drawLine),\n/* harmony export */   drawParticle: () => (/* binding */ drawParticle),\n/* harmony export */   drawParticlePlugin: () => (/* binding */ drawParticlePlugin),\n/* harmony export */   drawPlugin: () => (/* binding */ drawPlugin),\n/* harmony export */   drawShape: () => (/* binding */ drawShape),\n/* harmony export */   drawShapeAfterDraw: () => (/* binding */ drawShapeAfterDraw),\n/* harmony export */   paintBase: () => (/* binding */ paintBase),\n/* harmony export */   paintImage: () => (/* binding */ paintImage)\n/* harmony export */ });\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Enums_Types_AlterType_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Enums/Types/AlterType.js */ \"../../engine/dist/browser/Enums/Types/AlterType.js\");\n/* harmony import */ var _ColorUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ColorUtils.js */ \"../../engine/dist/browser/Utils/ColorUtils.js\");\n\n\n\nfunction drawLine(context, begin, end) {\n  context.beginPath();\n  context.moveTo(begin.x, begin.y);\n  context.lineTo(end.x, end.y);\n  context.closePath();\n}\nfunction paintBase(context, dimension, baseColor) {\n  context.fillStyle = baseColor ?? \"rgba(0,0,0,0)\";\n  context.fillRect(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, dimension.width, dimension.height);\n}\nfunction paintImage(context, dimension, image, opacity) {\n  if (!image) {\n    return;\n  }\n  context.globalAlpha = opacity;\n  context.drawImage(image, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, dimension.width, dimension.height);\n  context.globalAlpha = 1;\n}\nfunction clear(context, dimension) {\n  context.clearRect(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, dimension.width, dimension.height);\n}\nfunction drawParticle(data) {\n  const {\n      container,\n      context,\n      particle,\n      delta,\n      colorStyles,\n      backgroundMask,\n      composite,\n      radius,\n      opacity,\n      shadow,\n      transform\n    } = data,\n    pos = particle.getPosition(),\n    angle = particle.rotation + (particle.pathRotation ? particle.velocity.angle : _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultAngle),\n    rotateData = {\n      sin: Math.sin(angle),\n      cos: Math.cos(angle)\n    },\n    rotating = !!angle,\n    transformData = {\n      a: rotateData.cos * (transform.a ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransform.a),\n      b: rotating ? rotateData.sin * (transform.b ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.identity) : transform.b ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransform.b,\n      c: rotating ? -rotateData.sin * (transform.c ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.identity) : transform.c ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransform.c,\n      d: rotateData.cos * (transform.d ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransform.d)\n    };\n  context.setTransform(transformData.a, transformData.b, transformData.c, transformData.d, pos.x, pos.y);\n  if (backgroundMask) {\n    context.globalCompositeOperation = composite;\n  }\n  const shadowColor = particle.shadowColor;\n  if (shadow.enable && shadowColor) {\n    context.shadowBlur = shadow.blur;\n    context.shadowColor = (0,_ColorUtils_js__WEBPACK_IMPORTED_MODULE_2__.getStyleFromRgb)(shadowColor);\n    context.shadowOffsetX = shadow.offset.x;\n    context.shadowOffsetY = shadow.offset.y;\n  }\n  if (colorStyles.fill) {\n    context.fillStyle = colorStyles.fill;\n  }\n  const strokeWidth = particle.strokeWidth ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minStrokeWidth;\n  context.lineWidth = strokeWidth;\n  if (colorStyles.stroke) {\n    context.strokeStyle = colorStyles.stroke;\n  }\n  const drawData = {\n    container,\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    transformData,\n    strokeWidth\n  };\n  drawShape(drawData);\n  drawShapeAfterDraw(drawData);\n  drawEffect(drawData);\n  context.globalCompositeOperation = \"source-over\";\n  context.resetTransform();\n}\nfunction drawEffect(data) {\n  const {\n    container,\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    transformData\n  } = data;\n  if (!particle.effect) {\n    return;\n  }\n  const drawer = container.effectDrawers.get(particle.effect);\n  if (!drawer) {\n    return;\n  }\n  drawer.draw({\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    pixelRatio: container.retina.pixelRatio,\n    transformData: {\n      ...transformData\n    }\n  });\n}\nfunction drawShape(data) {\n  const {\n    container,\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    strokeWidth,\n    transformData\n  } = data;\n  if (!particle.shape) {\n    return;\n  }\n  const drawer = container.shapeDrawers.get(particle.shape);\n  if (!drawer) {\n    return;\n  }\n  context.beginPath();\n  drawer.draw({\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    pixelRatio: container.retina.pixelRatio,\n    transformData: {\n      ...transformData\n    }\n  });\n  if (particle.shapeClose) {\n    context.closePath();\n  }\n  if (strokeWidth > _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minStrokeWidth) {\n    context.stroke();\n  }\n  if (particle.shapeFill) {\n    context.fill();\n  }\n}\nfunction drawShapeAfterDraw(data) {\n  const {\n    container,\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    transformData\n  } = data;\n  if (!particle.shape) {\n    return;\n  }\n  const drawer = container.shapeDrawers.get(particle.shape);\n  if (!drawer?.afterDraw) {\n    return;\n  }\n  drawer.afterDraw({\n    context,\n    particle,\n    radius,\n    opacity,\n    delta,\n    pixelRatio: container.retina.pixelRatio,\n    transformData: {\n      ...transformData\n    }\n  });\n}\nfunction drawPlugin(context, plugin, delta) {\n  if (!plugin.draw) {\n    return;\n  }\n  plugin.draw(context, delta);\n}\nfunction drawParticlePlugin(context, plugin, particle, delta) {\n  if (!plugin.drawParticle) {\n    return;\n  }\n  plugin.drawParticle(context, particle, delta);\n}\nfunction alterHsl(color, type, value) {\n  return {\n    h: color.h,\n    s: color.s,\n    l: color.l + (type === _Enums_Types_AlterType_js__WEBPACK_IMPORTED_MODULE_1__.AlterType.darken ? -_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lFactor : _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lFactor) * value\n  };\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/CanvasUtils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/ColorUtils.js":
/*!*****************************************************!*\
  !*** ../../engine/dist/browser/Utils/ColorUtils.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   colorMix: () => (/* binding */ colorMix),\n/* harmony export */   colorToHsl: () => (/* binding */ colorToHsl),\n/* harmony export */   colorToRgb: () => (/* binding */ colorToRgb),\n/* harmony export */   getHslAnimationFromHsl: () => (/* binding */ getHslAnimationFromHsl),\n/* harmony export */   getHslFromAnimation: () => (/* binding */ getHslFromAnimation),\n/* harmony export */   getLinkColor: () => (/* binding */ getLinkColor),\n/* harmony export */   getLinkRandomColor: () => (/* binding */ getLinkRandomColor),\n/* harmony export */   getRandomRgbColor: () => (/* binding */ getRandomRgbColor),\n/* harmony export */   getStyleFromHsl: () => (/* binding */ getStyleFromHsl),\n/* harmony export */   getStyleFromRgb: () => (/* binding */ getStyleFromRgb),\n/* harmony export */   hslToRgb: () => (/* binding */ hslToRgb),\n/* harmony export */   hslaToRgba: () => (/* binding */ hslaToRgba),\n/* harmony export */   rangeColorToHsl: () => (/* binding */ rangeColorToHsl),\n/* harmony export */   rangeColorToRgb: () => (/* binding */ rangeColorToRgb),\n/* harmony export */   rgbToHsl: () => (/* binding */ rgbToHsl),\n/* harmony export */   stringToAlpha: () => (/* binding */ stringToAlpha),\n/* harmony export */   stringToRgb: () => (/* binding */ stringToRgb),\n/* harmony export */   updateColor: () => (/* binding */ updateColor),\n/* harmony export */   updateColorValue: () => (/* binding */ updateColorValue)\n/* harmony export */ });\n/* harmony import */ var _NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Enums/AnimationStatus.js */ \"../../engine/dist/browser/Enums/AnimationStatus.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n\n\n\n\n\nfunction stringToRgba(engine, input) {\n  if (!input) {\n    return;\n  }\n  for (const manager of engine.colorManagers.values()) {\n    if (input.startsWith(manager.stringPrefix)) {\n      return manager.parseString(input);\n    }\n  }\n}\nfunction rangeColorToRgb(engine, input, index, useIndex = true) {\n  if (!input) {\n    return;\n  }\n  const color = (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isString)(input) ? {\n    value: input\n  } : input;\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isString)(color.value)) {\n    return colorToRgb(engine, color.value, index, useIndex);\n  }\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(color.value)) {\n    return rangeColorToRgb(engine, {\n      value: (0,_Utils_js__WEBPACK_IMPORTED_MODULE_4__.itemFromArray)(color.value, index, useIndex)\n    });\n  }\n  for (const manager of engine.colorManagers.values()) {\n    const res = manager.handleRangeColor(color);\n    if (res) {\n      return res;\n    }\n  }\n}\nfunction colorToRgb(engine, input, index, useIndex = true) {\n  if (!input) {\n    return;\n  }\n  const color = (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isString)(input) ? {\n    value: input\n  } : input;\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isString)(color.value)) {\n    return color.value === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.randomColorValue ? getRandomRgbColor() : stringToRgb(engine, color.value);\n  }\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(color.value)) {\n    return colorToRgb(engine, {\n      value: (0,_Utils_js__WEBPACK_IMPORTED_MODULE_4__.itemFromArray)(color.value, index, useIndex)\n    });\n  }\n  for (const manager of engine.colorManagers.values()) {\n    const res = manager.handleColor(color);\n    if (res) {\n      return res;\n    }\n  }\n}\nfunction colorToHsl(engine, color, index, useIndex = true) {\n  const rgb = colorToRgb(engine, color, index, useIndex);\n  return rgb ? rgbToHsl(rgb) : undefined;\n}\nfunction rangeColorToHsl(engine, color, index, useIndex = true) {\n  const rgb = rangeColorToRgb(engine, color, index, useIndex);\n  return rgb ? rgbToHsl(rgb) : undefined;\n}\nfunction rgbToHsl(color) {\n  const r1 = color.r / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbMax,\n    g1 = color.g / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbMax,\n    b1 = color.b / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbMax,\n    max = Math.max(r1, g1, b1),\n    min = Math.min(r1, g1, b1),\n    res = {\n      h: _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMin,\n      l: (max + min) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half,\n      s: _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMin\n    };\n  if (max !== min) {\n    res.s = res.l < _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half ? (max - min) / (max + min) : (max - min) / (_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double - max - min);\n    res.h = r1 === max ? (g1 - b1) / (max - min) : res.h = g1 === max ? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double + (b1 - r1) / (max - min) : _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double + (r1 - g1) / (max - min);\n  }\n  res.l *= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.lMax;\n  res.s *= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMax;\n  res.h *= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hPhase;\n  if (res.h < _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMin) {\n    res.h += _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax;\n  }\n  if (res.h >= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax) {\n    res.h -= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax;\n  }\n  return res;\n}\nfunction stringToAlpha(engine, input) {\n  return stringToRgba(engine, input)?.a;\n}\nfunction stringToRgb(engine, input) {\n  return stringToRgba(engine, input);\n}\nfunction hslToRgb(hsl) {\n  const h = (hsl.h % _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax + _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax) % _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax,\n    s = Math.max(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMin, Math.min(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMax, hsl.s)),\n    l = Math.max(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.lMin, Math.min(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.lMax, hsl.l)),\n    hNormalized = h / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.hMax,\n    sNormalized = s / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMax,\n    lNormalized = l / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.lMax;\n  if (s === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sMin) {\n    const grayscaleValue = Math.round(lNormalized * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor);\n    return {\n      r: grayscaleValue,\n      g: grayscaleValue,\n      b: grayscaleValue\n    };\n  }\n  const channel = (temp1, temp2, temp3) => {\n      const temp3Min = 0,\n        temp3Max = 1;\n      if (temp3 < temp3Min) {\n        temp3++;\n      }\n      if (temp3 > temp3Max) {\n        temp3--;\n      }\n      if (temp3 * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sextuple < temp3Max) {\n        return temp1 + (temp2 - temp1) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sextuple * temp3;\n      }\n      if (temp3 * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double < temp3Max) {\n        return temp2;\n      }\n      if (temp3 * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.triple < temp3Max * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double) {\n        const temp3Offset = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.triple;\n        return temp1 + (temp2 - temp1) * (temp3Offset - temp3) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sextuple;\n      }\n      return temp1;\n    },\n    temp1 = lNormalized < _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half ? lNormalized * (_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.sNormalizedOffset + sNormalized) : lNormalized + sNormalized - lNormalized * sNormalized,\n    temp2 = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double * lNormalized - temp1,\n    phaseThird = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.phaseNumerator / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.triple,\n    red = Math.min(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor * channel(temp2, temp1, hNormalized + phaseThird)),\n    green = Math.min(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor * channel(temp2, temp1, hNormalized)),\n    blue = Math.min(_Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbFactor * channel(temp2, temp1, hNormalized - phaseThird));\n  return {\n    r: Math.round(red),\n    g: Math.round(green),\n    b: Math.round(blue)\n  };\n}\nfunction hslaToRgba(hsla) {\n  const rgbResult = hslToRgb(hsla);\n  return {\n    a: hsla.a,\n    b: rgbResult.b,\n    g: rgbResult.g,\n    r: rgbResult.r\n  };\n}\nfunction getRandomRgbColor(min) {\n  const fixedMin = min ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultRgbMin,\n    fixedMax = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.rgbMax + _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.identity;\n  return {\n    b: Math.floor((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.randomInRange)((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(fixedMin, fixedMax))),\n    g: Math.floor((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.randomInRange)((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(fixedMin, fixedMax))),\n    r: Math.floor((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.randomInRange)((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(fixedMin, fixedMax)))\n  };\n}\nfunction getStyleFromRgb(color, opacity) {\n  return `rgba(${color.r}, ${color.g}, ${color.b}, ${opacity ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultOpacity})`;\n}\nfunction getStyleFromHsl(color, opacity) {\n  return `hsla(${color.h}, ${color.s}%, ${color.l}%, ${opacity ?? _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultOpacity})`;\n}\nfunction colorMix(color1, color2, size1, size2) {\n  let rgb1 = color1,\n    rgb2 = color2;\n  if (rgb1.r === undefined) {\n    rgb1 = hslToRgb(color1);\n  }\n  if (rgb2.r === undefined) {\n    rgb2 = hslToRgb(color2);\n  }\n  return {\n    b: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.mix)(rgb1.b, rgb2.b, size1, size2),\n    g: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.mix)(rgb1.g, rgb2.g, size1, size2),\n    r: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.mix)(rgb1.r, rgb2.r, size1, size2)\n  };\n}\nfunction getLinkColor(p1, p2, linkColor) {\n  if (linkColor === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.randomColorValue) {\n    return getRandomRgbColor();\n  } else if (linkColor === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.midColorValue) {\n    const sourceColor = p1.getFillColor() ?? p1.getStrokeColor(),\n      destColor = p2?.getFillColor() ?? p2?.getStrokeColor();\n    if (sourceColor && destColor && p2) {\n      return colorMix(sourceColor, destColor, p1.getRadius(), p2.getRadius());\n    } else {\n      const hslColor = sourceColor ?? destColor;\n      if (hslColor) {\n        return hslToRgb(hslColor);\n      }\n    }\n  } else {\n    return linkColor;\n  }\n}\nfunction getLinkRandomColor(engine, optColor, blink, consent) {\n  const color = (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isString)(optColor) ? optColor : optColor.value;\n  if (color === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.randomColorValue) {\n    if (consent) {\n      return rangeColorToRgb(engine, {\n        value: color\n      });\n    }\n    if (blink) {\n      return _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.randomColorValue;\n    }\n    return _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.midColorValue;\n  } else if (color === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.midColorValue) {\n    return _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.midColorValue;\n  } else {\n    return rangeColorToRgb(engine, {\n      value: color\n    });\n  }\n}\nfunction getHslFromAnimation(animation) {\n  return animation !== undefined ? {\n    h: animation.h.value,\n    s: animation.s.value,\n    l: animation.l.value\n  } : undefined;\n}\nfunction getHslAnimationFromHsl(hsl, animationOptions, reduceFactor) {\n  const resColor = {\n    h: {\n      enable: false,\n      value: hsl.h\n    },\n    s: {\n      enable: false,\n      value: hsl.s\n    },\n    l: {\n      enable: false,\n      value: hsl.l\n    }\n  };\n  if (animationOptions) {\n    setColorAnimation(resColor.h, animationOptions.h, reduceFactor);\n    setColorAnimation(resColor.s, animationOptions.s, reduceFactor);\n    setColorAnimation(resColor.l, animationOptions.l, reduceFactor);\n  }\n  return resColor;\n}\nfunction setColorAnimation(colorValue, colorAnimation, reduceFactor) {\n  colorValue.enable = colorAnimation.enable;\n  if (colorValue.enable) {\n    colorValue.velocity = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(colorAnimation.speed) / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator * reduceFactor;\n    colorValue.decay = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.decayOffset - (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(colorAnimation.decay);\n    colorValue.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_3__.AnimationStatus.increasing;\n    colorValue.loops = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultLoops;\n    colorValue.maxLoops = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(colorAnimation.count);\n    colorValue.time = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultTime;\n    colorValue.delayTime = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(colorAnimation.delay) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds;\n    if (!colorAnimation.sync) {\n      colorValue.velocity *= (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n      colorValue.value *= (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n    }\n    colorValue.initialValue = colorValue.value;\n    colorValue.offset = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(colorAnimation.offset);\n  } else {\n    colorValue.velocity = _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.defaultVelocity;\n  }\n}\nfunction updateColorValue(data, range, decrease, delta) {\n  const minLoops = 0,\n    minDelay = 0,\n    identity = 1,\n    minVelocity = 0,\n    minOffset = 0,\n    velocityFactor = 3.6;\n  if (!data || !data.enable || (data.maxLoops ?? minLoops) > minLoops && (data.loops ?? minLoops) > (data.maxLoops ?? minLoops)) {\n    return;\n  }\n  if (!data.time) {\n    data.time = 0;\n  }\n  if ((data.delayTime ?? minDelay) > minDelay && data.time < (data.delayTime ?? minDelay)) {\n    data.time += delta.value;\n  }\n  if ((data.delayTime ?? minDelay) > minDelay && data.time < (data.delayTime ?? minDelay)) {\n    return;\n  }\n  const offset = data.offset ? (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(data.offset) : minOffset,\n    velocity = (data.velocity ?? minVelocity) * delta.factor + offset * velocityFactor,\n    decay = data.decay ?? identity,\n    max = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(range),\n    min = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeMin)(range);\n  if (!decrease || data.status === _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_3__.AnimationStatus.increasing) {\n    data.value += velocity;\n    if (data.value > max) {\n      if (!data.loops) {\n        data.loops = 0;\n      }\n      data.loops++;\n      if (decrease) {\n        data.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_3__.AnimationStatus.decreasing;\n      } else {\n        data.value -= max;\n      }\n    }\n  } else {\n    data.value -= velocity;\n    const minValue = 0;\n    if (data.value < minValue) {\n      if (!data.loops) {\n        data.loops = 0;\n      }\n      data.loops++;\n      data.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_3__.AnimationStatus.increasing;\n    }\n  }\n  if (data.velocity && decay !== identity) {\n    data.velocity *= decay;\n  }\n  data.value = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.clamp)(data.value, min, max);\n}\nfunction updateColor(color, delta) {\n  if (!color) {\n    return;\n  }\n  const {\n      h,\n      s,\n      l\n    } = color,\n    ranges = {\n      h: {\n        min: 0,\n        max: 360\n      },\n      s: {\n        min: 0,\n        max: 100\n      },\n      l: {\n        min: 0,\n        max: 100\n      }\n    };\n  if (h) {\n    updateColorValue(h, ranges.h, false, delta);\n  }\n  if (s) {\n    updateColorValue(s, ranges.s, true, delta);\n  }\n  if (l) {\n    updateColorValue(l, ranges.l, true, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/ColorUtils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/EventDispatcher.js":
/*!**********************************************************!*\
  !*** ../../engine/dist/browser/Utils/EventDispatcher.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EventDispatcher: () => (/* binding */ EventDispatcher)\n/* harmony export */ });\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n\nclass EventDispatcher {\n  constructor() {\n    this._listeners = new Map();\n  }\n  addEventListener(type, listener) {\n    this.removeEventListener(type, listener);\n    let arr = this._listeners.get(type);\n    if (!arr) {\n      arr = [];\n      this._listeners.set(type, arr);\n    }\n    arr.push(listener);\n  }\n  dispatchEvent(type, args) {\n    const listeners = this._listeners.get(type);\n    listeners?.forEach(handler => handler(args));\n  }\n  hasEventListener(type) {\n    return !!this._listeners.get(type);\n  }\n  removeAllEventListeners(type) {\n    if (!type) {\n      this._listeners = new Map();\n    } else {\n      this._listeners.delete(type);\n    }\n  }\n  removeEventListener(type, listener) {\n    const arr = this._listeners.get(type);\n    if (!arr) {\n      return;\n    }\n    const length = arr.length,\n      idx = arr.indexOf(listener);\n    if (idx < _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minIndex) {\n      return;\n    }\n    if (length === _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.deleteCount) {\n      this._listeners.delete(type);\n    } else {\n      arr.splice(idx, _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.deleteCount);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/EventDispatcher.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/NumberUtils.js":
/*!******************************************************!*\
  !*** ../../engine/dist/browser/Utils/NumberUtils.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   animate: () => (/* binding */ animate),\n/* harmony export */   calcExactPositionOrRandomFromSize: () => (/* binding */ calcExactPositionOrRandomFromSize),\n/* harmony export */   calcExactPositionOrRandomFromSizeRanged: () => (/* binding */ calcExactPositionOrRandomFromSizeRanged),\n/* harmony export */   calcPositionFromSize: () => (/* binding */ calcPositionFromSize),\n/* harmony export */   calcPositionOrRandomFromSize: () => (/* binding */ calcPositionOrRandomFromSize),\n/* harmony export */   calcPositionOrRandomFromSizeRanged: () => (/* binding */ calcPositionOrRandomFromSizeRanged),\n/* harmony export */   cancelAnimation: () => (/* binding */ cancelAnimation),\n/* harmony export */   clamp: () => (/* binding */ clamp),\n/* harmony export */   collisionVelocity: () => (/* binding */ collisionVelocity),\n/* harmony export */   degToRad: () => (/* binding */ degToRad),\n/* harmony export */   getDistance: () => (/* binding */ getDistance),\n/* harmony export */   getDistances: () => (/* binding */ getDistances),\n/* harmony export */   getParticleBaseVelocity: () => (/* binding */ getParticleBaseVelocity),\n/* harmony export */   getParticleDirectionAngle: () => (/* binding */ getParticleDirectionAngle),\n/* harmony export */   getRandom: () => (/* binding */ getRandom),\n/* harmony export */   getRangeMax: () => (/* binding */ getRangeMax),\n/* harmony export */   getRangeMin: () => (/* binding */ getRangeMin),\n/* harmony export */   getRangeValue: () => (/* binding */ getRangeValue),\n/* harmony export */   mix: () => (/* binding */ mix),\n/* harmony export */   parseAlpha: () => (/* binding */ parseAlpha),\n/* harmony export */   randomInRange: () => (/* binding */ randomInRange),\n/* harmony export */   setAnimationFunctions: () => (/* binding */ setAnimationFunctions),\n/* harmony export */   setRandom: () => (/* binding */ setRandom),\n/* harmony export */   setRangeValue: () => (/* binding */ setRangeValue)\n/* harmony export */ });\n/* harmony import */ var _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Enums/Directions/MoveDirection.js */ \"../../engine/dist/browser/Enums/Directions/MoveDirection.js\");\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Core/Utils/Vectors.js */ \"../../engine/dist/browser/Core/Utils/Vectors.js\");\n/* harmony import */ var _TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\nlet _random = Math.random;\nconst _animationLoop = {\n  nextFrame: cb => requestAnimationFrame(cb),\n  cancel: idx => cancelAnimationFrame(idx)\n};\nfunction setRandom(rnd = Math.random) {\n  _random = rnd;\n}\nfunction getRandom() {\n  const min = 0,\n    max = 1;\n  return clamp(_random(), min, max - Number.EPSILON);\n}\nfunction setAnimationFunctions(nextFrame, cancel) {\n  _animationLoop.nextFrame = callback => nextFrame(callback);\n  _animationLoop.cancel = handle => cancel(handle);\n}\nfunction animate(fn) {\n  return _animationLoop.nextFrame(fn);\n}\nfunction cancelAnimation(handle) {\n  _animationLoop.cancel(handle);\n}\nfunction clamp(num, min, max) {\n  return Math.min(Math.max(num, min), max);\n}\nfunction mix(comp1, comp2, weight1, weight2) {\n  return Math.floor((comp1 * weight1 + comp2 * weight2) / (weight1 + weight2));\n}\nfunction randomInRange(r) {\n  const max = getRangeMax(r),\n    minOffset = 0;\n  let min = getRangeMin(r);\n  if (max === min) {\n    min = minOffset;\n  }\n  return getRandom() * (max - min) + min;\n}\nfunction getRangeValue(value) {\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(value) ? value : randomInRange(value);\n}\nfunction getRangeMin(value) {\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(value) ? value : value.min;\n}\nfunction getRangeMax(value) {\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(value) ? value : value.max;\n}\nfunction setRangeValue(source, value) {\n  if (source === value || value === undefined && (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(source)) {\n    return source;\n  }\n  const min = getRangeMin(source),\n    max = getRangeMax(source);\n  return value !== undefined ? {\n    min: Math.min(min, value),\n    max: Math.max(max, value)\n  } : setRangeValue(min, max);\n}\nfunction getDistances(pointA, pointB) {\n  const dx = pointA.x - pointB.x,\n    dy = pointA.y - pointB.y,\n    squareExp = 2;\n  return {\n    dx: dx,\n    dy: dy,\n    distance: Math.sqrt(dx ** squareExp + dy ** squareExp)\n  };\n}\nfunction getDistance(pointA, pointB) {\n  return getDistances(pointA, pointB).distance;\n}\nfunction degToRad(degrees) {\n  const PIDeg = 180;\n  return degrees * Math.PI / PIDeg;\n}\nfunction getParticleDirectionAngle(direction, position, center) {\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(direction)) {\n    return degToRad(direction);\n  }\n  switch (direction) {\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.top:\n      return -Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.topRight:\n      return -Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.quarter;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.right:\n      return _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.empty;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.bottomRight:\n      return Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.quarter;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.bottom:\n      return Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.bottomLeft:\n      return Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.threeQuarter;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.left:\n      return Math.PI;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.topLeft:\n      return -Math.PI * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.threeQuarter;\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.inside:\n      return Math.atan2(center.y - position.y, center.x - position.x);\n    case _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_0__.MoveDirection.outside:\n      return Math.atan2(position.y - center.y, position.x - center.x);\n    default:\n      return getRandom() * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.doublePI;\n  }\n}\nfunction getParticleBaseVelocity(direction) {\n  const baseVelocity = _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_2__.Vector.origin;\n  baseVelocity.length = 1;\n  baseVelocity.angle = direction;\n  return baseVelocity;\n}\nfunction collisionVelocity(v1, v2, m1, m2) {\n  return _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_2__.Vector.create(v1.x * (m1 - m2) / (m1 + m2) + v2.x * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.double * m2 / (m1 + m2), v1.y);\n}\nfunction calcPositionFromSize(data) {\n  return data.position?.x !== undefined && data.position.y !== undefined ? {\n    x: data.position.x * data.size.width / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator,\n    y: data.position.y * data.size.height / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator\n  } : undefined;\n}\nfunction calcPositionOrRandomFromSize(data) {\n  return {\n    x: (data.position?.x ?? getRandom() * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator) * data.size.width / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator,\n    y: (data.position?.y ?? getRandom() * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator) * data.size.height / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator\n  };\n}\nfunction calcPositionOrRandomFromSizeRanged(data) {\n  const position = {\n    x: data.position?.x !== undefined ? getRangeValue(data.position.x) : undefined,\n    y: data.position?.y !== undefined ? getRangeValue(data.position.y) : undefined\n  };\n  return calcPositionOrRandomFromSize({\n    size: data.size,\n    position\n  });\n}\nfunction calcExactPositionOrRandomFromSize(data) {\n  return {\n    x: data.position?.x ?? getRandom() * data.size.width,\n    y: data.position?.y ?? getRandom() * data.size.height\n  };\n}\nfunction calcExactPositionOrRandomFromSizeRanged(data) {\n  const position = {\n    x: data.position?.x !== undefined ? getRangeValue(data.position.x) : undefined,\n    y: data.position?.y !== undefined ? getRangeValue(data.position.y) : undefined\n  };\n  return calcExactPositionOrRandomFromSize({\n    size: data.size,\n    position\n  });\n}\nfunction parseAlpha(input) {\n  const defaultAlpha = 1;\n  if (!input) {\n    return defaultAlpha;\n  }\n  return input.endsWith(\"%\") ? parseFloat(input) / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator : parseFloat(input);\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/NumberUtils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/OptionsUtils.js":
/*!*******************************************************!*\
  !*** ../../engine/dist/browser/Utils/OptionsUtils.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadOptions: () => (/* binding */ loadOptions),\n/* harmony export */   loadParticlesOptions: () => (/* binding */ loadParticlesOptions)\n/* harmony export */ });\n/* harmony import */ var _Options_Classes_Particles_ParticlesOptions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Options/Classes/Particles/ParticlesOptions.js */ \"../../engine/dist/browser/Options/Classes/Particles/ParticlesOptions.js\");\n\nfunction loadOptions(options, ...sourceOptionsArr) {\n  for (const sourceOptions of sourceOptionsArr) {\n    options.load(sourceOptions);\n  }\n}\nfunction loadParticlesOptions(engine, container, ...sourceOptionsArr) {\n  const options = new _Options_Classes_Particles_ParticlesOptions_js__WEBPACK_IMPORTED_MODULE_0__.ParticlesOptions(engine, container);\n  loadOptions(options, ...sourceOptionsArr);\n  return options;\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/OptionsUtils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/TypeUtils.js":
/*!****************************************************!*\
  !*** ../../engine/dist/browser/Utils/TypeUtils.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   isArray: () => (/* binding */ isArray),\n/* harmony export */   isBoolean: () => (/* binding */ isBoolean),\n/* harmony export */   isFunction: () => (/* binding */ isFunction),\n/* harmony export */   isNull: () => (/* binding */ isNull),\n/* harmony export */   isNumber: () => (/* binding */ isNumber),\n/* harmony export */   isObject: () => (/* binding */ isObject),\n/* harmony export */   isString: () => (/* binding */ isString)\n/* harmony export */ });\nfunction isBoolean(arg) {\n  return typeof arg === \"boolean\";\n}\nfunction isString(arg) {\n  return typeof arg === \"string\";\n}\nfunction isNumber(arg) {\n  return typeof arg === \"number\";\n}\nfunction isFunction(arg) {\n  return typeof arg === \"function\";\n}\nfunction isObject(arg) {\n  return typeof arg === \"object\" && arg !== null;\n}\nfunction isArray(arg) {\n  return Array.isArray(arg);\n}\nfunction isNull(arg) {\n  return arg === null || arg === undefined;\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/TypeUtils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/Utils/Utils.js":
/*!************************************************!*\
  !*** ../../engine/dist/browser/Utils/Utils.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   areBoundsInside: () => (/* binding */ areBoundsInside),\n/* harmony export */   arrayRandomIndex: () => (/* binding */ arrayRandomIndex),\n/* harmony export */   calculateBounds: () => (/* binding */ calculateBounds),\n/* harmony export */   circleBounce: () => (/* binding */ circleBounce),\n/* harmony export */   circleBounceDataFromParticle: () => (/* binding */ circleBounceDataFromParticle),\n/* harmony export */   cloneStyle: () => (/* binding */ cloneStyle),\n/* harmony export */   deepExtend: () => (/* binding */ deepExtend),\n/* harmony export */   divMode: () => (/* binding */ divMode),\n/* harmony export */   divModeExecute: () => (/* binding */ divModeExecute),\n/* harmony export */   executeOnSingleOrMultiple: () => (/* binding */ executeOnSingleOrMultiple),\n/* harmony export */   findItemFromSingleOrMultiple: () => (/* binding */ findItemFromSingleOrMultiple),\n/* harmony export */   getFullScreenStyle: () => (/* binding */ getFullScreenStyle),\n/* harmony export */   getLogger: () => (/* binding */ getLogger),\n/* harmony export */   getPosition: () => (/* binding */ getPosition),\n/* harmony export */   getSize: () => (/* binding */ getSize),\n/* harmony export */   hasMatchMedia: () => (/* binding */ hasMatchMedia),\n/* harmony export */   initParticleNumericAnimationValue: () => (/* binding */ initParticleNumericAnimationValue),\n/* harmony export */   isDivModeEnabled: () => (/* binding */ isDivModeEnabled),\n/* harmony export */   isInArray: () => (/* binding */ isInArray),\n/* harmony export */   isPointInside: () => (/* binding */ isPointInside),\n/* harmony export */   isSsr: () => (/* binding */ isSsr),\n/* harmony export */   itemFromArray: () => (/* binding */ itemFromArray),\n/* harmony export */   itemFromSingleOrMultiple: () => (/* binding */ itemFromSingleOrMultiple),\n/* harmony export */   loadFont: () => (/* binding */ loadFont),\n/* harmony export */   rectBounce: () => (/* binding */ rectBounce),\n/* harmony export */   safeIntersectionObserver: () => (/* binding */ safeIntersectionObserver),\n/* harmony export */   safeMatchMedia: () => (/* binding */ safeMatchMedia),\n/* harmony export */   safeMutationObserver: () => (/* binding */ safeMutationObserver),\n/* harmony export */   setLogger: () => (/* binding */ setLogger),\n/* harmony export */   singleDivModeExecute: () => (/* binding */ singleDivModeExecute),\n/* harmony export */   updateAnimation: () => (/* binding */ updateAnimation)\n/* harmony export */ });\n/* harmony import */ var _NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n/* harmony import */ var _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Enums/Modes/AnimationMode.js */ \"../../engine/dist/browser/Enums/Modes/AnimationMode.js\");\n/* harmony import */ var _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Enums/AnimationStatus.js */ \"../../engine/dist/browser/Enums/AnimationStatus.js\");\n/* harmony import */ var _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Enums/Types/DestroyType.js */ \"../../engine/dist/browser/Enums/Types/DestroyType.js\");\n/* harmony import */ var _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Enums/Directions/OutModeDirection.js */ \"../../engine/dist/browser/Enums/Directions/OutModeDirection.js\");\n/* harmony import */ var _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Enums/Modes/PixelMode.js */ \"../../engine/dist/browser/Enums/Modes/PixelMode.js\");\n/* harmony import */ var _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Enums/Types/StartValueType.js */ \"../../engine/dist/browser/Enums/Types/StartValueType.js\");\n/* harmony import */ var _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Core/Utils/Vectors.js */ \"../../engine/dist/browser/Core/Utils/Vectors.js\");\n\n\n\n\n\n\n\n\n\n\nconst _logger = {\n  debug: console.debug,\n  error: console.error,\n  info: console.info,\n  log: console.log,\n  verbose: console.log,\n  warning: console.warn\n};\nfunction setLogger(logger) {\n  _logger.debug = logger.debug || _logger.debug;\n  _logger.error = logger.error || _logger.error;\n  _logger.info = logger.info || _logger.info;\n  _logger.log = logger.log || _logger.log;\n  _logger.verbose = logger.verbose || _logger.verbose;\n  _logger.warning = logger.warning || _logger.warning;\n}\nfunction getLogger() {\n  return _logger;\n}\nfunction memoize(fn) {\n  const cache = new Map();\n  return (...args) => {\n    const key = JSON.stringify(args);\n    if (cache.has(key)) {\n      return cache.get(key);\n    }\n    const result = fn(...args);\n    cache.set(key, result);\n    return result;\n  };\n}\nfunction rectSideBounce(data) {\n  const res = {\n      bounced: false\n    },\n    {\n      pSide,\n      pOtherSide,\n      rectSide,\n      rectOtherSide,\n      velocity,\n      factor\n    } = data;\n  if (pOtherSide.min < rectOtherSide.min || pOtherSide.min > rectOtherSide.max || pOtherSide.max < rectOtherSide.min || pOtherSide.max > rectOtherSide.max) {\n    return res;\n  }\n  if (pSide.max >= rectSide.min && pSide.max <= (rectSide.max + rectSide.min) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half && velocity > _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.minVelocity || pSide.min <= rectSide.max && pSide.min > (rectSide.max + rectSide.min) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half && velocity < _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.minVelocity) {\n    res.velocity = velocity * -factor;\n    res.bounced = true;\n  }\n  return res;\n}\nfunction checkSelector(element, selectors) {\n  const res = executeOnSingleOrMultiple(selectors, selector => {\n    return element.matches(selector);\n  });\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(res) ? res.some(t => t) : res;\n}\nfunction isSsr() {\n  return typeof window === \"undefined\" || !window || typeof window.document === \"undefined\" || !window.document;\n}\nfunction hasMatchMedia() {\n  return !isSsr() && typeof matchMedia !== \"undefined\";\n}\nfunction safeMatchMedia(query) {\n  if (!hasMatchMedia()) {\n    return;\n  }\n  return matchMedia(query);\n}\nfunction safeIntersectionObserver(callback) {\n  if (isSsr() || typeof IntersectionObserver === \"undefined\") {\n    return;\n  }\n  return new IntersectionObserver(callback);\n}\nfunction safeMutationObserver(callback) {\n  if (isSsr() || typeof MutationObserver === \"undefined\") {\n    return;\n  }\n  return new MutationObserver(callback);\n}\nfunction isInArray(value, array) {\n  const invalidIndex = -1;\n  return value === array || (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(array) && array.indexOf(value) > invalidIndex;\n}\nasync function loadFont(font, weight) {\n  try {\n    await document.fonts.load(`${weight ?? \"400\"} 36px '${font ?? \"Verdana\"}'`);\n  } catch {}\n}\nfunction arrayRandomIndex(array) {\n  return Math.floor((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * array.length);\n}\nfunction itemFromArray(array, index, useIndex = true) {\n  return array[index !== undefined && useIndex ? index % array.length : arrayRandomIndex(array)];\n}\nfunction isPointInside(point, size, offset, radius, direction) {\n  const minRadius = 0;\n  return areBoundsInside(calculateBounds(point, radius ?? minRadius), size, offset, direction);\n}\nfunction areBoundsInside(bounds, size, offset, direction) {\n  let inside = true;\n  if (!direction || direction === _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_6__.OutModeDirection.bottom) {\n    inside = bounds.top < size.height + offset.x;\n  }\n  if (inside && (!direction || direction === _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_6__.OutModeDirection.left)) {\n    inside = bounds.right > offset.x;\n  }\n  if (inside && (!direction || direction === _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_6__.OutModeDirection.right)) {\n    inside = bounds.left < size.width + offset.y;\n  }\n  if (inside && (!direction || direction === _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_6__.OutModeDirection.top)) {\n    inside = bounds.bottom > offset.y;\n  }\n  return inside;\n}\nfunction calculateBounds(point, radius) {\n  return {\n    bottom: point.y + radius,\n    left: point.x - radius,\n    right: point.x + radius,\n    top: point.y - radius\n  };\n}\nfunction deepExtend(destination, ...sources) {\n  for (const source of sources) {\n    if (source === undefined || source === null) {\n      continue;\n    }\n    if (!(0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(source)) {\n      destination = source;\n      continue;\n    }\n    const sourceIsArray = Array.isArray(source);\n    if (sourceIsArray && ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(destination) || !destination || !Array.isArray(destination))) {\n      destination = [];\n    } else if (!sourceIsArray && ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(destination) || !destination || Array.isArray(destination))) {\n      destination = {};\n    }\n    for (const key in source) {\n      if (key === \"__proto__\") {\n        continue;\n      }\n      const sourceDict = source,\n        value = sourceDict[key],\n        destDict = destination;\n      destDict[key] = (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(value) && Array.isArray(value) ? value.map(v => deepExtend(destDict[key], v)) : deepExtend(destDict[key], value);\n    }\n  }\n  return destination;\n}\nfunction isDivModeEnabled(mode, divs) {\n  return !!findItemFromSingleOrMultiple(divs, t => t.enable && isInArray(mode, t.mode));\n}\nfunction divModeExecute(mode, divs, callback) {\n  executeOnSingleOrMultiple(divs, div => {\n    const divMode = div.mode,\n      divEnabled = div.enable;\n    if (divEnabled && isInArray(mode, divMode)) {\n      singleDivModeExecute(div, callback);\n    }\n  });\n}\nfunction singleDivModeExecute(div, callback) {\n  const selectors = div.selectors;\n  executeOnSingleOrMultiple(selectors, selector => {\n    callback(selector, div);\n  });\n}\nfunction divMode(divs, element) {\n  if (!element || !divs) {\n    return;\n  }\n  return findItemFromSingleOrMultiple(divs, div => {\n    return checkSelector(element, div.selectors);\n  });\n}\nfunction circleBounceDataFromParticle(p) {\n  return {\n    position: p.getPosition(),\n    radius: p.getRadius(),\n    mass: p.getMass(),\n    velocity: p.velocity,\n    factor: _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_9__.Vector.create((0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(p.options.bounce.horizontal.value), (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(p.options.bounce.vertical.value))\n  };\n}\nfunction circleBounce(p1, p2) {\n  const {\n      x: xVelocityDiff,\n      y: yVelocityDiff\n    } = p1.velocity.sub(p2.velocity),\n    [pos1, pos2] = [p1.position, p2.position],\n    {\n      dx: xDist,\n      dy: yDist\n    } = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getDistances)(pos2, pos1),\n    minimumDistance = 0;\n  if (xVelocityDiff * xDist + yVelocityDiff * yDist < minimumDistance) {\n    return;\n  }\n  const angle = -Math.atan2(yDist, xDist),\n    m1 = p1.mass,\n    m2 = p2.mass,\n    u1 = p1.velocity.rotate(angle),\n    u2 = p2.velocity.rotate(angle),\n    v1 = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.collisionVelocity)(u1, u2, m1, m2),\n    v2 = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.collisionVelocity)(u2, u1, m1, m2),\n    vFinal1 = v1.rotate(-angle),\n    vFinal2 = v2.rotate(-angle);\n  p1.velocity.x = vFinal1.x * p1.factor.x;\n  p1.velocity.y = vFinal1.y * p1.factor.y;\n  p2.velocity.x = vFinal2.x * p2.factor.x;\n  p2.velocity.y = vFinal2.y * p2.factor.y;\n}\nfunction rectBounce(particle, divBounds) {\n  const pPos = particle.getPosition(),\n    size = particle.getRadius(),\n    bounds = calculateBounds(pPos, size),\n    bounceOptions = particle.options.bounce,\n    resH = rectSideBounce({\n      pSide: {\n        min: bounds.left,\n        max: bounds.right\n      },\n      pOtherSide: {\n        min: bounds.top,\n        max: bounds.bottom\n      },\n      rectSide: {\n        min: divBounds.left,\n        max: divBounds.right\n      },\n      rectOtherSide: {\n        min: divBounds.top,\n        max: divBounds.bottom\n      },\n      velocity: particle.velocity.x,\n      factor: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(bounceOptions.horizontal.value)\n    });\n  if (resH.bounced) {\n    if (resH.velocity !== undefined) {\n      particle.velocity.x = resH.velocity;\n    }\n    if (resH.position !== undefined) {\n      particle.position.x = resH.position;\n    }\n  }\n  const resV = rectSideBounce({\n    pSide: {\n      min: bounds.top,\n      max: bounds.bottom\n    },\n    pOtherSide: {\n      min: bounds.left,\n      max: bounds.right\n    },\n    rectSide: {\n      min: divBounds.top,\n      max: divBounds.bottom\n    },\n    rectOtherSide: {\n      min: divBounds.left,\n      max: divBounds.right\n    },\n    velocity: particle.velocity.y,\n    factor: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(bounceOptions.vertical.value)\n  });\n  if (resV.bounced) {\n    if (resV.velocity !== undefined) {\n      particle.velocity.y = resV.velocity;\n    }\n    if (resV.position !== undefined) {\n      particle.position.y = resV.position;\n    }\n  }\n}\nfunction executeOnSingleOrMultiple(obj, callback) {\n  const defaultIndex = 0;\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(obj) ? obj.map((item, index) => callback(item, index)) : callback(obj, defaultIndex);\n}\nfunction itemFromSingleOrMultiple(obj, index, useIndex) {\n  return (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(obj) ? itemFromArray(obj, index, useIndex) : obj;\n}\nfunction findItemFromSingleOrMultiple(obj, callback) {\n  if ((0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(obj)) {\n    return obj.find((t, index) => callback(t, index));\n  }\n  const defaultIndex = 0;\n  return callback(obj, defaultIndex) ? obj : undefined;\n}\nfunction initParticleNumericAnimationValue(options, pxRatio) {\n  const valueRange = options.value,\n    animationOptions = options.animation,\n    res = {\n      delayTime: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(animationOptions.delay) * _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.millisecondsToSeconds,\n      enable: animationOptions.enable,\n      value: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(options.value) * pxRatio,\n      max: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(valueRange) * pxRatio,\n      min: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeMin)(valueRange) * pxRatio,\n      loops: 0,\n      maxLoops: (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(animationOptions.count),\n      time: 0\n    },\n    decayOffset = 1;\n  if (animationOptions.enable) {\n    res.decay = decayOffset - (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(animationOptions.decay);\n    switch (animationOptions.mode) {\n      case _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_3__.AnimationMode.increase:\n        res.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing;\n        break;\n      case _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_3__.AnimationMode.decrease:\n        res.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing;\n        break;\n      case _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_3__.AnimationMode.random:\n        res.status = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRandom)() >= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half ? _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing : _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing;\n        break;\n    }\n    const autoStatus = animationOptions.mode === _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_3__.AnimationMode.auto;\n    switch (animationOptions.startValue) {\n      case _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_8__.StartValueType.min:\n        res.value = res.min;\n        if (autoStatus) {\n          res.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing;\n        }\n        break;\n      case _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_8__.StartValueType.max:\n        res.value = res.max;\n        if (autoStatus) {\n          res.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing;\n        }\n        break;\n      case _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_8__.StartValueType.random:\n      default:\n        res.value = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(res);\n        if (autoStatus) {\n          res.status = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.getRandom)() >= _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.half ? _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing : _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing;\n        }\n        break;\n    }\n  }\n  res.initialValue = res.value;\n  return res;\n}\nfunction getPositionOrSize(positionOrSize, canvasSize) {\n  const isPercent = positionOrSize.mode === _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_7__.PixelMode.percent;\n  if (!isPercent) {\n    const {\n      mode: _,\n      ...rest\n    } = positionOrSize;\n    return rest;\n  }\n  const isPosition = \"x\" in positionOrSize;\n  if (isPosition) {\n    return {\n      x: positionOrSize.x / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator * canvasSize.width,\n      y: positionOrSize.y / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator * canvasSize.height\n    };\n  } else {\n    return {\n      width: positionOrSize.width / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator * canvasSize.width,\n      height: positionOrSize.height / _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_1__.percentDenominator * canvasSize.height\n    };\n  }\n}\nfunction getPosition(position, canvasSize) {\n  return getPositionOrSize(position, canvasSize);\n}\nfunction getSize(size, canvasSize) {\n  return getPositionOrSize(size, canvasSize);\n}\nfunction checkDestroy(particle, destroyType, value, minValue, maxValue) {\n  switch (destroyType) {\n    case _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_5__.DestroyType.max:\n      if (value >= maxValue) {\n        particle.destroy();\n      }\n      break;\n    case _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_5__.DestroyType.min:\n      if (value <= minValue) {\n        particle.destroy();\n      }\n      break;\n  }\n}\nfunction updateAnimation(particle, data, changeDirection, destroyType, delta) {\n  const minLoops = 0,\n    minDelay = 0,\n    identity = 1,\n    minVelocity = 0,\n    minDecay = 1;\n  if (particle.destroyed || !data || !data.enable || (data.maxLoops ?? minLoops) > minLoops && (data.loops ?? minLoops) > (data.maxLoops ?? minLoops)) {\n    return;\n  }\n  const velocity = (data.velocity ?? minVelocity) * delta.factor,\n    minValue = data.min,\n    maxValue = data.max,\n    decay = data.decay ?? minDecay;\n  if (!data.time) {\n    data.time = 0;\n  }\n  if ((data.delayTime ?? minDelay) > minDelay && data.time < (data.delayTime ?? minDelay)) {\n    data.time += delta.value;\n  }\n  if ((data.delayTime ?? minDelay) > minDelay && data.time < (data.delayTime ?? minDelay)) {\n    return;\n  }\n  switch (data.status) {\n    case _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing:\n      if (data.value >= maxValue) {\n        if (changeDirection) {\n          data.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing;\n        } else {\n          data.value -= maxValue;\n        }\n        if (!data.loops) {\n          data.loops = minLoops;\n        }\n        data.loops++;\n      } else {\n        data.value += velocity;\n      }\n      break;\n    case _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.decreasing:\n      if (data.value <= minValue) {\n        if (changeDirection) {\n          data.status = _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_4__.AnimationStatus.increasing;\n        } else {\n          data.value += maxValue;\n        }\n        if (!data.loops) {\n          data.loops = minLoops;\n        }\n        data.loops++;\n      } else {\n        data.value -= velocity;\n      }\n  }\n  if (data.velocity && decay !== identity) {\n    data.velocity *= decay;\n  }\n  checkDestroy(particle, destroyType, data.value, minValue, maxValue);\n  if (!particle.destroyed) {\n    data.value = (0,_NumberUtils_js__WEBPACK_IMPORTED_MODULE_0__.clamp)(data.value, minValue, maxValue);\n  }\n}\nfunction cloneStyle(style) {\n  const clonedStyle = document.createElement(\"div\").style;\n  if (!style) {\n    return clonedStyle;\n  }\n  for (const key in style) {\n    const styleKey = style[key];\n    if (!Object.prototype.hasOwnProperty.call(style, key) || (0,_TypeUtils_js__WEBPACK_IMPORTED_MODULE_2__.isNull)(styleKey)) {\n      continue;\n    }\n    const styleValue = style.getPropertyValue?.(styleKey);\n    if (!styleValue) {\n      continue;\n    }\n    const stylePriority = style.getPropertyPriority?.(styleKey);\n    if (!stylePriority) {\n      clonedStyle.setProperty?.(styleKey, styleValue);\n    } else {\n      clonedStyle.setProperty?.(styleKey, styleValue, stylePriority);\n    }\n  }\n  return clonedStyle;\n}\nfunction computeFullScreenStyle(zIndex) {\n  const fullScreenStyle = document.createElement(\"div\").style,\n    radix = 10,\n    style = {\n      width: \"100%\",\n      height: \"100%\",\n      margin: \"0\",\n      padding: \"0\",\n      borderWidth: \"0\",\n      position: \"fixed\",\n      zIndex: zIndex.toString(radix),\n      \"z-index\": zIndex.toString(radix),\n      top: \"0\",\n      left: \"0\"\n    };\n  for (const key in style) {\n    const value = style[key];\n    fullScreenStyle.setProperty(key, value);\n  }\n  return fullScreenStyle;\n}\nconst getFullScreenStyle = memoize(computeFullScreenStyle);\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/Utils/Utils.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/export-types.js":
/*!*************************************************!*\
  !*** ../../engine/dist/browser/export-types.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Core_Interfaces_Colors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Core/Interfaces/Colors.js */ \"../../engine/dist/browser/Core/Interfaces/Colors.js\");\n/* harmony import */ var _Core_Interfaces_IBounds_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Core/Interfaces/IBounds.js */ \"../../engine/dist/browser/Core/Interfaces/IBounds.js\");\n/* harmony import */ var _Core_Interfaces_IBubbleParticleData_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Core/Interfaces/IBubbleParticleData.js */ \"../../engine/dist/browser/Core/Interfaces/IBubbleParticleData.js\");\n/* harmony import */ var _Core_Interfaces_ICircleBouncer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Core/Interfaces/ICircleBouncer.js */ \"../../engine/dist/browser/Core/Interfaces/ICircleBouncer.js\");\n/* harmony import */ var _Core_Interfaces_IColorManager_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Core/Interfaces/IColorManager.js */ \"../../engine/dist/browser/Core/Interfaces/IColorManager.js\");\n/* harmony import */ var _Core_Interfaces_IContainerInteractivity_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Core/Interfaces/IContainerInteractivity.js */ \"../../engine/dist/browser/Core/Interfaces/IContainerInteractivity.js\");\n/* harmony import */ var _Core_Interfaces_IContainerPlugin_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Core/Interfaces/IContainerPlugin.js */ \"../../engine/dist/browser/Core/Interfaces/IContainerPlugin.js\");\n/* harmony import */ var _Core_Interfaces_ICoordinates_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Core/Interfaces/ICoordinates.js */ \"../../engine/dist/browser/Core/Interfaces/ICoordinates.js\");\n/* harmony import */ var _Core_Interfaces_IDelta_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Core/Interfaces/IDelta.js */ \"../../engine/dist/browser/Core/Interfaces/IDelta.js\");\n/* harmony import */ var _Core_Interfaces_IDimension_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Core/Interfaces/IDimension.js */ \"../../engine/dist/browser/Core/Interfaces/IDimension.js\");\n/* harmony import */ var _Core_Interfaces_IDistance_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Core/Interfaces/IDistance.js */ \"../../engine/dist/browser/Core/Interfaces/IDistance.js\");\n/* harmony import */ var _Core_Interfaces_IDrawParticleParams_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Core/Interfaces/IDrawParticleParams.js */ \"../../engine/dist/browser/Core/Interfaces/IDrawParticleParams.js\");\n/* harmony import */ var _Core_Interfaces_IEffectDrawer_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Core/Interfaces/IEffectDrawer.js */ \"../../engine/dist/browser/Core/Interfaces/IEffectDrawer.js\");\n/* harmony import */ var _Core_Interfaces_IExternalInteractor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Core/Interfaces/IExternalInteractor.js */ \"../../engine/dist/browser/Core/Interfaces/IExternalInteractor.js\");\n/* harmony import */ var _Core_Interfaces_IInteractor_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Core/Interfaces/IInteractor.js */ \"../../engine/dist/browser/Core/Interfaces/IInteractor.js\");\n/* harmony import */ var _Core_Interfaces_ILoadParams_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Core/Interfaces/ILoadParams.js */ \"../../engine/dist/browser/Core/Interfaces/ILoadParams.js\");\n/* harmony import */ var _Core_Interfaces_IMouseData_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Core/Interfaces/IMouseData.js */ \"../../engine/dist/browser/Core/Interfaces/IMouseData.js\");\n/* harmony import */ var _Core_Interfaces_IMovePathGenerator_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Core/Interfaces/IMovePathGenerator.js */ \"../../engine/dist/browser/Core/Interfaces/IMovePathGenerator.js\");\n/* harmony import */ var _Core_Interfaces_IParticleColorStyle_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Core/Interfaces/IParticleColorStyle.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleColorStyle.js\");\n/* harmony import */ var _Core_Interfaces_IParticleHslAnimation_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Core/Interfaces/IParticleHslAnimation.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleHslAnimation.js\");\n/* harmony import */ var _Core_Interfaces_IParticleLife_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Core/Interfaces/IParticleLife.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleLife.js\");\n/* harmony import */ var _Core_Interfaces_IParticleMover_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Core/Interfaces/IParticleMover.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleMover.js\");\n/* harmony import */ var _Core_Interfaces_IParticleRetinaProps_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Core/Interfaces/IParticleRetinaProps.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleRetinaProps.js\");\n/* harmony import */ var _Core_Interfaces_IParticleRoll_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Core/Interfaces/IParticleRoll.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleRoll.js\");\n/* harmony import */ var _Core_Interfaces_IParticleTransformValues_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./Core/Interfaces/IParticleTransformValues.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleTransformValues.js\");\n/* harmony import */ var _Core_Interfaces_IParticleUpdater_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Core/Interfaces/IParticleUpdater.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleUpdater.js\");\n/* harmony import */ var _Core_Interfaces_IParticleValueAnimation_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./Core/Interfaces/IParticleValueAnimation.js */ \"../../engine/dist/browser/Core/Interfaces/IParticleValueAnimation.js\");\n/* harmony import */ var _Core_Interfaces_IParticlesInteractor_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Core/Interfaces/IParticlesInteractor.js */ \"../../engine/dist/browser/Core/Interfaces/IParticlesInteractor.js\");\n/* harmony import */ var _Core_Interfaces_IPlugin_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./Core/Interfaces/IPlugin.js */ \"../../engine/dist/browser/Core/Interfaces/IPlugin.js\");\n/* harmony import */ var _Core_Interfaces_IPositionFromSizeParams_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Core/Interfaces/IPositionFromSizeParams.js */ \"../../engine/dist/browser/Core/Interfaces/IPositionFromSizeParams.js\");\n/* harmony import */ var _Core_Interfaces_IRangeValue_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Core/Interfaces/IRangeValue.js */ \"../../engine/dist/browser/Core/Interfaces/IRangeValue.js\");\n/* harmony import */ var _Core_Interfaces_IRectSideResult_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./Core/Interfaces/IRectSideResult.js */ \"../../engine/dist/browser/Core/Interfaces/IRectSideResult.js\");\n/* harmony import */ var _Core_Interfaces_IShapeDrawData_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./Core/Interfaces/IShapeDrawData.js */ \"../../engine/dist/browser/Core/Interfaces/IShapeDrawData.js\");\n/* harmony import */ var _Core_Interfaces_IShapeDrawer_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Core/Interfaces/IShapeDrawer.js */ \"../../engine/dist/browser/Core/Interfaces/IShapeDrawer.js\");\n/* harmony import */ var _Core_Interfaces_IShapeValues_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Core/Interfaces/IShapeValues.js */ \"../../engine/dist/browser/Core/Interfaces/IShapeValues.js\");\n/* harmony import */ var _Core_Interfaces_ISlowParticleData_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./Core/Interfaces/ISlowParticleData.js */ \"../../engine/dist/browser/Core/Interfaces/ISlowParticleData.js\");\n/* harmony import */ var _Core_Interfaces_ITrailFillData_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Core/Interfaces/ITrailFillData.js */ \"../../engine/dist/browser/Core/Interfaces/ITrailFillData.js\");\n/* harmony import */ var _Options_Interfaces_Background_IBackground_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./Options/Interfaces/Background/IBackground.js */ \"../../engine/dist/browser/Options/Interfaces/Background/IBackground.js\");\n/* harmony import */ var _Options_Interfaces_BackgroundMask_IBackgroundMask_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./Options/Interfaces/BackgroundMask/IBackgroundMask.js */ \"../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMask.js\");\n/* harmony import */ var _Options_Interfaces_BackgroundMask_IBackgroundMaskCover_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./Options/Interfaces/BackgroundMask/IBackgroundMaskCover.js */ \"../../engine/dist/browser/Options/Interfaces/BackgroundMask/IBackgroundMaskCover.js\");\n/* harmony import */ var _Options_Interfaces_FullScreen_IFullScreen_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./Options/Interfaces/FullScreen/IFullScreen.js */ \"../../engine/dist/browser/Options/Interfaces/FullScreen/IFullScreen.js\");\n/* harmony import */ var _Options_Interfaces_IAnimatable_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./Options/Interfaces/IAnimatable.js */ \"../../engine/dist/browser/Options/Interfaces/IAnimatable.js\");\n/* harmony import */ var _Options_Interfaces_IAnimatableColor_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./Options/Interfaces/IAnimatableColor.js */ \"../../engine/dist/browser/Options/Interfaces/IAnimatableColor.js\");\n/* harmony import */ var _Options_Interfaces_IAnimation_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./Options/Interfaces/IAnimation.js */ \"../../engine/dist/browser/Options/Interfaces/IAnimation.js\");\n/* harmony import */ var _Options_Interfaces_IColorAnimation_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./Options/Interfaces/IColorAnimation.js */ \"../../engine/dist/browser/Options/Interfaces/IColorAnimation.js\");\n/* harmony import */ var _Options_Interfaces_IHslAnimation_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./Options/Interfaces/IHslAnimation.js */ \"../../engine/dist/browser/Options/Interfaces/IHslAnimation.js\");\n/* harmony import */ var _Options_Interfaces_IManualParticle_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./Options/Interfaces/IManualParticle.js */ \"../../engine/dist/browser/Options/Interfaces/IManualParticle.js\");\n/* harmony import */ var _Options_Interfaces_IOptionLoader_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./Options/Interfaces/IOptionLoader.js */ \"../../engine/dist/browser/Options/Interfaces/IOptionLoader.js\");\n/* harmony import */ var _Options_Interfaces_IOptions_js__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./Options/Interfaces/IOptions.js */ \"../../engine/dist/browser/Options/Interfaces/IOptions.js\");\n/* harmony import */ var _Options_Interfaces_IOptionsColor_js__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./Options/Interfaces/IOptionsColor.js */ \"../../engine/dist/browser/Options/Interfaces/IOptionsColor.js\");\n/* harmony import */ var _Options_Interfaces_IResponsive_js__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./Options/Interfaces/IResponsive.js */ \"../../engine/dist/browser/Options/Interfaces/IResponsive.js\");\n/* harmony import */ var _Options_Interfaces_IValueWithRandom_js__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./Options/Interfaces/IValueWithRandom.js */ \"../../engine/dist/browser/Options/Interfaces/IValueWithRandom.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IClickEvent_js__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IClickEvent.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IClickEvent.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IDivEvent_js__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IDivEvent.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IDivEvent.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IEvents_js__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IEvents.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IEvents.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IHoverEvent_js__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IHoverEvent.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IHoverEvent.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IParallax_js__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IParallax.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IParallax.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Events_IResizeEvent_js__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Events/IResizeEvent.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Events/IResizeEvent.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Modes_IModeDiv_js__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Modes/IModeDiv.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModeDiv.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_Modes_IModes_js__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/Modes/IModes.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/Modes/IModes.js\");\n/* harmony import */ var _Options_Interfaces_Interactivity_IInteractivity_js__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./Options/Interfaces/Interactivity/IInteractivity.js */ \"../../engine/dist/browser/Options/Interfaces/Interactivity/IInteractivity.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Bounce_IParticlesBounce_js__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Bounce/IParticlesBounce.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Bounce/IParticlesBounce.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Collisions_ICollisions_js__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Collisions/ICollisions.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisions.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Collisions_ICollisionsAbsorb_js__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Collisions/ICollisionsAbsorb.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsAbsorb.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Collisions_ICollisionsOverlap_js__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Collisions/ICollisionsOverlap.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Collisions/ICollisionsOverlap.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Effect_IEffect_js__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Effect/IEffect.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Effect/IEffect.js\");\n/* harmony import */ var _Options_Interfaces_Particles_IParticlesOptions_js__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./Options/Interfaces/Particles/IParticlesOptions.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/IParticlesOptions.js\");\n/* harmony import */ var _Options_Interfaces_Particles_IShadow_js__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./Options/Interfaces/Particles/IShadow.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/IShadow.js\");\n/* harmony import */ var _Options_Interfaces_Particles_IStroke_js__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./Options/Interfaces/Particles/IStroke.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/IStroke.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMoveAttract_js__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMoveAttract.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAttract.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMove_js__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMove.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMove.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMoveAngle_js__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMoveAngle.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveAngle.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMoveCenter_js__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMoveCenter.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveCenter.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMoveGravity_js__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMoveGravity.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveGravity.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_Path_IMovePath_js__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/Path/IMovePath.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/Path/IMovePath.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IOutModes_js__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IOutModes.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IOutModes.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_ISpin_js__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/ISpin.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/ISpin.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Move_IMoveTrail_js__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Move/IMoveTrail.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Move/IMoveTrail.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Number_IParticlesDensity_js__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Number/IParticlesDensity.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesDensity.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Number_IParticlesNumber_js__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Number/IParticlesNumber.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumber.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Number_IParticlesNumberLimit_js__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Number/IParticlesNumberLimit.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Number/IParticlesNumberLimit.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Opacity_IOpacity_js__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Opacity/IOpacity.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacity.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Opacity_IOpacityAnimation_js__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Opacity/IOpacityAnimation.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Opacity/IOpacityAnimation.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Shape_IShape_js__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Shape/IShape.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Shape/IShape.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Size_ISize_js__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Size/ISize.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Size/ISize.js\");\n/* harmony import */ var _Options_Interfaces_Particles_Size_ISizeAnimation_js__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ./Options/Interfaces/Particles/Size/ISizeAnimation.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/Size/ISizeAnimation.js\");\n/* harmony import */ var _Options_Interfaces_Particles_ZIndex_IZIndex_js__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ./Options/Interfaces/Particles/ZIndex/IZIndex.js */ \"../../engine/dist/browser/Options/Interfaces/Particles/ZIndex/IZIndex.js\");\n/* harmony import */ var _Options_Interfaces_Theme_ITheme_js__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ./Options/Interfaces/Theme/ITheme.js */ \"../../engine/dist/browser/Options/Interfaces/Theme/ITheme.js\");\n/* harmony import */ var _Options_Interfaces_Theme_IThemeDefault_js__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ./Options/Interfaces/Theme/IThemeDefault.js */ \"../../engine/dist/browser/Options/Interfaces/Theme/IThemeDefault.js\");\n/* harmony import */ var _Types_CustomEventArgs_js__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ./Types/CustomEventArgs.js */ \"../../engine/dist/browser/Types/CustomEventArgs.js\");\n/* harmony import */ var _Types_CustomEventListener_js__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ./Types/CustomEventListener.js */ \"../../engine/dist/browser/Types/CustomEventListener.js\");\n/* harmony import */ var _Types_ExportResult_js__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ./Types/ExportResult.js */ \"../../engine/dist/browser/Types/ExportResult.js\");\n/* harmony import */ var _Types_ISourceOptions_js__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ./Types/ISourceOptions.js */ \"../../engine/dist/browser/Types/ISourceOptions.js\");\n/* harmony import */ var _Types_ParticlesGroups_js__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ./Types/ParticlesGroups.js */ \"../../engine/dist/browser/Types/ParticlesGroups.js\");\n/* harmony import */ var _Types_PathOptions_js__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ./Types/PathOptions.js */ \"../../engine/dist/browser/Types/PathOptions.js\");\n/* harmony import */ var _Types_RangeValue_js__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(/*! ./Types/RangeValue.js */ \"../../engine/dist/browser/Types/RangeValue.js\");\n/* harmony import */ var _Types_RecursivePartial_js__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(/*! ./Types/RecursivePartial.js */ \"../../engine/dist/browser/Types/RecursivePartial.js\");\n/* harmony import */ var _Types_ShapeData_js__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(/*! ./Types/ShapeData.js */ \"../../engine/dist/browser/Types/ShapeData.js\");\n/* harmony import */ var _Types_SingleOrMultiple_js__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(/*! ./Types/SingleOrMultiple.js */ \"../../engine/dist/browser/Types/SingleOrMultiple.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/export-types.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/exports.js":
/*!********************************************!*\
  !*** ../../engine/dist/browser/exports.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AlterType: () => (/* reexport safe */ _Enums_Types_AlterType_js__WEBPACK_IMPORTED_MODULE_16__.AlterType),\n/* harmony export */   AnimatableColor: () => (/* reexport safe */ _Options_Classes_AnimatableColor_js__WEBPACK_IMPORTED_MODULE_27__.AnimatableColor),\n/* harmony export */   AnimationMode: () => (/* reexport safe */ _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_9__.AnimationMode),\n/* harmony export */   AnimationOptions: () => (/* reexport safe */ _Options_Classes_AnimationOptions_js__WEBPACK_IMPORTED_MODULE_28__.AnimationOptions),\n/* harmony export */   AnimationStatus: () => (/* reexport safe */ _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_25__.AnimationStatus),\n/* harmony export */   AnimationValueWithRandom: () => (/* reexport safe */ _Options_Classes_ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_75__.AnimationValueWithRandom),\n/* harmony export */   Background: () => (/* reexport safe */ _Options_Classes_Background_Background_js__WEBPACK_IMPORTED_MODULE_29__.Background),\n/* harmony export */   BackgroundMask: () => (/* reexport safe */ _Options_Classes_BackgroundMask_BackgroundMask_js__WEBPACK_IMPORTED_MODULE_30__.BackgroundMask),\n/* harmony export */   BackgroundMaskCover: () => (/* reexport safe */ _Options_Classes_BackgroundMask_BackgroundMaskCover_js__WEBPACK_IMPORTED_MODULE_31__.BackgroundMaskCover),\n/* harmony export */   BaseRange: () => (/* reexport safe */ _Core_Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_4__.BaseRange),\n/* harmony export */   Circle: () => (/* reexport safe */ _Core_Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_4__.Circle),\n/* harmony export */   ClickEvent: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_ClickEvent_js__WEBPACK_IMPORTED_MODULE_35__.ClickEvent),\n/* harmony export */   CollisionMode: () => (/* reexport safe */ _Enums_Modes_CollisionMode_js__WEBPACK_IMPORTED_MODULE_10__.CollisionMode),\n/* harmony export */   Collisions: () => (/* reexport safe */ _Options_Classes_Particles_Collisions_Collisions_js__WEBPACK_IMPORTED_MODULE_48__.Collisions),\n/* harmony export */   CollisionsAbsorb: () => (/* reexport safe */ _Options_Classes_Particles_Collisions_CollisionsAbsorb_js__WEBPACK_IMPORTED_MODULE_49__.CollisionsAbsorb),\n/* harmony export */   CollisionsOverlap: () => (/* reexport safe */ _Options_Classes_Particles_Collisions_CollisionsOverlap_js__WEBPACK_IMPORTED_MODULE_50__.CollisionsOverlap),\n/* harmony export */   ColorAnimation: () => (/* reexport safe */ _Options_Classes_ColorAnimation_js__WEBPACK_IMPORTED_MODULE_32__.ColorAnimation),\n/* harmony export */   DestroyType: () => (/* reexport safe */ _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_17__.DestroyType),\n/* harmony export */   DivEvent: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_DivEvent_js__WEBPACK_IMPORTED_MODULE_36__.DivEvent),\n/* harmony export */   DivType: () => (/* reexport safe */ _Enums_Types_DivType_js__WEBPACK_IMPORTED_MODULE_22__.DivType),\n/* harmony export */   EasingType: () => (/* reexport safe */ _Enums_Types_EasingType_js__WEBPACK_IMPORTED_MODULE_23__.EasingType),\n/* harmony export */   EventType: () => (/* reexport safe */ _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_24__.EventType),\n/* harmony export */   Events: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_Events_js__WEBPACK_IMPORTED_MODULE_37__.Events),\n/* harmony export */   ExternalInteractorBase: () => (/* reexport safe */ _Core_Utils_ExternalInteractorBase_js__WEBPACK_IMPORTED_MODULE_1__.ExternalInteractorBase),\n/* harmony export */   FullScreen: () => (/* reexport safe */ _Options_Classes_FullScreen_FullScreen_js__WEBPACK_IMPORTED_MODULE_33__.FullScreen),\n/* harmony export */   GradientType: () => (/* reexport safe */ _Enums_Types_GradientType_js__WEBPACK_IMPORTED_MODULE_18__.GradientType),\n/* harmony export */   HoverEvent: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_HoverEvent_js__WEBPACK_IMPORTED_MODULE_38__.HoverEvent),\n/* harmony export */   HslAnimation: () => (/* reexport safe */ _Options_Classes_HslAnimation_js__WEBPACK_IMPORTED_MODULE_34__.HslAnimation),\n/* harmony export */   Interactivity: () => (/* reexport safe */ _Options_Classes_Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_41__.Interactivity),\n/* harmony export */   InteractivityDetect: () => (/* reexport safe */ _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_26__.InteractivityDetect),\n/* harmony export */   InteractorType: () => (/* reexport safe */ _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_19__.InteractorType),\n/* harmony export */   LimitMode: () => (/* reexport safe */ _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_11__.LimitMode),\n/* harmony export */   ManualParticle: () => (/* reexport safe */ _Options_Classes_ManualParticle_js__WEBPACK_IMPORTED_MODULE_43__.ManualParticle),\n/* harmony export */   Modes: () => (/* reexport safe */ _Options_Classes_Interactivity_Modes_Modes_js__WEBPACK_IMPORTED_MODULE_42__.Modes),\n/* harmony export */   Move: () => (/* reexport safe */ _Options_Classes_Particles_Move_Move_js__WEBPACK_IMPORTED_MODULE_55__.Move),\n/* harmony export */   MoveAngle: () => (/* reexport safe */ _Options_Classes_Particles_Move_MoveAngle_js__WEBPACK_IMPORTED_MODULE_56__.MoveAngle),\n/* harmony export */   MoveAttract: () => (/* reexport safe */ _Options_Classes_Particles_Move_MoveAttract_js__WEBPACK_IMPORTED_MODULE_54__.MoveAttract),\n/* harmony export */   MoveCenter: () => (/* reexport safe */ _Options_Classes_Particles_Move_MoveCenter_js__WEBPACK_IMPORTED_MODULE_57__.MoveCenter),\n/* harmony export */   MoveDirection: () => (/* reexport safe */ _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_6__.MoveDirection),\n/* harmony export */   MoveGravity: () => (/* reexport safe */ _Options_Classes_Particles_Move_MoveGravity_js__WEBPACK_IMPORTED_MODULE_58__.MoveGravity),\n/* harmony export */   MovePath: () => (/* reexport safe */ _Options_Classes_Particles_Move_Path_MovePath_js__WEBPACK_IMPORTED_MODULE_60__.MovePath),\n/* harmony export */   MoveTrail: () => (/* reexport safe */ _Options_Classes_Particles_Move_MoveTrail_js__WEBPACK_IMPORTED_MODULE_62__.MoveTrail),\n/* harmony export */   Opacity: () => (/* reexport safe */ _Options_Classes_Particles_Opacity_Opacity_js__WEBPACK_IMPORTED_MODULE_66__.Opacity),\n/* harmony export */   OpacityAnimation: () => (/* reexport safe */ _Options_Classes_Particles_Opacity_OpacityAnimation_js__WEBPACK_IMPORTED_MODULE_67__.OpacityAnimation),\n/* harmony export */   Options: () => (/* reexport safe */ _Options_Classes_Options_js__WEBPACK_IMPORTED_MODULE_44__.Options),\n/* harmony export */   OptionsColor: () => (/* reexport safe */ _Options_Classes_OptionsColor_js__WEBPACK_IMPORTED_MODULE_45__.OptionsColor),\n/* harmony export */   OutMode: () => (/* reexport safe */ _Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_12__.OutMode),\n/* harmony export */   OutModeDirection: () => (/* reexport safe */ _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_8__.OutModeDirection),\n/* harmony export */   OutModes: () => (/* reexport safe */ _Options_Classes_Particles_Move_OutModes_js__WEBPACK_IMPORTED_MODULE_59__.OutModes),\n/* harmony export */   Parallax: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_Parallax_js__WEBPACK_IMPORTED_MODULE_39__.Parallax),\n/* harmony export */   ParticleOutType: () => (/* reexport safe */ _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_20__.ParticleOutType),\n/* harmony export */   ParticlesBounce: () => (/* reexport safe */ _Options_Classes_Particles_Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_46__.ParticlesBounce),\n/* harmony export */   ParticlesBounceFactor: () => (/* reexport safe */ _Options_Classes_Particles_Bounce_ParticlesBounceFactor_js__WEBPACK_IMPORTED_MODULE_47__.ParticlesBounceFactor),\n/* harmony export */   ParticlesDensity: () => (/* reexport safe */ _Options_Classes_Particles_Number_ParticlesDensity_js__WEBPACK_IMPORTED_MODULE_65__.ParticlesDensity),\n/* harmony export */   ParticlesInteractorBase: () => (/* reexport safe */ _Core_Utils_ParticlesInteractorBase_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesInteractorBase),\n/* harmony export */   ParticlesNumber: () => (/* reexport safe */ _Options_Classes_Particles_Number_ParticlesNumber_js__WEBPACK_IMPORTED_MODULE_63__.ParticlesNumber),\n/* harmony export */   ParticlesNumberLimit: () => (/* reexport safe */ _Options_Classes_Particles_Number_ParticlesNumberLimit_js__WEBPACK_IMPORTED_MODULE_64__.ParticlesNumberLimit),\n/* harmony export */   ParticlesOptions: () => (/* reexport safe */ _Options_Classes_Particles_ParticlesOptions_js__WEBPACK_IMPORTED_MODULE_51__.ParticlesOptions),\n/* harmony export */   PixelMode: () => (/* reexport safe */ _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_13__.PixelMode),\n/* harmony export */   Point: () => (/* reexport safe */ _Core_Utils_Point_js__WEBPACK_IMPORTED_MODULE_3__.Point),\n/* harmony export */   RangedAnimationOptions: () => (/* reexport safe */ _Options_Classes_AnimationOptions_js__WEBPACK_IMPORTED_MODULE_28__.RangedAnimationOptions),\n/* harmony export */   RangedAnimationValueWithRandom: () => (/* reexport safe */ _Options_Classes_ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_75__.RangedAnimationValueWithRandom),\n/* harmony export */   Rectangle: () => (/* reexport safe */ _Core_Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_4__.Rectangle),\n/* harmony export */   ResizeEvent: () => (/* reexport safe */ _Options_Classes_Interactivity_Events_ResizeEvent_js__WEBPACK_IMPORTED_MODULE_40__.ResizeEvent),\n/* harmony export */   Responsive: () => (/* reexport safe */ _Options_Classes_Responsive_js__WEBPACK_IMPORTED_MODULE_72__.Responsive),\n/* harmony export */   ResponsiveMode: () => (/* reexport safe */ _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_15__.ResponsiveMode),\n/* harmony export */   RotateDirection: () => (/* reexport safe */ _Enums_Directions_RotateDirection_js__WEBPACK_IMPORTED_MODULE_7__.RotateDirection),\n/* harmony export */   Shadow: () => (/* reexport safe */ _Options_Classes_Particles_Shadow_js__WEBPACK_IMPORTED_MODULE_52__.Shadow),\n/* harmony export */   Shape: () => (/* reexport safe */ _Options_Classes_Particles_Shape_Shape_js__WEBPACK_IMPORTED_MODULE_68__.Shape),\n/* harmony export */   Size: () => (/* reexport safe */ _Options_Classes_Particles_Size_Size_js__WEBPACK_IMPORTED_MODULE_69__.Size),\n/* harmony export */   SizeAnimation: () => (/* reexport safe */ _Options_Classes_Particles_Size_SizeAnimation_js__WEBPACK_IMPORTED_MODULE_70__.SizeAnimation),\n/* harmony export */   Spin: () => (/* reexport safe */ _Options_Classes_Particles_Move_Spin_js__WEBPACK_IMPORTED_MODULE_61__.Spin),\n/* harmony export */   StartValueType: () => (/* reexport safe */ _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_21__.StartValueType),\n/* harmony export */   Stroke: () => (/* reexport safe */ _Options_Classes_Particles_Stroke_js__WEBPACK_IMPORTED_MODULE_53__.Stroke),\n/* harmony export */   Theme: () => (/* reexport safe */ _Options_Classes_Theme_Theme_js__WEBPACK_IMPORTED_MODULE_73__.Theme),\n/* harmony export */   ThemeDefault: () => (/* reexport safe */ _Options_Classes_Theme_ThemeDefault_js__WEBPACK_IMPORTED_MODULE_74__.ThemeDefault),\n/* harmony export */   ThemeMode: () => (/* reexport safe */ _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_14__.ThemeMode),\n/* harmony export */   ValueWithRandom: () => (/* reexport safe */ _Options_Classes_ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_75__.ValueWithRandom),\n/* harmony export */   Vector: () => (/* reexport safe */ _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_5__.Vector),\n/* harmony export */   Vector3d: () => (/* reexport safe */ _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_5__.Vector3d),\n/* harmony export */   ZIndex: () => (/* reexport safe */ _Options_Classes_Particles_ZIndex_ZIndex_js__WEBPACK_IMPORTED_MODULE_71__.ZIndex),\n/* harmony export */   alterHsl: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.alterHsl),\n/* harmony export */   animate: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.animate),\n/* harmony export */   areBoundsInside: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.areBoundsInside),\n/* harmony export */   arrayRandomIndex: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.arrayRandomIndex),\n/* harmony export */   calcExactPositionOrRandomFromSize: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.calcExactPositionOrRandomFromSize),\n/* harmony export */   calcExactPositionOrRandomFromSizeRanged: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.calcExactPositionOrRandomFromSizeRanged),\n/* harmony export */   calcPositionFromSize: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.calcPositionFromSize),\n/* harmony export */   calcPositionOrRandomFromSize: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.calcPositionOrRandomFromSize),\n/* harmony export */   calcPositionOrRandomFromSizeRanged: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.calcPositionOrRandomFromSizeRanged),\n/* harmony export */   calculateBounds: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.calculateBounds),\n/* harmony export */   cancelAnimation: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.cancelAnimation),\n/* harmony export */   canvasFirstIndex: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasFirstIndex),\n/* harmony export */   canvasTag: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.canvasTag),\n/* harmony export */   circleBounce: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.circleBounce),\n/* harmony export */   circleBounceDataFromParticle: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.circleBounceDataFromParticle),\n/* harmony export */   clamp: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.clamp),\n/* harmony export */   clear: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.clear),\n/* harmony export */   clickRadius: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.clickRadius),\n/* harmony export */   cloneStyle: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.cloneStyle),\n/* harmony export */   collisionVelocity: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.collisionVelocity),\n/* harmony export */   colorMix: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.colorMix),\n/* harmony export */   colorToHsl: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.colorToHsl),\n/* harmony export */   colorToRgb: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.colorToRgb),\n/* harmony export */   countOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.countOffset),\n/* harmony export */   decayOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.decayOffset),\n/* harmony export */   deepExtend: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.deepExtend),\n/* harmony export */   defaultAlpha: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultAlpha),\n/* harmony export */   defaultAngle: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultAngle),\n/* harmony export */   defaultDensityFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultDensityFactor),\n/* harmony export */   defaultFps: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultFps),\n/* harmony export */   defaultFpsLimit: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultFpsLimit),\n/* harmony export */   defaultLoops: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultLoops),\n/* harmony export */   defaultOpacity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultOpacity),\n/* harmony export */   defaultRadius: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRadius),\n/* harmony export */   defaultRatio: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRatio),\n/* harmony export */   defaultReduceFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultReduceFactor),\n/* harmony export */   defaultRemoveQuantity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRemoveQuantity),\n/* harmony export */   defaultRetryCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRetryCount),\n/* harmony export */   defaultRgbMin: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultRgbMin),\n/* harmony export */   defaultTime: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTime),\n/* harmony export */   defaultTransform: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransform),\n/* harmony export */   defaultTransformValue: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultTransformValue),\n/* harmony export */   defaultVelocity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.defaultVelocity),\n/* harmony export */   degToRad: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.degToRad),\n/* harmony export */   deleteCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.deleteCount),\n/* harmony export */   divMode: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.divMode),\n/* harmony export */   divModeExecute: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.divModeExecute),\n/* harmony export */   double: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.double),\n/* harmony export */   doublePI: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.doublePI),\n/* harmony export */   drawEffect: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawEffect),\n/* harmony export */   drawLine: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawLine),\n/* harmony export */   drawParticle: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawParticle),\n/* harmony export */   drawParticlePlugin: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawParticlePlugin),\n/* harmony export */   drawPlugin: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawPlugin),\n/* harmony export */   drawShape: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawShape),\n/* harmony export */   drawShapeAfterDraw: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.drawShapeAfterDraw),\n/* harmony export */   empty: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.empty),\n/* harmony export */   errorPrefix: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.errorPrefix),\n/* harmony export */   executeOnSingleOrMultiple: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.executeOnSingleOrMultiple),\n/* harmony export */   findItemFromSingleOrMultiple: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.findItemFromSingleOrMultiple),\n/* harmony export */   generatedAttribute: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedAttribute),\n/* harmony export */   generatedFalse: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedFalse),\n/* harmony export */   generatedTrue: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.generatedTrue),\n/* harmony export */   getDistance: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getDistance),\n/* harmony export */   getDistances: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getDistances),\n/* harmony export */   getFullScreenStyle: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.getFullScreenStyle),\n/* harmony export */   getHslAnimationFromHsl: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getHslAnimationFromHsl),\n/* harmony export */   getHslFromAnimation: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getHslFromAnimation),\n/* harmony export */   getLinkColor: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getLinkColor),\n/* harmony export */   getLinkRandomColor: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getLinkRandomColor),\n/* harmony export */   getLogger: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.getLogger),\n/* harmony export */   getParticleBaseVelocity: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getParticleBaseVelocity),\n/* harmony export */   getParticleDirectionAngle: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getParticleDirectionAngle),\n/* harmony export */   getPosition: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.getPosition),\n/* harmony export */   getRandom: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getRandom),\n/* harmony export */   getRandomRgbColor: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getRandomRgbColor),\n/* harmony export */   getRangeMax: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getRangeMax),\n/* harmony export */   getRangeMin: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getRangeMin),\n/* harmony export */   getRangeValue: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.getRangeValue),\n/* harmony export */   getSize: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.getSize),\n/* harmony export */   getStyleFromHsl: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getStyleFromHsl),\n/* harmony export */   getStyleFromRgb: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.getStyleFromRgb),\n/* harmony export */   hMax: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.hMax),\n/* harmony export */   hMin: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.hMin),\n/* harmony export */   hPhase: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.hPhase),\n/* harmony export */   half: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.half),\n/* harmony export */   hasMatchMedia: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.hasMatchMedia),\n/* harmony export */   hslToRgb: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.hslToRgb),\n/* harmony export */   hslaToRgba: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.hslaToRgba),\n/* harmony export */   identity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.identity),\n/* harmony export */   initParticleNumericAnimationValue: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.initParticleNumericAnimationValue),\n/* harmony export */   inverseFactorNumerator: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.inverseFactorNumerator),\n/* harmony export */   isArray: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isArray),\n/* harmony export */   isBoolean: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isBoolean),\n/* harmony export */   isDivModeEnabled: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.isDivModeEnabled),\n/* harmony export */   isFunction: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isFunction),\n/* harmony export */   isInArray: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.isInArray),\n/* harmony export */   isNull: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isNull),\n/* harmony export */   isNumber: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isNumber),\n/* harmony export */   isObject: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isObject),\n/* harmony export */   isPointInside: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.isPointInside),\n/* harmony export */   isSsr: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.isSsr),\n/* harmony export */   isString: () => (/* reexport safe */ _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__.isString),\n/* harmony export */   itemFromArray: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.itemFromArray),\n/* harmony export */   itemFromSingleOrMultiple: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.itemFromSingleOrMultiple),\n/* harmony export */   lFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lFactor),\n/* harmony export */   lMax: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lMax),\n/* harmony export */   lMin: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lMin),\n/* harmony export */   lengthOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.lengthOffset),\n/* harmony export */   loadFont: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.loadFont),\n/* harmony export */   loadMinIndex: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.loadMinIndex),\n/* harmony export */   loadOptions: () => (/* reexport safe */ _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_79__.loadOptions),\n/* harmony export */   loadParticlesOptions: () => (/* reexport safe */ _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_79__.loadParticlesOptions),\n/* harmony export */   loadRandomFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.loadRandomFactor),\n/* harmony export */   manualCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.manualCount),\n/* harmony export */   manualDefaultPosition: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.manualDefaultPosition),\n/* harmony export */   midColorValue: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.midColorValue),\n/* harmony export */   millisecondsToSeconds: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds),\n/* harmony export */   minCoordinate: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minCoordinate),\n/* harmony export */   minCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minCount),\n/* harmony export */   minFpsLimit: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minFpsLimit),\n/* harmony export */   minIndex: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minIndex),\n/* harmony export */   minLimit: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minLimit),\n/* harmony export */   minRetries: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minRetries),\n/* harmony export */   minStrokeWidth: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minStrokeWidth),\n/* harmony export */   minVelocity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minVelocity),\n/* harmony export */   minZ: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minZ),\n/* harmony export */   minimumLength: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minimumLength),\n/* harmony export */   minimumSize: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.minimumSize),\n/* harmony export */   mix: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.mix),\n/* harmony export */   mouseDownEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseDownEvent),\n/* harmony export */   mouseLeaveEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseLeaveEvent),\n/* harmony export */   mouseMoveEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent),\n/* harmony export */   mouseOutEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseOutEvent),\n/* harmony export */   mouseUpEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.mouseUpEvent),\n/* harmony export */   none: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.none),\n/* harmony export */   one: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.one),\n/* harmony export */   originPoint: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.originPoint),\n/* harmony export */   paintBase: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.paintBase),\n/* harmony export */   paintImage: () => (/* reexport safe */ _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__.paintImage),\n/* harmony export */   parseAlpha: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.parseAlpha),\n/* harmony export */   percentDenominator: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.percentDenominator),\n/* harmony export */   phaseNumerator: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.phaseNumerator),\n/* harmony export */   posOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.posOffset),\n/* harmony export */   qTreeCapacity: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.qTreeCapacity),\n/* harmony export */   quarter: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.quarter),\n/* harmony export */   randomColorValue: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.randomColorValue),\n/* harmony export */   randomInRange: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.randomInRange),\n/* harmony export */   rangeColorToHsl: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.rangeColorToHsl),\n/* harmony export */   rangeColorToRgb: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.rangeColorToRgb),\n/* harmony export */   rectBounce: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.rectBounce),\n/* harmony export */   removeDeleteCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.removeDeleteCount),\n/* harmony export */   removeMinIndex: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.removeMinIndex),\n/* harmony export */   resizeEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.resizeEvent),\n/* harmony export */   rgbFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.rgbFactor),\n/* harmony export */   rgbMax: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.rgbMax),\n/* harmony export */   rgbToHsl: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.rgbToHsl),\n/* harmony export */   rollFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.rollFactor),\n/* harmony export */   sMax: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sMax),\n/* harmony export */   sMin: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sMin),\n/* harmony export */   sNormalizedOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sNormalizedOffset),\n/* harmony export */   safeIntersectionObserver: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.safeIntersectionObserver),\n/* harmony export */   safeMatchMedia: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.safeMatchMedia),\n/* harmony export */   safeMutationObserver: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.safeMutationObserver),\n/* harmony export */   setAnimationFunctions: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.setAnimationFunctions),\n/* harmony export */   setLogger: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.setLogger),\n/* harmony export */   setRandom: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.setRandom),\n/* harmony export */   setRangeValue: () => (/* reexport safe */ _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__.setRangeValue),\n/* harmony export */   sextuple: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sextuple),\n/* harmony export */   singleDivModeExecute: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.singleDivModeExecute),\n/* harmony export */   sizeFactor: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.sizeFactor),\n/* harmony export */   squareExp: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.squareExp),\n/* harmony export */   stringToAlpha: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.stringToAlpha),\n/* harmony export */   stringToRgb: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.stringToRgb),\n/* harmony export */   subdivideCount: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.subdivideCount),\n/* harmony export */   threeQuarter: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.threeQuarter),\n/* harmony export */   touchCancelEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchCancelEvent),\n/* harmony export */   touchDelay: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchDelay),\n/* harmony export */   touchEndEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchEndEvent),\n/* harmony export */   touchEndLengthOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchEndLengthOffset),\n/* harmony export */   touchMoveEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchMoveEvent),\n/* harmony export */   touchStartEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.touchStartEvent),\n/* harmony export */   triple: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.triple),\n/* harmony export */   tryCountIncrement: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.tryCountIncrement),\n/* harmony export */   updateAnimation: () => (/* reexport safe */ _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__.updateAnimation),\n/* harmony export */   updateColor: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.updateColor),\n/* harmony export */   updateColorValue: () => (/* reexport safe */ _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__.updateColorValue),\n/* harmony export */   visibilityChangeEvent: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.visibilityChangeEvent),\n/* harmony export */   zIndexFactorOffset: () => (/* reexport safe */ _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__.zIndexFactorOffset)\n/* harmony export */ });\n/* harmony import */ var _Core_Utils_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Core/Utils/Constants.js */ \"../../engine/dist/browser/Core/Utils/Constants.js\");\n/* harmony import */ var _Core_Utils_ExternalInteractorBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Core/Utils/ExternalInteractorBase.js */ \"../../engine/dist/browser/Core/Utils/ExternalInteractorBase.js\");\n/* harmony import */ var _Core_Utils_ParticlesInteractorBase_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Core/Utils/ParticlesInteractorBase.js */ \"../../engine/dist/browser/Core/Utils/ParticlesInteractorBase.js\");\n/* harmony import */ var _Core_Utils_Point_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Core/Utils/Point.js */ \"../../engine/dist/browser/Core/Utils/Point.js\");\n/* harmony import */ var _Core_Utils_Ranges_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Core/Utils/Ranges.js */ \"../../engine/dist/browser/Core/Utils/Ranges.js\");\n/* harmony import */ var _Core_Utils_Vectors_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Core/Utils/Vectors.js */ \"../../engine/dist/browser/Core/Utils/Vectors.js\");\n/* harmony import */ var _Enums_Directions_MoveDirection_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Enums/Directions/MoveDirection.js */ \"../../engine/dist/browser/Enums/Directions/MoveDirection.js\");\n/* harmony import */ var _Enums_Directions_RotateDirection_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Enums/Directions/RotateDirection.js */ \"../../engine/dist/browser/Enums/Directions/RotateDirection.js\");\n/* harmony import */ var _Enums_Directions_OutModeDirection_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Enums/Directions/OutModeDirection.js */ \"../../engine/dist/browser/Enums/Directions/OutModeDirection.js\");\n/* harmony import */ var _Enums_Modes_AnimationMode_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Enums/Modes/AnimationMode.js */ \"../../engine/dist/browser/Enums/Modes/AnimationMode.js\");\n/* harmony import */ var _Enums_Modes_CollisionMode_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Enums/Modes/CollisionMode.js */ \"../../engine/dist/browser/Enums/Modes/CollisionMode.js\");\n/* harmony import */ var _Enums_Modes_LimitMode_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Enums/Modes/LimitMode.js */ \"../../engine/dist/browser/Enums/Modes/LimitMode.js\");\n/* harmony import */ var _Enums_Modes_OutMode_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Enums/Modes/OutMode.js */ \"../../engine/dist/browser/Enums/Modes/OutMode.js\");\n/* harmony import */ var _Enums_Modes_PixelMode_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Enums/Modes/PixelMode.js */ \"../../engine/dist/browser/Enums/Modes/PixelMode.js\");\n/* harmony import */ var _Enums_Modes_ThemeMode_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Enums/Modes/ThemeMode.js */ \"../../engine/dist/browser/Enums/Modes/ThemeMode.js\");\n/* harmony import */ var _Enums_Modes_ResponsiveMode_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Enums/Modes/ResponsiveMode.js */ \"../../engine/dist/browser/Enums/Modes/ResponsiveMode.js\");\n/* harmony import */ var _Enums_Types_AlterType_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Enums/Types/AlterType.js */ \"../../engine/dist/browser/Enums/Types/AlterType.js\");\n/* harmony import */ var _Enums_Types_DestroyType_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Enums/Types/DestroyType.js */ \"../../engine/dist/browser/Enums/Types/DestroyType.js\");\n/* harmony import */ var _Enums_Types_GradientType_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Enums/Types/GradientType.js */ \"../../engine/dist/browser/Enums/Types/GradientType.js\");\n/* harmony import */ var _Enums_Types_InteractorType_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Enums/Types/InteractorType.js */ \"../../engine/dist/browser/Enums/Types/InteractorType.js\");\n/* harmony import */ var _Enums_Types_ParticleOutType_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Enums/Types/ParticleOutType.js */ \"../../engine/dist/browser/Enums/Types/ParticleOutType.js\");\n/* harmony import */ var _Enums_Types_StartValueType_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Enums/Types/StartValueType.js */ \"../../engine/dist/browser/Enums/Types/StartValueType.js\");\n/* harmony import */ var _Enums_Types_DivType_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Enums/Types/DivType.js */ \"../../engine/dist/browser/Enums/Types/DivType.js\");\n/* harmony import */ var _Enums_Types_EasingType_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Enums/Types/EasingType.js */ \"../../engine/dist/browser/Enums/Types/EasingType.js\");\n/* harmony import */ var _Enums_Types_EventType_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./Enums/Types/EventType.js */ \"../../engine/dist/browser/Enums/Types/EventType.js\");\n/* harmony import */ var _Enums_AnimationStatus_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Enums/AnimationStatus.js */ \"../../engine/dist/browser/Enums/AnimationStatus.js\");\n/* harmony import */ var _Enums_InteractivityDetect_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./Enums/InteractivityDetect.js */ \"../../engine/dist/browser/Enums/InteractivityDetect.js\");\n/* harmony import */ var _Options_Classes_AnimatableColor_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Options/Classes/AnimatableColor.js */ \"../../engine/dist/browser/Options/Classes/AnimatableColor.js\");\n/* harmony import */ var _Options_Classes_AnimationOptions_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./Options/Classes/AnimationOptions.js */ \"../../engine/dist/browser/Options/Classes/AnimationOptions.js\");\n/* harmony import */ var _Options_Classes_Background_Background_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Options/Classes/Background/Background.js */ \"../../engine/dist/browser/Options/Classes/Background/Background.js\");\n/* harmony import */ var _Options_Classes_BackgroundMask_BackgroundMask_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Options/Classes/BackgroundMask/BackgroundMask.js */ \"../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMask.js\");\n/* harmony import */ var _Options_Classes_BackgroundMask_BackgroundMaskCover_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./Options/Classes/BackgroundMask/BackgroundMaskCover.js */ \"../../engine/dist/browser/Options/Classes/BackgroundMask/BackgroundMaskCover.js\");\n/* harmony import */ var _Options_Classes_ColorAnimation_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./Options/Classes/ColorAnimation.js */ \"../../engine/dist/browser/Options/Classes/ColorAnimation.js\");\n/* harmony import */ var _Options_Classes_FullScreen_FullScreen_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Options/Classes/FullScreen/FullScreen.js */ \"../../engine/dist/browser/Options/Classes/FullScreen/FullScreen.js\");\n/* harmony import */ var _Options_Classes_HslAnimation_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Options/Classes/HslAnimation.js */ \"../../engine/dist/browser/Options/Classes/HslAnimation.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_ClickEvent_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/ClickEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/ClickEvent.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_DivEvent_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/DivEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/DivEvent.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_Events_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/Events.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/Events.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_HoverEvent_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/HoverEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/HoverEvent.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_Parallax_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/Parallax.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/Parallax.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Events_ResizeEvent_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Events/ResizeEvent.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Events/ResizeEvent.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Interactivity_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Interactivity.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Interactivity.js\");\n/* harmony import */ var _Options_Classes_Interactivity_Modes_Modes_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./Options/Classes/Interactivity/Modes/Modes.js */ \"../../engine/dist/browser/Options/Classes/Interactivity/Modes/Modes.js\");\n/* harmony import */ var _Options_Classes_ManualParticle_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./Options/Classes/ManualParticle.js */ \"../../engine/dist/browser/Options/Classes/ManualParticle.js\");\n/* harmony import */ var _Options_Classes_Options_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./Options/Classes/Options.js */ \"../../engine/dist/browser/Options/Classes/Options.js\");\n/* harmony import */ var _Options_Classes_OptionsColor_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./Options/Classes/OptionsColor.js */ \"../../engine/dist/browser/Options/Classes/OptionsColor.js\");\n/* harmony import */ var _Options_Classes_Particles_Bounce_ParticlesBounce_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./Options/Classes/Particles/Bounce/ParticlesBounce.js */ \"../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounce.js\");\n/* harmony import */ var _Options_Classes_Particles_Bounce_ParticlesBounceFactor_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./Options/Classes/Particles/Bounce/ParticlesBounceFactor.js */ \"../../engine/dist/browser/Options/Classes/Particles/Bounce/ParticlesBounceFactor.js\");\n/* harmony import */ var _Options_Classes_Particles_Collisions_Collisions_js__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./Options/Classes/Particles/Collisions/Collisions.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/Collisions.js\");\n/* harmony import */ var _Options_Classes_Particles_Collisions_CollisionsAbsorb_js__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./Options/Classes/Particles/Collisions/CollisionsAbsorb.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsAbsorb.js\");\n/* harmony import */ var _Options_Classes_Particles_Collisions_CollisionsOverlap_js__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./Options/Classes/Particles/Collisions/CollisionsOverlap.js */ \"../../engine/dist/browser/Options/Classes/Particles/Collisions/CollisionsOverlap.js\");\n/* harmony import */ var _Options_Classes_Particles_ParticlesOptions_js__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./Options/Classes/Particles/ParticlesOptions.js */ \"../../engine/dist/browser/Options/Classes/Particles/ParticlesOptions.js\");\n/* harmony import */ var _Options_Classes_Particles_Shadow_js__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./Options/Classes/Particles/Shadow.js */ \"../../engine/dist/browser/Options/Classes/Particles/Shadow.js\");\n/* harmony import */ var _Options_Classes_Particles_Stroke_js__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./Options/Classes/Particles/Stroke.js */ \"../../engine/dist/browser/Options/Classes/Particles/Stroke.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_MoveAttract_js__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/MoveAttract.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveAttract.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_Move_js__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/Move.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Move.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_MoveAngle_js__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/MoveAngle.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveAngle.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_MoveCenter_js__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/MoveCenter.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveCenter.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_MoveGravity_js__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/MoveGravity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveGravity.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_OutModes_js__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/OutModes.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/OutModes.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_Path_MovePath_js__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/Path/MovePath.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Path/MovePath.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_Spin_js__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/Spin.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/Spin.js\");\n/* harmony import */ var _Options_Classes_Particles_Move_MoveTrail_js__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./Options/Classes/Particles/Move/MoveTrail.js */ \"../../engine/dist/browser/Options/Classes/Particles/Move/MoveTrail.js\");\n/* harmony import */ var _Options_Classes_Particles_Number_ParticlesNumber_js__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./Options/Classes/Particles/Number/ParticlesNumber.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumber.js\");\n/* harmony import */ var _Options_Classes_Particles_Number_ParticlesNumberLimit_js__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./Options/Classes/Particles/Number/ParticlesNumberLimit.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesNumberLimit.js\");\n/* harmony import */ var _Options_Classes_Particles_Number_ParticlesDensity_js__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./Options/Classes/Particles/Number/ParticlesDensity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Number/ParticlesDensity.js\");\n/* harmony import */ var _Options_Classes_Particles_Opacity_Opacity_js__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./Options/Classes/Particles/Opacity/Opacity.js */ \"../../engine/dist/browser/Options/Classes/Particles/Opacity/Opacity.js\");\n/* harmony import */ var _Options_Classes_Particles_Opacity_OpacityAnimation_js__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./Options/Classes/Particles/Opacity/OpacityAnimation.js */ \"../../engine/dist/browser/Options/Classes/Particles/Opacity/OpacityAnimation.js\");\n/* harmony import */ var _Options_Classes_Particles_Shape_Shape_js__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./Options/Classes/Particles/Shape/Shape.js */ \"../../engine/dist/browser/Options/Classes/Particles/Shape/Shape.js\");\n/* harmony import */ var _Options_Classes_Particles_Size_Size_js__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./Options/Classes/Particles/Size/Size.js */ \"../../engine/dist/browser/Options/Classes/Particles/Size/Size.js\");\n/* harmony import */ var _Options_Classes_Particles_Size_SizeAnimation_js__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./Options/Classes/Particles/Size/SizeAnimation.js */ \"../../engine/dist/browser/Options/Classes/Particles/Size/SizeAnimation.js\");\n/* harmony import */ var _Options_Classes_Particles_ZIndex_ZIndex_js__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./Options/Classes/Particles/ZIndex/ZIndex.js */ \"../../engine/dist/browser/Options/Classes/Particles/ZIndex/ZIndex.js\");\n/* harmony import */ var _Options_Classes_Responsive_js__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./Options/Classes/Responsive.js */ \"../../engine/dist/browser/Options/Classes/Responsive.js\");\n/* harmony import */ var _Options_Classes_Theme_Theme_js__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./Options/Classes/Theme/Theme.js */ \"../../engine/dist/browser/Options/Classes/Theme/Theme.js\");\n/* harmony import */ var _Options_Classes_Theme_ThemeDefault_js__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./Options/Classes/Theme/ThemeDefault.js */ \"../../engine/dist/browser/Options/Classes/Theme/ThemeDefault.js\");\n/* harmony import */ var _Options_Classes_ValueWithRandom_js__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./Options/Classes/ValueWithRandom.js */ \"../../engine/dist/browser/Options/Classes/ValueWithRandom.js\");\n/* harmony import */ var _Utils_CanvasUtils_js__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./Utils/CanvasUtils.js */ \"../../engine/dist/browser/Utils/CanvasUtils.js\");\n/* harmony import */ var _Utils_ColorUtils_js__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./Utils/ColorUtils.js */ \"../../engine/dist/browser/Utils/ColorUtils.js\");\n/* harmony import */ var _Utils_NumberUtils_js__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./Utils/NumberUtils.js */ \"../../engine/dist/browser/Utils/NumberUtils.js\");\n/* harmony import */ var _Utils_OptionsUtils_js__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./Utils/OptionsUtils.js */ \"../../engine/dist/browser/Utils/OptionsUtils.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _Utils_TypeUtils_js__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./Utils/TypeUtils.js */ \"../../engine/dist/browser/Utils/TypeUtils.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/exports.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/index.js":
/*!******************************************!*\
  !*** ../../engine/dist/browser/index.js ***!
  \******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AlterType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AlterType),\n/* harmony export */   AnimatableColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AnimatableColor),\n/* harmony export */   AnimationMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AnimationMode),\n/* harmony export */   AnimationOptions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AnimationOptions),\n/* harmony export */   AnimationStatus: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AnimationStatus),\n/* harmony export */   AnimationValueWithRandom: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.AnimationValueWithRandom),\n/* harmony export */   Background: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Background),\n/* harmony export */   BackgroundMask: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.BackgroundMask),\n/* harmony export */   BackgroundMaskCover: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.BackgroundMaskCover),\n/* harmony export */   BaseRange: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.BaseRange),\n/* harmony export */   Circle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Circle),\n/* harmony export */   ClickEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ClickEvent),\n/* harmony export */   CollisionMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.CollisionMode),\n/* harmony export */   Collisions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Collisions),\n/* harmony export */   CollisionsAbsorb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.CollisionsAbsorb),\n/* harmony export */   CollisionsOverlap: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.CollisionsOverlap),\n/* harmony export */   ColorAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ColorAnimation),\n/* harmony export */   DestroyType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.DestroyType),\n/* harmony export */   DivEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.DivEvent),\n/* harmony export */   DivType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.DivType),\n/* harmony export */   EasingType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.EasingType),\n/* harmony export */   EventType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.EventType),\n/* harmony export */   Events: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Events),\n/* harmony export */   ExternalInteractorBase: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ExternalInteractorBase),\n/* harmony export */   FullScreen: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.FullScreen),\n/* harmony export */   GradientType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.GradientType),\n/* harmony export */   HoverEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.HoverEvent),\n/* harmony export */   HslAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.HslAnimation),\n/* harmony export */   Interactivity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Interactivity),\n/* harmony export */   InteractivityDetect: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.InteractivityDetect),\n/* harmony export */   InteractorType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.InteractorType),\n/* harmony export */   LimitMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.LimitMode),\n/* harmony export */   ManualParticle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ManualParticle),\n/* harmony export */   Modes: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Modes),\n/* harmony export */   Move: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Move),\n/* harmony export */   MoveAngle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveAngle),\n/* harmony export */   MoveAttract: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveAttract),\n/* harmony export */   MoveCenter: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveCenter),\n/* harmony export */   MoveDirection: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveDirection),\n/* harmony export */   MoveGravity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveGravity),\n/* harmony export */   MovePath: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MovePath),\n/* harmony export */   MoveTrail: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.MoveTrail),\n/* harmony export */   Opacity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Opacity),\n/* harmony export */   OpacityAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.OpacityAnimation),\n/* harmony export */   Options: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Options),\n/* harmony export */   OptionsColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.OptionsColor),\n/* harmony export */   OutMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.OutMode),\n/* harmony export */   OutModeDirection: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.OutModeDirection),\n/* harmony export */   OutModes: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.OutModes),\n/* harmony export */   Parallax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Parallax),\n/* harmony export */   ParticleOutType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticleOutType),\n/* harmony export */   ParticlesBounce: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesBounce),\n/* harmony export */   ParticlesBounceFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesBounceFactor),\n/* harmony export */   ParticlesDensity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesDensity),\n/* harmony export */   ParticlesInteractorBase: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesInteractorBase),\n/* harmony export */   ParticlesNumber: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesNumber),\n/* harmony export */   ParticlesNumberLimit: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesNumberLimit),\n/* harmony export */   ParticlesOptions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ParticlesOptions),\n/* harmony export */   PixelMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.PixelMode),\n/* harmony export */   Point: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Point),\n/* harmony export */   RangedAnimationOptions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.RangedAnimationOptions),\n/* harmony export */   RangedAnimationValueWithRandom: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.RangedAnimationValueWithRandom),\n/* harmony export */   Rectangle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Rectangle),\n/* harmony export */   ResizeEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ResizeEvent),\n/* harmony export */   Responsive: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Responsive),\n/* harmony export */   ResponsiveMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ResponsiveMode),\n/* harmony export */   RotateDirection: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.RotateDirection),\n/* harmony export */   Shadow: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Shadow),\n/* harmony export */   Shape: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Shape),\n/* harmony export */   Size: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Size),\n/* harmony export */   SizeAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.SizeAnimation),\n/* harmony export */   Spin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Spin),\n/* harmony export */   StartValueType: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.StartValueType),\n/* harmony export */   Stroke: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Stroke),\n/* harmony export */   Theme: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Theme),\n/* harmony export */   ThemeDefault: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ThemeDefault),\n/* harmony export */   ThemeMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ThemeMode),\n/* harmony export */   ValueWithRandom: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ValueWithRandom),\n/* harmony export */   Vector: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Vector),\n/* harmony export */   Vector3d: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.Vector3d),\n/* harmony export */   ZIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.ZIndex),\n/* harmony export */   alterHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.alterHsl),\n/* harmony export */   animate: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.animate),\n/* harmony export */   areBoundsInside: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.areBoundsInside),\n/* harmony export */   arrayRandomIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.arrayRandomIndex),\n/* harmony export */   calcExactPositionOrRandomFromSize: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calcExactPositionOrRandomFromSize),\n/* harmony export */   calcExactPositionOrRandomFromSizeRanged: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calcExactPositionOrRandomFromSizeRanged),\n/* harmony export */   calcPositionFromSize: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calcPositionFromSize),\n/* harmony export */   calcPositionOrRandomFromSize: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calcPositionOrRandomFromSize),\n/* harmony export */   calcPositionOrRandomFromSizeRanged: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calcPositionOrRandomFromSizeRanged),\n/* harmony export */   calculateBounds: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.calculateBounds),\n/* harmony export */   cancelAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.cancelAnimation),\n/* harmony export */   canvasFirstIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.canvasFirstIndex),\n/* harmony export */   canvasTag: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.canvasTag),\n/* harmony export */   circleBounce: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.circleBounce),\n/* harmony export */   circleBounceDataFromParticle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.circleBounceDataFromParticle),\n/* harmony export */   clamp: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.clamp),\n/* harmony export */   clear: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.clear),\n/* harmony export */   clickRadius: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.clickRadius),\n/* harmony export */   cloneStyle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.cloneStyle),\n/* harmony export */   collisionVelocity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.collisionVelocity),\n/* harmony export */   colorMix: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.colorMix),\n/* harmony export */   colorToHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.colorToHsl),\n/* harmony export */   colorToRgb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.colorToRgb),\n/* harmony export */   countOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.countOffset),\n/* harmony export */   decayOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.decayOffset),\n/* harmony export */   deepExtend: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.deepExtend),\n/* harmony export */   defaultAlpha: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultAlpha),\n/* harmony export */   defaultAngle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultAngle),\n/* harmony export */   defaultDensityFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultDensityFactor),\n/* harmony export */   defaultFps: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultFps),\n/* harmony export */   defaultFpsLimit: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultFpsLimit),\n/* harmony export */   defaultLoops: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultLoops),\n/* harmony export */   defaultOpacity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultOpacity),\n/* harmony export */   defaultRadius: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultRadius),\n/* harmony export */   defaultRatio: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultRatio),\n/* harmony export */   defaultReduceFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultReduceFactor),\n/* harmony export */   defaultRemoveQuantity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultRemoveQuantity),\n/* harmony export */   defaultRetryCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultRetryCount),\n/* harmony export */   defaultRgbMin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultRgbMin),\n/* harmony export */   defaultTime: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultTime),\n/* harmony export */   defaultTransform: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultTransform),\n/* harmony export */   defaultTransformValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultTransformValue),\n/* harmony export */   defaultVelocity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.defaultVelocity),\n/* harmony export */   degToRad: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.degToRad),\n/* harmony export */   deleteCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.deleteCount),\n/* harmony export */   divMode: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.divMode),\n/* harmony export */   divModeExecute: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.divModeExecute),\n/* harmony export */   double: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.double),\n/* harmony export */   doublePI: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.doublePI),\n/* harmony export */   drawEffect: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawEffect),\n/* harmony export */   drawLine: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawLine),\n/* harmony export */   drawParticle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawParticle),\n/* harmony export */   drawParticlePlugin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawParticlePlugin),\n/* harmony export */   drawPlugin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawPlugin),\n/* harmony export */   drawShape: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawShape),\n/* harmony export */   drawShapeAfterDraw: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.drawShapeAfterDraw),\n/* harmony export */   empty: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.empty),\n/* harmony export */   errorPrefix: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.errorPrefix),\n/* harmony export */   executeOnSingleOrMultiple: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.executeOnSingleOrMultiple),\n/* harmony export */   findItemFromSingleOrMultiple: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.findItemFromSingleOrMultiple),\n/* harmony export */   generatedAttribute: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.generatedAttribute),\n/* harmony export */   generatedFalse: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.generatedFalse),\n/* harmony export */   generatedTrue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.generatedTrue),\n/* harmony export */   getDistance: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getDistance),\n/* harmony export */   getDistances: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getDistances),\n/* harmony export */   getFullScreenStyle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getFullScreenStyle),\n/* harmony export */   getHslAnimationFromHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getHslAnimationFromHsl),\n/* harmony export */   getHslFromAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getHslFromAnimation),\n/* harmony export */   getLinkColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getLinkColor),\n/* harmony export */   getLinkRandomColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getLinkRandomColor),\n/* harmony export */   getLogger: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getLogger),\n/* harmony export */   getParticleBaseVelocity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getParticleBaseVelocity),\n/* harmony export */   getParticleDirectionAngle: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getParticleDirectionAngle),\n/* harmony export */   getPosition: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getPosition),\n/* harmony export */   getRandom: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getRandom),\n/* harmony export */   getRandomRgbColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getRandomRgbColor),\n/* harmony export */   getRangeMax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getRangeMax),\n/* harmony export */   getRangeMin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getRangeMin),\n/* harmony export */   getRangeValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getRangeValue),\n/* harmony export */   getSize: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getSize),\n/* harmony export */   getStyleFromHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getStyleFromHsl),\n/* harmony export */   getStyleFromRgb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.getStyleFromRgb),\n/* harmony export */   hMax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hMax),\n/* harmony export */   hMin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hMin),\n/* harmony export */   hPhase: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hPhase),\n/* harmony export */   half: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.half),\n/* harmony export */   hasMatchMedia: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hasMatchMedia),\n/* harmony export */   hslToRgb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hslToRgb),\n/* harmony export */   hslaToRgba: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.hslaToRgba),\n/* harmony export */   identity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.identity),\n/* harmony export */   initParticleNumericAnimationValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.initParticleNumericAnimationValue),\n/* harmony export */   inverseFactorNumerator: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.inverseFactorNumerator),\n/* harmony export */   isArray: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isArray),\n/* harmony export */   isBoolean: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isBoolean),\n/* harmony export */   isDivModeEnabled: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isDivModeEnabled),\n/* harmony export */   isFunction: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isFunction),\n/* harmony export */   isInArray: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isInArray),\n/* harmony export */   isNull: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isNull),\n/* harmony export */   isNumber: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isNumber),\n/* harmony export */   isObject: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isObject),\n/* harmony export */   isPointInside: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isPointInside),\n/* harmony export */   isSsr: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isSsr),\n/* harmony export */   isString: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.isString),\n/* harmony export */   itemFromArray: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.itemFromArray),\n/* harmony export */   itemFromSingleOrMultiple: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.itemFromSingleOrMultiple),\n/* harmony export */   lFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.lFactor),\n/* harmony export */   lMax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.lMax),\n/* harmony export */   lMin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.lMin),\n/* harmony export */   lengthOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.lengthOffset),\n/* harmony export */   loadFont: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.loadFont),\n/* harmony export */   loadMinIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.loadMinIndex),\n/* harmony export */   loadOptions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.loadOptions),\n/* harmony export */   loadParticlesOptions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.loadParticlesOptions),\n/* harmony export */   loadRandomFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.loadRandomFactor),\n/* harmony export */   manualCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.manualCount),\n/* harmony export */   manualDefaultPosition: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.manualDefaultPosition),\n/* harmony export */   midColorValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.midColorValue),\n/* harmony export */   millisecondsToSeconds: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.millisecondsToSeconds),\n/* harmony export */   minCoordinate: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minCoordinate),\n/* harmony export */   minCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minCount),\n/* harmony export */   minFpsLimit: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minFpsLimit),\n/* harmony export */   minIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minIndex),\n/* harmony export */   minLimit: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minLimit),\n/* harmony export */   minRetries: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minRetries),\n/* harmony export */   minStrokeWidth: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minStrokeWidth),\n/* harmony export */   minVelocity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minVelocity),\n/* harmony export */   minZ: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minZ),\n/* harmony export */   minimumLength: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minimumLength),\n/* harmony export */   minimumSize: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.minimumSize),\n/* harmony export */   mix: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mix),\n/* harmony export */   mouseDownEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mouseDownEvent),\n/* harmony export */   mouseLeaveEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mouseLeaveEvent),\n/* harmony export */   mouseMoveEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mouseMoveEvent),\n/* harmony export */   mouseOutEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mouseOutEvent),\n/* harmony export */   mouseUpEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.mouseUpEvent),\n/* harmony export */   none: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.none),\n/* harmony export */   one: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.one),\n/* harmony export */   originPoint: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.originPoint),\n/* harmony export */   paintBase: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.paintBase),\n/* harmony export */   paintImage: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.paintImage),\n/* harmony export */   parseAlpha: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.parseAlpha),\n/* harmony export */   percentDenominator: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.percentDenominator),\n/* harmony export */   phaseNumerator: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.phaseNumerator),\n/* harmony export */   posOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.posOffset),\n/* harmony export */   qTreeCapacity: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.qTreeCapacity),\n/* harmony export */   quarter: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.quarter),\n/* harmony export */   randomColorValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.randomColorValue),\n/* harmony export */   randomInRange: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.randomInRange),\n/* harmony export */   rangeColorToHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rangeColorToHsl),\n/* harmony export */   rangeColorToRgb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rangeColorToRgb),\n/* harmony export */   rectBounce: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rectBounce),\n/* harmony export */   removeDeleteCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.removeDeleteCount),\n/* harmony export */   removeMinIndex: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.removeMinIndex),\n/* harmony export */   resizeEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.resizeEvent),\n/* harmony export */   rgbFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rgbFactor),\n/* harmony export */   rgbMax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rgbMax),\n/* harmony export */   rgbToHsl: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rgbToHsl),\n/* harmony export */   rollFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.rollFactor),\n/* harmony export */   sMax: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.sMax),\n/* harmony export */   sMin: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.sMin),\n/* harmony export */   sNormalizedOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.sNormalizedOffset),\n/* harmony export */   safeIntersectionObserver: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.safeIntersectionObserver),\n/* harmony export */   safeMatchMedia: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.safeMatchMedia),\n/* harmony export */   safeMutationObserver: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.safeMutationObserver),\n/* harmony export */   setAnimationFunctions: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.setAnimationFunctions),\n/* harmony export */   setLogger: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.setLogger),\n/* harmony export */   setRandom: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.setRandom),\n/* harmony export */   setRangeValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.setRangeValue),\n/* harmony export */   sextuple: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.sextuple),\n/* harmony export */   singleDivModeExecute: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.singleDivModeExecute),\n/* harmony export */   sizeFactor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.sizeFactor),\n/* harmony export */   squareExp: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.squareExp),\n/* harmony export */   stringToAlpha: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.stringToAlpha),\n/* harmony export */   stringToRgb: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.stringToRgb),\n/* harmony export */   subdivideCount: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.subdivideCount),\n/* harmony export */   threeQuarter: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.threeQuarter),\n/* harmony export */   touchCancelEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchCancelEvent),\n/* harmony export */   touchDelay: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchDelay),\n/* harmony export */   touchEndEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchEndEvent),\n/* harmony export */   touchEndLengthOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchEndLengthOffset),\n/* harmony export */   touchMoveEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchMoveEvent),\n/* harmony export */   touchStartEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.touchStartEvent),\n/* harmony export */   triple: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.triple),\n/* harmony export */   tryCountIncrement: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.tryCountIncrement),\n/* harmony export */   tsParticles: () => (/* binding */ tsParticles),\n/* harmony export */   updateAnimation: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.updateAnimation),\n/* harmony export */   updateColor: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.updateColor),\n/* harmony export */   updateColorValue: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.updateColorValue),\n/* harmony export */   visibilityChangeEvent: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.visibilityChangeEvent),\n/* harmony export */   zIndexFactorOffset: () => (/* reexport safe */ _exports_js__WEBPACK_IMPORTED_MODULE_2__.zIndexFactorOffset)\n/* harmony export */ });\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./init.js */ \"../../engine/dist/browser/init.js\");\n/* harmony import */ var _Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils/Utils.js */ \"../../engine/dist/browser/Utils/Utils.js\");\n/* harmony import */ var _exports_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./exports.js */ \"../../engine/dist/browser/exports.js\");\n/* harmony import */ var _export_types_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./export-types.js */ \"../../engine/dist/browser/export-types.js\");\n\n\nconst tsParticles = (0,_init_js__WEBPACK_IMPORTED_MODULE_0__.init)();\nif (!(0,_Utils_Utils_js__WEBPACK_IMPORTED_MODULE_1__.isSsr)()) {\n  window.tsParticles = tsParticles;\n}\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../engine/dist/browser/init.js":
/*!*****************************************!*\
  !*** ../../engine/dist/browser/init.js ***!
  \*****************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   init: () => (/* binding */ init)\n/* harmony export */ });\n/* harmony import */ var _Core_Engine_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Core/Engine.js */ \"../../engine/dist/browser/Core/Engine.js\");\n\nfunction init() {\n  const engine = new _Core_Engine_js__WEBPACK_IMPORTED_MODULE_0__.Engine();\n  engine.init();\n  return engine;\n}\n\n//# sourceURL=webpack://tsparticles/../../engine/dist/browser/init.js?\n}");

/***/ }),

/***/ "../../interactions/external/attract/dist/browser/Attractor.js":
/*!*********************************************************************!*\
  !*** ../../interactions/external/attract/dist/browser/Attractor.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Attractor: () => (/* binding */ Attractor)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/external/attract/dist/browser/Utils.js\");\n/* harmony import */ var _Options_Classes_Attract_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Attract.js */ \"../../interactions/external/attract/dist/browser/Options/Classes/Attract.js\");\n\n\n\nconst attractMode = \"attract\";\nclass Attractor extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(engine, container) {\n    super(container);\n    this._engine = engine;\n    if (!container.attract) {\n      container.attract = {\n        particles: []\n      };\n    }\n    this.handleClickMode = mode => {\n      const options = this.container.actualOptions,\n        attract = options.interactivity.modes.attract;\n      if (!attract || mode !== attractMode) {\n        return;\n      }\n      if (!container.attract) {\n        container.attract = {\n          particles: []\n        };\n      }\n      container.attract.clicking = true;\n      container.attract.count = 0;\n      for (const particle of container.attract.particles) {\n        if (!this.isEnabled(particle)) {\n          continue;\n        }\n        particle.velocity.setTo(particle.initialVelocity);\n      }\n      container.attract.particles = [];\n      container.attract.finish = false;\n      setTimeout(() => {\n        if (container.destroyed) {\n          return;\n        }\n        if (!container.attract) {\n          container.attract = {\n            particles: []\n          };\n        }\n        container.attract.clicking = false;\n      }, attract.duration * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds);\n    };\n  }\n  clear() {}\n  init() {\n    const container = this.container,\n      attract = container.actualOptions.interactivity.modes.attract;\n    if (!attract) {\n      return;\n    }\n    container.retina.attractModeDistance = attract.distance * container.retina.pixelRatio;\n  }\n  interact() {\n    const container = this.container,\n      options = container.actualOptions,\n      mouseMoveStatus = container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent,\n      events = options.interactivity.events,\n      {\n        enable: hoverEnabled,\n        mode: hoverMode\n      } = events.onHover,\n      {\n        enable: clickEnabled,\n        mode: clickMode\n      } = events.onClick;\n    if (mouseMoveStatus && hoverEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(attractMode, hoverMode)) {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.hoverAttract)(this._engine, this.container, p => this.isEnabled(p));\n    } else if (clickEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(attractMode, clickMode)) {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.clickAttract)(this._engine, this.container, p => this.isEnabled(p));\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events;\n    if ((!mouse.position || !events.onHover.enable) && (!mouse.clickPosition || !events.onClick.enable)) {\n      return false;\n    }\n    const hoverMode = events.onHover.mode,\n      clickMode = events.onClick.mode;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(attractMode, hoverMode) || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(attractMode, clickMode);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.attract) {\n      options.attract = new _Options_Classes_Attract_js__WEBPACK_IMPORTED_MODULE_2__.Attract();\n    }\n    for (const source of sources) {\n      options.attract.load(source?.attract);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/attract/dist/browser/Attractor.js?\n}");

/***/ }),

/***/ "../../interactions/external/attract/dist/browser/Options/Classes/Attract.js":
/*!***********************************************************************************!*\
  !*** ../../interactions/external/attract/dist/browser/Options/Classes/Attract.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Attract: () => (/* binding */ Attract)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Attract {\n  constructor() {\n    this.distance = 200;\n    this.duration = 0.4;\n    this.easing = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.EasingType.easeOutQuad;\n    this.factor = 1;\n    this.maxSpeed = 50;\n    this.speed = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.duration !== undefined) {\n      this.duration = data.duration;\n    }\n    if (data.easing !== undefined) {\n      this.easing = data.easing;\n    }\n    if (data.factor !== undefined) {\n      this.factor = data.factor;\n    }\n    if (data.maxSpeed !== undefined) {\n      this.maxSpeed = data.maxSpeed;\n    }\n    if (data.speed !== undefined) {\n      this.speed = data.speed;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/attract/dist/browser/Options/Classes/Attract.js?\n}");

/***/ }),

/***/ "../../interactions/external/attract/dist/browser/Options/Interfaces/IAttract.js":
/*!***************************************************************************************!*\
  !*** ../../interactions/external/attract/dist/browser/Options/Interfaces/IAttract.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/attract/dist/browser/Options/Interfaces/IAttract.js?\n}");

/***/ }),

/***/ "../../interactions/external/attract/dist/browser/Utils.js":
/*!*****************************************************************!*\
  !*** ../../interactions/external/attract/dist/browser/Utils.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   clickAttract: () => (/* binding */ clickAttract),\n/* harmony export */   hoverAttract: () => (/* binding */ hoverAttract)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minFactor = 1,\n  identity = 1,\n  minRadius = 0;\nfunction processAttract(engine, container, position, attractRadius, area, queryCb) {\n  const attractOptions = container.actualOptions.interactivity.modes.attract;\n  if (!attractOptions) {\n    return;\n  }\n  const query = container.particles.quadTree.query(area, queryCb);\n  for (const particle of query) {\n    const {\n        dx,\n        dy,\n        distance\n      } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, position),\n      velocity = attractOptions.speed * attractOptions.factor,\n      attractFactor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(engine.getEasing(attractOptions.easing)(identity - distance / attractRadius) * velocity, minFactor, attractOptions.maxSpeed),\n      normVec = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(!distance ? velocity : dx / distance * attractFactor, !distance ? velocity : dy / distance * attractFactor);\n    particle.position.subFrom(normVec);\n  }\n}\nfunction clickAttract(engine, container, enabledCb) {\n  if (!container.attract) {\n    container.attract = {\n      particles: []\n    };\n  }\n  const {\n    attract\n  } = container;\n  if (!attract.finish) {\n    if (!attract.count) {\n      attract.count = 0;\n    }\n    attract.count++;\n    if (attract.count === container.particles.count) {\n      attract.finish = true;\n    }\n  }\n  if (attract.clicking) {\n    const mousePos = container.interactivity.mouse.clickPosition,\n      attractRadius = container.retina.attractModeDistance;\n    if (!attractRadius || attractRadius < minRadius || !mousePos) {\n      return;\n    }\n    processAttract(engine, container, mousePos, attractRadius, new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(mousePos.x, mousePos.y, attractRadius), p => enabledCb(p));\n  } else if (attract.clicking === false) {\n    attract.particles = [];\n  }\n}\nfunction hoverAttract(engine, container, enabledCb) {\n  const mousePos = container.interactivity.mouse.position,\n    attractRadius = container.retina.attractModeDistance;\n  if (!attractRadius || attractRadius < minRadius || !mousePos) {\n    return;\n  }\n  processAttract(engine, container, mousePos, attractRadius, new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(mousePos.x, mousePos.y, attractRadius), p => enabledCb(p));\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/attract/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/external/attract/dist/browser/index.js":
/*!*****************************************************************!*\
  !*** ../../interactions/external/attract/dist/browser/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Attract: () => (/* reexport safe */ _Options_Classes_Attract_js__WEBPACK_IMPORTED_MODULE_1__.Attract),\n/* harmony export */   loadExternalAttractInteraction: () => (/* binding */ loadExternalAttractInteraction)\n/* harmony export */ });\n/* harmony import */ var _Attractor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Attractor.js */ \"../../interactions/external/attract/dist/browser/Attractor.js\");\n/* harmony import */ var _Options_Classes_Attract_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Attract.js */ \"../../interactions/external/attract/dist/browser/Options/Classes/Attract.js\");\n/* harmony import */ var _Options_Interfaces_IAttract_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/IAttract.js */ \"../../interactions/external/attract/dist/browser/Options/Interfaces/IAttract.js\");\n\nasync function loadExternalAttractInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalAttract\", container => {\n    return Promise.resolve(new _Attractor_js__WEBPACK_IMPORTED_MODULE_0__.Attractor(engine, container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/attract/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/bounce/dist/browser/Bouncer.js":
/*!******************************************************************!*\
  !*** ../../interactions/external/bounce/dist/browser/Bouncer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bouncer: () => (/* binding */ Bouncer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/external/bounce/dist/browser/Utils.js\");\n/* harmony import */ var _Options_Classes_Bounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Bounce.js */ \"../../interactions/external/bounce/dist/browser/Options/Classes/Bounce.js\");\n\n\n\nconst bounceMode = \"bounce\";\nclass Bouncer extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n  }\n  clear() {}\n  init() {\n    const container = this.container,\n      bounce = container.actualOptions.interactivity.modes.bounce;\n    if (!bounce) {\n      return;\n    }\n    container.retina.bounceModeDistance = bounce.distance * container.retina.pixelRatio;\n  }\n  interact() {\n    const container = this.container,\n      options = container.actualOptions,\n      events = options.interactivity.events,\n      mouseMoveStatus = container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent,\n      hoverEnabled = events.onHover.enable,\n      hoverMode = events.onHover.mode,\n      divs = events.onDiv;\n    if (mouseMoveStatus && hoverEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bounceMode, hoverMode)) {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.mouseBounce)(this.container, p => this.isEnabled(p));\n    } else {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.divBounce)(this.container, divs, bounceMode, p => this.isEnabled(p));\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events,\n      divs = events.onDiv;\n    return !!mouse.position && events.onHover.enable && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bounceMode, events.onHover.mode) || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isDivModeEnabled)(bounceMode, divs);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.bounce) {\n      options.bounce = new _Options_Classes_Bounce_js__WEBPACK_IMPORTED_MODULE_2__.Bounce();\n    }\n    for (const source of sources) {\n      options.bounce.load(source?.bounce);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bounce/dist/browser/Bouncer.js?\n}");

/***/ }),

/***/ "../../interactions/external/bounce/dist/browser/Options/Classes/Bounce.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/bounce/dist/browser/Options/Classes/Bounce.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bounce: () => (/* binding */ Bounce)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Bounce {\n  constructor() {\n    this.distance = 200;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bounce/dist/browser/Options/Classes/Bounce.js?\n}");

/***/ }),

/***/ "../../interactions/external/bounce/dist/browser/Options/Interfaces/IBounce.js":
/*!*************************************************************************************!*\
  !*** ../../interactions/external/bounce/dist/browser/Options/Interfaces/IBounce.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bounce/dist/browser/Options/Interfaces/IBounce.js?\n}");

/***/ }),

/***/ "../../interactions/external/bounce/dist/browser/Utils.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/bounce/dist/browser/Utils.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   divBounce: () => (/* binding */ divBounce),\n/* harmony export */   mouseBounce: () => (/* binding */ mouseBounce)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst squareExp = 2,\n  half = 0.5,\n  halfPI = Math.PI * half,\n  double = 2,\n  toleranceFactor = 10,\n  minRadius = 0;\nfunction processBounce(container, position, radius, area, enabledCb) {\n  const query = container.particles.quadTree.query(area, enabledCb);\n  for (const particle of query) {\n    if (area instanceof _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle) {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.circleBounce)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.circleBounceDataFromParticle)(particle), {\n        position,\n        radius,\n        mass: radius ** squareExp * halfPI,\n        velocity: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin,\n        factor: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin\n      });\n    } else if (area instanceof _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle) {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rectBounce)(particle, (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calculateBounds)(position, radius));\n    }\n  }\n}\nfunction singleSelectorBounce(container, selector, div, bounceCb) {\n  const query = document.querySelectorAll(selector);\n  if (!query.length) {\n    return;\n  }\n  query.forEach(item => {\n    const elem = item,\n      pxRatio = container.retina.pixelRatio,\n      pos = {\n        x: (elem.offsetLeft + elem.offsetWidth * half) * pxRatio,\n        y: (elem.offsetTop + elem.offsetHeight * half) * pxRatio\n      },\n      radius = elem.offsetWidth * half * pxRatio,\n      tolerance = toleranceFactor * pxRatio,\n      area = div.type === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DivType.circle ? new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos.x, pos.y, radius + tolerance) : new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(elem.offsetLeft * pxRatio - tolerance, elem.offsetTop * pxRatio - tolerance, elem.offsetWidth * pxRatio + tolerance * double, elem.offsetHeight * pxRatio + tolerance * double);\n    bounceCb(pos, radius, area);\n  });\n}\nfunction divBounce(container, divs, bounceMode, enabledCb) {\n  (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divModeExecute)(bounceMode, divs, (selector, div) => singleSelectorBounce(container, selector, div, (pos, radius, area) => processBounce(container, pos, radius, area, enabledCb)));\n}\nfunction mouseBounce(container, enabledCb) {\n  const pxRatio = container.retina.pixelRatio,\n    tolerance = toleranceFactor * pxRatio,\n    mousePos = container.interactivity.mouse.position,\n    radius = container.retina.bounceModeDistance;\n  if (!radius || radius < minRadius || !mousePos) {\n    return;\n  }\n  processBounce(container, mousePos, radius, new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(mousePos.x, mousePos.y, radius + tolerance), enabledCb);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bounce/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/external/bounce/dist/browser/index.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/bounce/dist/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bounce: () => (/* reexport safe */ _Options_Classes_Bounce_js__WEBPACK_IMPORTED_MODULE_1__.Bounce),\n/* harmony export */   loadExternalBounceInteraction: () => (/* binding */ loadExternalBounceInteraction)\n/* harmony export */ });\n/* harmony import */ var _Bouncer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Bouncer.js */ \"../../interactions/external/bounce/dist/browser/Bouncer.js\");\n/* harmony import */ var _Options_Classes_Bounce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Bounce.js */ \"../../interactions/external/bounce/dist/browser/Options/Classes/Bounce.js\");\n/* harmony import */ var _Options_Interfaces_IBounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/IBounce.js */ \"../../interactions/external/bounce/dist/browser/Options/Interfaces/IBounce.js\");\n\nasync function loadExternalBounceInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalBounce\", container => {\n    return Promise.resolve(new _Bouncer_js__WEBPACK_IMPORTED_MODULE_0__.Bouncer(container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bounce/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Bubbler.js":
/*!******************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Bubbler.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubbler: () => (/* binding */ Bubbler)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Bubble.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/Bubble.js\");\n/* harmony import */ var _Enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums.js */ \"../../interactions/external/bubble/dist/browser/Enums.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/external/bubble/dist/browser/Utils.js\");\n\n\n\n\nconst bubbleMode = \"bubble\",\n  minDistance = 0,\n  defaultClickTime = 0,\n  double = 2,\n  defaultOpacity = 1,\n  ratioOffset = 1,\n  defaultBubbleValue = 0,\n  minRatio = 0,\n  half = 0.5,\n  defaultRatio = 1;\nclass Bubbler extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container, engine) {\n    super(container);\n    this._clickBubble = () => {\n      const container = this.container,\n        options = container.actualOptions,\n        mouseClickPos = container.interactivity.mouse.clickPosition,\n        bubbleOptions = options.interactivity.modes.bubble;\n      if (!bubbleOptions || !mouseClickPos) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      const distance = container.retina.bubbleModeDistance;\n      if (!distance || distance < minDistance) {\n        return;\n      }\n      const query = container.particles.quadTree.queryCircle(mouseClickPos, distance, p => this.isEnabled(p)),\n        {\n          bubble\n        } = container;\n      for (const particle of query) {\n        if (!bubble.clicking) {\n          continue;\n        }\n        particle.bubble.inRange = !bubble.durationEnd;\n        const pos = particle.getPosition(),\n          distMouse = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, mouseClickPos),\n          timeSpent = (new Date().getTime() - (container.interactivity.mouse.clickTime ?? defaultClickTime)) / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds;\n        if (timeSpent > bubbleOptions.duration) {\n          bubble.durationEnd = true;\n        }\n        if (timeSpent > bubbleOptions.duration * double) {\n          bubble.clicking = false;\n          bubble.durationEnd = false;\n        }\n        const sizeData = {\n          bubbleObj: {\n            optValue: container.retina.bubbleModeSize,\n            value: particle.bubble.radius\n          },\n          particlesObj: {\n            optValue: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.size.value) * container.retina.pixelRatio,\n            value: particle.size.value\n          },\n          type: _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size\n        };\n        this._process(particle, distMouse, timeSpent, sizeData);\n        const opacityData = {\n          bubbleObj: {\n            optValue: bubbleOptions.opacity,\n            value: particle.bubble.opacity\n          },\n          particlesObj: {\n            optValue: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.opacity.value),\n            value: particle.opacity?.value ?? defaultOpacity\n          },\n          type: _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity\n        };\n        this._process(particle, distMouse, timeSpent, opacityData);\n        if (!bubble.durationEnd && distMouse <= distance) {\n          this._hoverBubbleColor(particle, distMouse);\n        } else {\n          delete particle.bubble.color;\n        }\n      }\n    };\n    this._hoverBubble = () => {\n      const container = this.container,\n        mousePos = container.interactivity.mouse.position,\n        distance = container.retina.bubbleModeDistance;\n      if (!distance || distance < minDistance || !mousePos) {\n        return;\n      }\n      const query = container.particles.quadTree.queryCircle(mousePos, distance, p => this.isEnabled(p));\n      for (const particle of query) {\n        particle.bubble.inRange = true;\n        const pos = particle.getPosition(),\n          pointDistance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, mousePos),\n          ratio = ratioOffset - pointDistance / distance;\n        if (pointDistance <= distance) {\n          if (ratio >= minRatio && container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent) {\n            this._hoverBubbleSize(particle, ratio);\n            this._hoverBubbleOpacity(particle, ratio);\n            this._hoverBubbleColor(particle, ratio);\n          }\n        } else {\n          this.reset(particle);\n        }\n        if (container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseLeaveEvent) {\n          this.reset(particle);\n        }\n      }\n    };\n    this._hoverBubbleColor = (particle, ratio, divBubble) => {\n      const options = this.container.actualOptions,\n        bubbleOptions = divBubble ?? options.interactivity.modes.bubble;\n      if (!bubbleOptions) {\n        return;\n      }\n      if (!particle.bubble.finalColor) {\n        const modeColor = bubbleOptions.color;\n        if (!modeColor) {\n          return;\n        }\n        const bubbleColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(modeColor);\n        particle.bubble.finalColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, bubbleColor);\n      }\n      if (!particle.bubble.finalColor) {\n        return;\n      }\n      if (bubbleOptions.mix) {\n        particle.bubble.color = undefined;\n        const pColor = particle.getFillColor();\n        particle.bubble.color = pColor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rgbToHsl)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.colorMix)(pColor, particle.bubble.finalColor, ratioOffset - ratio, ratio)) : particle.bubble.finalColor;\n      } else {\n        particle.bubble.color = particle.bubble.finalColor;\n      }\n    };\n    this._hoverBubbleOpacity = (particle, ratio, divBubble) => {\n      const container = this.container,\n        options = container.actualOptions,\n        modeOpacity = divBubble?.opacity ?? options.interactivity.modes.bubble?.opacity;\n      if (!modeOpacity) {\n        return;\n      }\n      const optOpacity = particle.options.opacity.value,\n        pOpacity = particle.opacity?.value ?? defaultOpacity,\n        opacity = (0,_Utils_js__WEBPACK_IMPORTED_MODULE_3__.calculateBubbleValue)(pOpacity, modeOpacity, (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(optOpacity), ratio);\n      if (opacity !== undefined) {\n        particle.bubble.opacity = opacity;\n      }\n    };\n    this._hoverBubbleSize = (particle, ratio, divBubble) => {\n      const container = this.container,\n        modeSize = divBubble?.size ? divBubble.size * container.retina.pixelRatio : container.retina.bubbleModeSize;\n      if (modeSize === undefined) {\n        return;\n      }\n      const optSize = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.options.size.value) * container.retina.pixelRatio,\n        pSize = particle.size.value,\n        size = (0,_Utils_js__WEBPACK_IMPORTED_MODULE_3__.calculateBubbleValue)(pSize, modeSize, optSize, ratio);\n      if (size !== undefined) {\n        particle.bubble.radius = size;\n      }\n    };\n    this._process = (particle, distMouse, timeSpent, data) => {\n      const container = this.container,\n        bubbleParam = data.bubbleObj.optValue,\n        options = container.actualOptions,\n        bubbleOptions = options.interactivity.modes.bubble;\n      if (!bubbleOptions || bubbleParam === undefined) {\n        return;\n      }\n      const bubbleDuration = bubbleOptions.duration,\n        bubbleDistance = container.retina.bubbleModeDistance,\n        particlesParam = data.particlesObj.optValue,\n        pObjBubble = data.bubbleObj.value,\n        pObj = data.particlesObj.value ?? defaultBubbleValue,\n        type = data.type;\n      if (!bubbleDistance || bubbleDistance < minDistance || bubbleParam === particlesParam) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      if (container.bubble.durationEnd) {\n        if (pObjBubble) {\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n            delete particle.bubble.radius;\n          }\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n            delete particle.bubble.opacity;\n          }\n        }\n      } else {\n        if (distMouse <= bubbleDistance) {\n          const obj = pObjBubble ?? pObj;\n          if (obj !== bubbleParam) {\n            const value = pObj - timeSpent * (pObj - bubbleParam) / bubbleDuration;\n            if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n              particle.bubble.radius = value;\n            }\n            if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n              particle.bubble.opacity = value;\n            }\n          }\n        } else {\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.size) {\n            delete particle.bubble.radius;\n          }\n          if (type === _Enums_js__WEBPACK_IMPORTED_MODULE_2__.ProcessBubbleType.opacity) {\n            delete particle.bubble.opacity;\n          }\n        }\n      }\n    };\n    this._singleSelectorHover = (delta, selector, div) => {\n      const container = this.container,\n        selectors = document.querySelectorAll(selector),\n        bubble = container.actualOptions.interactivity.modes.bubble;\n      if (!bubble || !selectors.length) {\n        return;\n      }\n      selectors.forEach(item => {\n        const elem = item,\n          pxRatio = container.retina.pixelRatio,\n          pos = {\n            x: (elem.offsetLeft + elem.offsetWidth * half) * pxRatio,\n            y: (elem.offsetTop + elem.offsetHeight * half) * pxRatio\n          },\n          repulseRadius = elem.offsetWidth * half * pxRatio,\n          area = div.type === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DivType.circle ? new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos.x, pos.y, repulseRadius) : new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(elem.offsetLeft * pxRatio, elem.offsetTop * pxRatio, elem.offsetWidth * pxRatio, elem.offsetHeight * pxRatio),\n          query = container.particles.quadTree.query(area, p => this.isEnabled(p));\n        for (const particle of query) {\n          if (!area.contains(particle.getPosition())) {\n            continue;\n          }\n          particle.bubble.inRange = true;\n          const divs = bubble.divs,\n            divBubble = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divMode)(divs, elem);\n          if (!particle.bubble.div || particle.bubble.div !== elem) {\n            this.clear(particle, delta, true);\n            particle.bubble.div = elem;\n          }\n          this._hoverBubbleSize(particle, defaultRatio, divBubble);\n          this._hoverBubbleOpacity(particle, defaultRatio, divBubble);\n          this._hoverBubbleColor(particle, defaultRatio, divBubble);\n        }\n      });\n    };\n    this._engine = engine;\n    if (!container.bubble) {\n      container.bubble = {};\n    }\n    this.handleClickMode = mode => {\n      if (mode !== bubbleMode) {\n        return;\n      }\n      if (!container.bubble) {\n        container.bubble = {};\n      }\n      container.bubble.clicking = true;\n    };\n  }\n  clear(particle, delta, force) {\n    if (particle.bubble.inRange && !force) {\n      return;\n    }\n    delete particle.bubble.div;\n    delete particle.bubble.opacity;\n    delete particle.bubble.radius;\n    delete particle.bubble.color;\n  }\n  init() {\n    const container = this.container,\n      bubble = container.actualOptions.interactivity.modes.bubble;\n    if (!bubble) {\n      return;\n    }\n    container.retina.bubbleModeDistance = bubble.distance * container.retina.pixelRatio;\n    if (bubble.size !== undefined) {\n      container.retina.bubbleModeSize = bubble.size * container.retina.pixelRatio;\n    }\n  }\n  interact(delta) {\n    const options = this.container.actualOptions,\n      events = options.interactivity.events,\n      onHover = events.onHover,\n      onClick = events.onClick,\n      hoverEnabled = onHover.enable,\n      hoverMode = onHover.mode,\n      clickEnabled = onClick.enable,\n      clickMode = onClick.mode,\n      divs = events.onDiv;\n    if (hoverEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, hoverMode)) {\n      this._hoverBubble();\n    } else if (clickEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, clickMode)) {\n      this._clickBubble();\n    } else {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divModeExecute)(bubbleMode, divs, (selector, div) => this._singleSelectorHover(delta, selector, div));\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events,\n      {\n        onClick,\n        onDiv,\n        onHover\n      } = events,\n      divBubble = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isDivModeEnabled)(bubbleMode, onDiv);\n    if (!(divBubble || onHover.enable && !!mouse.position || onClick.enable && mouse.clickPosition)) {\n      return false;\n    }\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, onHover.mode) || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(bubbleMode, onClick.mode) || divBubble;\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.bubble) {\n      options.bubble = new _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_1__.Bubble();\n    }\n    for (const source of sources) {\n      options.bubble.load(source?.bubble);\n    }\n  }\n  reset(particle) {\n    particle.bubble.inRange = false;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Bubbler.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Enums.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Enums.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ProcessBubbleType: () => (/* binding */ ProcessBubbleType)\n/* harmony export */ });\nvar ProcessBubbleType;\n(function (ProcessBubbleType) {\n  ProcessBubbleType[\"color\"] = \"color\";\n  ProcessBubbleType[\"opacity\"] = \"opacity\";\n  ProcessBubbleType[\"size\"] = \"size\";\n})(ProcessBubbleType || (ProcessBubbleType = {}));\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Enums.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Classes/Bubble.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Classes/Bubble.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubble: () => (/* binding */ Bubble)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BubbleBase.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js\");\n/* harmony import */ var _BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BubbleDiv.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/BubbleDiv.js\");\n\n\n\nclass Bubble extends _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase {\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    this.divs = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.divs, div => {\n      const tmp = new _BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__.BubbleDiv();\n      tmp.load(div);\n      return tmp;\n    });\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Classes/Bubble.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js":
/*!*************************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BubbleBase: () => (/* binding */ BubbleBase)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass BubbleBase {\n  constructor() {\n    this.distance = 200;\n    this.duration = 0.4;\n    this.mix = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.duration !== undefined) {\n      this.duration = data.duration;\n    }\n    if (data.mix !== undefined) {\n      this.mix = data.mix;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    if (data.color !== undefined) {\n      const sourceColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(this.color) ? undefined : this.color;\n      this.color = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.color, color => {\n        return _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(sourceColor, color);\n      });\n    }\n    if (data.size !== undefined) {\n      this.size = data.size;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Classes/BubbleDiv.js":
/*!************************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Classes/BubbleDiv.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BubbleDiv: () => (/* binding */ BubbleDiv)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BubbleBase.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js\");\n\n\nclass BubbleDiv extends _BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase {\n  constructor() {\n    super();\n    this.selectors = [];\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.selectors !== undefined) {\n      this.selectors = data.selectors;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Classes/BubbleDiv.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubble.js":
/*!*************************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubble.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubble.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleBase.js":
/*!*****************************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleBase.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleBase.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleDiv.js":
/*!****************************************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleDiv.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleDiv.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/Utils.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/Utils.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   calculateBubbleValue: () => (/* binding */ calculateBubbleValue)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nfunction calculateBubbleValue(particleValue, modeValue, optionsValue, ratio) {\n  if (modeValue >= optionsValue) {\n    const value = particleValue + (modeValue - optionsValue) * ratio;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(value, particleValue, modeValue);\n  } else if (modeValue < optionsValue) {\n    const value = particleValue - (optionsValue - modeValue) * ratio;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(value, modeValue, particleValue);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/external/bubble/dist/browser/index.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/bubble/dist/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Bubble: () => (/* reexport safe */ _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_3__.Bubble),\n/* harmony export */   BubbleBase: () => (/* reexport safe */ _Options_Classes_BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__.BubbleBase),\n/* harmony export */   BubbleDiv: () => (/* reexport safe */ _Options_Classes_BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__.BubbleDiv),\n/* harmony export */   loadExternalBubbleInteraction: () => (/* binding */ loadExternalBubbleInteraction)\n/* harmony export */ });\n/* harmony import */ var _Bubbler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Bubbler.js */ \"../../interactions/external/bubble/dist/browser/Bubbler.js\");\n/* harmony import */ var _Options_Classes_BubbleBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/BubbleBase.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/BubbleBase.js\");\n/* harmony import */ var _Options_Classes_BubbleDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/BubbleDiv.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/BubbleDiv.js\");\n/* harmony import */ var _Options_Classes_Bubble_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Classes/Bubble.js */ \"../../interactions/external/bubble/dist/browser/Options/Classes/Bubble.js\");\n/* harmony import */ var _Options_Interfaces_IBubbleBase_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Interfaces/IBubbleBase.js */ \"../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleBase.js\");\n/* harmony import */ var _Options_Interfaces_IBubbleDiv_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Options/Interfaces/IBubbleDiv.js */ \"../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubbleDiv.js\");\n/* harmony import */ var _Options_Interfaces_IBubble_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Options/Interfaces/IBubble.js */ \"../../interactions/external/bubble/dist/browser/Options/Interfaces/IBubble.js\");\n\nasync function loadExternalBubbleInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalBubble\", container => {\n    return Promise.resolve(new _Bubbler_js__WEBPACK_IMPORTED_MODULE_0__.Bubbler(container, engine));\n  }, refresh);\n}\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/bubble/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Connector.js":
/*!*********************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Connector.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Connector: () => (/* binding */ Connector)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Connect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Connect.js */ \"../../interactions/external/connect/dist/browser/Options/Classes/Connect.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/external/connect/dist/browser/Utils.js\");\n\n\n\nconst connectMode = \"connect\",\n  minDistance = 0;\nclass Connector extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n  }\n  clear() {}\n  init() {\n    const container = this.container,\n      connect = container.actualOptions.interactivity.modes.connect;\n    if (!connect) {\n      return;\n    }\n    container.retina.connectModeDistance = connect.distance * container.retina.pixelRatio;\n    container.retina.connectModeRadius = connect.radius * container.retina.pixelRatio;\n  }\n  interact() {\n    const container = this.container,\n      options = container.actualOptions;\n    if (options.interactivity.events.onHover.enable && container.interactivity.status === \"pointermove\") {\n      const mousePos = container.interactivity.mouse.position,\n        {\n          connectModeDistance,\n          connectModeRadius\n        } = container.retina;\n      if (!connectModeDistance || connectModeDistance < minDistance || !connectModeRadius || connectModeRadius < minDistance || !mousePos) {\n        return;\n      }\n      const distance = Math.abs(connectModeRadius),\n        query = container.particles.quadTree.queryCircle(mousePos, distance, p => this.isEnabled(p));\n      query.forEach((p1, i) => {\n        const pos1 = p1.getPosition(),\n          indexOffset = 1;\n        for (const p2 of query.slice(i + indexOffset)) {\n          const pos2 = p2.getPosition(),\n            distMax = Math.abs(connectModeDistance),\n            xDiff = Math.abs(pos1.x - pos2.x),\n            yDiff = Math.abs(pos1.y - pos2.y);\n          if (xDiff < distMax && yDiff < distMax) {\n            (0,_Utils_js__WEBPACK_IMPORTED_MODULE_2__.drawConnection)(container, p1, p2);\n          }\n        }\n      });\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? container.actualOptions.interactivity).events;\n    if (!(events.onHover.enable && mouse.position)) {\n      return false;\n    }\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(connectMode, events.onHover.mode);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.connect) {\n      options.connect = new _Options_Classes_Connect_js__WEBPACK_IMPORTED_MODULE_1__.Connect();\n    }\n    for (const source of sources) {\n      options.connect.load(source?.connect);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Connector.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Options/Classes/Connect.js":
/*!***********************************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Options/Classes/Connect.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Connect: () => (/* binding */ Connect)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _ConnectLinks_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ConnectLinks.js */ \"../../interactions/external/connect/dist/browser/Options/Classes/ConnectLinks.js\");\n\n\nclass Connect {\n  constructor() {\n    this.distance = 80;\n    this.links = new _ConnectLinks_js__WEBPACK_IMPORTED_MODULE_1__.ConnectLinks();\n    this.radius = 60;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    this.links.load(data.links);\n    if (data.radius !== undefined) {\n      this.radius = data.radius;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Options/Classes/Connect.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Options/Classes/ConnectLinks.js":
/*!****************************************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Options/Classes/ConnectLinks.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConnectLinks: () => (/* binding */ ConnectLinks)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass ConnectLinks {\n  constructor() {\n    this.opacity = 0.5;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Options/Classes/ConnectLinks.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Options/Interfaces/IConnect.js":
/*!***************************************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Options/Interfaces/IConnect.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Options/Interfaces/IConnect.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Options/Interfaces/IConnectLinks.js":
/*!********************************************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Options/Interfaces/IConnectLinks.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Options/Interfaces/IConnectLinks.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/Utils.js":
/*!*****************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/Utils.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawConnectLine: () => (/* binding */ drawConnectLine),\n/* harmony export */   drawConnection: () => (/* binding */ drawConnection),\n/* harmony export */   gradient: () => (/* binding */ gradient),\n/* harmony export */   lineStyle: () => (/* binding */ lineStyle)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst gradientMin = 0,\n  gradientMax = 1,\n  defaultLinksWidth = 0;\nfunction gradient(context, p1, p2, opacity) {\n  const gradStop = Math.floor(p2.getRadius() / p1.getRadius()),\n    color1 = p1.getFillColor(),\n    color2 = p2.getFillColor();\n  if (!color1 || !color2) {\n    return;\n  }\n  const sourcePos = p1.getPosition(),\n    destPos = p2.getPosition(),\n    midRgb = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.colorMix)(color1, color2, p1.getRadius(), p2.getRadius()),\n    grad = context.createLinearGradient(sourcePos.x, sourcePos.y, destPos.x, destPos.y);\n  grad.addColorStop(gradientMin, (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromHsl)(color1, opacity));\n  grad.addColorStop((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(gradStop, gradientMin, gradientMax), (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(midRgb, opacity));\n  grad.addColorStop(gradientMax, (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromHsl)(color2, opacity));\n  return grad;\n}\nfunction drawConnectLine(context, width, lineStyle, begin, end) {\n  (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, end);\n  context.lineWidth = width;\n  context.strokeStyle = lineStyle;\n  context.stroke();\n}\nfunction lineStyle(container, ctx, p1, p2) {\n  const options = container.actualOptions,\n    connectOptions = options.interactivity.modes.connect;\n  if (!connectOptions) {\n    return;\n  }\n  return gradient(ctx, p1, p2, connectOptions.links.opacity);\n}\nfunction drawConnection(container, p1, p2) {\n  container.canvas.draw(ctx => {\n    const ls = lineStyle(container, ctx, p1, p2);\n    if (!ls) {\n      return;\n    }\n    const pos1 = p1.getPosition(),\n      pos2 = p2.getPosition();\n    drawConnectLine(ctx, p1.retina.linksWidth ?? defaultLinksWidth, ls, pos1, pos2);\n  });\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/external/connect/dist/browser/index.js":
/*!*****************************************************************!*\
  !*** ../../interactions/external/connect/dist/browser/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Connect: () => (/* reexport safe */ _Options_Classes_Connect_js__WEBPACK_IMPORTED_MODULE_1__.Connect),\n/* harmony export */   ConnectLinks: () => (/* reexport safe */ _Options_Classes_ConnectLinks_js__WEBPACK_IMPORTED_MODULE_2__.ConnectLinks),\n/* harmony export */   loadExternalConnectInteraction: () => (/* binding */ loadExternalConnectInteraction)\n/* harmony export */ });\n/* harmony import */ var _Connector_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Connector.js */ \"../../interactions/external/connect/dist/browser/Connector.js\");\n/* harmony import */ var _Options_Classes_Connect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Connect.js */ \"../../interactions/external/connect/dist/browser/Options/Classes/Connect.js\");\n/* harmony import */ var _Options_Classes_ConnectLinks_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/ConnectLinks.js */ \"../../interactions/external/connect/dist/browser/Options/Classes/ConnectLinks.js\");\n/* harmony import */ var _Options_Interfaces_IConnect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Interfaces/IConnect.js */ \"../../interactions/external/connect/dist/browser/Options/Interfaces/IConnect.js\");\n/* harmony import */ var _Options_Interfaces_IConnectLinks_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Interfaces/IConnectLinks.js */ \"../../interactions/external/connect/dist/browser/Options/Interfaces/IConnectLinks.js\");\n\nasync function loadExternalConnectInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalConnect\", container => {\n    return Promise.resolve(new _Connector_js__WEBPACK_IMPORTED_MODULE_0__.Connector(container));\n  }, refresh);\n}\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/connect/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Grabber.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Grabber.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Grabber: () => (/* binding */ Grabber)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Grab_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Grab.js */ \"../../interactions/external/grab/dist/browser/Options/Classes/Grab.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/external/grab/dist/browser/Utils.js\");\n\n\n\nconst grabMode = \"grab\",\n  minDistance = 0,\n  minOpacity = 0;\nclass Grabber extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container, engine) {\n    super(container);\n    this._engine = engine;\n  }\n  clear() {}\n  init() {\n    const container = this.container,\n      grab = container.actualOptions.interactivity.modes.grab;\n    if (!grab) {\n      return;\n    }\n    container.retina.grabModeDistance = grab.distance * container.retina.pixelRatio;\n  }\n  interact() {\n    const container = this.container,\n      options = container.actualOptions,\n      interactivity = options.interactivity;\n    if (!interactivity.modes.grab || !interactivity.events.onHover.enable || container.interactivity.status !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent) {\n      return;\n    }\n    const mousePos = container.interactivity.mouse.position;\n    if (!mousePos) {\n      return;\n    }\n    const distance = container.retina.grabModeDistance;\n    if (!distance || distance < minDistance) {\n      return;\n    }\n    const query = container.particles.quadTree.queryCircle(mousePos, distance, p => this.isEnabled(p));\n    for (const particle of query) {\n      const pos = particle.getPosition(),\n        pointDistance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, mousePos);\n      if (pointDistance > distance) {\n        continue;\n      }\n      const grabLineOptions = interactivity.modes.grab.links,\n        lineOpacity = grabLineOptions.opacity,\n        opacityLine = lineOpacity - pointDistance * lineOpacity / distance;\n      if (opacityLine <= minOpacity) {\n        continue;\n      }\n      const optColor = grabLineOptions.color ?? particle.options.links?.color;\n      if (!container.particles.grabLineColor && optColor) {\n        const linksOptions = interactivity.modes.grab.links;\n        container.particles.grabLineColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkRandomColor)(this._engine, optColor, linksOptions.blink, linksOptions.consent);\n      }\n      const colorLine = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkColor)(particle, undefined, container.particles.grabLineColor);\n      if (!colorLine) {\n        continue;\n      }\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_2__.drawGrab)(container, particle, colorLine, opacityLine, mousePos);\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? container.actualOptions.interactivity).events;\n    return events.onHover.enable && !!mouse.position && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(grabMode, events.onHover.mode);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.grab) {\n      options.grab = new _Options_Classes_Grab_js__WEBPACK_IMPORTED_MODULE_1__.Grab();\n    }\n    for (const source of sources) {\n      options.grab.load(source?.grab);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Grabber.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Options/Classes/Grab.js":
/*!*****************************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Options/Classes/Grab.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Grab: () => (/* binding */ Grab)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _GrabLinks_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GrabLinks.js */ \"../../interactions/external/grab/dist/browser/Options/Classes/GrabLinks.js\");\n\n\nclass Grab {\n  constructor() {\n    this.distance = 100;\n    this.links = new _GrabLinks_js__WEBPACK_IMPORTED_MODULE_1__.GrabLinks();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    this.links.load(data.links);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Options/Classes/Grab.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Options/Classes/GrabLinks.js":
/*!**********************************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Options/Classes/GrabLinks.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GrabLinks: () => (/* binding */ GrabLinks)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass GrabLinks {\n  constructor() {\n    this.blink = false;\n    this.consent = false;\n    this.opacity = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.blink !== undefined) {\n      this.blink = data.blink;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.consent !== undefined) {\n      this.consent = data.consent;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Options/Classes/GrabLinks.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Options/Interfaces/IGrab.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Options/Interfaces/IGrab.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Options/Interfaces/IGrab.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Options/Interfaces/IGrabLinks.js":
/*!**************************************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Options/Interfaces/IGrabLinks.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Options/Interfaces/IGrabLinks.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/Utils.js":
/*!**************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/Utils.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawGrab: () => (/* binding */ drawGrab),\n/* harmony export */   drawGrabLine: () => (/* binding */ drawGrabLine)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst defaultWidth = 0;\nfunction drawGrabLine(context, width, begin, end, colorLine, opacity) {\n  (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, end);\n  context.strokeStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(colorLine, opacity);\n  context.lineWidth = width;\n  context.stroke();\n}\nfunction drawGrab(container, particle, lineColor, opacity, mousePos) {\n  container.canvas.draw(ctx => {\n    const beginPos = particle.getPosition();\n    drawGrabLine(ctx, particle.retina.linksWidth ?? defaultWidth, beginPos, mousePos, lineColor, opacity);\n  });\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/external/grab/dist/browser/index.js":
/*!**************************************************************!*\
  !*** ../../interactions/external/grab/dist/browser/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Grab: () => (/* reexport safe */ _Options_Classes_Grab_js__WEBPACK_IMPORTED_MODULE_1__.Grab),\n/* harmony export */   GrabLinks: () => (/* reexport safe */ _Options_Classes_GrabLinks_js__WEBPACK_IMPORTED_MODULE_2__.GrabLinks),\n/* harmony export */   loadExternalGrabInteraction: () => (/* binding */ loadExternalGrabInteraction)\n/* harmony export */ });\n/* harmony import */ var _Grabber_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Grabber.js */ \"../../interactions/external/grab/dist/browser/Grabber.js\");\n/* harmony import */ var _Options_Classes_Grab_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Grab.js */ \"../../interactions/external/grab/dist/browser/Options/Classes/Grab.js\");\n/* harmony import */ var _Options_Classes_GrabLinks_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/GrabLinks.js */ \"../../interactions/external/grab/dist/browser/Options/Classes/GrabLinks.js\");\n/* harmony import */ var _Options_Interfaces_IGrab_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Interfaces/IGrab.js */ \"../../interactions/external/grab/dist/browser/Options/Interfaces/IGrab.js\");\n/* harmony import */ var _Options_Interfaces_IGrabLinks_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Interfaces/IGrabLinks.js */ \"../../interactions/external/grab/dist/browser/Options/Interfaces/IGrabLinks.js\");\n\nasync function loadExternalGrabInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalGrab\", container => {\n    return Promise.resolve(new _Grabber_js__WEBPACK_IMPORTED_MODULE_0__.Grabber(container, engine));\n  }, refresh);\n}\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/grab/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/pause/dist/browser/Pauser.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/pause/dist/browser/Pauser.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Pauser: () => (/* binding */ Pauser)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst pauseMode = \"pause\";\nclass Pauser extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n    this.handleClickMode = mode => {\n      if (mode !== pauseMode) {\n        return;\n      }\n      const container = this.container;\n      if (container.animationStatus) {\n        container.pause();\n      } else {\n        container.play();\n      }\n    };\n  }\n  clear() {}\n  init() {}\n  interact() {}\n  isEnabled() {\n    return true;\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/pause/dist/browser/Pauser.js?\n}");

/***/ }),

/***/ "../../interactions/external/pause/dist/browser/index.js":
/*!***************************************************************!*\
  !*** ../../interactions/external/pause/dist/browser/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadExternalPauseInteraction: () => (/* binding */ loadExternalPauseInteraction)\n/* harmony export */ });\n/* harmony import */ var _Pauser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Pauser.js */ \"../../interactions/external/pause/dist/browser/Pauser.js\");\n\nasync function loadExternalPauseInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalPause\", container => {\n    return Promise.resolve(new _Pauser_js__WEBPACK_IMPORTED_MODULE_0__.Pauser(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/pause/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/push/dist/browser/Options/Classes/Push.js":
/*!*****************************************************************************!*\
  !*** ../../interactions/external/push/dist/browser/Options/Classes/Push.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Push: () => (/* binding */ Push)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Push {\n  constructor() {\n    this.default = true;\n    this.groups = [];\n    this.quantity = 4;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.default !== undefined) {\n      this.default = data.default;\n    }\n    if (data.groups !== undefined) {\n      this.groups = data.groups.map(t => t);\n    }\n    if (!this.groups.length) {\n      this.default = true;\n    }\n    const quantity = data.quantity;\n    if (quantity !== undefined) {\n      this.quantity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(quantity);\n    }\n    this.particles = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.particles, particles => {\n      return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, particles);\n    });\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/push/dist/browser/Options/Classes/Push.js?\n}");

/***/ }),

/***/ "../../interactions/external/push/dist/browser/Options/Interfaces/IPush.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/push/dist/browser/Options/Interfaces/IPush.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/push/dist/browser/Options/Interfaces/IPush.js?\n}");

/***/ }),

/***/ "../../interactions/external/push/dist/browser/Pusher.js":
/*!***************************************************************!*\
  !*** ../../interactions/external/push/dist/browser/Pusher.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Pusher: () => (/* binding */ Pusher)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Push_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Push.js */ \"../../interactions/external/push/dist/browser/Options/Classes/Push.js\");\n\n\nconst pushMode = \"push\",\n  minQuantity = 0;\nclass Pusher extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n    this.handleClickMode = mode => {\n      if (mode !== pushMode) {\n        return;\n      }\n      const container = this.container,\n        options = container.actualOptions,\n        pushOptions = options.interactivity.modes.push;\n      if (!pushOptions) {\n        return;\n      }\n      const quantity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(pushOptions.quantity);\n      if (quantity <= minQuantity) {\n        return;\n      }\n      const group = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromArray)([undefined, ...pushOptions.groups]),\n        groupOptions = group !== undefined ? container.actualOptions.particles.groups[group] : undefined,\n        particlesOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(pushOptions.particles),\n        overrideOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(groupOptions, particlesOptions);\n      void container.particles.push(quantity, container.interactivity.mouse, overrideOptions, group);\n    };\n  }\n  clear() {}\n  init() {}\n  interact() {}\n  isEnabled() {\n    return true;\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.push) {\n      options.push = new _Options_Classes_Push_js__WEBPACK_IMPORTED_MODULE_1__.Push();\n    }\n    for (const source of sources) {\n      options.push.load(source?.push);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/push/dist/browser/Pusher.js?\n}");

/***/ }),

/***/ "../../interactions/external/push/dist/browser/index.js":
/*!**************************************************************!*\
  !*** ../../interactions/external/push/dist/browser/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Push: () => (/* reexport safe */ _Options_Classes_Push_js__WEBPACK_IMPORTED_MODULE_1__.Push),\n/* harmony export */   loadExternalPushInteraction: () => (/* binding */ loadExternalPushInteraction)\n/* harmony export */ });\n/* harmony import */ var _Pusher_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Pusher.js */ \"../../interactions/external/push/dist/browser/Pusher.js\");\n/* harmony import */ var _Options_Classes_Push_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Push.js */ \"../../interactions/external/push/dist/browser/Options/Classes/Push.js\");\n/* harmony import */ var _Options_Interfaces_IPush_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/IPush.js */ \"../../interactions/external/push/dist/browser/Options/Interfaces/IPush.js\");\n\nasync function loadExternalPushInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalPush\", container => {\n    return Promise.resolve(new _Pusher_js__WEBPACK_IMPORTED_MODULE_0__.Pusher(container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/push/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/remove/dist/browser/Options/Classes/Remove.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/remove/dist/browser/Options/Classes/Remove.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Remove: () => (/* binding */ Remove)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Remove {\n  constructor() {\n    this.quantity = 2;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    const quantity = data.quantity;\n    if (quantity !== undefined) {\n      this.quantity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(quantity);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/remove/dist/browser/Options/Classes/Remove.js?\n}");

/***/ }),

/***/ "../../interactions/external/remove/dist/browser/Options/Interfaces/IRemove.js":
/*!*************************************************************************************!*\
  !*** ../../interactions/external/remove/dist/browser/Options/Interfaces/IRemove.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/remove/dist/browser/Options/Interfaces/IRemove.js?\n}");

/***/ }),

/***/ "../../interactions/external/remove/dist/browser/Remover.js":
/*!******************************************************************!*\
  !*** ../../interactions/external/remove/dist/browser/Remover.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Remover: () => (/* binding */ Remover)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Remove_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Remove.js */ \"../../interactions/external/remove/dist/browser/Options/Classes/Remove.js\");\n\n\nconst removeMode = \"remove\";\nclass Remover extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n    this.handleClickMode = mode => {\n      const container = this.container,\n        options = container.actualOptions;\n      if (!options.interactivity.modes.remove || mode !== removeMode) {\n        return;\n      }\n      const removeNb = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(options.interactivity.modes.remove.quantity);\n      container.particles.removeQuantity(removeNb);\n    };\n  }\n  clear() {}\n  init() {}\n  interact() {}\n  isEnabled() {\n    return true;\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.remove) {\n      options.remove = new _Options_Classes_Remove_js__WEBPACK_IMPORTED_MODULE_1__.Remove();\n    }\n    for (const source of sources) {\n      options.remove.load(source?.remove);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/remove/dist/browser/Remover.js?\n}");

/***/ }),

/***/ "../../interactions/external/remove/dist/browser/index.js":
/*!****************************************************************!*\
  !*** ../../interactions/external/remove/dist/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Remove: () => (/* reexport safe */ _Options_Classes_Remove_js__WEBPACK_IMPORTED_MODULE_1__.Remove),\n/* harmony export */   loadExternalRemoveInteraction: () => (/* binding */ loadExternalRemoveInteraction)\n/* harmony export */ });\n/* harmony import */ var _Remover_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Remover.js */ \"../../interactions/external/remove/dist/browser/Remover.js\");\n/* harmony import */ var _Options_Classes_Remove_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Remove.js */ \"../../interactions/external/remove/dist/browser/Options/Classes/Remove.js\");\n/* harmony import */ var _Options_Interfaces_IRemove_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/IRemove.js */ \"../../interactions/external/remove/dist/browser/Options/Interfaces/IRemove.js\");\n\nasync function loadExternalRemoveInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalRemove\", container => {\n    return Promise.resolve(new _Remover_js__WEBPACK_IMPORTED_MODULE_0__.Remover(container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/remove/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Classes/Repulse.js":
/*!***********************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Classes/Repulse.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Repulse: () => (/* binding */ Repulse)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RepulseBase.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js\");\n/* harmony import */ var _RepulseDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./RepulseDiv.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/RepulseDiv.js\");\n\n\n\nclass Repulse extends _RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__.RepulseBase {\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    this.divs = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.divs, div => {\n      const tmp = new _RepulseDiv_js__WEBPACK_IMPORTED_MODULE_2__.RepulseDiv();\n      tmp.load(div);\n      return tmp;\n    });\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Classes/Repulse.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js":
/*!***************************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RepulseBase: () => (/* binding */ RepulseBase)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass RepulseBase {\n  constructor() {\n    this.distance = 200;\n    this.duration = 0.4;\n    this.factor = 100;\n    this.speed = 1;\n    this.maxSpeed = 50;\n    this.easing = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.EasingType.easeOutQuad;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.duration !== undefined) {\n      this.duration = data.duration;\n    }\n    if (data.easing !== undefined) {\n      this.easing = data.easing;\n    }\n    if (data.factor !== undefined) {\n      this.factor = data.factor;\n    }\n    if (data.speed !== undefined) {\n      this.speed = data.speed;\n    }\n    if (data.maxSpeed !== undefined) {\n      this.maxSpeed = data.maxSpeed;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Classes/RepulseDiv.js":
/*!**************************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Classes/RepulseDiv.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RepulseDiv: () => (/* binding */ RepulseDiv)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RepulseBase.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js\");\n\n\nclass RepulseDiv extends _RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__.RepulseBase {\n  constructor() {\n    super();\n    this.selectors = [];\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.selectors !== undefined) {\n      this.selectors = data.selectors;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Classes/RepulseDiv.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulse.js":
/*!***************************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulse.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulse.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseBase.js":
/*!*******************************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseBase.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseBase.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseDiv.js":
/*!******************************************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseDiv.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseDiv.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/Repulser.js":
/*!********************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/Repulser.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Repulser: () => (/* binding */ Repulser)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Repulse_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Repulse.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/Repulse.js\");\n\n\nconst repulseMode = \"repulse\",\n  minDistance = 0,\n  repulseRadiusFactor = 6,\n  repulseRadiusPower = 3,\n  squarePower = 2,\n  minRadius = 0,\n  minSpeed = 0,\n  easingOffset = 1,\n  half = 0.5;\nclass Repulser extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(engine, container) {\n    super(container);\n    this._clickRepulse = () => {\n      const container = this.container,\n        repulseOptions = container.actualOptions.interactivity.modes.repulse;\n      if (!repulseOptions) {\n        return;\n      }\n      const repulse = container.repulse ?? {\n        particles: []\n      };\n      if (!repulse.finish) {\n        if (!repulse.count) {\n          repulse.count = 0;\n        }\n        repulse.count++;\n        if (repulse.count === container.particles.count) {\n          repulse.finish = true;\n        }\n      }\n      if (repulse.clicking) {\n        const repulseDistance = container.retina.repulseModeDistance;\n        if (!repulseDistance || repulseDistance < minDistance) {\n          return;\n        }\n        const repulseRadius = Math.pow(repulseDistance / repulseRadiusFactor, repulseRadiusPower),\n          mouseClickPos = container.interactivity.mouse.clickPosition;\n        if (mouseClickPos === undefined) {\n          return;\n        }\n        const range = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(mouseClickPos.x, mouseClickPos.y, repulseRadius),\n          query = container.particles.quadTree.query(range, p => this.isEnabled(p));\n        for (const particle of query) {\n          const {\n              dx,\n              dy,\n              distance\n            } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(mouseClickPos, particle.position),\n            d = distance ** squarePower,\n            velocity = repulseOptions.speed,\n            force = -repulseRadius * velocity / d;\n          if (d <= repulseRadius) {\n            repulse.particles.push(particle);\n            const vect = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(dx, dy);\n            vect.length = force;\n            particle.velocity.setTo(vect);\n          }\n        }\n      } else if (repulse.clicking === false) {\n        for (const particle of repulse.particles) {\n          particle.velocity.setTo(particle.initialVelocity);\n        }\n        repulse.particles = [];\n      }\n    };\n    this._hoverRepulse = () => {\n      const container = this.container,\n        mousePos = container.interactivity.mouse.position,\n        repulseRadius = container.retina.repulseModeDistance;\n      if (!repulseRadius || repulseRadius < minRadius || !mousePos) {\n        return;\n      }\n      this._processRepulse(mousePos, repulseRadius, new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(mousePos.x, mousePos.y, repulseRadius));\n    };\n    this._processRepulse = (position, repulseRadius, area, divRepulse) => {\n      const container = this.container,\n        query = container.particles.quadTree.query(area, p => this.isEnabled(p)),\n        repulseOptions = container.actualOptions.interactivity.modes.repulse;\n      if (!repulseOptions) {\n        return;\n      }\n      const {\n          easing,\n          speed,\n          factor,\n          maxSpeed\n        } = repulseOptions,\n        easingFunc = this._engine.getEasing(easing),\n        velocity = (divRepulse?.speed ?? speed) * factor;\n      for (const particle of query) {\n        const {\n            dx,\n            dy,\n            distance\n          } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, position),\n          repulseFactor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(easingFunc(easingOffset - distance / repulseRadius) * velocity, minSpeed, maxSpeed),\n          normVec = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(!distance ? velocity : dx / distance * repulseFactor, !distance ? velocity : dy / distance * repulseFactor);\n        particle.position.addTo(normVec);\n      }\n    };\n    this._singleSelectorRepulse = (selector, div) => {\n      const container = this.container,\n        repulse = container.actualOptions.interactivity.modes.repulse;\n      if (!repulse) {\n        return;\n      }\n      const query = document.querySelectorAll(selector);\n      if (!query.length) {\n        return;\n      }\n      query.forEach(item => {\n        const elem = item,\n          pxRatio = container.retina.pixelRatio,\n          pos = {\n            x: (elem.offsetLeft + elem.offsetWidth * half) * pxRatio,\n            y: (elem.offsetTop + elem.offsetHeight * half) * pxRatio\n          },\n          repulseRadius = elem.offsetWidth * half * pxRatio,\n          area = div.type === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DivType.circle ? new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos.x, pos.y, repulseRadius) : new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(elem.offsetLeft * pxRatio, elem.offsetTop * pxRatio, elem.offsetWidth * pxRatio, elem.offsetHeight * pxRatio),\n          divs = repulse.divs,\n          divRepulse = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divMode)(divs, elem);\n        this._processRepulse(pos, repulseRadius, area, divRepulse);\n      });\n    };\n    this._engine = engine;\n    if (!container.repulse) {\n      container.repulse = {\n        particles: []\n      };\n    }\n    this.handleClickMode = mode => {\n      const options = this.container.actualOptions,\n        repulseOpts = options.interactivity.modes.repulse;\n      if (!repulseOpts || mode !== repulseMode) {\n        return;\n      }\n      if (!container.repulse) {\n        container.repulse = {\n          particles: []\n        };\n      }\n      const repulse = container.repulse;\n      repulse.clicking = true;\n      repulse.count = 0;\n      for (const particle of container.repulse.particles) {\n        if (!this.isEnabled(particle)) {\n          continue;\n        }\n        particle.velocity.setTo(particle.initialVelocity);\n      }\n      repulse.particles = [];\n      repulse.finish = false;\n      setTimeout(() => {\n        if (container.destroyed) {\n          return;\n        }\n        repulse.clicking = false;\n      }, repulseOpts.duration * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds);\n    };\n  }\n  clear() {}\n  init() {\n    const container = this.container,\n      repulse = container.actualOptions.interactivity.modes.repulse;\n    if (!repulse) {\n      return;\n    }\n    container.retina.repulseModeDistance = repulse.distance * container.retina.pixelRatio;\n  }\n  interact() {\n    const container = this.container,\n      options = container.actualOptions,\n      mouseMoveStatus = container.interactivity.status === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.mouseMoveEvent,\n      events = options.interactivity.events,\n      hover = events.onHover,\n      hoverEnabled = hover.enable,\n      hoverMode = hover.mode,\n      click = events.onClick,\n      clickEnabled = click.enable,\n      clickMode = click.mode,\n      divs = events.onDiv;\n    if (mouseMoveStatus && hoverEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(repulseMode, hoverMode)) {\n      this._hoverRepulse();\n    } else if (clickEnabled && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(repulseMode, clickMode)) {\n      this._clickRepulse();\n    } else {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.divModeExecute)(repulseMode, divs, (selector, div) => this._singleSelectorRepulse(selector, div));\n    }\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events,\n      divs = events.onDiv,\n      hover = events.onHover,\n      click = events.onClick,\n      divRepulse = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isDivModeEnabled)(repulseMode, divs);\n    if (!(divRepulse || hover.enable && !!mouse.position || click.enable && mouse.clickPosition)) {\n      return false;\n    }\n    const hoverMode = hover.mode,\n      clickMode = click.mode;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(repulseMode, hoverMode) || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(repulseMode, clickMode) || divRepulse;\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.repulse) {\n      options.repulse = new _Options_Classes_Repulse_js__WEBPACK_IMPORTED_MODULE_1__.Repulse();\n    }\n    for (const source of sources) {\n      options.repulse.load(source?.repulse);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/Repulser.js?\n}");

/***/ }),

/***/ "../../interactions/external/repulse/dist/browser/index.js":
/*!*****************************************************************!*\
  !*** ../../interactions/external/repulse/dist/browser/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Repulse: () => (/* reexport safe */ _Options_Classes_Repulse_js__WEBPACK_IMPORTED_MODULE_3__.Repulse),\n/* harmony export */   RepulseBase: () => (/* reexport safe */ _Options_Classes_RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__.RepulseBase),\n/* harmony export */   RepulseDiv: () => (/* reexport safe */ _Options_Classes_RepulseDiv_js__WEBPACK_IMPORTED_MODULE_2__.RepulseDiv),\n/* harmony export */   loadExternalRepulseInteraction: () => (/* binding */ loadExternalRepulseInteraction)\n/* harmony export */ });\n/* harmony import */ var _Repulser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Repulser.js */ \"../../interactions/external/repulse/dist/browser/Repulser.js\");\n/* harmony import */ var _Options_Classes_RepulseBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/RepulseBase.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/RepulseBase.js\");\n/* harmony import */ var _Options_Classes_RepulseDiv_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/RepulseDiv.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/RepulseDiv.js\");\n/* harmony import */ var _Options_Classes_Repulse_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Classes/Repulse.js */ \"../../interactions/external/repulse/dist/browser/Options/Classes/Repulse.js\");\n/* harmony import */ var _Options_Interfaces_IRepulseBase_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Interfaces/IRepulseBase.js */ \"../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseBase.js\");\n/* harmony import */ var _Options_Interfaces_IRepulseDiv_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Options/Interfaces/IRepulseDiv.js */ \"../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulseDiv.js\");\n/* harmony import */ var _Options_Interfaces_IRepulse_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Options/Interfaces/IRepulse.js */ \"../../interactions/external/repulse/dist/browser/Options/Interfaces/IRepulse.js\");\n\nasync function loadExternalRepulseInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalRepulse\", container => {\n    return Promise.resolve(new _Repulser_js__WEBPACK_IMPORTED_MODULE_0__.Repulser(engine, container));\n  }, refresh);\n}\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/repulse/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/slow/dist/browser/Options/Classes/Slow.js":
/*!*****************************************************************************!*\
  !*** ../../interactions/external/slow/dist/browser/Options/Classes/Slow.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Slow: () => (/* binding */ Slow)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Slow {\n  constructor() {\n    this.factor = 3;\n    this.radius = 200;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.factor !== undefined) {\n      this.factor = data.factor;\n    }\n    if (data.radius !== undefined) {\n      this.radius = data.radius;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/slow/dist/browser/Options/Classes/Slow.js?\n}");

/***/ }),

/***/ "../../interactions/external/slow/dist/browser/Options/Interfaces/ISlow.js":
/*!*********************************************************************************!*\
  !*** ../../interactions/external/slow/dist/browser/Options/Interfaces/ISlow.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/slow/dist/browser/Options/Interfaces/ISlow.js?\n}");

/***/ }),

/***/ "../../interactions/external/slow/dist/browser/Slower.js":
/*!***************************************************************!*\
  !*** ../../interactions/external/slow/dist/browser/Slower.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Slower: () => (/* binding */ Slower)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Slow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Slow.js */ \"../../interactions/external/slow/dist/browser/Options/Classes/Slow.js\");\n\n\nconst slowMode = \"slow\",\n  minRadius = 0;\nclass Slower extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n  }\n  clear(particle, delta, force) {\n    if (particle.slow.inRange && !force) {\n      return;\n    }\n    particle.slow.factor = 1;\n  }\n  init() {\n    const container = this.container,\n      slow = container.actualOptions.interactivity.modes.slow;\n    if (!slow) {\n      return;\n    }\n    container.retina.slowModeRadius = slow.radius * container.retina.pixelRatio;\n  }\n  interact() {}\n  isEnabled(particle) {\n    const container = this.container,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? container.actualOptions.interactivity).events;\n    return events.onHover.enable && !!mouse.position && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(slowMode, events.onHover.mode);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.slow) {\n      options.slow = new _Options_Classes_Slow_js__WEBPACK_IMPORTED_MODULE_1__.Slow();\n    }\n    for (const source of sources) {\n      options.slow.load(source?.slow);\n    }\n  }\n  reset(particle) {\n    particle.slow.inRange = false;\n    const container = this.container,\n      options = container.actualOptions,\n      mousePos = container.interactivity.mouse.position,\n      radius = container.retina.slowModeRadius,\n      slowOptions = options.interactivity.modes.slow;\n    if (!slowOptions || !radius || radius < minRadius || !mousePos) {\n      return;\n    }\n    const particlePos = particle.getPosition(),\n      dist = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(mousePos, particlePos),\n      proximityFactor = dist / radius,\n      slowFactor = slowOptions.factor,\n      {\n        slow\n      } = particle;\n    if (dist > radius) {\n      return;\n    }\n    slow.inRange = true;\n    slow.factor = proximityFactor / slowFactor;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/slow/dist/browser/Slower.js?\n}");

/***/ }),

/***/ "../../interactions/external/slow/dist/browser/index.js":
/*!**************************************************************!*\
  !*** ../../interactions/external/slow/dist/browser/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Slow: () => (/* reexport safe */ _Options_Classes_Slow_js__WEBPACK_IMPORTED_MODULE_1__.Slow),\n/* harmony export */   loadExternalSlowInteraction: () => (/* binding */ loadExternalSlowInteraction)\n/* harmony export */ });\n/* harmony import */ var _Slower_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Slower.js */ \"../../interactions/external/slow/dist/browser/Slower.js\");\n/* harmony import */ var _Options_Classes_Slow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Slow.js */ \"../../interactions/external/slow/dist/browser/Options/Classes/Slow.js\");\n/* harmony import */ var _Options_Interfaces_ISlow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/ISlow.js */ \"../../interactions/external/slow/dist/browser/Options/Interfaces/ISlow.js\");\n\nasync function loadExternalSlowInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalSlow\", container => {\n    return Promise.resolve(new _Slower_js__WEBPACK_IMPORTED_MODULE_0__.Slower(container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/slow/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/external/trail/dist/browser/Options/Classes/Trail.js":
/*!*******************************************************************************!*\
  !*** ../../interactions/external/trail/dist/browser/Options/Classes/Trail.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Trail: () => (/* binding */ Trail)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Trail {\n  constructor() {\n    this.delay = 1;\n    this.pauseOnStop = false;\n    this.quantity = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.delay !== undefined) {\n      this.delay = data.delay;\n    }\n    if (data.quantity !== undefined) {\n      this.quantity = data.quantity;\n    }\n    if (data.particles !== undefined) {\n      this.particles = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, data.particles);\n    }\n    if (data.pauseOnStop !== undefined) {\n      this.pauseOnStop = data.pauseOnStop;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/trail/dist/browser/Options/Classes/Trail.js?\n}");

/***/ }),

/***/ "../../interactions/external/trail/dist/browser/Options/Interfaces/ITrail.js":
/*!***********************************************************************************!*\
  !*** ../../interactions/external/trail/dist/browser/Options/Interfaces/ITrail.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/trail/dist/browser/Options/Interfaces/ITrail.js?\n}");

/***/ }),

/***/ "../../interactions/external/trail/dist/browser/TrailMaker.js":
/*!********************************************************************!*\
  !*** ../../interactions/external/trail/dist/browser/TrailMaker.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TrailMaker: () => (/* binding */ TrailMaker)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Trail_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Trail.js */ \"../../interactions/external/trail/dist/browser/Options/Classes/Trail.js\");\n\n\nconst trailMode = \"trail\";\nclass TrailMaker extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ExternalInteractorBase {\n  constructor(container) {\n    super(container);\n    this._delay = 0;\n  }\n  clear() {}\n  init() {}\n  interact(delta) {\n    const container = this.container,\n      {\n        interactivity\n      } = container;\n    if (!container.retina.reduceFactor) {\n      return;\n    }\n    const options = container.actualOptions,\n      trailOptions = options.interactivity.modes.trail;\n    if (!trailOptions) {\n      return;\n    }\n    const optDelay = trailOptions.delay * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / this.container.retina.reduceFactor;\n    if (this._delay < optDelay) {\n      this._delay += delta.value;\n    }\n    if (this._delay < optDelay) {\n      return;\n    }\n    const canEmit = !(trailOptions.pauseOnStop && (interactivity.mouse.position === this._lastPosition || interactivity.mouse.position?.x === this._lastPosition?.x && interactivity.mouse.position?.y === this._lastPosition?.y));\n    const mousePos = container.interactivity.mouse.position;\n    if (mousePos) {\n      this._lastPosition = {\n        ...mousePos\n      };\n    } else {\n      delete this._lastPosition;\n    }\n    if (canEmit) {\n      container.particles.push(trailOptions.quantity, container.interactivity.mouse, trailOptions.particles);\n    }\n    this._delay -= optDelay;\n  }\n  isEnabled(particle) {\n    const container = this.container,\n      options = container.actualOptions,\n      mouse = container.interactivity.mouse,\n      events = (particle?.interactivity ?? options.interactivity).events;\n    return mouse.clicking && mouse.inside && !!mouse.position && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(trailMode, events.onClick.mode) || mouse.inside && !!mouse.position && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(trailMode, events.onHover.mode);\n  }\n  loadModeOptions(options, ...sources) {\n    if (!options.trail) {\n      options.trail = new _Options_Classes_Trail_js__WEBPACK_IMPORTED_MODULE_1__.Trail();\n    }\n    for (const source of sources) {\n      options.trail.load(source?.trail);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/trail/dist/browser/TrailMaker.js?\n}");

/***/ }),

/***/ "../../interactions/external/trail/dist/browser/index.js":
/*!***************************************************************!*\
  !*** ../../interactions/external/trail/dist/browser/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Trail: () => (/* reexport safe */ _Options_Classes_Trail_js__WEBPACK_IMPORTED_MODULE_1__.Trail),\n/* harmony export */   loadExternalTrailInteraction: () => (/* binding */ loadExternalTrailInteraction)\n/* harmony export */ });\n/* harmony import */ var _TrailMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TrailMaker.js */ \"../../interactions/external/trail/dist/browser/TrailMaker.js\");\n/* harmony import */ var _Options_Classes_Trail_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Trail.js */ \"../../interactions/external/trail/dist/browser/Options/Classes/Trail.js\");\n/* harmony import */ var _Options_Interfaces_ITrail_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Interfaces/ITrail.js */ \"../../interactions/external/trail/dist/browser/Options/Interfaces/ITrail.js\");\n\nasync function loadExternalTrailInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"externalTrail\", container => {\n    return Promise.resolve(new _TrailMaker_js__WEBPACK_IMPORTED_MODULE_0__.TrailMaker(container));\n  }, refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/external/trail/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/particles/attract/dist/browser/Attractor.js":
/*!**********************************************************************!*\
  !*** ../../interactions/particles/attract/dist/browser/Attractor.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Attractor: () => (/* binding */ Attractor)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst attractFactor = 1000,\n  identity = 1;\nclass Attractor extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticlesInteractorBase {\n  constructor(container) {\n    super(container);\n  }\n  clear() {}\n  init() {}\n  interact(p1) {\n    const container = this.container;\n    if (p1.attractDistance === undefined) {\n      p1.attractDistance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(p1.options.move.attract.distance) * container.retina.pixelRatio;\n    }\n    const distance = p1.attractDistance,\n      pos1 = p1.getPosition(),\n      query = container.particles.quadTree.queryCircle(pos1, distance);\n    for (const p2 of query) {\n      if (p1 === p2 || !p2.options.move.attract.enable || p2.destroyed || p2.spawning) {\n        continue;\n      }\n      const pos2 = p2.getPosition(),\n        {\n          dx,\n          dy\n        } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(pos1, pos2),\n        rotate = p1.options.move.attract.rotate,\n        ax = dx / (rotate.x * attractFactor),\n        ay = dy / (rotate.y * attractFactor),\n        p1Factor = p2.size.value / p1.size.value,\n        p2Factor = identity / p1Factor;\n      p1.velocity.x -= ax * p1Factor;\n      p1.velocity.y -= ay * p1Factor;\n      p2.velocity.x += ax * p2Factor;\n      p2.velocity.y += ay * p2Factor;\n    }\n  }\n  isEnabled(particle) {\n    return particle.options.move.attract.enable;\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/attract/dist/browser/Attractor.js?\n}");

/***/ }),

/***/ "../../interactions/particles/attract/dist/browser/index.js":
/*!******************************************************************!*\
  !*** ../../interactions/particles/attract/dist/browser/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadParticlesAttractInteraction: () => (/* binding */ loadParticlesAttractInteraction)\n/* harmony export */ });\n/* harmony import */ var _Attractor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Attractor.js */ \"../../interactions/particles/attract/dist/browser/Attractor.js\");\n\nasync function loadParticlesAttractInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"particlesAttract\", container => {\n    return Promise.resolve(new _Attractor_js__WEBPACK_IMPORTED_MODULE_0__.Attractor(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/attract/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/Absorb.js":
/*!**********************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/Absorb.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   absorb: () => (/* binding */ absorb)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst half = 0.5,\n  absorbFactor = 10,\n  minAbsorbFactor = 0;\nfunction updateAbsorb(p1, r1, p2, r2, delta, pixelRatio) {\n  const factor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(p1.options.collisions.absorb.speed * delta.factor / absorbFactor, minAbsorbFactor, r2);\n  p1.size.value += factor * half;\n  p2.size.value -= factor;\n  if (r2 <= pixelRatio) {\n    p2.size.value = 0;\n    p2.destroy();\n  }\n}\nfunction absorb(p1, p2, delta, pixelRatio) {\n  const r1 = p1.getRadius(),\n    r2 = p2.getRadius();\n  if (r1 === undefined && r2 !== undefined) {\n    p1.destroy();\n  } else if (r1 !== undefined && r2 === undefined) {\n    p2.destroy();\n  } else if (r1 !== undefined && r2 !== undefined) {\n    if (r1 >= r2) {\n      updateAbsorb(p1, r1, p2, r2, delta, pixelRatio);\n    } else {\n      updateAbsorb(p2, r2, p1, r1, delta, pixelRatio);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/Absorb.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/Bounce.js":
/*!**********************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/Bounce.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   bounce: () => (/* binding */ bounce)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst fixBounceSpeed = p => {\n  if (p.collisionMaxSpeed === undefined) {\n    p.collisionMaxSpeed = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(p.options.collisions.maxSpeed);\n  }\n  if (p.velocity.length > p.collisionMaxSpeed) {\n    p.velocity.length = p.collisionMaxSpeed;\n  }\n};\nfunction bounce(p1, p2) {\n  (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.circleBounce)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.circleBounceDataFromParticle)(p1), (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.circleBounceDataFromParticle)(p2));\n  fixBounceSpeed(p1);\n  fixBounceSpeed(p2);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/Bounce.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/Collider.js":
/*!************************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/Collider.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Collider: () => (/* binding */ Collider)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _ResolveCollision_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ResolveCollision.js */ \"../../interactions/particles/collisions/dist/browser/ResolveCollision.js\");\n\n\nconst double = 2;\nclass Collider extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticlesInteractorBase {\n  constructor(container) {\n    super(container);\n  }\n  clear() {}\n  init() {}\n  interact(p1, delta) {\n    if (p1.destroyed || p1.spawning) {\n      return;\n    }\n    const container = this.container,\n      pos1 = p1.getPosition(),\n      radius1 = p1.getRadius(),\n      query = container.particles.quadTree.queryCircle(pos1, radius1 * double);\n    for (const p2 of query) {\n      if (p1 === p2 || !p2.options.collisions.enable || p1.options.collisions.mode !== p2.options.collisions.mode || p2.destroyed || p2.spawning) {\n        continue;\n      }\n      const pos2 = p2.getPosition(),\n        radius2 = p2.getRadius();\n      if (Math.abs(Math.round(pos1.z) - Math.round(pos2.z)) > radius1 + radius2) {\n        continue;\n      }\n      const dist = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos1, pos2),\n        distP = radius1 + radius2;\n      if (dist > distP) {\n        continue;\n      }\n      (0,_ResolveCollision_js__WEBPACK_IMPORTED_MODULE_1__.resolveCollision)(p1, p2, delta, container.retina.pixelRatio);\n    }\n  }\n  isEnabled(particle) {\n    return particle.options.collisions.enable;\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/Collider.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/Destroy.js":
/*!***********************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/Destroy.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   destroy: () => (/* binding */ destroy)\n/* harmony export */ });\n/* harmony import */ var _Bounce_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Bounce.js */ \"../../interactions/particles/collisions/dist/browser/Bounce.js\");\n\nfunction destroy(p1, p2) {\n  if (!p1.unbreakable && !p2.unbreakable) {\n    (0,_Bounce_js__WEBPACK_IMPORTED_MODULE_0__.bounce)(p1, p2);\n  }\n  if (p1.getRadius() === undefined && p2.getRadius() !== undefined) {\n    p1.destroy();\n  } else if (p1.getRadius() !== undefined && p2.getRadius() === undefined) {\n    p2.destroy();\n  } else if (p1.getRadius() !== undefined && p2.getRadius() !== undefined) {\n    const deleteP = p1.getRadius() >= p2.getRadius() ? p2 : p1;\n    deleteP.destroy();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/Destroy.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/ResolveCollision.js":
/*!********************************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/ResolveCollision.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   resolveCollision: () => (/* binding */ resolveCollision)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Absorb_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Absorb.js */ \"../../interactions/particles/collisions/dist/browser/Absorb.js\");\n/* harmony import */ var _Bounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Bounce.js */ \"../../interactions/particles/collisions/dist/browser/Bounce.js\");\n/* harmony import */ var _Destroy_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Destroy.js */ \"../../interactions/particles/collisions/dist/browser/Destroy.js\");\n\n\n\n\nfunction resolveCollision(p1, p2, delta, pixelRatio) {\n  switch (p1.options.collisions.mode) {\n    case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.CollisionMode.absorb:\n      {\n        (0,_Absorb_js__WEBPACK_IMPORTED_MODULE_1__.absorb)(p1, p2, delta, pixelRatio);\n        break;\n      }\n    case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.CollisionMode.bounce:\n      {\n        (0,_Bounce_js__WEBPACK_IMPORTED_MODULE_2__.bounce)(p1, p2);\n        break;\n      }\n    case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.CollisionMode.destroy:\n      {\n        (0,_Destroy_js__WEBPACK_IMPORTED_MODULE_3__.destroy)(p1, p2);\n        break;\n      }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/ResolveCollision.js?\n}");

/***/ }),

/***/ "../../interactions/particles/collisions/dist/browser/index.js":
/*!*********************************************************************!*\
  !*** ../../interactions/particles/collisions/dist/browser/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadParticlesCollisionsInteraction: () => (/* binding */ loadParticlesCollisionsInteraction)\n/* harmony export */ });\n/* harmony import */ var _Collider_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collider.js */ \"../../interactions/particles/collisions/dist/browser/Collider.js\");\n\nasync function loadParticlesCollisionsInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addInteractor(\"particlesCollisions\", container => {\n    return Promise.resolve(new _Collider_js__WEBPACK_IMPORTED_MODULE_0__.Collider(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/collisions/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/CircleWarp.js":
/*!*********************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/CircleWarp.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CircleWarp: () => (/* binding */ CircleWarp)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst double = 2;\nclass CircleWarp extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle {\n  constructor(x, y, radius, canvasSize) {\n    super(x, y, radius);\n    this.canvasSize = canvasSize;\n    this.canvasSize = {\n      ...canvasSize\n    };\n  }\n  contains(point) {\n    const {\n        width,\n        height\n      } = this.canvasSize,\n      {\n        x,\n        y\n      } = point;\n    return super.contains(point) || super.contains({\n      x: x - width,\n      y\n    }) || super.contains({\n      x: x - width,\n      y: y - height\n    }) || super.contains({\n      x,\n      y: y - height\n    });\n  }\n  intersects(range) {\n    if (super.intersects(range)) {\n      return true;\n    }\n    const rect = range,\n      circle = range,\n      newPos = {\n        x: range.position.x - this.canvasSize.width,\n        y: range.position.y - this.canvasSize.height\n      };\n    if (circle.radius !== undefined) {\n      const biggerCircle = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(newPos.x, newPos.y, circle.radius * double);\n      return super.intersects(biggerCircle);\n    } else if (rect.size !== undefined) {\n      const rectSW = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(newPos.x, newPos.y, rect.size.width * double, rect.size.height * double);\n      return super.intersects(rectSW);\n    }\n    return false;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/CircleWarp.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/LinkInstance.js":
/*!***********************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/LinkInstance.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinkInstance: () => (/* binding */ LinkInstance)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../interactions/particles/links/dist/browser/Utils.js\");\n\n\nconst minOpacity = 0,\n  minWidth = 0,\n  minDistance = 0,\n  half = 0.5,\n  maxFrequency = 1;\nclass LinkInstance {\n  constructor(container, engine) {\n    this._drawLinkLine = (p1, link) => {\n      const p1LinksOptions = p1.options.links;\n      if (!p1LinksOptions?.enable) {\n        return;\n      }\n      const container = this._container,\n        options = container.actualOptions,\n        p2 = link.destination,\n        pos1 = p1.getPosition(),\n        pos2 = p2.getPosition();\n      let opacity = link.opacity;\n      container.canvas.draw(ctx => {\n        let colorLine;\n        const twinkle = p1.options.twinkle?.lines;\n        if (twinkle?.enable) {\n          const twinkleFreq = twinkle.frequency,\n            twinkleRgb = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, twinkle.color),\n            twinkling = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() < twinkleFreq;\n          if (twinkling && twinkleRgb) {\n            colorLine = twinkleRgb;\n            opacity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(twinkle.opacity);\n          }\n        }\n        if (!colorLine) {\n          const linkColor = p1LinksOptions.id !== undefined ? container.particles.linksColors.get(p1LinksOptions.id) : container.particles.linksColor;\n          colorLine = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkColor)(p1, p2, linkColor);\n        }\n        if (!colorLine) {\n          return;\n        }\n        const width = p1.retina.linksWidth ?? minWidth,\n          maxDistance = p1.retina.linksDistance ?? minDistance,\n          {\n            backgroundMask\n          } = options;\n        (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawLinkLine)({\n          context: ctx,\n          width,\n          begin: pos1,\n          end: pos2,\n          engine: this._engine,\n          maxDistance,\n          canvasSize: container.canvas.size,\n          links: p1LinksOptions,\n          backgroundMask: backgroundMask,\n          colorLine,\n          opacity\n        });\n      });\n    };\n    this._drawLinkTriangle = (p1, link1, link2) => {\n      const linksOptions = p1.options.links;\n      if (!linksOptions?.enable) {\n        return;\n      }\n      const triangleOptions = linksOptions.triangles;\n      if (!triangleOptions.enable) {\n        return;\n      }\n      const container = this._container,\n        options = container.actualOptions,\n        p2 = link1.destination,\n        p3 = link2.destination,\n        opacityTriangle = triangleOptions.opacity ?? (link1.opacity + link2.opacity) * half;\n      if (opacityTriangle <= minOpacity) {\n        return;\n      }\n      container.canvas.draw(ctx => {\n        const pos1 = p1.getPosition(),\n          pos2 = p2.getPosition(),\n          pos3 = p3.getPosition(),\n          linksDistance = p1.retina.linksDistance ?? minDistance;\n        if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos1, pos2) > linksDistance || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos3, pos2) > linksDistance || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos3, pos1) > linksDistance) {\n          return;\n        }\n        let colorTriangle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, triangleOptions.color);\n        if (!colorTriangle) {\n          const linkColor = linksOptions.id !== undefined ? container.particles.linksColors.get(linksOptions.id) : container.particles.linksColor;\n          colorTriangle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkColor)(p1, p2, linkColor);\n        }\n        if (!colorTriangle) {\n          return;\n        }\n        (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawLinkTriangle)({\n          context: ctx,\n          pos1,\n          pos2,\n          pos3,\n          backgroundMask: options.backgroundMask,\n          colorTriangle,\n          opacityTriangle\n        });\n      });\n    };\n    this._drawTriangles = (options, p1, link, p1Links) => {\n      const p2 = link.destination;\n      if (!(options.links?.triangles.enable && p2.options.links?.triangles.enable)) {\n        return;\n      }\n      const vertices = p2.links?.filter(t => {\n        const linkFreq = this._getLinkFrequency(p2, t.destination),\n          minCount = 0;\n        return p2.options.links && linkFreq <= p2.options.links.frequency && p1Links.findIndex(l => l.destination === t.destination) >= minCount;\n      });\n      if (!vertices?.length) {\n        return;\n      }\n      for (const vertex of vertices) {\n        const p3 = vertex.destination,\n          triangleFreq = this._getTriangleFrequency(p1, p2, p3);\n        if (triangleFreq > options.links.triangles.frequency) {\n          continue;\n        }\n        this._drawLinkTriangle(p1, link, vertex);\n      }\n    };\n    this._getLinkFrequency = (p1, p2) => {\n      return (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.setLinkFrequency)([p1, p2], this._freqs.links);\n    };\n    this._getTriangleFrequency = (p1, p2, p3) => {\n      return (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.setLinkFrequency)([p1, p2, p3], this._freqs.triangles);\n    };\n    this._container = container;\n    this._engine = engine;\n    this._freqs = {\n      links: new Map(),\n      triangles: new Map()\n    };\n  }\n  drawParticle(context, particle) {\n    const {\n      links,\n      options\n    } = particle;\n    if (!links?.length) {\n      return;\n    }\n    const p1Links = links.filter(l => options.links && (options.links.frequency >= maxFrequency || this._getLinkFrequency(particle, l.destination) <= options.links.frequency));\n    for (const link of p1Links) {\n      this._drawTriangles(options, particle, link, p1Links);\n      if (link.opacity > minOpacity && (particle.retina.linksWidth ?? minWidth) > minWidth) {\n        this._drawLinkLine(particle, link);\n      }\n    }\n  }\n  async init() {\n    this._freqs.links = new Map();\n    this._freqs.triangles = new Map();\n    await Promise.resolve();\n  }\n  particleCreated(particle) {\n    particle.links = [];\n    if (!particle.options.links) {\n      return;\n    }\n    const ratio = this._container.retina.pixelRatio,\n      {\n        retina\n      } = particle,\n      {\n        distance,\n        width\n      } = particle.options.links;\n    retina.linksDistance = distance * ratio;\n    retina.linksWidth = width * ratio;\n  }\n  particleDestroyed(particle) {\n    particle.links = [];\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/LinkInstance.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Linker.js":
/*!*****************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Linker.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Linker: () => (/* binding */ Linker)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _CircleWarp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CircleWarp.js */ \"../../interactions/particles/links/dist/browser/CircleWarp.js\");\n/* harmony import */ var _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Links.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/Links.js\");\n\n\n\nconst squarePower = 2,\n  opacityOffset = 1,\n  origin = {\n    x: 0,\n    y: 0\n  },\n  minDistance = 0;\nfunction getLinkDistance(pos1, pos2, optDistance, canvasSize, warp) {\n  const {\n    dx,\n    dy,\n    distance\n  } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(pos1, pos2);\n  if (!warp || distance <= optDistance) {\n    return distance;\n  }\n  const absDiffs = {\n      x: Math.abs(dx),\n      y: Math.abs(dy)\n    },\n    warpDistances = {\n      x: Math.min(absDiffs.x, canvasSize.width - absDiffs.x),\n      y: Math.min(absDiffs.y, canvasSize.height - absDiffs.y)\n    };\n  return Math.sqrt(warpDistances.x ** squarePower + warpDistances.y ** squarePower);\n}\nclass Linker extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticlesInteractorBase {\n  constructor(container, engine) {\n    super(container);\n    this._setColor = p1 => {\n      if (!p1.options.links) {\n        return;\n      }\n      const container = this._linkContainer,\n        linksOptions = p1.options.links;\n      let linkColor = linksOptions.id === undefined ? container.particles.linksColor : container.particles.linksColors.get(linksOptions.id);\n      if (linkColor) {\n        return;\n      }\n      const optColor = linksOptions.color;\n      linkColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkRandomColor)(this._engine, optColor, linksOptions.blink, linksOptions.consent);\n      if (linksOptions.id === undefined) {\n        container.particles.linksColor = linkColor;\n      } else {\n        container.particles.linksColors.set(linksOptions.id, linkColor);\n      }\n    };\n    this._linkContainer = container;\n    this._engine = engine;\n  }\n  clear() {}\n  init() {\n    this._linkContainer.particles.linksColor = undefined;\n    this._linkContainer.particles.linksColors = new Map();\n  }\n  interact(p1) {\n    if (!p1.options.links) {\n      return;\n    }\n    p1.links = [];\n    const pos1 = p1.getPosition(),\n      container = this.container,\n      canvasSize = container.canvas.size;\n    if (pos1.x < origin.x || pos1.y < origin.y || pos1.x > canvasSize.width || pos1.y > canvasSize.height) {\n      return;\n    }\n    const linkOpt1 = p1.options.links,\n      optOpacity = linkOpt1.opacity,\n      optDistance = p1.retina.linksDistance ?? minDistance,\n      warp = linkOpt1.warp;\n    let range;\n    if (warp) {\n      range = new _CircleWarp_js__WEBPACK_IMPORTED_MODULE_1__.CircleWarp(pos1.x, pos1.y, optDistance, canvasSize);\n    } else {\n      range = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos1.x, pos1.y, optDistance);\n    }\n    const query = container.particles.quadTree.query(range);\n    for (const p2 of query) {\n      const linkOpt2 = p2.options.links;\n      if (p1 === p2 || !linkOpt2?.enable || linkOpt1.id !== linkOpt2.id || p2.spawning || p2.destroyed || !p2.links || p1.links.some(t => t.destination === p2) || p2.links.some(t => t.destination === p1)) {\n        continue;\n      }\n      const pos2 = p2.getPosition();\n      if (pos2.x < origin.x || pos2.y < origin.y || pos2.x > canvasSize.width || pos2.y > canvasSize.height) {\n        continue;\n      }\n      const distance = getLinkDistance(pos1, pos2, optDistance, canvasSize, warp && linkOpt2.warp);\n      if (distance > optDistance) {\n        continue;\n      }\n      const opacityLine = (opacityOffset - distance / optDistance) * optOpacity;\n      this._setColor(p1);\n      p1.links.push({\n        destination: p2,\n        opacity: opacityLine\n      });\n    }\n  }\n  isEnabled(particle) {\n    return !!particle.options.links?.enable;\n  }\n  loadParticlesOptions(options, ...sources) {\n    if (!options.links) {\n      options.links = new _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__.Links();\n    }\n    for (const source of sources) {\n      options.links.load(source?.links);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Linker.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/LinksPlugin.js":
/*!**********************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/LinksPlugin.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksPlugin: () => (/* binding */ LinksPlugin)\n/* harmony export */ });\n/* harmony import */ var _LinkInstance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LinkInstance.js */ \"../../interactions/particles/links/dist/browser/LinkInstance.js\");\n\nclass LinksPlugin {\n  constructor(engine) {\n    this.id = \"links\";\n    this._engine = engine;\n  }\n  getPlugin(container) {\n    return Promise.resolve(new _LinkInstance_js__WEBPACK_IMPORTED_MODULE_0__.LinkInstance(container, this._engine));\n  }\n  loadOptions() {}\n  needsPlugin() {\n    return true;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/LinksPlugin.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Classes/Links.js":
/*!********************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Classes/Links.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Links: () => (/* binding */ Links)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _LinksShadow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LinksShadow.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/LinksShadow.js\");\n/* harmony import */ var _LinksTriangle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LinksTriangle.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/LinksTriangle.js\");\n\n\n\nclass Links {\n  constructor() {\n    this.blink = false;\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#fff\";\n    this.consent = false;\n    this.distance = 100;\n    this.enable = false;\n    this.frequency = 1;\n    this.opacity = 1;\n    this.shadow = new _LinksShadow_js__WEBPACK_IMPORTED_MODULE_1__.LinksShadow();\n    this.triangles = new _LinksTriangle_js__WEBPACK_IMPORTED_MODULE_2__.LinksTriangle();\n    this.width = 1;\n    this.warp = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.id !== undefined) {\n      this.id = data.id;\n    }\n    if (data.blink !== undefined) {\n      this.blink = data.blink;\n    }\n    this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    if (data.consent !== undefined) {\n      this.consent = data.consent;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.frequency !== undefined) {\n      this.frequency = data.frequency;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    this.shadow.load(data.shadow);\n    this.triangles.load(data.triangles);\n    if (data.width !== undefined) {\n      this.width = data.width;\n    }\n    if (data.warp !== undefined) {\n      this.warp = data.warp;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Classes/Links.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Classes/LinksShadow.js":
/*!**************************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Classes/LinksShadow.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksShadow: () => (/* binding */ LinksShadow)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass LinksShadow {\n  constructor() {\n    this.blur = 5;\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#000\";\n    this.enable = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.blur !== undefined) {\n      this.blur = data.blur;\n    }\n    this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Classes/LinksShadow.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Classes/LinksTriangle.js":
/*!****************************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Classes/LinksTriangle.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksTriangle: () => (/* binding */ LinksTriangle)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass LinksTriangle {\n  constructor() {\n    this.enable = false;\n    this.frequency = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.frequency !== undefined) {\n      this.frequency = data.frequency;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Classes/LinksTriangle.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Interfaces/ILinks.js":
/*!************************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Interfaces/ILinks.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Interfaces/ILinks.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksShadow.js":
/*!******************************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksShadow.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksShadow.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksTriangle.js":
/*!********************************************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksTriangle.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksTriangle.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/Utils.js":
/*!****************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/Utils.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawLinkLine: () => (/* binding */ drawLinkLine),\n/* harmony export */   drawLinkTriangle: () => (/* binding */ drawLinkTriangle),\n/* harmony export */   drawTriangle: () => (/* binding */ drawTriangle),\n/* harmony export */   getLinkKey: () => (/* binding */ getLinkKey),\n/* harmony export */   setLinkFrequency: () => (/* binding */ setLinkFrequency)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nfunction drawTriangle(context, p1, p2, p3) {\n  context.beginPath();\n  context.moveTo(p1.x, p1.y);\n  context.lineTo(p2.x, p2.y);\n  context.lineTo(p3.x, p3.y);\n  context.closePath();\n}\nfunction drawLinkLine(params) {\n  let drawn = false;\n  const {\n    begin,\n    end,\n    engine,\n    maxDistance,\n    context,\n    canvasSize,\n    width,\n    backgroundMask,\n    colorLine,\n    opacity,\n    links\n  } = params;\n  if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(begin, end) <= maxDistance) {\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, end);\n    drawn = true;\n  } else if (links.warp) {\n    let pi1;\n    let pi2;\n    const endNE = {\n      x: end.x - canvasSize.width,\n      y: end.y\n    };\n    const d1 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endNE);\n    if (d1.distance <= maxDistance) {\n      const yi = begin.y - d1.dy / d1.dx * begin.x;\n      pi1 = {\n        x: 0,\n        y: yi\n      };\n      pi2 = {\n        x: canvasSize.width,\n        y: yi\n      };\n    } else {\n      const endSW = {\n        x: end.x,\n        y: end.y - canvasSize.height\n      };\n      const d2 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endSW);\n      if (d2.distance <= maxDistance) {\n        const yi = begin.y - d2.dy / d2.dx * begin.x;\n        const xi = -yi / (d2.dy / d2.dx);\n        pi1 = {\n          x: xi,\n          y: 0\n        };\n        pi2 = {\n          x: xi,\n          y: canvasSize.height\n        };\n      } else {\n        const endSE = {\n          x: end.x - canvasSize.width,\n          y: end.y - canvasSize.height\n        };\n        const d3 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endSE);\n        if (d3.distance <= maxDistance) {\n          const yi = begin.y - d3.dy / d3.dx * begin.x;\n          const xi = -yi / (d3.dy / d3.dx);\n          pi1 = {\n            x: xi,\n            y: yi\n          };\n          pi2 = {\n            x: pi1.x + canvasSize.width,\n            y: pi1.y + canvasSize.height\n          };\n        }\n      }\n    }\n    if (pi1 && pi2) {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, pi1);\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, end, pi2);\n      drawn = true;\n    }\n  }\n  if (!drawn) {\n    return;\n  }\n  context.lineWidth = width;\n  if (backgroundMask.enable) {\n    context.globalCompositeOperation = backgroundMask.composite;\n  }\n  context.strokeStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(colorLine, opacity);\n  const {\n    shadow\n  } = links;\n  if (shadow.enable) {\n    const shadowColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(engine, shadow.color);\n    if (shadowColor) {\n      context.shadowBlur = shadow.blur;\n      context.shadowColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(shadowColor);\n    }\n  }\n  context.stroke();\n}\nfunction drawLinkTriangle(params) {\n  const {\n    context,\n    pos1,\n    pos2,\n    pos3,\n    backgroundMask,\n    colorTriangle,\n    opacityTriangle\n  } = params;\n  drawTriangle(context, pos1, pos2, pos3);\n  if (backgroundMask.enable) {\n    context.globalCompositeOperation = backgroundMask.composite;\n  }\n  context.fillStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(colorTriangle, opacityTriangle);\n  context.fill();\n}\nfunction getLinkKey(ids) {\n  ids.sort((a, b) => a - b);\n  return ids.join(\"_\");\n}\nfunction setLinkFrequency(particles, dictionary) {\n  const key = getLinkKey(particles.map(t => t.id));\n  let res = dictionary.get(key);\n  if (res === undefined) {\n    res = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n    dictionary.set(key, res);\n  }\n  return res;\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/index.js":
/*!****************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Links: () => (/* reexport safe */ _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__.Links),\n/* harmony export */   LinksShadow: () => (/* reexport safe */ _Options_Classes_LinksShadow_js__WEBPACK_IMPORTED_MODULE_3__.LinksShadow),\n/* harmony export */   LinksTriangle: () => (/* reexport safe */ _Options_Classes_LinksTriangle_js__WEBPACK_IMPORTED_MODULE_4__.LinksTriangle),\n/* harmony export */   loadParticlesLinksInteraction: () => (/* binding */ loadParticlesLinksInteraction)\n/* harmony export */ });\n/* harmony import */ var _interaction_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interaction.js */ \"../../interactions/particles/links/dist/browser/interaction.js\");\n/* harmony import */ var _plugin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin.js */ \"../../interactions/particles/links/dist/browser/plugin.js\");\n/* harmony import */ var _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Links.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/Links.js\");\n/* harmony import */ var _Options_Classes_LinksShadow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Classes/LinksShadow.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/LinksShadow.js\");\n/* harmony import */ var _Options_Classes_LinksTriangle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Classes/LinksTriangle.js */ \"../../interactions/particles/links/dist/browser/Options/Classes/LinksTriangle.js\");\n/* harmony import */ var _Options_Interfaces_ILinks_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Options/Interfaces/ILinks.js */ \"../../interactions/particles/links/dist/browser/Options/Interfaces/ILinks.js\");\n/* harmony import */ var _Options_Interfaces_ILinksShadow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Options/Interfaces/ILinksShadow.js */ \"../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksShadow.js\");\n/* harmony import */ var _Options_Interfaces_ILinksTriangle_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Options/Interfaces/ILinksTriangle.js */ \"../../interactions/particles/links/dist/browser/Options/Interfaces/ILinksTriangle.js\");\n\n\nasync function loadParticlesLinksInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await (0,_interaction_js__WEBPACK_IMPORTED_MODULE_0__.loadLinksInteraction)(engine, refresh);\n  await (0,_plugin_js__WEBPACK_IMPORTED_MODULE_1__.loadLinksPlugin)(engine, refresh);\n}\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/interaction.js":
/*!**********************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/interaction.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLinksInteraction: () => (/* binding */ loadLinksInteraction)\n/* harmony export */ });\n/* harmony import */ var _Linker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Linker.js */ \"../../interactions/particles/links/dist/browser/Linker.js\");\n\nasync function loadLinksInteraction(engine, refresh = true) {\n  await engine.addInteractor(\"particlesLinks\", async container => {\n    return Promise.resolve(new _Linker_js__WEBPACK_IMPORTED_MODULE_0__.Linker(container, engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/interaction.js?\n}");

/***/ }),

/***/ "../../interactions/particles/links/dist/browser/plugin.js":
/*!*****************************************************************!*\
  !*** ../../interactions/particles/links/dist/browser/plugin.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLinksPlugin: () => (/* binding */ loadLinksPlugin)\n/* harmony export */ });\n/* harmony import */ var _LinksPlugin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LinksPlugin.js */ \"../../interactions/particles/links/dist/browser/LinksPlugin.js\");\n\nasync function loadLinksPlugin(engine, refresh = true) {\n  const plugin = new _LinksPlugin_js__WEBPACK_IMPORTED_MODULE_0__.LinksPlugin(engine);\n  await engine.addPlugin(plugin, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../interactions/particles/links/dist/browser/plugin.js?\n}");

/***/ }),

/***/ "../../move/base/dist/browser/BaseMover.js":
/*!*************************************************!*\
  !*** ../../move/base/dist/browser/BaseMover.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BaseMover: () => (/* binding */ BaseMover)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../move/base/dist/browser/Utils.js\");\n\n\nconst diffFactor = 2,\n  defaultSizeFactor = 1,\n  defaultDeltaFactor = 1;\nclass BaseMover {\n  init(particle) {\n    const options = particle.options,\n      gravityOptions = options.move.gravity;\n    particle.gravity = {\n      enable: gravityOptions.enable,\n      acceleration: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(gravityOptions.acceleration),\n      inverse: gravityOptions.inverse\n    };\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.initSpin)(particle);\n  }\n  isEnabled(particle) {\n    return !particle.destroyed && particle.options.move.enable;\n  }\n  move(particle, delta) {\n    const particleOptions = particle.options,\n      moveOptions = particleOptions.move;\n    if (!moveOptions.enable) {\n      return;\n    }\n    const container = particle.container,\n      pxRatio = container.retina.pixelRatio;\n    particle.retina.moveSpeed ??= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(moveOptions.speed) * pxRatio;\n    particle.retina.moveDrift ??= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(particle.options.move.drift) * pxRatio;\n    const slowFactor = (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.getProximitySpeedFactor)(particle),\n      reduceFactor = container.retina.reduceFactor,\n      baseSpeed = particle.retina.moveSpeed,\n      moveDrift = particle.retina.moveDrift,\n      maxSize = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particleOptions.size.value) * pxRatio,\n      sizeFactor = moveOptions.size ? particle.getRadius() / maxSize : defaultSizeFactor,\n      deltaFactor = delta.factor || defaultDeltaFactor,\n      moveSpeed = baseSpeed * sizeFactor * slowFactor * deltaFactor / diffFactor,\n      maxSpeed = particle.retina.maxSpeed ?? container.retina.maxSpeed;\n    if (moveOptions.spin.enable) {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.spin)(particle, moveSpeed, reduceFactor);\n    } else {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.move)(particle, moveOptions, moveSpeed, maxSpeed, moveDrift, reduceFactor, delta);\n    }\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.applyDistance)(particle);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../move/base/dist/browser/BaseMover.js?\n}");

/***/ }),

/***/ "../../move/base/dist/browser/Utils.js":
/*!*********************************************!*\
  !*** ../../move/base/dist/browser/Utils.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   applyDistance: () => (/* binding */ applyDistance),\n/* harmony export */   applyPath: () => (/* binding */ applyPath),\n/* harmony export */   getProximitySpeedFactor: () => (/* binding */ getProximitySpeedFactor),\n/* harmony export */   initSpin: () => (/* binding */ initSpin),\n/* harmony export */   move: () => (/* binding */ move),\n/* harmony export */   spin: () => (/* binding */ spin)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst half = 0.5,\n  double = 2,\n  minVelocity = 0,\n  identity = 1,\n  moveSpeedFactor = 60,\n  minSpinRadius = 0,\n  spinFactor = 0.01,\n  doublePI = Math.PI * double;\nfunction applyDistance(particle) {\n  const initialPosition = particle.initialPosition,\n    {\n      dx,\n      dy\n    } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(initialPosition, particle.position),\n    dxFixed = Math.abs(dx),\n    dyFixed = Math.abs(dy),\n    {\n      maxDistance\n    } = particle.retina,\n    hDistance = maxDistance.horizontal,\n    vDistance = maxDistance.vertical;\n  if (!hDistance && !vDistance) {\n    return;\n  }\n  const hasHDistance = (hDistance && dxFixed >= hDistance) ?? false,\n    hasVDistance = (vDistance && dyFixed >= vDistance) ?? false;\n  if ((hasHDistance || hasVDistance) && !particle.misplaced) {\n    particle.misplaced = !!hDistance && dxFixed > hDistance || !!vDistance && dyFixed > vDistance;\n    if (hDistance) {\n      particle.velocity.x = particle.velocity.y * half - particle.velocity.x;\n    }\n    if (vDistance) {\n      particle.velocity.y = particle.velocity.x * half - particle.velocity.y;\n    }\n  } else if ((!hDistance || dxFixed < hDistance) && (!vDistance || dyFixed < vDistance) && particle.misplaced) {\n    particle.misplaced = false;\n  } else if (particle.misplaced) {\n    const pos = particle.position,\n      vel = particle.velocity;\n    if (hDistance && (pos.x < initialPosition.x && vel.x < minVelocity || pos.x > initialPosition.x && vel.x > minVelocity)) {\n      vel.x *= -(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n    }\n    if (vDistance && (pos.y < initialPosition.y && vel.y < minVelocity || pos.y > initialPosition.y && vel.y > minVelocity)) {\n      vel.y *= -(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n    }\n  }\n}\nfunction move(particle, moveOptions, moveSpeed, maxSpeed, moveDrift, reduceFactor, delta) {\n  applyPath(particle, delta);\n  const gravityOptions = particle.gravity,\n    gravityFactor = gravityOptions?.enable && gravityOptions.inverse ? -identity : identity;\n  if (moveDrift && moveSpeed) {\n    particle.velocity.x += moveDrift * delta.factor / (moveSpeedFactor * moveSpeed);\n  }\n  if (gravityOptions?.enable && moveSpeed) {\n    particle.velocity.y += gravityFactor * (gravityOptions.acceleration * delta.factor) / (moveSpeedFactor * moveSpeed);\n  }\n  const decay = particle.moveDecay;\n  particle.velocity.multTo(decay);\n  const velocity = particle.velocity.mult(moveSpeed);\n  if (gravityOptions?.enable && maxSpeed > minVelocity && (!gravityOptions.inverse && velocity.y >= minVelocity && velocity.y >= maxSpeed || gravityOptions.inverse && velocity.y <= minVelocity && velocity.y <= -maxSpeed)) {\n    velocity.y = gravityFactor * maxSpeed;\n    if (moveSpeed) {\n      particle.velocity.y = velocity.y / moveSpeed;\n    }\n  }\n  const zIndexOptions = particle.options.zIndex,\n    zVelocityFactor = (identity - particle.zIndexFactor) ** zIndexOptions.velocityRate;\n  velocity.multTo(zVelocityFactor);\n  velocity.multTo(reduceFactor);\n  const {\n    position\n  } = particle;\n  position.addTo(velocity);\n  if (moveOptions.vibrate) {\n    position.x += Math.sin(position.x * Math.cos(position.y)) * reduceFactor;\n    position.y += Math.cos(position.y * Math.sin(position.x)) * reduceFactor;\n  }\n}\nfunction spin(particle, moveSpeed, reduceFactor) {\n  const container = particle.container;\n  if (!particle.spin) {\n    return;\n  }\n  const spinClockwise = particle.spin.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise,\n    updateFunc = {\n      x: spinClockwise ? Math.cos : Math.sin,\n      y: spinClockwise ? Math.sin : Math.cos\n    };\n  particle.position.x = particle.spin.center.x + particle.spin.radius * updateFunc.x(particle.spin.angle) * reduceFactor;\n  particle.position.y = particle.spin.center.y + particle.spin.radius * updateFunc.y(particle.spin.angle) * reduceFactor;\n  particle.spin.radius += particle.spin.acceleration * reduceFactor;\n  const maxCanvasSize = Math.max(container.canvas.size.width, container.canvas.size.height),\n    halfMaxSize = maxCanvasSize * half;\n  if (particle.spin.radius > halfMaxSize) {\n    particle.spin.radius = halfMaxSize;\n    particle.spin.acceleration *= -identity;\n  } else if (particle.spin.radius < minSpinRadius) {\n    particle.spin.radius = minSpinRadius;\n    particle.spin.acceleration *= -identity;\n  }\n  particle.spin.angle += moveSpeed * spinFactor * (identity - particle.spin.radius / maxCanvasSize);\n}\nfunction applyPath(particle, delta) {\n  const particlesOptions = particle.options,\n    pathOptions = particlesOptions.move.path,\n    pathEnabled = pathOptions.enable;\n  if (!pathEnabled) {\n    return;\n  }\n  if (particle.lastPathTime <= particle.pathDelay) {\n    particle.lastPathTime += delta.value;\n    return;\n  }\n  const path = particle.pathGenerator?.generate(particle, delta);\n  if (path) {\n    particle.velocity.addTo(path);\n  }\n  if (pathOptions.clamp) {\n    particle.velocity.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(particle.velocity.x, -identity, identity);\n    particle.velocity.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.clamp)(particle.velocity.y, -identity, identity);\n  }\n  particle.lastPathTime -= particle.pathDelay;\n}\nfunction getProximitySpeedFactor(particle) {\n  return particle.slow.inRange ? particle.slow.factor : identity;\n}\nfunction initSpin(particle) {\n  const container = particle.container,\n    options = particle.options,\n    spinOptions = options.move.spin;\n  if (!spinOptions.enable) {\n    return;\n  }\n  const spinPos = spinOptions.position ?? {\n      x: 50,\n      y: 50\n    },\n    spinFactor = 0.01,\n    spinCenter = {\n      x: spinPos.x * spinFactor * container.canvas.size.width,\n      y: spinPos.y * spinFactor * container.canvas.size.height\n    },\n    pos = particle.getPosition(),\n    distance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos, spinCenter),\n    spinAcceleration = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(spinOptions.acceleration);\n  particle.retina.spinAcceleration = spinAcceleration * container.retina.pixelRatio;\n  particle.spin = {\n    center: spinCenter,\n    direction: particle.velocity.x >= minVelocity ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise : _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.counterClockwise,\n    angle: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * doublePI,\n    radius: distance,\n    acceleration: particle.retina.spinAcceleration\n  };\n}\n\n//# sourceURL=webpack://tsparticles/../../move/base/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../move/base/dist/browser/index.js":
/*!*********************************************!*\
  !*** ../../move/base/dist/browser/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadBaseMover: () => (/* binding */ loadBaseMover)\n/* harmony export */ });\n/* harmony import */ var _BaseMover_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMover.js */ \"../../move/base/dist/browser/BaseMover.js\");\n\nasync function loadBaseMover(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addMover(\"base\", () => {\n    return Promise.resolve(new _BaseMover_js__WEBPACK_IMPORTED_MODULE_0__.BaseMover());\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../move/base/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../move/parallax/dist/browser/ParallaxMover.js":
/*!*********************************************************!*\
  !*** ../../move/parallax/dist/browser/ParallaxMover.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ParallaxMover: () => (/* binding */ ParallaxMover)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst half = 0.5;\nclass ParallaxMover {\n  init() {}\n  isEnabled(particle) {\n    return !(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isSsr)() && !particle.destroyed && particle.container.actualOptions.interactivity.events.onHover.parallax.enable;\n  }\n  move(particle) {\n    const container = particle.container,\n      options = container.actualOptions,\n      parallaxOptions = options.interactivity.events.onHover.parallax;\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isSsr)() || !parallaxOptions.enable) {\n      return;\n    }\n    const parallaxForce = parallaxOptions.force,\n      mousePos = container.interactivity.mouse.position;\n    if (!mousePos) {\n      return;\n    }\n    const canvasSize = container.canvas.size,\n      canvasCenter = {\n        x: canvasSize.width * half,\n        y: canvasSize.height * half\n      },\n      parallaxSmooth = parallaxOptions.smooth,\n      factor = particle.getRadius() / parallaxForce,\n      centerDistance = {\n        x: (mousePos.x - canvasCenter.x) * factor,\n        y: (mousePos.y - canvasCenter.y) * factor\n      },\n      {\n        offset\n      } = particle;\n    offset.x += (centerDistance.x - offset.x) / parallaxSmooth;\n    offset.y += (centerDistance.y - offset.y) / parallaxSmooth;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../move/parallax/dist/browser/ParallaxMover.js?\n}");

/***/ }),

/***/ "../../move/parallax/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../move/parallax/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadParallaxMover: () => (/* binding */ loadParallaxMover)\n/* harmony export */ });\n/* harmony import */ var _ParallaxMover_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ParallaxMover.js */ \"../../move/parallax/dist/browser/ParallaxMover.js\");\n\nasync function loadParallaxMover(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addMover(\"parallax\", () => {\n    return Promise.resolve(new _ParallaxMover_js__WEBPACK_IMPORTED_MODULE_0__.ParallaxMover());\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../move/parallax/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/AbsorberContainer.js":
/*!*****************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/AbsorberContainer.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/AbsorberContainer.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/AbsorberInstance.js":
/*!****************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/AbsorberInstance.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberInstance: () => (/* binding */ AbsorberInstance)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Absorber.js */ \"../../plugins/absorbers/dist/browser/Options/Classes/Absorber.js\");\n\n\nconst squareExp = 2,\n  absorbFactor = 0.033,\n  minOrbitLength = 0,\n  minRadius = 0,\n  minMass = 0,\n  minAngle = 0,\n  double = 2,\n  maxAngle = Math.PI * double,\n  minVelocity = 0;\nclass AbsorberInstance {\n  constructor(absorbers, container, engine, options, position) {\n    this._calcPosition = () => {\n      const exactPosition = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calcPositionOrRandomFromSizeRanged)({\n        size: this._container.canvas.size,\n        position: this.options.position\n      });\n      return _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(exactPosition.x, exactPosition.y);\n    };\n    this._updateParticlePosition = (particle, v) => {\n      if (particle.destroyed) {\n        return;\n      }\n      const container = this._container,\n        canvasSize = container.canvas.size;\n      if (particle.needsNewPosition) {\n        const newPosition = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calcPositionOrRandomFromSize)({\n          size: canvasSize\n        });\n        particle.position.setTo(newPosition);\n        particle.velocity.setTo(particle.initialVelocity);\n        particle.absorberOrbit = undefined;\n        particle.needsNewPosition = false;\n      }\n      if (this.options.orbits) {\n        if (particle.absorberOrbit === undefined) {\n          particle.absorberOrbit = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n          particle.absorberOrbit.length = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(particle.getPosition(), this.position);\n          particle.absorberOrbit.angle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * maxAngle;\n        }\n        if (particle.absorberOrbit.length <= this.size && !this.options.destroy) {\n          const minSize = Math.min(canvasSize.width, canvasSize.height),\n            offset = 1,\n            randomOffset = 0.1,\n            randomFactor = 0.2;\n          particle.absorberOrbit.length = minSize * (offset + ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * randomFactor - randomOffset));\n        }\n        if (particle.absorberOrbitDirection === undefined) {\n          particle.absorberOrbitDirection = particle.velocity.x >= minVelocity ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise : _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.counterClockwise;\n        }\n        const orbitRadius = particle.absorberOrbit.length,\n          orbitAngle = particle.absorberOrbit.angle,\n          orbitDirection = particle.absorberOrbitDirection;\n        particle.velocity.setTo(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin);\n        const updateFunc = {\n          x: orbitDirection === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise ? Math.cos : Math.sin,\n          y: orbitDirection === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise ? Math.sin : Math.cos\n        };\n        particle.position.x = this.position.x + orbitRadius * updateFunc.x(orbitAngle);\n        particle.position.y = this.position.y + orbitRadius * updateFunc.y(orbitAngle);\n        particle.absorberOrbit.length -= v.length;\n        particle.absorberOrbit.angle += (particle.retina.moveSpeed ?? minVelocity) * container.retina.pixelRatio / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator * container.retina.reduceFactor;\n      } else {\n        const addV = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n        addV.length = v.length;\n        addV.angle = v.angle;\n        particle.velocity.addTo(addV);\n      }\n    };\n    this._absorbers = absorbers;\n    this._container = container;\n    this._engine = engine;\n    this.initialPosition = position ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(position.x, position.y) : undefined;\n    if (options instanceof _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber) {\n      this.options = options;\n    } else {\n      this.options = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n      this.options.load(options);\n    }\n    this.dragging = false;\n    this.name = this.options.name;\n    this.opacity = this.options.opacity;\n    this.size = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.size.value) * container.retina.pixelRatio;\n    this.mass = this.size * this.options.size.density * container.retina.reduceFactor;\n    const limit = this.options.size.limit;\n    this.limit = {\n      radius: limit.radius * container.retina.pixelRatio * container.retina.reduceFactor,\n      mass: limit.mass\n    };\n    this.color = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, this.options.color) ?? {\n      b: 0,\n      g: 0,\n      r: 0\n    };\n    this.position = this.initialPosition?.copy() ?? this._calcPosition();\n  }\n  attract(particle) {\n    const container = this._container,\n      options = this.options;\n    if (options.draggable) {\n      const mouse = container.interactivity.mouse;\n      if (mouse.clicking && mouse.downPosition) {\n        const mouseDist = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(this.position, mouse.downPosition);\n        if (mouseDist <= this.size) {\n          this.dragging = true;\n        }\n      } else {\n        this.dragging = false;\n      }\n      if (this.dragging && mouse.position) {\n        this.position.x = mouse.position.x;\n        this.position.y = mouse.position.y;\n      }\n    }\n    const pos = particle.getPosition(),\n      {\n        dx,\n        dy,\n        distance\n      } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(this.position, pos),\n      v = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(dx, dy);\n    v.length = this.mass / Math.pow(distance, squareExp) * container.retina.reduceFactor;\n    if (distance < this.size + particle.getRadius()) {\n      const sizeFactor = particle.getRadius() * absorbFactor * container.retina.pixelRatio;\n      if (this.size > particle.getRadius() && distance < this.size - particle.getRadius() || particle.absorberOrbit !== undefined && particle.absorberOrbit.length < minOrbitLength) {\n        if (options.destroy) {\n          particle.destroy();\n        } else {\n          particle.needsNewPosition = true;\n          this._updateParticlePosition(particle, v);\n        }\n      } else {\n        if (options.destroy) {\n          particle.size.value -= sizeFactor;\n        }\n        this._updateParticlePosition(particle, v);\n      }\n      if (this.limit.radius <= minRadius || this.size < this.limit.radius) {\n        this.size += sizeFactor;\n      }\n      if (this.limit.mass <= minMass || this.mass < this.limit.mass) {\n        this.mass += sizeFactor * this.options.size.density * container.retina.reduceFactor;\n      }\n    } else {\n      this._updateParticlePosition(particle, v);\n    }\n  }\n  draw(context) {\n    context.translate(this.position.x, this.position.y);\n    context.beginPath();\n    context.arc(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.originPoint.x, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.originPoint.y, this.size, minAngle, maxAngle, false);\n    context.closePath();\n    context.fillStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(this.color, this.opacity);\n    context.fill();\n  }\n  resize() {\n    const initialPosition = this.initialPosition;\n    this.position = initialPosition && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(initialPosition, this._container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin) ? initialPosition : this._calcPosition();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/AbsorberInstance.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/Absorbers.js":
/*!*********************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/Absorbers.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Absorbers: () => (/* binding */ Absorbers)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js\");\n/* harmony import */ var _AbsorberInstance_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbsorberInstance.js */ \"../../plugins/absorbers/dist/browser/AbsorberInstance.js\");\n\n\n\nconst defaultIndex = 0;\nclass Absorbers {\n  constructor(container, engine) {\n    this._container = container;\n    this._engine = engine;\n    this.array = [];\n    this.absorbers = [];\n    this.interactivityAbsorbers = [];\n    container.getAbsorber = idxOrName => idxOrName === undefined || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(idxOrName) ? this.array[idxOrName ?? defaultIndex] : this.array.find(t => t.name === idxOrName);\n    container.addAbsorber = async (options, position) => this.addAbsorber(options, position);\n  }\n  async addAbsorber(options, position) {\n    const absorber = new _AbsorberInstance_js__WEBPACK_IMPORTED_MODULE_2__.AbsorberInstance(this, this._container, this._engine, options, position);\n    this.array.push(absorber);\n    return Promise.resolve(absorber);\n  }\n  draw(context) {\n    for (const absorber of this.array) {\n      absorber.draw(context);\n    }\n  }\n  handleClickMode(mode) {\n    const absorberOptions = this.absorbers,\n      modeAbsorbers = this.interactivityAbsorbers;\n    if (mode === _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberClickMode.absorber) {\n      const absorbersModeOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(modeAbsorbers),\n        absorbersOptions = absorbersModeOptions ?? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(absorberOptions),\n        aPosition = this._container.interactivity.mouse.clickPosition;\n      void this.addAbsorber(absorbersOptions, aPosition);\n    }\n  }\n  async init() {\n    this.absorbers = this._container.actualOptions.absorbers;\n    this.interactivityAbsorbers = this._container.actualOptions.interactivity.modes.absorbers;\n    const promises = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(this.absorbers, async absorber => {\n      await this.addAbsorber(absorber);\n    });\n    if (promises instanceof Array) {\n      await Promise.all(promises);\n    } else {\n      await promises;\n    }\n  }\n  particleUpdate(particle) {\n    for (const absorber of this.array) {\n      absorber.attract(particle);\n      if (particle.destroyed) {\n        break;\n      }\n    }\n  }\n  removeAbsorber(absorber) {\n    const index = this.array.indexOf(absorber),\n      deleteCount = 1;\n    if (index >= defaultIndex) {\n      this.array.splice(index, deleteCount);\n    }\n  }\n  resize() {\n    for (const absorber of this.array) {\n      absorber.resize();\n    }\n  }\n  stop() {\n    this.array = [];\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/Absorbers.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/AbsorbersPlugin.js":
/*!***************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/AbsorbersPlugin.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorbersPlugin: () => (/* binding */ AbsorbersPlugin)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Absorber.js */ \"../../plugins/absorbers/dist/browser/Options/Classes/Absorber.js\");\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js\");\n/* harmony import */ var _Absorbers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Absorbers.js */ \"../../plugins/absorbers/dist/browser/Absorbers.js\");\n\n\n\n\nclass AbsorbersPlugin {\n  constructor(engine) {\n    this.id = \"absorbers\";\n    this._engine = engine;\n  }\n  async getPlugin(container) {\n    return Promise.resolve(new _Absorbers_js__WEBPACK_IMPORTED_MODULE_3__.Absorbers(container, this._engine));\n  }\n  loadOptions(options, source) {\n    if (!this.needsPlugin(options) && !this.needsPlugin(source)) {\n      return;\n    }\n    if (source?.absorbers) {\n      options.absorbers = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(source.absorbers, absorber => {\n        const tmp = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n        tmp.load(absorber);\n        return tmp;\n      });\n    }\n    options.interactivity.modes.absorbers = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(source?.interactivity?.modes?.absorbers, absorber => {\n      const tmp = new _Options_Classes_Absorber_js__WEBPACK_IMPORTED_MODULE_1__.Absorber();\n      tmp.load(absorber);\n      return tmp;\n    });\n  }\n  needsPlugin(options) {\n    if (!options) {\n      return false;\n    }\n    const absorbers = options.absorbers;\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(absorbers)) {\n      return !!absorbers.length;\n    } else if (absorbers) {\n      return true;\n    } else if (options.interactivity?.events?.onClick?.mode && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(_Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__.AbsorberClickMode.absorber, options.interactivity.events.onClick.mode)) {\n      return true;\n    }\n    return false;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/AbsorbersPlugin.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js":
/*!***********************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberClickMode: () => (/* binding */ AbsorberClickMode)\n/* harmony export */ });\nvar AbsorberClickMode;\n(function (AbsorberClickMode) {\n  AbsorberClickMode[\"absorber\"] = \"absorber\";\n})(AbsorberClickMode || (AbsorberClickMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/Options/Classes/Absorber.js":
/*!************************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/Options/Classes/Absorber.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Absorber: () => (/* binding */ Absorber)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _AbsorberSize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AbsorberSize.js */ \"../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSize.js\");\n\n\nclass Absorber {\n  constructor() {\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#000000\";\n    this.draggable = false;\n    this.opacity = 1;\n    this.destroy = true;\n    this.orbits = false;\n    this.size = new _AbsorberSize_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberSize();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.draggable !== undefined) {\n      this.draggable = data.draggable;\n    }\n    this.name = data.name;\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    if (data.position !== undefined) {\n      this.position = {};\n      if (data.position.x !== undefined) {\n        this.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.x);\n      }\n      if (data.position.y !== undefined) {\n        this.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.y);\n      }\n    }\n    if (data.size !== undefined) {\n      this.size.load(data.size);\n    }\n    if (data.destroy !== undefined) {\n      this.destroy = data.destroy;\n    }\n    if (data.orbits !== undefined) {\n      this.orbits = data.orbits;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/Options/Classes/Absorber.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSize.js":
/*!****************************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSize.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberSize: () => (/* binding */ AbsorberSize)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _AbsorberSizeLimit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AbsorberSizeLimit.js */ \"../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSizeLimit.js\");\n\n\nclass AbsorberSize extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.density = 5;\n    this.value = 50;\n    this.limit = new _AbsorberSizeLimit_js__WEBPACK_IMPORTED_MODULE_1__.AbsorberSizeLimit();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    if (data.density !== undefined) {\n      this.density = data.density;\n    }\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(data.limit)) {\n      this.limit.radius = data.limit;\n    } else {\n      this.limit.load(data.limit);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSize.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSizeLimit.js":
/*!*********************************************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSizeLimit.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberSizeLimit: () => (/* binding */ AbsorberSizeLimit)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass AbsorberSizeLimit {\n  constructor() {\n    this.radius = 0;\n    this.mass = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.mass !== undefined) {\n      this.mass = data.mass;\n    }\n    if (data.radius !== undefined) {\n      this.radius = data.radius;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/Options/Classes/AbsorberSizeLimit.js?\n}");

/***/ }),

/***/ "../../plugins/absorbers/dist/browser/index.js":
/*!*****************************************************!*\
  !*** ../../plugins/absorbers/dist/browser/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AbsorberClickMode: () => (/* reexport safe */ _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__.AbsorberClickMode),\n/* harmony export */   loadAbsorbersPlugin: () => (/* binding */ loadAbsorbersPlugin)\n/* harmony export */ });\n/* harmony import */ var _AbsorbersPlugin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AbsorbersPlugin.js */ \"../../plugins/absorbers/dist/browser/AbsorbersPlugin.js\");\n/* harmony import */ var _AbsorberContainer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AbsorberContainer.js */ \"../../plugins/absorbers/dist/browser/AbsorberContainer.js\");\n/* harmony import */ var _Enums_AbsorberClickMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/AbsorberClickMode.js */ \"../../plugins/absorbers/dist/browser/Enums/AbsorberClickMode.js\");\n\nasync function loadAbsorbersPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addPlugin(new _AbsorbersPlugin_js__WEBPACK_IMPORTED_MODULE_0__.AbsorbersPlugin(engine), refresh);\n}\n\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/absorbers/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/colors/hexColor/dist/browser/HexColorManager.js":
/*!*********************************************************************!*\
  !*** ../../plugins/colors/hexColor/dist/browser/HexColorManager.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   HexColorManager: () => (/* binding */ HexColorManager)\n/* harmony export */ });\nvar RgbIndexes;\n(function (RgbIndexes) {\n  RgbIndexes[RgbIndexes[\"r\"] = 1] = \"r\";\n  RgbIndexes[RgbIndexes[\"g\"] = 2] = \"g\";\n  RgbIndexes[RgbIndexes[\"b\"] = 3] = \"b\";\n  RgbIndexes[RgbIndexes[\"a\"] = 4] = \"a\";\n})(RgbIndexes || (RgbIndexes = {}));\nconst shorthandHexRegex = /^#?([a-f\\d])([a-f\\d])([a-f\\d])([a-f\\d])?$/i,\n  hexRegex = /^#?([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})?$/i,\n  hexRadix = 16,\n  defaultAlpha = 1,\n  alphaFactor = 0xff;\nclass HexColorManager {\n  constructor() {\n    this.key = \"hex\";\n    this.stringPrefix = \"#\";\n  }\n  handleColor(color) {\n    return this._parseString(color.value);\n  }\n  handleRangeColor(color) {\n    return this._parseString(color.value);\n  }\n  parseString(input) {\n    return this._parseString(input);\n  }\n  _parseString(hexColor) {\n    if (typeof hexColor !== \"string\") {\n      return;\n    }\n    if (!hexColor?.startsWith(this.stringPrefix)) {\n      return;\n    }\n    const hexFixed = hexColor.replace(shorthandHexRegex, (_, r, g, b, a) => {\n        return r + r + g + g + b + b + (a !== undefined ? a + a : \"\");\n      }),\n      result = hexRegex.exec(hexFixed);\n    return result ? {\n      a: result[RgbIndexes.a] !== undefined ? parseInt(result[RgbIndexes.a], hexRadix) / alphaFactor : defaultAlpha,\n      b: parseInt(result[RgbIndexes.b], hexRadix),\n      g: parseInt(result[RgbIndexes.g], hexRadix),\n      r: parseInt(result[RgbIndexes.r], hexRadix)\n    } : undefined;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/hexColor/dist/browser/HexColorManager.js?\n}");

/***/ }),

/***/ "../../plugins/colors/hexColor/dist/browser/index.js":
/*!***********************************************************!*\
  !*** ../../plugins/colors/hexColor/dist/browser/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadHexColorPlugin: () => (/* binding */ loadHexColorPlugin)\n/* harmony export */ });\n/* harmony import */ var _HexColorManager_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./HexColorManager.js */ \"../../plugins/colors/hexColor/dist/browser/HexColorManager.js\");\n\nasync function loadHexColorPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addColorManager(new _HexColorManager_js__WEBPACK_IMPORTED_MODULE_0__.HexColorManager(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/hexColor/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/colors/hslColor/dist/browser/HslColorManager.js":
/*!*********************************************************************!*\
  !*** ../../plugins/colors/hslColor/dist/browser/HslColorManager.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   HslColorManager: () => (/* binding */ HslColorManager)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nvar HslIndexes;\n(function (HslIndexes) {\n  HslIndexes[HslIndexes[\"h\"] = 1] = \"h\";\n  HslIndexes[HslIndexes[\"s\"] = 2] = \"s\";\n  HslIndexes[HslIndexes[\"l\"] = 3] = \"l\";\n  HslIndexes[HslIndexes[\"a\"] = 5] = \"a\";\n})(HslIndexes || (HslIndexes = {}));\nclass HslColorManager {\n  constructor() {\n    this.key = \"hsl\";\n    this.stringPrefix = \"hsl\";\n  }\n  handleColor(color) {\n    const colorValue = color.value,\n      hslColor = colorValue.hsl ?? color.value;\n    if (hslColor.h !== undefined && hslColor.s !== undefined && hslColor.l !== undefined) {\n      return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.hslToRgb)(hslColor);\n    }\n  }\n  handleRangeColor(color) {\n    const colorValue = color.value,\n      hslColor = colorValue.hsl ?? color.value;\n    if (hslColor.h !== undefined && hslColor.l !== undefined) {\n      return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.hslToRgb)({\n        h: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(hslColor.h),\n        l: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(hslColor.l),\n        s: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(hslColor.s)\n      });\n    }\n  }\n  parseString(input) {\n    if (!input.startsWith(\"hsl\")) {\n      return;\n    }\n    const regex = /hsla?\\(\\s*(\\d+)\\s*[\\s,]\\s*(\\d+)%\\s*[\\s,]\\s*(\\d+)%\\s*([\\s,]\\s*(0|1|0?\\.\\d+|(\\d{1,3})%)\\s*)?\\)/i,\n      result = regex.exec(input),\n      minLength = 4,\n      defaultAlpha = 1,\n      radix = 10;\n    return result ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.hslaToRgba)({\n      a: result.length > minLength ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.parseAlpha)(result[HslIndexes.a]) : defaultAlpha,\n      h: parseInt(result[HslIndexes.h], radix),\n      l: parseInt(result[HslIndexes.l], radix),\n      s: parseInt(result[HslIndexes.s], radix)\n    }) : undefined;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/hslColor/dist/browser/HslColorManager.js?\n}");

/***/ }),

/***/ "../../plugins/colors/hslColor/dist/browser/index.js":
/*!***********************************************************!*\
  !*** ../../plugins/colors/hslColor/dist/browser/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadHslColorPlugin: () => (/* binding */ loadHslColorPlugin)\n/* harmony export */ });\n/* harmony import */ var _HslColorManager_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./HslColorManager.js */ \"../../plugins/colors/hslColor/dist/browser/HslColorManager.js\");\n\nasync function loadHslColorPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addColorManager(new _HslColorManager_js__WEBPACK_IMPORTED_MODULE_0__.HslColorManager(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/hslColor/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/colors/rgbColor/dist/browser/RgbColorManager.js":
/*!*********************************************************************!*\
  !*** ../../plugins/colors/rgbColor/dist/browser/RgbColorManager.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RgbColorManager: () => (/* binding */ RgbColorManager)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nvar RgbIndexes;\n(function (RgbIndexes) {\n  RgbIndexes[RgbIndexes[\"r\"] = 1] = \"r\";\n  RgbIndexes[RgbIndexes[\"g\"] = 2] = \"g\";\n  RgbIndexes[RgbIndexes[\"b\"] = 3] = \"b\";\n  RgbIndexes[RgbIndexes[\"a\"] = 5] = \"a\";\n})(RgbIndexes || (RgbIndexes = {}));\nclass RgbColorManager {\n  constructor() {\n    this.key = \"rgb\";\n    this.stringPrefix = \"rgb\";\n  }\n  handleColor(color) {\n    const colorValue = color.value,\n      rgbColor = colorValue.rgb ?? color.value;\n    if (rgbColor.r !== undefined) {\n      return rgbColor;\n    }\n  }\n  handleRangeColor(color) {\n    const colorValue = color.value,\n      rgbColor = colorValue.rgb ?? color.value;\n    if (rgbColor.r !== undefined) {\n      return {\n        r: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rgbColor.r),\n        g: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rgbColor.g),\n        b: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rgbColor.b)\n      };\n    }\n  }\n  parseString(input) {\n    if (!input.startsWith(this.stringPrefix)) {\n      return;\n    }\n    const regex = /rgba?\\(\\s*(\\d{1,3})\\s*[\\s,]\\s*(\\d{1,3})\\s*[\\s,]\\s*(\\d{1,3})\\s*([\\s,]\\s*(0|1|0?\\.\\d+|(\\d{1,3})%)\\s*)?\\)/i,\n      result = regex.exec(input),\n      radix = 10,\n      minLength = 4,\n      defaultAlpha = 1;\n    return result ? {\n      a: result.length > minLength ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.parseAlpha)(result[RgbIndexes.a]) : defaultAlpha,\n      b: parseInt(result[RgbIndexes.b], radix),\n      g: parseInt(result[RgbIndexes.g], radix),\n      r: parseInt(result[RgbIndexes.r], radix)\n    } : undefined;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/rgbColor/dist/browser/RgbColorManager.js?\n}");

/***/ }),

/***/ "../../plugins/colors/rgbColor/dist/browser/index.js":
/*!***********************************************************!*\
  !*** ../../plugins/colors/rgbColor/dist/browser/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadRgbColorPlugin: () => (/* binding */ loadRgbColorPlugin)\n/* harmony export */ });\n/* harmony import */ var _RgbColorManager_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RgbColorManager.js */ \"../../plugins/colors/rgbColor/dist/browser/RgbColorManager.js\");\n\nasync function loadRgbColorPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addColorManager(new _RgbColorManager_js__WEBPACK_IMPORTED_MODULE_0__.RgbColorManager(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/colors/rgbColor/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/easings/quad/dist/browser/index.js":
/*!********************************************************!*\
  !*** ../../plugins/easings/quad/dist/browser/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadEasingQuadPlugin: () => (/* binding */ loadEasingQuadPlugin)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nasync function loadEasingQuadPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addEasing(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.EasingType.easeInQuad, value => value ** 2, false);\n  await engine.addEasing(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.EasingType.easeOutQuad, value => 1 - (1 - value) ** 2, false);\n  await engine.addEasing(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.EasingType.easeInOutQuad, value => value < 0.5 ? 2 * value ** 2 : 1 - (-2 * value + 2) ** 2 / 2, false);\n  await engine.refresh(refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/easings/quad/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/EmitterContainer.js":
/*!***************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/EmitterContainer.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/EmitterContainer.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/EmitterInstance.js":
/*!**************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/EmitterInstance.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterInstance: () => (/* binding */ EmitterInstance)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Emitter.js */ \"../../plugins/emitters/dist/browser/Options/Classes/Emitter.js\");\n/* harmony import */ var _Options_Classes_EmitterSize_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/EmitterSize.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterSize.js\");\n\n\n\nconst half = 0.5,\n  defaultLifeDelay = 0,\n  minLifeCount = 0,\n  defaultSpawnDelay = 0,\n  defaultEmitDelay = 0,\n  defaultLifeCount = -1,\n  defaultColorAnimationFactor = 1;\nfunction setParticlesOptionsColor(particlesOptions, color) {\n  if (particlesOptions.color) {\n    particlesOptions.color.value = color;\n  } else {\n    particlesOptions.color = {\n      value: color\n    };\n  }\n}\nclass EmitterInstance {\n  constructor(engine, emitters, container, options, position) {\n    this.emitters = emitters;\n    this.container = container;\n    this._destroy = () => {\n      this._mutationObserver?.disconnect();\n      this._mutationObserver = undefined;\n      this._resizeObserver?.disconnect();\n      this._resizeObserver = undefined;\n      this.emitters.removeEmitter(this);\n      this._engine.dispatchEvent(\"emitterDestroyed\", {\n        container: this.container,\n        data: {\n          emitter: this\n        }\n      });\n    };\n    this._prepareToDie = () => {\n      if (this._paused) {\n        return;\n      }\n      const duration = this.options.life?.duration !== undefined ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.life.duration) : undefined,\n        minDuration = 0,\n        minLifeCount = 0;\n      if ((this._lifeCount > minLifeCount || this._immortal) && duration !== undefined && duration > minDuration) {\n        this._duration = duration * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds;\n      }\n    };\n    this._setColorAnimation = (animation, initValue, maxValue, factor = defaultColorAnimationFactor) => {\n      const container = this.container;\n      if (!animation.enable) {\n        return initValue;\n      }\n      const colorOffset = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(animation.offset),\n        delay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.rate.delay),\n        emitFactor = container.retina.reduceFactor ? delay * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / container.retina.reduceFactor : Infinity,\n        defaultColorSpeed = 0,\n        colorSpeed = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(animation.speed ?? defaultColorSpeed);\n      return (initValue + colorSpeed * container.fpsLimit / emitFactor + colorOffset * factor) % maxValue;\n    };\n    this._engine = engine;\n    this._currentDuration = 0;\n    this._currentEmitDelay = 0;\n    this._currentSpawnDelay = 0;\n    this._initialPosition = position;\n    if (options instanceof _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter) {\n      this.options = options;\n    } else {\n      this.options = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n      this.options.load(options);\n    }\n    this._spawnDelay = container.retina.reduceFactor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.life.delay ?? defaultLifeDelay) * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / container.retina.reduceFactor : Infinity;\n    this.position = this._initialPosition ?? this._calcPosition();\n    this.name = this.options.name;\n    this.fill = this.options.fill;\n    this._firstSpawn = !this.options.life.wait;\n    this._startParticlesAdded = false;\n    let particlesOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, this.options.particles);\n    particlesOptions ??= {};\n    particlesOptions.move ??= {};\n    particlesOptions.move.direction ??= this.options.direction;\n    if (this.options.spawnColor) {\n      this.spawnColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, this.options.spawnColor);\n    }\n    this._paused = !this.options.autoPlay;\n    this._particlesOptions = particlesOptions;\n    this._size = this._calcSize();\n    this.size = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getSize)(this._size, this.container.canvas.size);\n    this._lifeCount = this.options.life.count ?? defaultLifeCount;\n    this._immortal = this._lifeCount <= minLifeCount;\n    if (this.options.domId) {\n      const element = document.getElementById(this.options.domId);\n      if (element) {\n        this._mutationObserver = new MutationObserver(() => {\n          this.resize();\n        });\n        this._resizeObserver = new ResizeObserver(() => {\n          this.resize();\n        });\n        this._mutationObserver.observe(element, {\n          attributes: true,\n          attributeFilter: [\"style\", \"width\", \"height\"]\n        });\n        this._resizeObserver.observe(element);\n      }\n    }\n    const shapeOptions = this.options.shape,\n      shapeGenerator = this._engine.emitterShapeManager?.getShapeGenerator(shapeOptions.type);\n    if (shapeGenerator) {\n      this._shape = shapeGenerator.generate(this.position, this.size, this.fill, shapeOptions.options);\n    }\n    this._engine.dispatchEvent(\"emitterCreated\", {\n      container,\n      data: {\n        emitter: this\n      }\n    });\n    this.play();\n  }\n  externalPause() {\n    this._paused = true;\n    this.pause();\n  }\n  externalPlay() {\n    this._paused = false;\n    this.play();\n  }\n  async init() {\n    await this._shape?.init();\n  }\n  pause() {\n    if (this._paused) {\n      return;\n    }\n    delete this._emitDelay;\n  }\n  play() {\n    if (this._paused) {\n      return;\n    }\n    if (!((this._lifeCount > minLifeCount || this._immortal || !this.options.life.count) && (this._firstSpawn || this._currentSpawnDelay >= (this._spawnDelay ?? defaultSpawnDelay)))) {\n      return;\n    }\n    const container = this.container;\n    if (this._emitDelay === undefined) {\n      const delay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.rate.delay);\n      this._emitDelay = container.retina.reduceFactor ? delay * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / container.retina.reduceFactor : Infinity;\n    }\n    if (this._lifeCount > minLifeCount || this._immortal) {\n      this._prepareToDie();\n    }\n  }\n  resize() {\n    const initialPosition = this._initialPosition,\n      container = this.container;\n    this.position = initialPosition && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(initialPosition, container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin) ? initialPosition : this._calcPosition();\n    this._size = this._calcSize();\n    this.size = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getSize)(this._size, container.canvas.size);\n    this._shape?.resize(this.position, this.size);\n  }\n  update(delta) {\n    if (this._paused) {\n      return;\n    }\n    const container = this.container;\n    if (this._firstSpawn) {\n      this._firstSpawn = false;\n      this._currentSpawnDelay = this._spawnDelay ?? defaultSpawnDelay;\n      this._currentEmitDelay = this._emitDelay ?? defaultEmitDelay;\n    }\n    if (!this._startParticlesAdded) {\n      this._startParticlesAdded = true;\n      this._emitParticles(this.options.startCount);\n    }\n    if (this._duration !== undefined) {\n      this._currentDuration += delta.value;\n      if (this._currentDuration >= this._duration) {\n        this.pause();\n        if (this._spawnDelay !== undefined) {\n          delete this._spawnDelay;\n        }\n        if (!this._immortal) {\n          this._lifeCount--;\n        }\n        if (this._lifeCount > minLifeCount || this._immortal) {\n          this.position = this._calcPosition();\n          this._shape?.resize(this.position, this.size);\n          this._spawnDelay = container.retina.reduceFactor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.life.delay ?? defaultLifeDelay) * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / container.retina.reduceFactor : Infinity;\n        } else {\n          this._destroy();\n        }\n        this._currentDuration -= this._duration;\n        delete this._duration;\n      }\n    }\n    if (this._spawnDelay !== undefined) {\n      this._currentSpawnDelay += delta.value;\n      if (this._currentSpawnDelay >= this._spawnDelay) {\n        this._engine.dispatchEvent(\"emitterPlay\", {\n          container: this.container\n        });\n        this.play();\n        this._currentSpawnDelay -= this._currentSpawnDelay;\n        delete this._spawnDelay;\n      }\n    }\n    if (this._emitDelay !== undefined) {\n      this._currentEmitDelay += delta.value;\n      if (this._currentEmitDelay >= this._emitDelay) {\n        this._emit();\n        this._currentEmitDelay -= this._emitDelay;\n      }\n    }\n  }\n  _calcPosition() {\n    const container = this.container;\n    if (this.options.domId) {\n      const element = document.getElementById(this.options.domId);\n      if (element) {\n        const elRect = element.getBoundingClientRect(),\n          pxRatio = container.retina.pixelRatio;\n        return {\n          x: (elRect.x + elRect.width * half) * pxRatio,\n          y: (elRect.y + elRect.height * half) * pxRatio\n        };\n      }\n    }\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calcPositionOrRandomFromSizeRanged)({\n      size: container.canvas.size,\n      position: this.options.position\n    });\n  }\n  _calcSize() {\n    const container = this.container;\n    if (this.options.domId) {\n      const element = document.getElementById(this.options.domId);\n      if (element) {\n        const elRect = element.getBoundingClientRect();\n        return {\n          width: elRect.width * container.retina.pixelRatio,\n          height: elRect.height * container.retina.pixelRatio,\n          mode: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.PixelMode.precise\n        };\n      }\n    }\n    return this.options.size ?? (() => {\n      const size = new _Options_Classes_EmitterSize_js__WEBPACK_IMPORTED_MODULE_2__.EmitterSize();\n      size.load({\n        height: 0,\n        mode: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.PixelMode.percent,\n        width: 0\n      });\n      return size;\n    })();\n  }\n  _emit() {\n    if (this._paused) {\n      return;\n    }\n    const quantity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(this.options.rate.quantity);\n    this._emitParticles(quantity);\n  }\n  _emitParticles(quantity) {\n    const singleParticlesOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(this._particlesOptions),\n      reduceFactor = this.container.retina.reduceFactor;\n    for (let i = 0; i < quantity * reduceFactor; i++) {\n      const particlesOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, singleParticlesOptions);\n      if (this.spawnColor) {\n        const hslAnimation = this.options.spawnColor?.animation;\n        if (hslAnimation) {\n          const maxValues = {\n              h: 360,\n              s: 100,\n              l: 100\n            },\n            colorFactor = 3.6;\n          this.spawnColor.h = this._setColorAnimation(hslAnimation.h, this.spawnColor.h, maxValues.h, colorFactor);\n          this.spawnColor.s = this._setColorAnimation(hslAnimation.s, this.spawnColor.s, maxValues.s);\n          this.spawnColor.l = this._setColorAnimation(hslAnimation.l, this.spawnColor.l, maxValues.l);\n        }\n        setParticlesOptionsColor(particlesOptions, this.spawnColor);\n      }\n      const shapeOptions = this.options.shape;\n      let position = this.position;\n      if (this._shape) {\n        const shapePosData = this._shape.randomPosition();\n        if (shapePosData) {\n          position = shapePosData.position;\n          const replaceData = shapeOptions.replace;\n          if (replaceData.color && shapePosData.color) {\n            setParticlesOptionsColor(particlesOptions, shapePosData.color);\n          }\n          if (replaceData.opacity) {\n            if (particlesOptions.opacity) {\n              particlesOptions.opacity.value = shapePosData.opacity;\n            } else {\n              particlesOptions.opacity = {\n                value: shapePosData.opacity\n              };\n            }\n          }\n        } else {\n          position = null;\n        }\n      }\n      if (position) {\n        this.container.particles.addParticle(position, particlesOptions);\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/EmitterInstance.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/EmitterShapeBase.js":
/*!***************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/EmitterShapeBase.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterShapeBase: () => (/* binding */ EmitterShapeBase)\n/* harmony export */ });\nclass EmitterShapeBase {\n  constructor(position, size, fill, options) {\n    this.position = position;\n    this.size = size;\n    this.fill = fill;\n    this.options = options;\n  }\n  resize(position, size) {\n    this.position = position;\n    this.size = size;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/EmitterShapeBase.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Emitters.js":
/*!*******************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Emitters.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Emitters: () => (/* binding */ Emitters)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Emitter.js */ \"../../plugins/emitters/dist/browser/Options/Classes/Emitter.js\");\n/* harmony import */ var _Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/EmitterClickMode.js */ \"../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js\");\n/* harmony import */ var _EmitterInstance_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EmitterInstance.js */ \"../../plugins/emitters/dist/browser/EmitterInstance.js\");\n\n\n\n\nclass Emitters {\n  constructor(engine, container) {\n    this.container = container;\n    this._engine = engine;\n    this.array = [];\n    this.emitters = [];\n    this.interactivityEmitters = {\n      random: {\n        count: 1,\n        enable: false\n      },\n      value: []\n    };\n    const defaultIndex = 0;\n    container.getEmitter = idxOrName => idxOrName === undefined || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(idxOrName) ? this.array[idxOrName ?? defaultIndex] : this.array.find(t => t.name === idxOrName);\n    container.addEmitter = async (options, position) => this.addEmitter(options, position);\n    container.removeEmitter = idxOrName => {\n      const emitter = container.getEmitter(idxOrName);\n      if (emitter) {\n        this.removeEmitter(emitter);\n      }\n    };\n    container.playEmitter = idxOrName => {\n      const emitter = container.getEmitter(idxOrName);\n      if (emitter) {\n        emitter.externalPlay();\n      }\n    };\n    container.pauseEmitter = idxOrName => {\n      const emitter = container.getEmitter(idxOrName);\n      if (emitter) {\n        emitter.externalPause();\n      }\n    };\n  }\n  async addEmitter(options, position) {\n    const emitterOptions = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n    emitterOptions.load(options);\n    const emitter = new _EmitterInstance_js__WEBPACK_IMPORTED_MODULE_3__.EmitterInstance(this._engine, this, this.container, emitterOptions, position);\n    await emitter.init();\n    this.array.push(emitter);\n    return emitter;\n  }\n  handleClickMode(mode) {\n    const emitterOptions = this.emitters,\n      modeEmitters = this.interactivityEmitters;\n    if (mode !== _Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_2__.EmitterClickMode.emitter) {\n      return;\n    }\n    let emittersModeOptions;\n    if (modeEmitters && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(modeEmitters.value)) {\n      const minLength = 0;\n      if (modeEmitters.value.length > minLength && modeEmitters.random.enable) {\n        emittersModeOptions = [];\n        const usedIndexes = [];\n        for (let i = 0; i < modeEmitters.random.count; i++) {\n          const idx = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.arrayRandomIndex)(modeEmitters.value);\n          if (usedIndexes.includes(idx) && usedIndexes.length < modeEmitters.value.length) {\n            i--;\n            continue;\n          }\n          usedIndexes.push(idx);\n          emittersModeOptions.push((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromArray)(modeEmitters.value, idx));\n        }\n      } else {\n        emittersModeOptions = modeEmitters.value;\n      }\n    } else {\n      emittersModeOptions = modeEmitters?.value;\n    }\n    const emittersOptions = emittersModeOptions ?? emitterOptions,\n      ePosition = this.container.interactivity.mouse.clickPosition;\n    void (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(emittersOptions, async emitter => {\n      await this.addEmitter(emitter, ePosition);\n    });\n  }\n  async init() {\n    this.emitters = this.container.actualOptions.emitters;\n    this.interactivityEmitters = this.container.actualOptions.interactivity.modes.emitters;\n    if (!this.emitters) {\n      return;\n    }\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(this.emitters)) {\n      for (const emitterOptions of this.emitters) {\n        await this.addEmitter(emitterOptions);\n      }\n    } else {\n      await this.addEmitter(this.emitters);\n    }\n  }\n  pause() {\n    for (const emitter of this.array) {\n      emitter.pause();\n    }\n  }\n  play() {\n    for (const emitter of this.array) {\n      emitter.play();\n    }\n  }\n  removeEmitter(emitter) {\n    const index = this.array.indexOf(emitter),\n      minIndex = 0,\n      deleteCount = 1;\n    if (index >= minIndex) {\n      this.array.splice(index, deleteCount);\n    }\n  }\n  resize() {\n    for (const emitter of this.array) {\n      emitter.resize();\n    }\n  }\n  stop() {\n    this.array = [];\n  }\n  update(delta) {\n    for (const emitter of this.array) {\n      emitter.update(delta);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Emitters.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/EmittersEngine.js":
/*!*************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/EmittersEngine.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/EmittersEngine.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/EmittersPlugin.js":
/*!*************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/EmittersPlugin.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmittersPlugin: () => (/* binding */ EmittersPlugin)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Emitter.js */ \"../../plugins/emitters/dist/browser/Options/Classes/Emitter.js\");\n/* harmony import */ var _Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/EmitterClickMode.js */ \"../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js\");\n/* harmony import */ var _Emitters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Emitters.js */ \"../../plugins/emitters/dist/browser/Emitters.js\");\n\n\n\n\nclass EmittersPlugin {\n  constructor(engine) {\n    this._engine = engine;\n    this.id = \"emitters\";\n  }\n  getPlugin(container) {\n    return Promise.resolve(new _Emitters_js__WEBPACK_IMPORTED_MODULE_3__.Emitters(this._engine, container));\n  }\n  loadOptions(options, source) {\n    if (!this.needsPlugin(options) && !this.needsPlugin(source)) {\n      return;\n    }\n    if (source?.emitters) {\n      options.emitters = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(source.emitters, emitter => {\n        const tmp = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n        tmp.load(emitter);\n        return tmp;\n      });\n    }\n    const interactivityEmitters = source?.interactivity?.modes?.emitters;\n    if (interactivityEmitters) {\n      if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(interactivityEmitters)) {\n        options.interactivity.modes.emitters = {\n          random: {\n            count: 1,\n            enable: true\n          },\n          value: interactivityEmitters.map(s => {\n            const tmp = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n            tmp.load(s);\n            return tmp;\n          })\n        };\n      } else {\n        const emitterMode = interactivityEmitters;\n        if (emitterMode.value !== undefined) {\n          const defaultCount = 1;\n          if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(emitterMode.value)) {\n            options.interactivity.modes.emitters = {\n              random: {\n                count: emitterMode.random.count ?? defaultCount,\n                enable: emitterMode.random.enable ?? false\n              },\n              value: emitterMode.value.map(s => {\n                const tmp = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n                tmp.load(s);\n                return tmp;\n              })\n            };\n          } else {\n            const tmp = new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter();\n            tmp.load(emitterMode.value);\n            options.interactivity.modes.emitters = {\n              random: {\n                count: emitterMode.random.count ?? defaultCount,\n                enable: emitterMode.random.enable ?? false\n              },\n              value: tmp\n            };\n          }\n        } else {\n          const emitterOptions = options.interactivity.modes.emitters = {\n            random: {\n              count: 1,\n              enable: false\n            },\n            value: new _Options_Classes_Emitter_js__WEBPACK_IMPORTED_MODULE_1__.Emitter()\n          };\n          emitterOptions.value.load(interactivityEmitters);\n        }\n      }\n    }\n  }\n  needsPlugin(options) {\n    if (!options) {\n      return false;\n    }\n    const emitters = options.emitters;\n    return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isArray)(emitters) && !!emitters.length || emitters !== undefined || !!options.interactivity?.events?.onClick?.mode && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(_Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_2__.EmitterClickMode.emitter, options.interactivity.events.onClick.mode);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/EmittersPlugin.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js":
/*!*********************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterClickMode: () => (/* binding */ EmitterClickMode)\n/* harmony export */ });\nvar EmitterClickMode;\n(function (EmitterClickMode) {\n  EmitterClickMode[\"emitter\"] = \"emitter\";\n})(EmitterClickMode || (EmitterClickMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/IEmitterShape.js":
/*!************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/IEmitterShape.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/IEmitterShape.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/IEmitterShapeGenerator.js":
/*!*********************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/IEmitterShapeGenerator.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/IEmitterShapeGenerator.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/IRandomPositionData.js":
/*!******************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/IRandomPositionData.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/IRandomPositionData.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/Emitter.js":
/*!**********************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/Emitter.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Emitter: () => (/* binding */ Emitter)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _EmitterLife_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EmitterLife.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterLife.js\");\n/* harmony import */ var _EmitterRate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EmitterRate.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterRate.js\");\n/* harmony import */ var _EmitterShape_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EmitterShape.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterShape.js\");\n/* harmony import */ var _EmitterSize_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EmitterSize.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterSize.js\");\n\n\n\n\n\nclass Emitter {\n  constructor() {\n    this.autoPlay = true;\n    this.fill = true;\n    this.life = new _EmitterLife_js__WEBPACK_IMPORTED_MODULE_1__.EmitterLife();\n    this.rate = new _EmitterRate_js__WEBPACK_IMPORTED_MODULE_2__.EmitterRate();\n    this.shape = new _EmitterShape_js__WEBPACK_IMPORTED_MODULE_3__.EmitterShape();\n    this.startCount = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.autoPlay !== undefined) {\n      this.autoPlay = data.autoPlay;\n    }\n    if (data.size !== undefined) {\n      if (!this.size) {\n        this.size = new _EmitterSize_js__WEBPACK_IMPORTED_MODULE_4__.EmitterSize();\n      }\n      this.size.load(data.size);\n    }\n    if (data.direction !== undefined) {\n      this.direction = data.direction;\n    }\n    this.domId = data.domId;\n    if (data.fill !== undefined) {\n      this.fill = data.fill;\n    }\n    this.life.load(data.life);\n    this.name = data.name;\n    this.particles = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.particles, particles => {\n      return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, particles);\n    });\n    this.rate.load(data.rate);\n    this.shape.load(data.shape);\n    if (data.position !== undefined) {\n      this.position = {};\n      if (data.position.x !== undefined) {\n        this.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.x);\n      }\n      if (data.position.y !== undefined) {\n        this.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.position.y);\n      }\n    }\n    if (data.spawnColor !== undefined) {\n      if (this.spawnColor === undefined) {\n        this.spawnColor = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AnimatableColor();\n      }\n      this.spawnColor.load(data.spawnColor);\n    }\n    if (data.startCount !== undefined) {\n      this.startCount = data.startCount;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/Emitter.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/EmitterLife.js":
/*!**************************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/EmitterLife.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterLife: () => (/* binding */ EmitterLife)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass EmitterLife {\n  constructor() {\n    this.wait = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.count !== undefined) {\n      this.count = data.count;\n    }\n    if (data.delay !== undefined) {\n      this.delay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.delay);\n    }\n    if (data.duration !== undefined) {\n      this.duration = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.duration);\n    }\n    if (data.wait !== undefined) {\n      this.wait = data.wait;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/EmitterLife.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/EmitterRate.js":
/*!**************************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/EmitterRate.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterRate: () => (/* binding */ EmitterRate)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass EmitterRate {\n  constructor() {\n    this.quantity = 1;\n    this.delay = 0.1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.quantity !== undefined) {\n      this.quantity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.quantity);\n    }\n    if (data.delay !== undefined) {\n      this.delay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.delay);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/EmitterRate.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/EmitterShape.js":
/*!***************************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/EmitterShape.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterShape: () => (/* binding */ EmitterShape)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _EmitterShapeReplace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EmitterShapeReplace.js */ \"../../plugins/emitters/dist/browser/Options/Classes/EmitterShapeReplace.js\");\n\n\nclass EmitterShape {\n  constructor() {\n    this.options = {};\n    this.replace = new _EmitterShapeReplace_js__WEBPACK_IMPORTED_MODULE_1__.EmitterShapeReplace();\n    this.type = \"square\";\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.options !== undefined) {\n      this.options = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, data.options ?? {});\n    }\n    this.replace.load(data.replace);\n    if (data.type !== undefined) {\n      this.type = data.type;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/EmitterShape.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/EmitterShapeReplace.js":
/*!**********************************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/EmitterShapeReplace.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterShapeReplace: () => (/* binding */ EmitterShapeReplace)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass EmitterShapeReplace {\n  constructor() {\n    this.color = false;\n    this.opacity = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = data.color;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/EmitterShapeReplace.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/Options/Classes/EmitterSize.js":
/*!**************************************************************************!*\
  !*** ../../plugins/emitters/dist/browser/Options/Classes/EmitterSize.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterSize: () => (/* binding */ EmitterSize)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass EmitterSize {\n  constructor() {\n    this.mode = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.PixelMode.percent;\n    this.height = 0;\n    this.width = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.height !== undefined) {\n      this.height = data.height;\n    }\n    if (data.width !== undefined) {\n      this.width = data.width;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/Options/Classes/EmitterSize.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/ShapeManager.js":
/*!***********************************************************!*\
  !*** ../../plugins/emitters/dist/browser/ShapeManager.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ShapeManager: () => (/* binding */ ShapeManager)\n/* harmony export */ });\nconst shapeGeneratorss = new Map();\nclass ShapeManager {\n  constructor(engine) {\n    this._engine = engine;\n  }\n  addShapeGenerator(name, generator) {\n    if (!this.getShapeGenerator(name)) {\n      shapeGeneratorss.set(name, generator);\n    }\n  }\n  getShapeGenerator(name) {\n    return shapeGeneratorss.get(name);\n  }\n  getSupportedShapeGenerators() {\n    return shapeGeneratorss.keys();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/ShapeManager.js?\n}");

/***/ }),

/***/ "../../plugins/emitters/dist/browser/index.js":
/*!****************************************************!*\
  !*** ../../plugins/emitters/dist/browser/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmitterClickMode: () => (/* reexport safe */ _Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_7__.EmitterClickMode),\n/* harmony export */   EmitterShapeBase: () => (/* reexport safe */ _EmitterShapeBase_js__WEBPACK_IMPORTED_MODULE_3__.EmitterShapeBase),\n/* harmony export */   loadEmittersPlugin: () => (/* binding */ loadEmittersPlugin)\n/* harmony export */ });\n/* harmony import */ var _EmittersPlugin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmittersPlugin.js */ \"../../plugins/emitters/dist/browser/EmittersPlugin.js\");\n/* harmony import */ var _ShapeManager_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ShapeManager.js */ \"../../plugins/emitters/dist/browser/ShapeManager.js\");\n/* harmony import */ var _EmitterContainer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EmitterContainer.js */ \"../../plugins/emitters/dist/browser/EmitterContainer.js\");\n/* harmony import */ var _EmitterShapeBase_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EmitterShapeBase.js */ \"../../plugins/emitters/dist/browser/EmitterShapeBase.js\");\n/* harmony import */ var _EmittersEngine_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EmittersEngine.js */ \"../../plugins/emitters/dist/browser/EmittersEngine.js\");\n/* harmony import */ var _IEmitterShape_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./IEmitterShape.js */ \"../../plugins/emitters/dist/browser/IEmitterShape.js\");\n/* harmony import */ var _IEmitterShapeGenerator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IEmitterShapeGenerator.js */ \"../../plugins/emitters/dist/browser/IEmitterShapeGenerator.js\");\n/* harmony import */ var _Enums_EmitterClickMode_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Enums/EmitterClickMode.js */ \"../../plugins/emitters/dist/browser/Enums/EmitterClickMode.js\");\n/* harmony import */ var _IRandomPositionData_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./IRandomPositionData.js */ \"../../plugins/emitters/dist/browser/IRandomPositionData.js\");\n\n\nasync function loadEmittersPlugin(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  if (!engine.emitterShapeManager) {\n    engine.emitterShapeManager = new _ShapeManager_js__WEBPACK_IMPORTED_MODULE_1__.ShapeManager(engine);\n  }\n  if (!engine.addEmitterShapeGenerator) {\n    engine.addEmitterShapeGenerator = (name, generator) => {\n      engine.emitterShapeManager?.addShapeGenerator(name, generator);\n    };\n  }\n  const plugin = new _EmittersPlugin_js__WEBPACK_IMPORTED_MODULE_0__.EmittersPlugin(engine);\n  await engine.addPlugin(plugin, refresh);\n}\n\n\n\n\n\n\n\n\n//# sourceURL=webpack://tsparticles/../../plugins/emitters/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShape.js":
/*!*******************************************************************************!*\
  !*** ../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShape.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmittersCircleShape: () => (/* binding */ EmittersCircleShape)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_plugin_emitters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/plugin-emitters */ \"../../plugins/emitters/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\n\nconst quarter = 0.25,\n  double = 2,\n  doublePI = Math.PI * double,\n  squareExp = 2,\n  half = 0.5;\nclass EmittersCircleShape extends _tsparticles_plugin_emitters__WEBPACK_IMPORTED_MODULE_0__.EmitterShapeBase {\n  constructor(position, size, fill, options) {\n    super(position, size, fill, options);\n  }\n  async init() {}\n  randomPosition() {\n    const size = this.size,\n      fill = this.fill,\n      position = this.position,\n      generateTheta = (x, y) => {\n        const u = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)() * quarter,\n          theta = Math.atan(y / x * Math.tan(doublePI * u)),\n          v = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)();\n        if (v < quarter) {\n          return theta;\n        } else if (v < double * quarter) {\n          return Math.PI - theta;\n        } else if (v < double * quarter + quarter) {\n          return Math.PI + theta;\n        } else {\n          return -theta;\n        }\n      },\n      radius = (x, y, theta) => x * y / Math.sqrt((y * Math.cos(theta)) ** squareExp + (x * Math.sin(theta)) ** squareExp),\n      [a, b] = [size.width * half, size.height * half],\n      randomTheta = generateTheta(a, b),\n      maxRadius = radius(a, b, randomTheta),\n      randomRadius = fill ? maxRadius * Math.sqrt((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)()) : maxRadius;\n    return {\n      position: {\n        x: position.x + randomRadius * Math.cos(randomTheta),\n        y: position.y + randomRadius * Math.sin(randomTheta)\n      }\n    };\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShape.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShapeGenerator.js":
/*!****************************************************************************************!*\
  !*** ../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShapeGenerator.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmittersCircleShapeGenerator: () => (/* binding */ EmittersCircleShapeGenerator)\n/* harmony export */ });\n/* harmony import */ var _EmittersCircleShape_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmittersCircleShape.js */ \"../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShape.js\");\n\nclass EmittersCircleShapeGenerator {\n  generate(position, size, fill, options) {\n    return new _EmittersCircleShape_js__WEBPACK_IMPORTED_MODULE_0__.EmittersCircleShape(position, size, fill, options);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShapeGenerator.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/circle/dist/browser/index.js":
/*!*****************************************************************!*\
  !*** ../../plugins/emittersShapes/circle/dist/browser/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadEmittersShapeCircle: () => (/* binding */ loadEmittersShapeCircle)\n/* harmony export */ });\n/* harmony import */ var _EmittersCircleShapeGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmittersCircleShapeGenerator.js */ \"../../plugins/emittersShapes/circle/dist/browser/EmittersCircleShapeGenerator.js\");\n\nasync function loadEmittersShapeCircle(engine, refresh = true) {\n  const emittersEngine = engine;\n  emittersEngine.checkVersion(\"3.9.1\");\n  emittersEngine.addEmitterShapeGenerator?.(\"circle\", new _EmittersCircleShapeGenerator_js__WEBPACK_IMPORTED_MODULE_0__.EmittersCircleShapeGenerator());\n  await emittersEngine.refresh(refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/circle/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/square/dist/browser/EmittersSquareShape.js":
/*!*******************************************************************************!*\
  !*** ../../plugins/emittersShapes/square/dist/browser/EmittersSquareShape.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmittersSquareShape: () => (/* binding */ EmittersSquareShape)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_plugin_emitters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/plugin-emitters */ \"../../plugins/emitters/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\n\nconst sides = 4;\nvar Sides;\n(function (Sides) {\n  Sides[Sides[\"TopLeft\"] = 0] = \"TopLeft\";\n  Sides[Sides[\"TopRight\"] = 1] = \"TopRight\";\n  Sides[Sides[\"BottomRight\"] = 2] = \"BottomRight\";\n  Sides[Sides[\"BottomLeft\"] = 3] = \"BottomLeft\";\n})(Sides || (Sides = {}));\nfunction randomSquareCoordinate(position, offset) {\n  return position + offset * ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)() - _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.half);\n}\nclass EmittersSquareShape extends _tsparticles_plugin_emitters__WEBPACK_IMPORTED_MODULE_0__.EmitterShapeBase {\n  constructor(position, size, fill, options) {\n    super(position, size, fill, options);\n  }\n  async init() {}\n  randomPosition() {\n    const fill = this.fill,\n      position = this.position,\n      size = this.size;\n    if (fill) {\n      return {\n        position: {\n          x: randomSquareCoordinate(position.x, size.width),\n          y: randomSquareCoordinate(position.y, size.height)\n        }\n      };\n    } else {\n      const halfW = size.width * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.half,\n        halfH = size.height * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.half,\n        side = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)() * sides),\n        v = ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.getRandom)() - _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.half) * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.double;\n      switch (side) {\n        case Sides.TopLeft:\n          return {\n            position: {\n              x: position.x + v * halfW,\n              y: position.y - halfH\n            }\n          };\n        case Sides.TopRight:\n          return {\n            position: {\n              x: position.x - halfW,\n              y: position.y + v * halfH\n            }\n          };\n        case Sides.BottomRight:\n          return {\n            position: {\n              x: position.x + v * halfW,\n              y: position.y + halfH\n            }\n          };\n        case Sides.BottomLeft:\n        default:\n          return {\n            position: {\n              x: position.x + halfW,\n              y: position.y + v * halfH\n            }\n          };\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/square/dist/browser/EmittersSquareShape.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/square/dist/browser/EmittersSquareShapeGenerator.js":
/*!****************************************************************************************!*\
  !*** ../../plugins/emittersShapes/square/dist/browser/EmittersSquareShapeGenerator.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmittersSquareShapeGenerator: () => (/* binding */ EmittersSquareShapeGenerator)\n/* harmony export */ });\n/* harmony import */ var _EmittersSquareShape_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmittersSquareShape.js */ \"../../plugins/emittersShapes/square/dist/browser/EmittersSquareShape.js\");\n\nclass EmittersSquareShapeGenerator {\n  generate(position, size, fill, options) {\n    return new _EmittersSquareShape_js__WEBPACK_IMPORTED_MODULE_0__.EmittersSquareShape(position, size, fill, options);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/square/dist/browser/EmittersSquareShapeGenerator.js?\n}");

/***/ }),

/***/ "../../plugins/emittersShapes/square/dist/browser/index.js":
/*!*****************************************************************!*\
  !*** ../../plugins/emittersShapes/square/dist/browser/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadEmittersShapeSquare: () => (/* binding */ loadEmittersShapeSquare)\n/* harmony export */ });\n/* harmony import */ var _EmittersSquareShapeGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmittersSquareShapeGenerator.js */ \"../../plugins/emittersShapes/square/dist/browser/EmittersSquareShapeGenerator.js\");\n\nasync function loadEmittersShapeSquare(engine, refresh = true) {\n  const emittersEngine = engine;\n  emittersEngine.checkVersion(\"3.9.1\");\n  emittersEngine.addEmitterShapeGenerator?.(\"square\", new _EmittersSquareShapeGenerator_js__WEBPACK_IMPORTED_MODULE_0__.EmittersSquareShapeGenerator());\n  await emittersEngine.refresh(refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../plugins/emittersShapes/square/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/circle/dist/browser/CircleDrawer.js":
/*!********************************************************!*\
  !*** ../../shapes/circle/dist/browser/CircleDrawer.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CircleDrawer: () => (/* binding */ CircleDrawer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/circle/dist/browser/Utils.js\");\n\n\nconst sides = 12,\n  maxAngle = 360,\n  minAngle = 0;\nclass CircleDrawer {\n  constructor() {\n    this.validTypes = [\"circle\"];\n  }\n  draw(data) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawCircle)(data);\n  }\n  getSidesCount() {\n    return sides;\n  }\n  particleInit(container, particle) {\n    const shapeData = particle.shapeData,\n      angle = shapeData?.angle ?? {\n        max: maxAngle,\n        min: minAngle\n      };\n    particle.circleRange = !(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isObject)(angle) ? {\n      min: minAngle,\n      max: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)(angle)\n    } : {\n      min: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)(angle.min),\n      max: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)(angle.max)\n    };\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/circle/dist/browser/CircleDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/circle/dist/browser/Utils.js":
/*!*************************************************!*\
  !*** ../../shapes/circle/dist/browser/Utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawCircle: () => (/* binding */ drawCircle)\n/* harmony export */ });\nconst double = 2,\n  doublePI = Math.PI * double,\n  minAngle = 0,\n  origin = {\n    x: 0,\n    y: 0\n  };\nfunction drawCircle(data) {\n  const {\n    context,\n    particle,\n    radius\n  } = data;\n  if (!particle.circleRange) {\n    particle.circleRange = {\n      min: minAngle,\n      max: doublePI\n    };\n  }\n  const circleRange = particle.circleRange;\n  context.arc(origin.x, origin.y, radius, circleRange.min, circleRange.max, false);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/circle/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/circle/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../shapes/circle/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadCircleShape: () => (/* binding */ loadCircleShape)\n/* harmony export */ });\n/* harmony import */ var _CircleDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CircleDrawer.js */ \"../../shapes/circle/dist/browser/CircleDrawer.js\");\n\nasync function loadCircleShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _CircleDrawer_js__WEBPACK_IMPORTED_MODULE_0__.CircleDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/circle/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/emoji/dist/browser/EmojiDrawer.js":
/*!******************************************************!*\
  !*** ../../shapes/emoji/dist/browser/EmojiDrawer.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmojiDrawer: () => (/* binding */ EmojiDrawer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/emoji/dist/browser/Utils.js\");\n\n\nconst defaultFont = '\"Twemoji Mozilla\", Apple Color Emoji, \"Segoe UI Emoji\", \"Noto Color Emoji\", \"EmojiOne Color\"',\n  noPadding = 0;\nclass EmojiDrawer {\n  constructor() {\n    this.validTypes = [\"emoji\"];\n    this._emojiShapeDict = new Map();\n  }\n  destroy() {\n    for (const [key, data] of this._emojiShapeDict) {\n      if (data instanceof ImageBitmap) {\n        data?.close();\n      }\n      this._emojiShapeDict.delete(key);\n    }\n  }\n  draw(data) {\n    const key = data.particle.emojiDataKey;\n    if (!key) {\n      return;\n    }\n    const image = this._emojiShapeDict.get(key);\n    if (!image) {\n      return;\n    }\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawEmoji)(data, image);\n  }\n  async init(container) {\n    const options = container.actualOptions,\n      {\n        validTypes\n      } = this;\n    if (!validTypes.find(t => (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(t, options.particles.shape.type))) {\n      return;\n    }\n    const promises = [(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.loadFont)(defaultFont)],\n      shapeOptions = validTypes.map(t => options.particles.shape.options[t]).find(t => !!t);\n    if (shapeOptions) {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(shapeOptions, shape => {\n        if (shape.font) {\n          promises.push((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.loadFont)(shape.font));\n        }\n      });\n    }\n    await Promise.all(promises);\n  }\n  particleDestroy(particle) {\n    particle.emojiDataKey = undefined;\n  }\n  particleInit(_container, particle) {\n    const double = 2,\n      shapeData = particle.shapeData;\n    if (!shapeData?.value) {\n      return;\n    }\n    const emoji = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(shapeData.value, particle.randomIndexData);\n    if (!emoji) {\n      return;\n    }\n    const emojiOptions = typeof emoji === \"string\" ? {\n        font: shapeData.font ?? defaultFont,\n        padding: shapeData.padding ?? noPadding,\n        value: emoji\n      } : {\n        font: defaultFont,\n        padding: noPadding,\n        ...shapeData,\n        ...emoji\n      },\n      font = emojiOptions.font,\n      value = emojiOptions.value;\n    const key = `${value}_${font}`;\n    if (this._emojiShapeDict.has(key)) {\n      particle.emojiDataKey = key;\n      return;\n    }\n    const padding = emojiOptions.padding * double,\n      maxSize = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeMax)(particle.size.value),\n      fullSize = maxSize + padding,\n      canvasSize = fullSize * double;\n    let image;\n    if (typeof OffscreenCanvas !== \"undefined\") {\n      const canvas = new OffscreenCanvas(canvasSize, canvasSize),\n        context = canvas.getContext(\"2d\");\n      if (!context) {\n        return;\n      }\n      context.font = `400 ${maxSize * double}px ${font}`;\n      context.textBaseline = \"middle\";\n      context.textAlign = \"center\";\n      context.fillText(value, fullSize, fullSize);\n      image = canvas.transferToImageBitmap();\n    } else {\n      const canvas = document.createElement(\"canvas\");\n      canvas.width = canvasSize;\n      canvas.height = canvasSize;\n      const context = canvas.getContext(\"2d\");\n      if (!context) {\n        return;\n      }\n      context.font = `400 ${maxSize * double}px ${font}`;\n      context.textBaseline = \"middle\";\n      context.textAlign = \"center\";\n      context.fillText(value, fullSize, fullSize);\n      image = canvas;\n    }\n    this._emojiShapeDict.set(key, image);\n    particle.emojiDataKey = key;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/emoji/dist/browser/EmojiDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/emoji/dist/browser/Utils.js":
/*!************************************************!*\
  !*** ../../shapes/emoji/dist/browser/Utils.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawEmoji: () => (/* binding */ drawEmoji)\n/* harmony export */ });\nfunction drawEmoji(data, image) {\n  const {\n      context,\n      opacity\n    } = data,\n    half = 0.5,\n    previousAlpha = context.globalAlpha;\n  if (!image) {\n    return;\n  }\n  const diameter = image.width,\n    radius = diameter * half;\n  context.globalAlpha = opacity;\n  context.drawImage(image, -radius, -radius, diameter, diameter);\n  context.globalAlpha = previousAlpha;\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/emoji/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/emoji/dist/browser/index.js":
/*!************************************************!*\
  !*** ../../shapes/emoji/dist/browser/index.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadEmojiShape: () => (/* binding */ loadEmojiShape)\n/* harmony export */ });\n/* harmony import */ var _EmojiDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EmojiDrawer.js */ \"../../shapes/emoji/dist/browser/EmojiDrawer.js\");\n\nasync function loadEmojiShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _EmojiDrawer_js__WEBPACK_IMPORTED_MODULE_0__.EmojiDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/emoji/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/GifUtils/ByteStream.js":
/*!**************************************************************!*\
  !*** ../../shapes/image/dist/browser/GifUtils/ByteStream.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ByteStream: () => (/* binding */ ByteStream)\n/* harmony export */ });\nclass ByteStream {\n  constructor(bytes) {\n    this.pos = 0;\n    this.data = new Uint8ClampedArray(bytes);\n  }\n  getString(count) {\n    const slice = this.data.slice(this.pos, this.pos + count);\n    this.pos += slice.length;\n    return slice.reduce((acc, curr) => acc + String.fromCharCode(curr), \"\");\n  }\n  nextByte() {\n    return this.data[this.pos++];\n  }\n  nextTwoBytes() {\n    const increment = 2,\n      previous = 1,\n      shift = 8;\n    this.pos += increment;\n    return this.data[this.pos - increment] + (this.data[this.pos - previous] << shift);\n  }\n  readSubBlocks() {\n    let blockString = \"\",\n      size = 0;\n    const minCount = 0,\n      emptySize = 0;\n    do {\n      size = this.data[this.pos++];\n      for (let count = size; --count >= minCount; blockString += String.fromCharCode(this.data[this.pos++])) {}\n    } while (size !== emptySize);\n    return blockString;\n  }\n  readSubBlocksBin() {\n    let size = this.data[this.pos],\n      len = 0;\n    const emptySize = 0,\n      increment = 1;\n    for (let offset = 0; size !== emptySize; offset += size + increment, size = this.data[this.pos + offset]) {\n      len += size;\n    }\n    const blockData = new Uint8Array(len);\n    size = this.data[this.pos++];\n    for (let i = 0; size !== emptySize; size = this.data[this.pos++]) {\n      for (let count = size; --count >= emptySize; blockData[i++] = this.data[this.pos++]) {}\n    }\n    return blockData;\n  }\n  skipSubBlocks() {\n    for (const increment = 1, noData = 0; this.data[this.pos] !== noData; this.pos += this.data[this.pos] + increment) {}\n    this.pos++;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/GifUtils/ByteStream.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/GifUtils/Constants.js":
/*!*************************************************************!*\
  !*** ../../shapes/image/dist/browser/GifUtils/Constants.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   InterlaceOffsets: () => (/* binding */ InterlaceOffsets),\n/* harmony export */   InterlaceSteps: () => (/* binding */ InterlaceSteps)\n/* harmony export */ });\nconst InterlaceOffsets = [0, 4, 2, 1];\nconst InterlaceSteps = [8, 8, 4, 2];\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/GifUtils/Constants.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/GifUtils/Enums/DisposalMethod.js":
/*!************************************************************************!*\
  !*** ../../shapes/image/dist/browser/GifUtils/Enums/DisposalMethod.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DisposalMethod: () => (/* binding */ DisposalMethod)\n/* harmony export */ });\nvar DisposalMethod;\n(function (DisposalMethod) {\n  DisposalMethod[DisposalMethod[\"Replace\"] = 0] = \"Replace\";\n  DisposalMethod[DisposalMethod[\"Combine\"] = 1] = \"Combine\";\n  DisposalMethod[DisposalMethod[\"RestoreBackground\"] = 2] = \"RestoreBackground\";\n  DisposalMethod[DisposalMethod[\"RestorePrevious\"] = 3] = \"RestorePrevious\";\n  DisposalMethod[DisposalMethod[\"UndefinedA\"] = 4] = \"UndefinedA\";\n  DisposalMethod[DisposalMethod[\"UndefinedB\"] = 5] = \"UndefinedB\";\n  DisposalMethod[DisposalMethod[\"UndefinedC\"] = 6] = \"UndefinedC\";\n  DisposalMethod[DisposalMethod[\"UndefinedD\"] = 7] = \"UndefinedD\";\n})(DisposalMethod || (DisposalMethod = {}));\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/GifUtils/Enums/DisposalMethod.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/GifUtils/Types/GIFDataHeaders.js":
/*!************************************************************************!*\
  !*** ../../shapes/image/dist/browser/GifUtils/Types/GIFDataHeaders.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GIFDataHeaders: () => (/* binding */ GIFDataHeaders)\n/* harmony export */ });\nvar GIFDataHeaders;\n(function (GIFDataHeaders) {\n  GIFDataHeaders[GIFDataHeaders[\"Extension\"] = 33] = \"Extension\";\n  GIFDataHeaders[GIFDataHeaders[\"ApplicationExtension\"] = 255] = \"ApplicationExtension\";\n  GIFDataHeaders[GIFDataHeaders[\"GraphicsControlExtension\"] = 249] = \"GraphicsControlExtension\";\n  GIFDataHeaders[GIFDataHeaders[\"PlainTextExtension\"] = 1] = \"PlainTextExtension\";\n  GIFDataHeaders[GIFDataHeaders[\"CommentExtension\"] = 254] = \"CommentExtension\";\n  GIFDataHeaders[GIFDataHeaders[\"Image\"] = 44] = \"Image\";\n  GIFDataHeaders[GIFDataHeaders[\"EndOfFile\"] = 59] = \"EndOfFile\";\n})(GIFDataHeaders || (GIFDataHeaders = {}));\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/GifUtils/Types/GIFDataHeaders.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/GifUtils/Utils.js":
/*!*********************************************************!*\
  !*** ../../shapes/image/dist/browser/GifUtils/Utils.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   decodeGIF: () => (/* binding */ decodeGIF),\n/* harmony export */   drawGif: () => (/* binding */ drawGif),\n/* harmony export */   getGIFLoopAmount: () => (/* binding */ getGIFLoopAmount),\n/* harmony export */   loadGifImage: () => (/* binding */ loadGifImage)\n/* harmony export */ });\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Utils.js */ \"../../shapes/image/dist/browser/Utils.js\");\n/* harmony import */ var _Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Constants.js */ \"../../shapes/image/dist/browser/GifUtils/Constants.js\");\n/* harmony import */ var _ByteStream_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ByteStream.js */ \"../../shapes/image/dist/browser/GifUtils/ByteStream.js\");\n/* harmony import */ var _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Enums/DisposalMethod.js */ \"../../shapes/image/dist/browser/GifUtils/Enums/DisposalMethod.js\");\n/* harmony import */ var _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Types/GIFDataHeaders.js */ \"../../shapes/image/dist/browser/GifUtils/Types/GIFDataHeaders.js\");\n\n\n\n\n\nconst origin = {\n    x: 0,\n    y: 0\n  },\n  defaultFrame = 0,\n  half = 0.5,\n  initialTime = 0,\n  firstIndex = 0,\n  defaultLoopCount = 0;\nfunction parseColorTable(byteStream, count) {\n  const colors = [];\n  for (let i = 0; i < count; i++) {\n    colors.push({\n      r: byteStream.data[byteStream.pos],\n      g: byteStream.data[byteStream.pos + 1],\n      b: byteStream.data[byteStream.pos + 2]\n    });\n    byteStream.pos += 3;\n  }\n  return colors;\n}\nfunction parseExtensionBlock(byteStream, gif, getFrameIndex, getTransparencyIndex) {\n  switch (byteStream.nextByte()) {\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.GraphicsControlExtension:\n      {\n        const frame = gif.frames[getFrameIndex(false)];\n        byteStream.pos++;\n        const packedByte = byteStream.nextByte();\n        frame.GCreserved = (packedByte & 0xe0) >>> 5;\n        frame.disposalMethod = (packedByte & 0x1c) >>> 2;\n        frame.userInputDelayFlag = (packedByte & 2) === 2;\n        const transparencyFlag = (packedByte & 1) === 1;\n        frame.delayTime = byteStream.nextTwoBytes() * 0xa;\n        const transparencyIndex = byteStream.nextByte();\n        if (transparencyFlag) {\n          getTransparencyIndex(transparencyIndex);\n        }\n        byteStream.pos++;\n        break;\n      }\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.ApplicationExtension:\n      {\n        byteStream.pos++;\n        const applicationExtension = {\n          identifier: byteStream.getString(8),\n          authenticationCode: byteStream.getString(3),\n          data: byteStream.readSubBlocksBin()\n        };\n        gif.applicationExtensions.push(applicationExtension);\n        break;\n      }\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.CommentExtension:\n      {\n        gif.comments.push([getFrameIndex(false), byteStream.readSubBlocks()]);\n        break;\n      }\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.PlainTextExtension:\n      {\n        if (gif.globalColorTable.length === 0) {\n          throw new EvalError(\"plain text extension without global color table\");\n        }\n        byteStream.pos++;\n        gif.frames[getFrameIndex(false)].plainTextData = {\n          left: byteStream.nextTwoBytes(),\n          top: byteStream.nextTwoBytes(),\n          width: byteStream.nextTwoBytes(),\n          height: byteStream.nextTwoBytes(),\n          charSize: {\n            width: byteStream.nextTwoBytes(),\n            height: byteStream.nextTwoBytes()\n          },\n          foregroundColor: byteStream.nextByte(),\n          backgroundColor: byteStream.nextByte(),\n          text: byteStream.readSubBlocks()\n        };\n        break;\n      }\n    default:\n      byteStream.skipSubBlocks();\n      break;\n  }\n}\nasync function parseImageBlock(byteStream, gif, avgAlpha, getFrameIndex, getTransparencyIndex, progressCallback) {\n  const frame = gif.frames[getFrameIndex(true)];\n  frame.left = byteStream.nextTwoBytes();\n  frame.top = byteStream.nextTwoBytes();\n  frame.width = byteStream.nextTwoBytes();\n  frame.height = byteStream.nextTwoBytes();\n  const packedByte = byteStream.nextByte(),\n    localColorTableFlag = (packedByte & 0x80) === 0x80,\n    interlacedFlag = (packedByte & 0x40) === 0x40;\n  frame.sortFlag = (packedByte & 0x20) === 0x20;\n  frame.reserved = (packedByte & 0x18) >>> 3;\n  const localColorCount = 1 << (packedByte & 7) + 1;\n  if (localColorTableFlag) {\n    frame.localColorTable = parseColorTable(byteStream, localColorCount);\n  }\n  const getColor = index => {\n    const {\n      r,\n      g,\n      b\n    } = (localColorTableFlag ? frame.localColorTable : gif.globalColorTable)[index];\n    if (index !== getTransparencyIndex(null)) {\n      return {\n        r,\n        g,\n        b,\n        a: 255\n      };\n    }\n    return {\n      r,\n      g,\n      b,\n      a: avgAlpha ? ~~((r + g + b) / 3) : 0\n    };\n  };\n  const image = (() => {\n    try {\n      return new ImageData(frame.width, frame.height, {\n        colorSpace: \"srgb\"\n      });\n    } catch (error) {\n      if (error instanceof DOMException && error.name === \"IndexSizeError\") {\n        return null;\n      }\n      throw error;\n    }\n  })();\n  if (image == null) {\n    throw new EvalError(\"GIF frame size is to large\");\n  }\n  const minCodeSize = byteStream.nextByte(),\n    imageData = byteStream.readSubBlocksBin(),\n    clearCode = 1 << minCodeSize;\n  const readBits = (pos, len) => {\n    const bytePos = pos >>> 3,\n      bitPos = pos & 7;\n    return (imageData[bytePos] + (imageData[bytePos + 1] << 8) + (imageData[bytePos + 2] << 16) & (1 << len) - 1 << bitPos) >>> bitPos;\n  };\n  if (interlacedFlag) {\n    for (let code = 0, size = minCodeSize + 1, pos = 0, dic = [[0]], pass = 0; pass < 4; pass++) {\n      if (_Constants_js__WEBPACK_IMPORTED_MODULE_1__.InterlaceOffsets[pass] < frame.height) {\n        let pixelPos = 0,\n          lineIndex = 0,\n          exit = false;\n        while (!exit) {\n          const last = code;\n          code = readBits(pos, size);\n          pos += size + 1;\n          if (code === clearCode) {\n            size = minCodeSize + 1;\n            dic.length = clearCode + 2;\n            for (let i = 0; i < dic.length; i++) {\n              dic[i] = i < clearCode ? [i] : [];\n            }\n          } else {\n            if (code >= dic.length) {\n              dic.push(dic[last].concat(dic[last][0]));\n            } else if (last !== clearCode) {\n              dic.push(dic[last].concat(dic[code][0]));\n            }\n            for (const item of dic[code]) {\n              const {\n                r,\n                g,\n                b,\n                a\n              } = getColor(item);\n              image.data.set([r, g, b, a], _Constants_js__WEBPACK_IMPORTED_MODULE_1__.InterlaceOffsets[pass] * frame.width + _Constants_js__WEBPACK_IMPORTED_MODULE_1__.InterlaceSteps[pass] * lineIndex + pixelPos % (frame.width * 4));\n              pixelPos += 4;\n            }\n            if (dic.length === 1 << size && size < 0xc) {\n              size++;\n            }\n          }\n          if (pixelPos === frame.width * 4 * (lineIndex + 1)) {\n            lineIndex++;\n            if (_Constants_js__WEBPACK_IMPORTED_MODULE_1__.InterlaceOffsets[pass] + _Constants_js__WEBPACK_IMPORTED_MODULE_1__.InterlaceSteps[pass] * lineIndex >= frame.height) {\n              exit = true;\n            }\n          }\n        }\n      }\n      progressCallback?.(byteStream.pos / (byteStream.data.length - 1), getFrameIndex(false) + 1, image, {\n        x: frame.left,\n        y: frame.top\n      }, {\n        width: gif.width,\n        height: gif.height\n      });\n    }\n    frame.image = image;\n    frame.bitmap = await createImageBitmap(image);\n  } else {\n    let code = 0,\n      size = minCodeSize + 1,\n      pos = 0,\n      pixelPos = -4,\n      exit = false;\n    const dic = [[0]];\n    while (!exit) {\n      const last = code;\n      code = readBits(pos, size);\n      pos += size;\n      if (code === clearCode) {\n        size = minCodeSize + 1;\n        dic.length = clearCode + 2;\n        for (let i = 0; i < dic.length; i++) {\n          dic[i] = i < clearCode ? [i] : [];\n        }\n      } else {\n        if (code === clearCode + 1) {\n          exit = true;\n          break;\n        }\n        if (code >= dic.length) {\n          dic.push(dic[last].concat(dic[last][0]));\n        } else if (last !== clearCode) {\n          dic.push(dic[last].concat(dic[code][0]));\n        }\n        for (const item of dic[code]) {\n          const {\n            r,\n            g,\n            b,\n            a\n          } = getColor(item);\n          image.data.set([r, g, b, a], pixelPos += 4);\n        }\n        if (dic.length >= 1 << size && size < 0xc) {\n          size++;\n        }\n      }\n    }\n    frame.image = image;\n    frame.bitmap = await createImageBitmap(image);\n    progressCallback?.((byteStream.pos + 1) / byteStream.data.length, getFrameIndex(false) + 1, frame.image, {\n      x: frame.left,\n      y: frame.top\n    }, {\n      width: gif.width,\n      height: gif.height\n    });\n  }\n}\nasync function parseBlock(byteStream, gif, avgAlpha, getFrameIndex, getTransparencyIndex, progressCallback) {\n  switch (byteStream.nextByte()) {\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.EndOfFile:\n      return true;\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.Image:\n      await parseImageBlock(byteStream, gif, avgAlpha, getFrameIndex, getTransparencyIndex, progressCallback);\n      break;\n    case _Types_GIFDataHeaders_js__WEBPACK_IMPORTED_MODULE_4__.GIFDataHeaders.Extension:\n      parseExtensionBlock(byteStream, gif, getFrameIndex, getTransparencyIndex);\n      break;\n    default:\n      throw new EvalError(\"undefined block found\");\n  }\n  return false;\n}\nfunction getGIFLoopAmount(gif) {\n  for (const extension of gif.applicationExtensions) {\n    if (extension.identifier + extension.authenticationCode !== \"NETSCAPE2.0\") {\n      continue;\n    }\n    return extension.data[1] + (extension.data[2] << 8);\n  }\n  return NaN;\n}\nasync function decodeGIF(gifURL, progressCallback, avgAlpha) {\n  if (!avgAlpha) avgAlpha = false;\n  const res = await fetch(gifURL);\n  if (!res.ok && res.status === 404) {\n    throw new EvalError(\"file not found\");\n  }\n  const buffer = await res.arrayBuffer();\n  const gif = {\n      width: 0,\n      height: 0,\n      totalTime: 0,\n      colorRes: 0,\n      pixelAspectRatio: 0,\n      frames: [],\n      sortFlag: false,\n      globalColorTable: [],\n      backgroundImage: new ImageData(1, 1, {\n        colorSpace: \"srgb\"\n      }),\n      comments: [],\n      applicationExtensions: []\n    },\n    byteStream = new _ByteStream_js__WEBPACK_IMPORTED_MODULE_2__.ByteStream(new Uint8ClampedArray(buffer));\n  if (byteStream.getString(6) !== \"GIF89a\") {\n    throw new Error(\"not a supported GIF file\");\n  }\n  gif.width = byteStream.nextTwoBytes();\n  gif.height = byteStream.nextTwoBytes();\n  const packedByte = byteStream.nextByte(),\n    globalColorTableFlag = (packedByte & 0x80) === 0x80;\n  gif.colorRes = (packedByte & 0x70) >>> 4;\n  gif.sortFlag = (packedByte & 8) === 8;\n  const globalColorCount = 1 << (packedByte & 7) + 1,\n    backgroundColorIndex = byteStream.nextByte();\n  gif.pixelAspectRatio = byteStream.nextByte();\n  if (gif.pixelAspectRatio !== 0) {\n    gif.pixelAspectRatio = (gif.pixelAspectRatio + 0xf) / 0x40;\n  }\n  if (globalColorTableFlag) {\n    gif.globalColorTable = parseColorTable(byteStream, globalColorCount);\n  }\n  const backgroundImage = (() => {\n    try {\n      return new ImageData(gif.width, gif.height, {\n        colorSpace: \"srgb\"\n      });\n    } catch (error) {\n      if (error instanceof DOMException && error.name === \"IndexSizeError\") {\n        return null;\n      }\n      throw error;\n    }\n  })();\n  if (backgroundImage == null) {\n    throw new Error(\"GIF frame size is to large\");\n  }\n  const {\n    r,\n    g,\n    b\n  } = gif.globalColorTable[backgroundColorIndex];\n  backgroundImage.data.set(globalColorTableFlag ? [r, g, b, 255] : [0, 0, 0, 0]);\n  for (let i = 4; i < backgroundImage.data.length; i *= 2) {\n    backgroundImage.data.copyWithin(i, 0, i);\n  }\n  gif.backgroundImage = backgroundImage;\n  let frameIndex = -1,\n    incrementFrameIndex = true,\n    transparencyIndex = -1;\n  const getframeIndex = increment => {\n    if (increment) {\n      incrementFrameIndex = true;\n    }\n    return frameIndex;\n  };\n  const getTransparencyIndex = newValue => {\n    if (newValue != null) {\n      transparencyIndex = newValue;\n    }\n    return transparencyIndex;\n  };\n  try {\n    do {\n      if (incrementFrameIndex) {\n        gif.frames.push({\n          left: 0,\n          top: 0,\n          width: 0,\n          height: 0,\n          disposalMethod: _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.Replace,\n          image: new ImageData(1, 1, {\n            colorSpace: \"srgb\"\n          }),\n          plainTextData: null,\n          userInputDelayFlag: false,\n          delayTime: 0,\n          sortFlag: false,\n          localColorTable: [],\n          reserved: 0,\n          GCreserved: 0\n        });\n        frameIndex++;\n        transparencyIndex = -1;\n        incrementFrameIndex = false;\n      }\n    } while (!(await parseBlock(byteStream, gif, avgAlpha, getframeIndex, getTransparencyIndex, progressCallback)));\n    gif.frames.length--;\n    for (const frame of gif.frames) {\n      if (frame.userInputDelayFlag && frame.delayTime === 0) {\n        gif.totalTime = Infinity;\n        break;\n      }\n      gif.totalTime += frame.delayTime;\n    }\n    return gif;\n  } catch (error) {\n    if (error instanceof EvalError) {\n      throw new Error(`error while parsing frame ${frameIndex} \"${error.message}\"`);\n    }\n    throw error;\n  }\n}\nfunction drawGif(data) {\n  const {\n      context,\n      radius,\n      particle,\n      delta\n    } = data,\n    image = particle.image;\n  if (!image?.gifData || !image.gif) {\n    return;\n  }\n  const offscreenCanvas = new OffscreenCanvas(image.gifData.width, image.gifData.height),\n    offscreenContext = offscreenCanvas.getContext(\"2d\");\n  if (!offscreenContext) {\n    throw new Error(\"could not create offscreen canvas context\");\n  }\n  offscreenContext.imageSmoothingQuality = \"low\";\n  offscreenContext.imageSmoothingEnabled = false;\n  offscreenContext.clearRect(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n  if (particle.gifLoopCount === undefined) {\n    particle.gifLoopCount = image.gifLoopCount ?? defaultLoopCount;\n  }\n  let frameIndex = particle.gifFrame ?? defaultFrame;\n  const pos = {\n      x: -image.gifData.width * half,\n      y: -image.gifData.height * half\n    },\n    frame = image.gifData.frames[frameIndex];\n  if (particle.gifTime === undefined) {\n    particle.gifTime = initialTime;\n  }\n  if (!frame.bitmap) {\n    return;\n  }\n  context.scale(radius / image.gifData.width, radius / image.gifData.height);\n  switch (frame.disposalMethod) {\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.UndefinedA:\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.UndefinedB:\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.UndefinedC:\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.UndefinedD:\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.Replace:\n      offscreenContext.drawImage(frame.bitmap, frame.left, frame.top);\n      context.drawImage(offscreenCanvas, pos.x, pos.y);\n      offscreenContext.clearRect(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n      break;\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.Combine:\n      offscreenContext.drawImage(frame.bitmap, frame.left, frame.top);\n      context.drawImage(offscreenCanvas, pos.x, pos.y);\n      break;\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.RestoreBackground:\n      offscreenContext.drawImage(frame.bitmap, frame.left, frame.top);\n      context.drawImage(offscreenCanvas, pos.x, pos.y);\n      offscreenContext.clearRect(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n      if (!image.gifData.globalColorTable.length) {\n        offscreenContext.putImageData(image.gifData.frames[firstIndex].image, pos.x + frame.left, pos.y + frame.top);\n      } else {\n        offscreenContext.putImageData(image.gifData.backgroundImage, pos.x, pos.y);\n      }\n      break;\n    case _Enums_DisposalMethod_js__WEBPACK_IMPORTED_MODULE_3__.DisposalMethod.RestorePrevious:\n      {\n        const previousImageData = offscreenContext.getImageData(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n        offscreenContext.drawImage(frame.bitmap, frame.left, frame.top);\n        context.drawImage(offscreenCanvas, pos.x, pos.y);\n        offscreenContext.clearRect(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n        offscreenContext.putImageData(previousImageData, origin.x, origin.y);\n      }\n      break;\n  }\n  particle.gifTime += delta.value;\n  if (particle.gifTime > frame.delayTime) {\n    particle.gifTime -= frame.delayTime;\n    if (++frameIndex >= image.gifData.frames.length) {\n      if (--particle.gifLoopCount <= defaultLoopCount) {\n        return;\n      }\n      frameIndex = firstIndex;\n      offscreenContext.clearRect(origin.x, origin.y, offscreenCanvas.width, offscreenCanvas.height);\n    }\n    particle.gifFrame = frameIndex;\n  }\n  context.scale(image.gifData.width / radius, image.gifData.height / radius);\n}\nasync function loadGifImage(image) {\n  if (image.type !== \"gif\") {\n    await (0,_Utils_js__WEBPACK_IMPORTED_MODULE_0__.loadImage)(image);\n    return;\n  }\n  image.loading = true;\n  try {\n    image.gifData = await decodeGIF(image.source);\n    image.gifLoopCount = getGIFLoopAmount(image.gifData) ?? defaultLoopCount;\n    if (!image.gifLoopCount) {\n      image.gifLoopCount = Infinity;\n    }\n  } catch {\n    image.error = true;\n  }\n  image.loading = false;\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/GifUtils/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/ImageDrawer.js":
/*!******************************************************!*\
  !*** ../../shapes/image/dist/browser/ImageDrawer.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ImageDrawer: () => (/* binding */ ImageDrawer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/image/dist/browser/Utils.js\");\n/* harmony import */ var _GifUtils_Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GifUtils/Utils.js */ \"../../shapes/image/dist/browser/GifUtils/Utils.js\");\n\n\n\nconst double = 2,\n  defaultAlpha = 1,\n  sides = 12,\n  defaultRatio = 1;\nclass ImageDrawer {\n  constructor(engine) {\n    this.validTypes = [\"image\", \"images\"];\n    this.loadImageShape = async imageShape => {\n      if (!this._engine.loadImage) {\n        throw new Error(`${_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} image shape not initialized`);\n      }\n      await this._engine.loadImage({\n        gif: imageShape.gif,\n        name: imageShape.name,\n        replaceColor: imageShape.replaceColor ?? false,\n        src: imageShape.src\n      });\n    };\n    this._engine = engine;\n  }\n  addImage(image) {\n    if (!this._engine.images) {\n      this._engine.images = [];\n    }\n    this._engine.images.push(image);\n  }\n  draw(data) {\n    const {\n        context,\n        radius,\n        particle,\n        opacity\n      } = data,\n      image = particle.image,\n      element = image?.element;\n    if (!image) {\n      return;\n    }\n    context.globalAlpha = opacity;\n    if (image.gif && image.gifData) {\n      (0,_GifUtils_Utils_js__WEBPACK_IMPORTED_MODULE_2__.drawGif)(data);\n    } else if (element) {\n      const ratio = image.ratio,\n        pos = {\n          x: -radius,\n          y: -radius\n        },\n        diameter = radius * double;\n      context.drawImage(element, pos.x, pos.y, diameter, diameter / ratio);\n    }\n    context.globalAlpha = defaultAlpha;\n  }\n  getSidesCount() {\n    return sides;\n  }\n  async init(container) {\n    const options = container.actualOptions;\n    if (!options.preload || !this._engine.loadImage) {\n      return;\n    }\n    for (const imageData of options.preload) {\n      await this._engine.loadImage(imageData);\n    }\n  }\n  loadShape(particle) {\n    if (particle.shape !== \"image\" && particle.shape !== \"images\") {\n      return;\n    }\n    if (!this._engine.images) {\n      this._engine.images = [];\n    }\n    const imageData = particle.shapeData;\n    if (!imageData) {\n      return;\n    }\n    const image = this._engine.images.find(t => t.name === imageData.name || t.source === imageData.src);\n    if (!image) {\n      void this.loadImageShape(imageData).then(() => {\n        this.loadShape(particle);\n      });\n    }\n  }\n  particleInit(container, particle) {\n    if (particle.shape !== \"image\" && particle.shape !== \"images\") {\n      return;\n    }\n    if (!this._engine.images) {\n      this._engine.images = [];\n    }\n    const images = this._engine.images,\n      imageData = particle.shapeData;\n    if (!imageData) {\n      return;\n    }\n    const color = particle.getFillColor(),\n      image = images.find(t => t.name === imageData.name || t.source === imageData.src);\n    if (!image) {\n      return;\n    }\n    const replaceColor = imageData.replaceColor ?? image.replaceColor;\n    if (image.loading) {\n      setTimeout(() => {\n        this.particleInit(container, particle);\n      });\n      return;\n    }\n    void (async () => {\n      let imageRes;\n      if (image.svgData && color) {\n        imageRes = await (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.replaceImageColor)(image, imageData, color, particle);\n      } else {\n        imageRes = {\n          color,\n          data: image,\n          element: image.element,\n          gif: image.gif,\n          gifData: image.gifData,\n          gifLoopCount: image.gifLoopCount,\n          loaded: true,\n          ratio: imageData.width && imageData.height ? imageData.width / imageData.height : image.ratio ?? defaultRatio,\n          replaceColor: replaceColor,\n          source: imageData.src\n        };\n      }\n      if (!imageRes.ratio) {\n        imageRes.ratio = 1;\n      }\n      const fill = imageData.fill ?? particle.shapeFill,\n        close = imageData.close ?? particle.shapeClose,\n        imageShape = {\n          image: imageRes,\n          fill,\n          close\n        };\n      particle.image = imageShape.image;\n      particle.shapeFill = imageShape.fill;\n      particle.shapeClose = imageShape.close;\n    })();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/ImageDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/ImagePreloader.js":
/*!*********************************************************!*\
  !*** ../../shapes/image/dist/browser/ImagePreloader.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ImagePreloaderPlugin: () => (/* binding */ ImagePreloaderPlugin)\n/* harmony export */ });\n/* harmony import */ var _Options_Classes_Preload_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Options/Classes/Preload.js */ \"../../shapes/image/dist/browser/Options/Classes/Preload.js\");\n\nclass ImagePreloaderPlugin {\n  constructor(engine) {\n    this.id = \"imagePreloader\";\n    this._engine = engine;\n  }\n  async getPlugin() {\n    await Promise.resolve();\n    return {};\n  }\n  loadOptions(options, source) {\n    if (!source?.preload) {\n      return;\n    }\n    if (!options.preload) {\n      options.preload = [];\n    }\n    const preloadOptions = options.preload;\n    for (const item of source.preload) {\n      const existing = preloadOptions.find(t => t.name === item.name || t.src === item.src);\n      if (existing) {\n        existing.load(item);\n      } else {\n        const preload = new _Options_Classes_Preload_js__WEBPACK_IMPORTED_MODULE_0__.Preload();\n        preload.load(item);\n        preloadOptions.push(preload);\n      }\n    }\n  }\n  needsPlugin() {\n    return true;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/ImagePreloader.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/Options/Classes/Preload.js":
/*!******************************************************************!*\
  !*** ../../shapes/image/dist/browser/Options/Classes/Preload.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Preload: () => (/* binding */ Preload)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass Preload {\n  constructor() {\n    this.src = \"\";\n    this.gif = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.gif !== undefined) {\n      this.gif = data.gif;\n    }\n    if (data.height !== undefined) {\n      this.height = data.height;\n    }\n    if (data.name !== undefined) {\n      this.name = data.name;\n    }\n    if (data.replaceColor !== undefined) {\n      this.replaceColor = data.replaceColor;\n    }\n    if (data.src !== undefined) {\n      this.src = data.src;\n    }\n    if (data.width !== undefined) {\n      this.width = data.width;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/Options/Classes/Preload.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/Utils.js":
/*!************************************************!*\
  !*** ../../shapes/image/dist/browser/Utils.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   downloadSvgImage: () => (/* binding */ downloadSvgImage),\n/* harmony export */   loadImage: () => (/* binding */ loadImage),\n/* harmony export */   replaceImageColor: () => (/* binding */ replaceImageColor)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst stringStart = 0,\n  defaultOpacity = 1;\nconst currentColorRegex = /(#(?:[0-9a-f]{2}){2,4}|(#[0-9a-f]{3})|(rgb|hsl)a?\\((-?\\d+%?[,\\s]+){2,3}\\s*[\\d.]+%?\\))|currentcolor/gi;\nfunction replaceColorSvg(imageShape, color, opacity) {\n  const {\n    svgData\n  } = imageShape;\n  if (!svgData) {\n    return \"\";\n  }\n  const colorStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromHsl)(color, opacity);\n  if (svgData.includes(\"fill\")) {\n    return svgData.replace(currentColorRegex, () => colorStyle);\n  }\n  const preFillIndex = svgData.indexOf(\">\");\n  return `${svgData.substring(stringStart, preFillIndex)} fill=\"${colorStyle}\"${svgData.substring(preFillIndex)}`;\n}\nasync function loadImage(image) {\n  return new Promise(resolve => {\n    image.loading = true;\n    const img = new Image();\n    image.element = img;\n    img.addEventListener(\"load\", () => {\n      image.loading = false;\n      resolve();\n    });\n    img.addEventListener(\"error\", () => {\n      image.element = undefined;\n      image.error = true;\n      image.loading = false;\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLogger)().error(`${_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} loading image: ${image.source}`);\n      resolve();\n    });\n    img.src = image.source;\n  });\n}\nasync function downloadSvgImage(image) {\n  if (image.type !== \"svg\") {\n    await loadImage(image);\n    return;\n  }\n  image.loading = true;\n  const response = await fetch(image.source);\n  if (!response.ok) {\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLogger)().error(`${_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.errorPrefix} Image not found`);\n    image.error = true;\n  } else {\n    image.svgData = await response.text();\n  }\n  image.loading = false;\n}\nfunction replaceImageColor(image, imageData, color, particle) {\n  const svgColoredData = replaceColorSvg(image, color, particle.opacity?.value ?? defaultOpacity),\n    imageRes = {\n      color,\n      gif: imageData.gif,\n      data: {\n        ...image,\n        svgData: svgColoredData\n      },\n      loaded: false,\n      ratio: imageData.width / imageData.height,\n      replaceColor: imageData.replaceColor,\n      source: imageData.src\n    };\n  return new Promise(resolve => {\n    const svg = new Blob([svgColoredData], {\n        type: \"image/svg+xml\"\n      }),\n      domUrl = URL || window.URL || window.webkitURL || window,\n      url = domUrl.createObjectURL(svg),\n      img = new Image();\n    img.addEventListener(\"load\", () => {\n      imageRes.loaded = true;\n      imageRes.element = img;\n      resolve(imageRes);\n      domUrl.revokeObjectURL(url);\n    });\n    const errorHandler = async () => {\n      domUrl.revokeObjectURL(url);\n      const img2 = {\n        ...image,\n        error: false,\n        loading: true\n      };\n      await loadImage(img2);\n      imageRes.loaded = true;\n      imageRes.element = img2.element;\n      resolve(imageRes);\n    };\n    img.addEventListener(\"error\", () => void errorHandler());\n    img.src = url;\n  });\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/image/dist/browser/index.js":
/*!************************************************!*\
  !*** ../../shapes/image/dist/browser/index.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadImageShape: () => (/* binding */ loadImageShape)\n/* harmony export */ });\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/image/dist/browser/Utils.js\");\n/* harmony import */ var _ImageDrawer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ImageDrawer.js */ \"../../shapes/image/dist/browser/ImageDrawer.js\");\n/* harmony import */ var _ImagePreloader_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ImagePreloader.js */ \"../../shapes/image/dist/browser/ImagePreloader.js\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _GifUtils_Utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GifUtils/Utils.js */ \"../../shapes/image/dist/browser/GifUtils/Utils.js\");\n\n\n\n\n\nconst extLength = 3;\nfunction addLoadImageToEngine(engine) {\n  if (engine.loadImage) {\n    return;\n  }\n  engine.loadImage = async data => {\n    if (!data.name && !data.src) {\n      throw new Error(`${_tsparticles_engine__WEBPACK_IMPORTED_MODULE_3__.errorPrefix} no image source provided`);\n    }\n    if (!engine.images) {\n      engine.images = [];\n    }\n    if (engine.images.find(t => t.name === data.name || t.source === data.src)) {\n      return;\n    }\n    try {\n      const image = {\n        gif: data.gif ?? false,\n        name: data.name ?? data.src,\n        source: data.src,\n        type: data.src.substring(data.src.length - extLength),\n        error: false,\n        loading: true,\n        replaceColor: data.replaceColor,\n        ratio: data.width && data.height ? data.width / data.height : undefined\n      };\n      engine.images.push(image);\n      let imageFunc;\n      if (data.gif) {\n        imageFunc = _GifUtils_Utils_js__WEBPACK_IMPORTED_MODULE_4__.loadGifImage;\n      } else {\n        imageFunc = data.replaceColor ? _Utils_js__WEBPACK_IMPORTED_MODULE_0__.downloadSvgImage : _Utils_js__WEBPACK_IMPORTED_MODULE_0__.loadImage;\n      }\n      await imageFunc(image);\n    } catch {\n      throw new Error(`${_tsparticles_engine__WEBPACK_IMPORTED_MODULE_3__.errorPrefix} ${data.name ?? data.src} not found`);\n    }\n  };\n}\nasync function loadImageShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  addLoadImageToEngine(engine);\n  const preloader = new _ImagePreloader_js__WEBPACK_IMPORTED_MODULE_2__.ImagePreloaderPlugin(engine);\n  await engine.addPlugin(preloader, refresh);\n  await engine.addShape(new _ImageDrawer_js__WEBPACK_IMPORTED_MODULE_1__.ImageDrawer(engine), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/image/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/line/dist/browser/LineDrawer.js":
/*!****************************************************!*\
  !*** ../../shapes/line/dist/browser/LineDrawer.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LineDrawer: () => (/* binding */ LineDrawer)\n/* harmony export */ });\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/line/dist/browser/Utils.js\");\n\nconst sides = 1;\nclass LineDrawer {\n  constructor() {\n    this.validTypes = [\"line\"];\n  }\n  draw(data) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_0__.drawLine)(data);\n  }\n  getSidesCount() {\n    return sides;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/line/dist/browser/LineDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/line/dist/browser/Utils.js":
/*!***********************************************!*\
  !*** ../../shapes/line/dist/browser/Utils.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawLine: () => (/* binding */ drawLine)\n/* harmony export */ });\nfunction drawLine(data) {\n  const {\n      context,\n      particle,\n      radius\n    } = data,\n    shapeData = particle.shapeData,\n    centerY = 0;\n  context.moveTo(-radius, centerY);\n  context.lineTo(radius, centerY);\n  context.lineCap = shapeData?.cap ?? \"butt\";\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/line/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/line/dist/browser/index.js":
/*!***********************************************!*\
  !*** ../../shapes/line/dist/browser/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLineShape: () => (/* binding */ loadLineShape)\n/* harmony export */ });\n/* harmony import */ var _LineDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LineDrawer.js */ \"../../shapes/line/dist/browser/LineDrawer.js\");\n\nasync function loadLineShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _LineDrawer_js__WEBPACK_IMPORTED_MODULE_0__.LineDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/line/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/polygon/dist/browser/PolygonDrawer.js":
/*!**********************************************************!*\
  !*** ../../shapes/polygon/dist/browser/PolygonDrawer.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PolygonDrawer: () => (/* binding */ PolygonDrawer)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawerBase.js */ \"../../shapes/polygon/dist/browser/PolygonDrawerBase.js\");\n\nconst sidesCenterFactor = 3.5,\n  yFactor = 2.66,\n  sidesFactor = 3;\nclass PolygonDrawer extends _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawerBase {\n  constructor() {\n    super(...arguments);\n    this.validTypes = [\"polygon\"];\n  }\n  getCenter(particle, radius) {\n    return {\n      x: -radius / (particle.sides / sidesCenterFactor),\n      y: -radius / (yFactor / sidesCenterFactor)\n    };\n  }\n  getSidesData(particle, radius) {\n    const sides = particle.sides;\n    return {\n      count: {\n        denominator: 1,\n        numerator: sides\n      },\n      length: radius * yFactor / (sides / sidesFactor)\n    };\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/polygon/dist/browser/PolygonDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/polygon/dist/browser/PolygonDrawerBase.js":
/*!**************************************************************!*\
  !*** ../../shapes/polygon/dist/browser/PolygonDrawerBase.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PolygonDrawerBase: () => (/* binding */ PolygonDrawerBase)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/polygon/dist/browser/Utils.js\");\n\n\nconst defaultSides = 5;\nclass PolygonDrawerBase {\n  draw(data) {\n    const {\n        particle,\n        radius\n      } = data,\n      start = this.getCenter(particle, radius),\n      side = this.getSidesData(particle, radius);\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawPolygon)(data, start, side);\n  }\n  getSidesCount(particle) {\n    const polygon = particle.shapeData;\n    return Math.round((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(polygon?.sides ?? defaultSides));\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/polygon/dist/browser/PolygonDrawerBase.js?\n}");

/***/ }),

/***/ "../../shapes/polygon/dist/browser/TriangleDrawer.js":
/*!***********************************************************!*\
  !*** ../../shapes/polygon/dist/browser/TriangleDrawer.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TriangleDrawer: () => (/* binding */ TriangleDrawer)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawerBase.js */ \"../../shapes/polygon/dist/browser/PolygonDrawerBase.js\");\n\nconst yFactor = 1.66,\n  sides = 3,\n  double = 2;\nclass TriangleDrawer extends _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawerBase {\n  constructor() {\n    super(...arguments);\n    this.validTypes = [\"triangle\"];\n  }\n  getCenter(particle, radius) {\n    return {\n      x: -radius,\n      y: radius / yFactor\n    };\n  }\n  getSidesCount() {\n    return sides;\n  }\n  getSidesData(particle, radius) {\n    const diameter = radius * double;\n    return {\n      count: {\n        denominator: 2,\n        numerator: 3\n      },\n      length: diameter\n    };\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/polygon/dist/browser/TriangleDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/polygon/dist/browser/Utils.js":
/*!**************************************************!*\
  !*** ../../shapes/polygon/dist/browser/Utils.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawPolygon: () => (/* binding */ drawPolygon)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst piDeg = 180,\n  origin = {\n    x: 0,\n    y: 0\n  },\n  sidesOffset = 2;\nfunction drawPolygon(data, start, side) {\n  const {\n      context\n    } = data,\n    sideCount = side.count.numerator * side.count.denominator,\n    decimalSides = side.count.numerator / side.count.denominator,\n    interiorAngleDegrees = piDeg * (decimalSides - sidesOffset) / decimalSides,\n    interiorAngle = Math.PI - (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)(interiorAngleDegrees);\n  if (!context) {\n    return;\n  }\n  context.beginPath();\n  context.translate(start.x, start.y);\n  context.moveTo(origin.x, origin.y);\n  for (let i = 0; i < sideCount; i++) {\n    context.lineTo(side.length, origin.y);\n    context.translate(side.length, origin.y);\n    context.rotate(interiorAngle);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/polygon/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/polygon/dist/browser/index.js":
/*!**************************************************!*\
  !*** ../../shapes/polygon/dist/browser/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadGenericPolygonShape: () => (/* binding */ loadGenericPolygonShape),\n/* harmony export */   loadPolygonShape: () => (/* binding */ loadPolygonShape),\n/* harmony export */   loadTriangleShape: () => (/* binding */ loadTriangleShape)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawer.js */ \"../../shapes/polygon/dist/browser/PolygonDrawer.js\");\n/* harmony import */ var _TriangleDrawer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TriangleDrawer.js */ \"../../shapes/polygon/dist/browser/TriangleDrawer.js\");\n\n\nasync function loadGenericPolygonShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _PolygonDrawer_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawer(), refresh);\n}\nasync function loadTriangleShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _TriangleDrawer_js__WEBPACK_IMPORTED_MODULE_1__.TriangleDrawer(), refresh);\n}\nasync function loadPolygonShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await loadGenericPolygonShape(engine, refresh);\n  await loadTriangleShape(engine, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/polygon/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/square/dist/browser/SquareDrawer.js":
/*!********************************************************!*\
  !*** ../../shapes/square/dist/browser/SquareDrawer.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SquareDrawer: () => (/* binding */ SquareDrawer)\n/* harmony export */ });\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/square/dist/browser/Utils.js\");\n\nconst sides = 4;\nclass SquareDrawer {\n  constructor() {\n    this.validTypes = [\"edge\", \"square\"];\n  }\n  draw(data) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_0__.drawSquare)(data);\n  }\n  getSidesCount() {\n    return sides;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/square/dist/browser/SquareDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/square/dist/browser/Utils.js":
/*!*************************************************!*\
  !*** ../../shapes/square/dist/browser/Utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawSquare: () => (/* binding */ drawSquare)\n/* harmony export */ });\nconst fixFactorSquared = 2,\n  fixFactor = Math.sqrt(fixFactorSquared),\n  double = 2;\nfunction drawSquare(data) {\n  const {\n      context,\n      radius\n    } = data,\n    fixedRadius = radius / fixFactor,\n    fixedDiameter = fixedRadius * double;\n  context.rect(-fixedRadius, -fixedRadius, fixedDiameter, fixedDiameter);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/square/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/square/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../shapes/square/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadSquareShape: () => (/* binding */ loadSquareShape)\n/* harmony export */ });\n/* harmony import */ var _SquareDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SquareDrawer.js */ \"../../shapes/square/dist/browser/SquareDrawer.js\");\n\nasync function loadSquareShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _SquareDrawer_js__WEBPACK_IMPORTED_MODULE_0__.SquareDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/square/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/star/dist/browser/StarDrawer.js":
/*!****************************************************!*\
  !*** ../../shapes/star/dist/browser/StarDrawer.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StarDrawer: () => (/* binding */ StarDrawer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/star/dist/browser/Utils.js\");\n\n\nconst defaultInset = 2,\n  defaultSides = 5;\nclass StarDrawer {\n  constructor() {\n    this.validTypes = [\"star\"];\n  }\n  draw(data) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawStar)(data);\n  }\n  getSidesCount(particle) {\n    const star = particle.shapeData;\n    return Math.round((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(star?.sides ?? defaultSides));\n  }\n  particleInit(container, particle) {\n    const star = particle.shapeData;\n    particle.starInset = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(star?.inset ?? defaultInset);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/star/dist/browser/StarDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/star/dist/browser/Utils.js":
/*!***********************************************!*\
  !*** ../../shapes/star/dist/browser/Utils.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawStar: () => (/* binding */ drawStar)\n/* harmony export */ });\nconst defaultInset = 2,\n  origin = {\n    x: 0,\n    y: 0\n  };\nfunction drawStar(data) {\n  const {\n      context,\n      particle,\n      radius\n    } = data,\n    sides = particle.sides,\n    inset = particle.starInset ?? defaultInset;\n  context.moveTo(origin.x, origin.y - radius);\n  for (let i = 0; i < sides; i++) {\n    context.rotate(Math.PI / sides);\n    context.lineTo(origin.x, origin.y - radius * inset);\n    context.rotate(Math.PI / sides);\n    context.lineTo(origin.x, origin.y - radius);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/star/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/star/dist/browser/index.js":
/*!***********************************************!*\
  !*** ../../shapes/star/dist/browser/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadStarShape: () => (/* binding */ loadStarShape)\n/* harmony export */ });\n/* harmony import */ var _StarDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StarDrawer.js */ \"../../shapes/star/dist/browser/StarDrawer.js\");\n\nasync function loadStarShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _StarDrawer_js__WEBPACK_IMPORTED_MODULE_0__.StarDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/star/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../shapes/text/dist/browser/TextDrawer.js":
/*!****************************************************!*\
  !*** ../../shapes/text/dist/browser/TextDrawer.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TextDrawer: () => (/* binding */ TextDrawer)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../shapes/text/dist/browser/Utils.js\");\n\n\nclass TextDrawer {\n  constructor() {\n    this.validTypes = [\"text\", \"character\", \"char\", \"multiline-text\"];\n  }\n  draw(data) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawText)(data);\n  }\n  async init(container) {\n    const options = container.actualOptions,\n      {\n        validTypes\n      } = this;\n    if (validTypes.find(t => (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isInArray)(t, options.particles.shape.type))) {\n      const shapeOptions = validTypes.map(t => options.particles.shape.options[t]).find(t => !!t),\n        promises = [];\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(shapeOptions, shape => {\n        promises.push((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.loadFont)(shape.font, shape.weight));\n      });\n      await Promise.all(promises);\n    }\n  }\n  particleInit(container, particle) {\n    if (!particle.shape || !this.validTypes.includes(particle.shape)) {\n      return;\n    }\n    const character = particle.shapeData;\n    if (character === undefined) {\n      return;\n    }\n    const textData = character.value;\n    if (textData === undefined) {\n      return;\n    }\n    particle.text = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(textData, particle.randomIndexData);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/text/dist/browser/TextDrawer.js?\n}");

/***/ }),

/***/ "../../shapes/text/dist/browser/Utils.js":
/*!***********************************************!*\
  !*** ../../shapes/text/dist/browser/Utils.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawText: () => (/* binding */ drawText)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst double = 2,\n  half = 0.5;\nfunction drawText(data) {\n  const {\n      context,\n      particle,\n      radius,\n      opacity\n    } = data,\n    character = particle.shapeData;\n  if (!character) {\n    return;\n  }\n  const textData = character.value;\n  if (textData === undefined) {\n    return;\n  }\n  if (particle.text === undefined) {\n    particle.text = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(textData, particle.randomIndexData);\n  }\n  const text = particle.text,\n    style = character.style ?? \"\",\n    weight = character.weight ?? \"400\",\n    size = Math.round(radius) * double,\n    font = character.font ?? \"Verdana\",\n    fill = particle.shapeFill;\n  const lines = text?.split(\"\\n\");\n  if (!lines) {\n    return;\n  }\n  context.font = `${style} ${weight} ${size}px \"${font}\"`;\n  context.globalAlpha = opacity;\n  for (let i = 0; i < lines.length; i++) {\n    drawLine(context, lines[i], radius, opacity, i, fill);\n  }\n  context.globalAlpha = 1;\n}\nfunction drawLine(context, line, radius, opacity, index, fill) {\n  const offsetX = line.length * radius * half,\n    pos = {\n      x: -offsetX,\n      y: radius * half\n    },\n    diameter = radius * double;\n  if (fill) {\n    context.fillText(line, pos.x, pos.y + diameter * index);\n  } else {\n    context.strokeText(line, pos.x, pos.y + diameter * index);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/text/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../shapes/text/dist/browser/index.js":
/*!***********************************************!*\
  !*** ../../shapes/text/dist/browser/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadTextShape: () => (/* binding */ loadTextShape)\n/* harmony export */ });\n/* harmony import */ var _TextDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TextDrawer.js */ \"../../shapes/text/dist/browser/TextDrawer.js\");\n\nasync function loadTextShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _TextDrawer_js__WEBPACK_IMPORTED_MODULE_0__.TextDrawer(), refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../shapes/text/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/color/dist/browser/ColorUpdater.js":
/*!*********************************************************!*\
  !*** ../../updaters/color/dist/browser/ColorUpdater.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ColorUpdater: () => (/* binding */ ColorUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass ColorUpdater {\n  constructor(container, engine) {\n    this._container = container;\n    this._engine = engine;\n  }\n  init(particle) {\n    const hslColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, particle.options.color, particle.id, particle.options.reduceDuplicates);\n    if (hslColor) {\n      particle.color = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getHslAnimationFromHsl)(hslColor, particle.options.color.animation, this._container.retina.reduceFactor);\n    }\n  }\n  isEnabled(particle) {\n    const {\n        h: hAnimation,\n        s: sAnimation,\n        l: lAnimation\n      } = particle.options.color.animation,\n      {\n        color\n      } = particle;\n    return !particle.destroyed && !particle.spawning && (color?.h.value !== undefined && hAnimation.enable || color?.s.value !== undefined && sAnimation.enable || color?.l.value !== undefined && lAnimation.enable);\n  }\n  update(particle, delta) {\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateColor)(particle.color, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/color/dist/browser/ColorUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/color/dist/browser/index.js":
/*!**************************************************!*\
  !*** ../../updaters/color/dist/browser/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadColorUpdater: () => (/* binding */ loadColorUpdater)\n/* harmony export */ });\n/* harmony import */ var _ColorUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ColorUpdater.js */ \"../../updaters/color/dist/browser/ColorUpdater.js\");\n\nasync function loadColorUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"color\", container => {\n    return Promise.resolve(new _ColorUpdater_js__WEBPACK_IMPORTED_MODULE_0__.ColorUpdater(container, engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/color/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/DestroyUpdater.js":
/*!*************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/DestroyUpdater.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DestroyUpdater: () => (/* binding */ DestroyUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Destroy_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Destroy.js */ \"../../updaters/destroy/dist/browser/Options/Classes/Destroy.js\");\n/* harmony import */ var _Enums_DestroyMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Enums/DestroyMode.js */ \"../../updaters/destroy/dist/browser/Enums/DestroyMode.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Utils.js */ \"../../updaters/destroy/dist/browser/Utils.js\");\n\n\n\n\nclass DestroyUpdater {\n  constructor(engine, container) {\n    this.container = container;\n    this.engine = engine;\n  }\n  init(particle) {\n    const container = this.container,\n      particlesOptions = particle.options,\n      destroyOptions = particlesOptions.destroy;\n    if (!destroyOptions) {\n      return;\n    }\n    particle.splitCount = 0;\n    const destroyBoundsOptions = destroyOptions.bounds;\n    if (!particle.destroyBounds) {\n      particle.destroyBounds = {};\n    }\n    const {\n        bottom,\n        left,\n        right,\n        top\n      } = destroyBoundsOptions,\n      {\n        destroyBounds\n      } = particle,\n      canvasSize = container.canvas.size;\n    if (bottom) {\n      destroyBounds.bottom = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(bottom) * canvasSize.height / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator;\n    }\n    if (left) {\n      destroyBounds.left = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(left) * canvasSize.width / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator;\n    }\n    if (right) {\n      destroyBounds.right = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(right) * canvasSize.width / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator;\n    }\n    if (top) {\n      destroyBounds.top = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(top) * canvasSize.height / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator;\n    }\n  }\n  isEnabled(particle) {\n    return !particle.destroyed;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.destroy) {\n      options.destroy = new _Options_Classes_Destroy_js__WEBPACK_IMPORTED_MODULE_1__.Destroy();\n    }\n    for (const source of sources) {\n      options.destroy.load(source?.destroy);\n    }\n  }\n  particleDestroyed(particle, override) {\n    if (override) {\n      return;\n    }\n    const destroyOptions = particle.options.destroy;\n    if (destroyOptions && destroyOptions.mode === _Enums_DestroyMode_js__WEBPACK_IMPORTED_MODULE_2__.DestroyMode.split) {\n      (0,_Utils_js__WEBPACK_IMPORTED_MODULE_3__.split)(this.engine, this.container, particle);\n    }\n  }\n  update(particle) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    const position = particle.getPosition(),\n      bounds = particle.destroyBounds;\n    if (!bounds) {\n      return;\n    }\n    if (bounds.bottom !== undefined && position.y >= bounds.bottom || bounds.left !== undefined && position.x <= bounds.left || bounds.right !== undefined && position.x >= bounds.right || bounds.top !== undefined && position.y <= bounds.top) {\n      particle.destroy();\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/DestroyUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Enums/DestroyMode.js":
/*!****************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Enums/DestroyMode.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DestroyMode: () => (/* binding */ DestroyMode)\n/* harmony export */ });\nvar DestroyMode;\n(function (DestroyMode) {\n  DestroyMode[\"none\"] = \"none\";\n  DestroyMode[\"split\"] = \"split\";\n})(DestroyMode || (DestroyMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Enums/DestroyMode.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Options/Classes/Destroy.js":
/*!**********************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Options/Classes/Destroy.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Destroy: () => (/* binding */ Destroy)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _DestroyBounds_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DestroyBounds.js */ \"../../updaters/destroy/dist/browser/Options/Classes/DestroyBounds.js\");\n/* harmony import */ var _Enums_DestroyMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Enums/DestroyMode.js */ \"../../updaters/destroy/dist/browser/Enums/DestroyMode.js\");\n/* harmony import */ var _Split_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Split.js */ \"../../updaters/destroy/dist/browser/Options/Classes/Split.js\");\n\n\n\n\nclass Destroy {\n  constructor() {\n    this.bounds = new _DestroyBounds_js__WEBPACK_IMPORTED_MODULE_1__.DestroyBounds();\n    this.mode = _Enums_DestroyMode_js__WEBPACK_IMPORTED_MODULE_2__.DestroyMode.none;\n    this.split = new _Split_js__WEBPACK_IMPORTED_MODULE_3__.Split();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.mode) {\n      this.mode = data.mode;\n    }\n    if (data.bounds) {\n      this.bounds.load(data.bounds);\n    }\n    this.split.load(data.split);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Options/Classes/Destroy.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Options/Classes/DestroyBounds.js":
/*!****************************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Options/Classes/DestroyBounds.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DestroyBounds: () => (/* binding */ DestroyBounds)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass DestroyBounds {\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.bottom !== undefined) {\n      this.bottom = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.bottom);\n    }\n    if (data.left !== undefined) {\n      this.left = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.left);\n    }\n    if (data.right !== undefined) {\n      this.right = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.right);\n    }\n    if (data.top !== undefined) {\n      this.top = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.top);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Options/Classes/DestroyBounds.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Options/Classes/Split.js":
/*!********************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Options/Classes/Split.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Split: () => (/* binding */ Split)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _SplitFactor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SplitFactor.js */ \"../../updaters/destroy/dist/browser/Options/Classes/SplitFactor.js\");\n/* harmony import */ var _SplitRate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SplitRate.js */ \"../../updaters/destroy/dist/browser/Options/Classes/SplitRate.js\");\n\n\n\nclass Split {\n  constructor() {\n    this.count = 1;\n    this.factor = new _SplitFactor_js__WEBPACK_IMPORTED_MODULE_1__.SplitFactor();\n    this.rate = new _SplitRate_js__WEBPACK_IMPORTED_MODULE_2__.SplitRate();\n    this.sizeOffset = true;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.count !== undefined) {\n      this.count = data.count;\n    }\n    this.factor.load(data.factor);\n    this.rate.load(data.rate);\n    this.particles = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.executeOnSingleOrMultiple)(data.particles, particles => {\n      return (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.deepExtend)({}, particles);\n    });\n    if (data.sizeOffset !== undefined) {\n      this.sizeOffset = data.sizeOffset;\n    }\n    if (data.colorOffset) {\n      this.colorOffset = this.colorOffset ?? {};\n      if (data.colorOffset.h !== undefined) {\n        this.colorOffset.h = data.colorOffset.h;\n      }\n      if (data.colorOffset.s !== undefined) {\n        this.colorOffset.s = data.colorOffset.s;\n      }\n      if (data.colorOffset.l !== undefined) {\n        this.colorOffset.l = data.colorOffset.l;\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Options/Classes/Split.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Options/Classes/SplitFactor.js":
/*!**************************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Options/Classes/SplitFactor.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SplitFactor: () => (/* binding */ SplitFactor)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass SplitFactor extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.value = 3;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Options/Classes/SplitFactor.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Options/Classes/SplitRate.js":
/*!************************************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Options/Classes/SplitRate.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SplitRate: () => (/* binding */ SplitRate)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass SplitRate extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.value = {\n      min: 4,\n      max: 9\n    };\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Options/Classes/SplitRate.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/Utils.js":
/*!****************************************************!*\
  !*** ../../updaters/destroy/dist/browser/Utils.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   split: () => (/* binding */ split)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst defaultOffset = 0,\n  minDestroySize = 0.5,\n  defaultSplitCount = 0,\n  increment = 1,\n  unbreakableTime = 500,\n  minSplitCount = 0;\nfunction addSplitParticle(engine, container, parent, splitParticlesOptions) {\n  const destroyOptions = parent.options.destroy;\n  if (!destroyOptions) {\n    return;\n  }\n  const splitOptions = destroyOptions.split,\n    options = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.loadParticlesOptions)(engine, container, parent.options),\n    factor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(splitOptions.factor.value),\n    parentColor = parent.getFillColor();\n  if (splitOptions.color) {\n    options.color.load(splitOptions.color);\n  } else if (splitOptions.colorOffset && parentColor) {\n    options.color.load({\n      value: {\n        hsl: {\n          h: parentColor.h + (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(splitOptions.colorOffset.h ?? defaultOffset),\n          s: parentColor.s + (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(splitOptions.colorOffset.s ?? defaultOffset),\n          l: parentColor.l + (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(splitOptions.colorOffset.l ?? defaultOffset)\n        }\n      }\n    });\n  } else {\n    options.color.load({\n      value: {\n        hsl: parent.getFillColor()\n      }\n    });\n  }\n  options.move.load({\n    center: {\n      x: parent.position.x,\n      y: parent.position.y,\n      mode: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.PixelMode.precise\n    }\n  });\n  if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(options.size.value)) {\n    options.size.value /= factor;\n  } else {\n    options.size.value.min /= factor;\n    options.size.value.max /= factor;\n  }\n  options.load(splitParticlesOptions);\n  const offset = splitOptions.sizeOffset ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(-parent.size.value, parent.size.value) : defaultOffset,\n    position = {\n      x: parent.position.x + (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(offset),\n      y: parent.position.y + (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(offset)\n    };\n  return container.particles.addParticle(position, options, parent.group, particle => {\n    if (particle.size.value < minDestroySize) {\n      return false;\n    }\n    particle.velocity.length = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(parent.velocity.length, particle.velocity.length));\n    particle.splitCount = (parent.splitCount ?? defaultSplitCount) + increment;\n    particle.unbreakable = true;\n    setTimeout(() => {\n      particle.unbreakable = false;\n    }, unbreakableTime);\n    return true;\n  });\n}\nfunction split(engine, container, particle) {\n  const destroyOptions = particle.options.destroy;\n  if (!destroyOptions) {\n    return;\n  }\n  const splitOptions = destroyOptions.split;\n  if (splitOptions.count >= minSplitCount && (particle.splitCount === undefined || particle.splitCount++ > splitOptions.count)) {\n    return;\n  }\n  const rate = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(splitOptions.rate.value),\n    particlesSplitOptions = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(splitOptions.particles);\n  for (let i = 0; i < rate; i++) {\n    addSplitParticle(engine, container, particle, particlesSplitOptions);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../updaters/destroy/dist/browser/index.js":
/*!****************************************************!*\
  !*** ../../updaters/destroy/dist/browser/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadDestroyUpdater: () => (/* binding */ loadDestroyUpdater)\n/* harmony export */ });\n/* harmony import */ var _DestroyUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DestroyUpdater.js */ \"../../updaters/destroy/dist/browser/DestroyUpdater.js\");\n\nasync function loadDestroyUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"destroy\", container => {\n    return Promise.resolve(new _DestroyUpdater_js__WEBPACK_IMPORTED_MODULE_0__.DestroyUpdater(engine, container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/destroy/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/LifeUpdater.js":
/*!*******************************************************!*\
  !*** ../../updaters/life/dist/browser/LifeUpdater.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LifeUpdater: () => (/* binding */ LifeUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Life_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Life.js */ \"../../updaters/life/dist/browser/Options/Classes/Life.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils.js */ \"../../updaters/life/dist/browser/Utils.js\");\n\n\n\nconst noTime = 0,\n  identity = 1,\n  infiniteValue = -1;\nclass LifeUpdater {\n  constructor(container) {\n    this.container = container;\n  }\n  init(particle) {\n    const container = this.container,\n      particlesOptions = particle.options,\n      lifeOptions = particlesOptions.life;\n    if (!lifeOptions) {\n      return;\n    }\n    particle.life = {\n      delay: container.retina.reduceFactor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(lifeOptions.delay.value) * (lifeOptions.delay.sync ? identity : (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)()) / container.retina.reduceFactor * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds : noTime,\n      delayTime: noTime,\n      duration: container.retina.reduceFactor ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(lifeOptions.duration.value) * (lifeOptions.duration.sync ? identity : (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)()) / container.retina.reduceFactor * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds : noTime,\n      time: noTime,\n      count: lifeOptions.count\n    };\n    if (particle.life.duration <= noTime) {\n      particle.life.duration = infiniteValue;\n    }\n    if (particle.life.count <= noTime) {\n      particle.life.count = infiniteValue;\n    }\n    if (particle.life) {\n      particle.spawning = particle.life.delay > noTime;\n    }\n  }\n  isEnabled(particle) {\n    return !particle.destroyed;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.life) {\n      options.life = new _Options_Classes_Life_js__WEBPACK_IMPORTED_MODULE_1__.Life();\n    }\n    for (const source of sources) {\n      options.life.load(source?.life);\n    }\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle) || !particle.life) {\n      return;\n    }\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_2__.updateLife)(particle, delta, this.container.canvas.size);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/LifeUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/Options/Classes/Life.js":
/*!****************************************************************!*\
  !*** ../../updaters/life/dist/browser/Options/Classes/Life.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Life: () => (/* binding */ Life)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _LifeDelay_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LifeDelay.js */ \"../../updaters/life/dist/browser/Options/Classes/LifeDelay.js\");\n/* harmony import */ var _LifeDuration_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LifeDuration.js */ \"../../updaters/life/dist/browser/Options/Classes/LifeDuration.js\");\n\n\n\nclass Life {\n  constructor() {\n    this.count = 0;\n    this.delay = new _LifeDelay_js__WEBPACK_IMPORTED_MODULE_1__.LifeDelay();\n    this.duration = new _LifeDuration_js__WEBPACK_IMPORTED_MODULE_2__.LifeDuration();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.count !== undefined) {\n      this.count = data.count;\n    }\n    this.delay.load(data.delay);\n    this.duration.load(data.duration);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/Options/Classes/Life.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/Options/Classes/LifeDelay.js":
/*!*********************************************************************!*\
  !*** ../../updaters/life/dist/browser/Options/Classes/LifeDelay.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LifeDelay: () => (/* binding */ LifeDelay)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass LifeDelay extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.sync = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    if (data.sync !== undefined) {\n      this.sync = data.sync;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/Options/Classes/LifeDelay.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/Options/Classes/LifeDuration.js":
/*!************************************************************************!*\
  !*** ../../updaters/life/dist/browser/Options/Classes/LifeDuration.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LifeDuration: () => (/* binding */ LifeDuration)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass LifeDuration extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.sync = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    if (data.sync !== undefined) {\n      this.sync = data.sync;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/Options/Classes/LifeDuration.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/Utils.js":
/*!*************************************************!*\
  !*** ../../updaters/life/dist/browser/Utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   updateLife: () => (/* binding */ updateLife)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst noTime = 0,\n  infiniteValue = -1,\n  noLife = 0,\n  minCanvasSize = 0;\nfunction updateLife(particle, delta, canvasSize) {\n  if (!particle.life) {\n    return;\n  }\n  const life = particle.life;\n  let justSpawned = false;\n  if (particle.spawning) {\n    life.delayTime += delta.value;\n    if (life.delayTime >= particle.life.delay) {\n      justSpawned = true;\n      particle.spawning = false;\n      life.delayTime = noTime;\n      life.time = noTime;\n    } else {\n      return;\n    }\n  }\n  if (life.duration === infiniteValue) {\n    return;\n  }\n  if (particle.spawning) {\n    return;\n  }\n  if (justSpawned) {\n    life.time = noTime;\n  } else {\n    life.time += delta.value;\n  }\n  if (life.time < life.duration) {\n    return;\n  }\n  life.time = noTime;\n  if (particle.life.count > noLife) {\n    particle.life.count--;\n  }\n  if (particle.life.count === noLife) {\n    particle.destroy();\n    return;\n  }\n  const widthRange = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(minCanvasSize, canvasSize.width),\n    heightRange = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(minCanvasSize, canvasSize.width);\n  particle.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(widthRange);\n  particle.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)(heightRange);\n  particle.spawning = true;\n  life.delayTime = noTime;\n  life.time = noTime;\n  particle.reset();\n  const lifeOptions = particle.options.life;\n  if (lifeOptions) {\n    life.delay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(lifeOptions.delay.value) * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds;\n    life.duration = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(lifeOptions.duration.value) * _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../updaters/life/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../updaters/life/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLifeUpdater: () => (/* binding */ loadLifeUpdater)\n/* harmony export */ });\n/* harmony import */ var _LifeUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LifeUpdater.js */ \"../../updaters/life/dist/browser/LifeUpdater.js\");\n\nasync function loadLifeUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"life\", async container => {\n    return Promise.resolve(new _LifeUpdater_js__WEBPACK_IMPORTED_MODULE_0__.LifeUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/life/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/opacity/dist/browser/OpacityUpdater.js":
/*!*************************************************************!*\
  !*** ../../updaters/opacity/dist/browser/OpacityUpdater.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OpacityUpdater: () => (/* binding */ OpacityUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass OpacityUpdater {\n  constructor(container) {\n    this.container = container;\n  }\n  init(particle) {\n    const opacityOptions = particle.options.opacity,\n      pxRatio = 1;\n    particle.opacity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.initParticleNumericAnimationValue)(opacityOptions, pxRatio);\n    const opacityAnimation = opacityOptions.animation;\n    if (opacityAnimation.enable) {\n      particle.opacity.velocity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(opacityAnimation.speed) / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator * this.container.retina.reduceFactor;\n      if (!opacityAnimation.sync) {\n        particle.opacity.velocity *= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n      }\n    }\n  }\n  isEnabled(particle) {\n    const none = 0;\n    return !particle.destroyed && !particle.spawning && !!particle.opacity && particle.opacity.enable && ((particle.opacity.maxLoops ?? none) <= none || (particle.opacity.maxLoops ?? none) > none && (particle.opacity.loops ?? none) < (particle.opacity.maxLoops ?? none));\n  }\n  reset(particle) {\n    if (particle.opacity) {\n      particle.opacity.time = 0;\n      particle.opacity.loops = 0;\n    }\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle) || !particle.opacity) {\n      return;\n    }\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateAnimation)(particle, particle.opacity, true, particle.options.opacity.animation.destroy, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/opacity/dist/browser/OpacityUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/opacity/dist/browser/index.js":
/*!****************************************************!*\
  !*** ../../updaters/opacity/dist/browser/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadOpacityUpdater: () => (/* binding */ loadOpacityUpdater)\n/* harmony export */ });\n/* harmony import */ var _OpacityUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OpacityUpdater.js */ \"../../updaters/opacity/dist/browser/OpacityUpdater.js\");\n\nasync function loadOpacityUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"opacity\", container => {\n    return Promise.resolve(new _OpacityUpdater_js__WEBPACK_IMPORTED_MODULE_0__.OpacityUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/opacity/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/BounceOutMode.js":
/*!*************************************************************!*\
  !*** ../../updaters/outModes/dist/browser/BounceOutMode.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BounceOutMode: () => (/* binding */ BounceOutMode)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"../../updaters/outModes/dist/browser/Utils.js\");\n\n\nclass BounceOutMode {\n  constructor(container) {\n    this.container = container;\n    this.modes = [_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.bounce, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.split];\n  }\n  update(particle, direction, delta, outMode) {\n    if (!this.modes.includes(outMode)) {\n      return;\n    }\n    const container = this.container;\n    let handled = false;\n    for (const plugin of container.plugins.values()) {\n      if (plugin.particleBounce !== undefined) {\n        handled = plugin.particleBounce(particle, delta, direction);\n      }\n      if (handled) {\n        break;\n      }\n    }\n    if (handled) {\n      return;\n    }\n    const pos = particle.getPosition(),\n      offset = particle.offset,\n      size = particle.getRadius(),\n      bounds = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calculateBounds)(pos, size),\n      canvasSize = container.canvas.size;\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.bounceHorizontal)({\n      particle,\n      outMode,\n      direction,\n      bounds,\n      canvasSize,\n      offset,\n      size\n    });\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.bounceVertical)({\n      particle,\n      outMode,\n      direction,\n      bounds,\n      canvasSize,\n      offset,\n      size\n    });\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/BounceOutMode.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/DestroyOutMode.js":
/*!**************************************************************!*\
  !*** ../../updaters/outModes/dist/browser/DestroyOutMode.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DestroyOutMode: () => (/* binding */ DestroyOutMode)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minVelocity = 0;\nclass DestroyOutMode {\n  constructor(container) {\n    this.container = container;\n    this.modes = [_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.destroy];\n  }\n  update(particle, direction, _delta, outMode) {\n    if (!this.modes.includes(outMode)) {\n      return;\n    }\n    const container = this.container;\n    switch (particle.outType) {\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.normal:\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.outside:\n        if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(particle.position, container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin, particle.getRadius(), direction)) {\n          return;\n        }\n        break;\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.inside:\n        {\n          const {\n              dx,\n              dy\n            } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, particle.moveCenter),\n            {\n              x: vx,\n              y: vy\n            } = particle.velocity;\n          if (vx < minVelocity && dx > particle.moveCenter.radius || vy < minVelocity && dy > particle.moveCenter.radius || vx >= minVelocity && dx < -particle.moveCenter.radius || vy >= minVelocity && dy < -particle.moveCenter.radius) {\n            return;\n          }\n          break;\n        }\n    }\n    container.particles.remove(particle, particle.group, true);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/DestroyOutMode.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/NoneOutMode.js":
/*!***********************************************************!*\
  !*** ../../updaters/outModes/dist/browser/NoneOutMode.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NoneOutMode: () => (/* binding */ NoneOutMode)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minVelocity = 0;\nclass NoneOutMode {\n  constructor(container) {\n    this.container = container;\n    this.modes = [_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.none];\n  }\n  update(particle, direction, delta, outMode) {\n    if (!this.modes.includes(outMode)) {\n      return;\n    }\n    if ((particle.options.move.distance.horizontal && (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left || direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right)) ?? (particle.options.move.distance.vertical && (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top || direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom))) {\n      return;\n    }\n    const gravityOptions = particle.options.move.gravity,\n      container = this.container,\n      canvasSize = container.canvas.size,\n      pRadius = particle.getRadius();\n    if (!gravityOptions.enable) {\n      if (particle.velocity.y > minVelocity && particle.position.y <= canvasSize.height + pRadius || particle.velocity.y < minVelocity && particle.position.y >= -pRadius || particle.velocity.x > minVelocity && particle.position.x <= canvasSize.width + pRadius || particle.velocity.x < minVelocity && particle.position.x >= -pRadius) {\n        return;\n      }\n      if (!(0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(particle.position, container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin, pRadius, direction)) {\n        container.particles.remove(particle);\n      }\n    } else {\n      const position = particle.position;\n      if (!gravityOptions.inverse && position.y > canvasSize.height + pRadius && direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom || gravityOptions.inverse && position.y < -pRadius && direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top) {\n        container.particles.remove(particle);\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/NoneOutMode.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/OutOfCanvasUpdater.js":
/*!******************************************************************!*\
  !*** ../../updaters/outModes/dist/browser/OutOfCanvasUpdater.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OutOfCanvasUpdater: () => (/* binding */ OutOfCanvasUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _BounceOutMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BounceOutMode.js */ \"../../updaters/outModes/dist/browser/BounceOutMode.js\");\n/* harmony import */ var _DestroyOutMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DestroyOutMode.js */ \"../../updaters/outModes/dist/browser/DestroyOutMode.js\");\n/* harmony import */ var _NoneOutMode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NoneOutMode.js */ \"../../updaters/outModes/dist/browser/NoneOutMode.js\");\n/* harmony import */ var _OutOutMode_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./OutOutMode.js */ \"../../updaters/outModes/dist/browser/OutOutMode.js\");\n\n\n\n\n\nconst checkOutMode = (outModes, outMode) => {\n  return outModes.default === outMode || outModes.bottom === outMode || outModes.left === outMode || outModes.right === outMode || outModes.top === outMode;\n};\nclass OutOfCanvasUpdater {\n  constructor(container) {\n    this._addUpdaterIfMissing = (particle, outMode, getUpdater) => {\n      const outModes = particle.options.move.outModes;\n      if (!this.updaters.has(outMode) && checkOutMode(outModes, outMode)) {\n        this.updaters.set(outMode, getUpdater(this.container));\n      }\n    };\n    this._updateOutMode = (particle, delta, outMode, direction) => {\n      for (const updater of this.updaters.values()) {\n        updater.update(particle, direction, delta, outMode);\n      }\n    };\n    this.container = container;\n    this.updaters = new Map();\n  }\n  init(particle) {\n    this._addUpdaterIfMissing(particle, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.bounce, container => new _BounceOutMode_js__WEBPACK_IMPORTED_MODULE_1__.BounceOutMode(container));\n    this._addUpdaterIfMissing(particle, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.out, container => new _OutOutMode_js__WEBPACK_IMPORTED_MODULE_4__.OutOutMode(container));\n    this._addUpdaterIfMissing(particle, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.destroy, container => new _DestroyOutMode_js__WEBPACK_IMPORTED_MODULE_2__.DestroyOutMode(container));\n    this._addUpdaterIfMissing(particle, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.none, container => new _NoneOutMode_js__WEBPACK_IMPORTED_MODULE_3__.NoneOutMode(container));\n  }\n  isEnabled(particle) {\n    return !particle.destroyed && !particle.spawning;\n  }\n  update(particle, delta) {\n    const outModes = particle.options.move.outModes;\n    this._updateOutMode(particle, delta, outModes.bottom ?? outModes.default, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom);\n    this._updateOutMode(particle, delta, outModes.left ?? outModes.default, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left);\n    this._updateOutMode(particle, delta, outModes.right ?? outModes.default, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right);\n    this._updateOutMode(particle, delta, outModes.top ?? outModes.default, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/OutOfCanvasUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/OutOutMode.js":
/*!**********************************************************!*\
  !*** ../../updaters/outModes/dist/browser/OutOutMode.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OutOutMode: () => (/* binding */ OutOutMode)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minVelocity = 0,\n  minDistance = 0;\nclass OutOutMode {\n  constructor(container) {\n    this.container = container;\n    this.modes = [_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.out];\n  }\n  update(particle, direction, delta, outMode) {\n    if (!this.modes.includes(outMode)) {\n      return;\n    }\n    const container = this.container;\n    switch (particle.outType) {\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.inside:\n        {\n          const {\n            x: vx,\n            y: vy\n          } = particle.velocity;\n          const circVec = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin;\n          circVec.length = particle.moveCenter.radius;\n          circVec.angle = particle.velocity.angle + Math.PI;\n          circVec.addTo(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.create(particle.moveCenter));\n          const {\n            dx,\n            dy\n          } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, circVec);\n          if (vx <= minVelocity && dx >= minDistance || vy <= minVelocity && dy >= minDistance || vx >= minVelocity && dx <= minDistance || vy >= minVelocity && dy <= minDistance) {\n            return;\n          }\n          particle.position.x = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)({\n            min: 0,\n            max: container.canvas.size.width\n          }));\n          particle.position.y = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)({\n            min: 0,\n            max: container.canvas.size.height\n          }));\n          const {\n            dx: newDx,\n            dy: newDy\n          } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, particle.moveCenter);\n          particle.direction = Math.atan2(-newDy, -newDx);\n          particle.velocity.angle = particle.direction;\n          break;\n        }\n      default:\n        {\n          if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isPointInside)(particle.position, container.canvas.size, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Vector.origin, particle.getRadius(), direction)) {\n            return;\n          }\n          switch (particle.outType) {\n            case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.outside:\n              {\n                particle.position.x = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)({\n                  min: -particle.moveCenter.radius,\n                  max: particle.moveCenter.radius\n                })) + particle.moveCenter.x;\n                particle.position.y = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.randomInRange)({\n                  min: -particle.moveCenter.radius,\n                  max: particle.moveCenter.radius\n                })) + particle.moveCenter.y;\n                const {\n                  dx,\n                  dy\n                } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(particle.position, particle.moveCenter);\n                if (particle.moveCenter.radius) {\n                  particle.direction = Math.atan2(dy, dx);\n                  particle.velocity.angle = particle.direction;\n                }\n                break;\n              }\n            case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticleOutType.normal:\n              {\n                const warp = particle.options.move.warp,\n                  canvasSize = container.canvas.size,\n                  newPos = {\n                    bottom: canvasSize.height + particle.getRadius() + particle.offset.y,\n                    left: -particle.getRadius() - particle.offset.x,\n                    right: canvasSize.width + particle.getRadius() + particle.offset.x,\n                    top: -particle.getRadius() - particle.offset.y\n                  },\n                  sizeValue = particle.getRadius(),\n                  nextBounds = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.calculateBounds)(particle.position, sizeValue);\n                if (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right && nextBounds.left > canvasSize.width + particle.offset.x) {\n                  particle.position.x = newPos.left;\n                  particle.initialPosition.x = particle.position.x;\n                  if (!warp) {\n                    particle.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * canvasSize.height;\n                    particle.initialPosition.y = particle.position.y;\n                  }\n                } else if (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left && nextBounds.right < -particle.offset.x) {\n                  particle.position.x = newPos.right;\n                  particle.initialPosition.x = particle.position.x;\n                  if (!warp) {\n                    particle.position.y = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * canvasSize.height;\n                    particle.initialPosition.y = particle.position.y;\n                  }\n                }\n                if (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom && nextBounds.top > canvasSize.height + particle.offset.y) {\n                  if (!warp) {\n                    particle.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * canvasSize.width;\n                    particle.initialPosition.x = particle.position.x;\n                  }\n                  particle.position.y = newPos.top;\n                  particle.initialPosition.y = particle.position.y;\n                } else if (direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top && nextBounds.bottom < -particle.offset.y) {\n                  if (!warp) {\n                    particle.position.x = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * canvasSize.width;\n                    particle.initialPosition.x = particle.position.x;\n                  }\n                  particle.position.y = newPos.bottom;\n                  particle.initialPosition.y = particle.position.y;\n                }\n                break;\n              }\n          }\n          break;\n        }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/OutOutMode.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/Utils.js":
/*!*****************************************************!*\
  !*** ../../updaters/outModes/dist/browser/Utils.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   bounceHorizontal: () => (/* binding */ bounceHorizontal),\n/* harmony export */   bounceVertical: () => (/* binding */ bounceVertical)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minVelocity = 0,\n  boundsMin = 0;\nfunction bounceHorizontal(data) {\n  if (data.outMode !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.bounce && data.outMode !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.split || data.direction !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left && data.direction !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right) {\n    return;\n  }\n  if (data.bounds.right < boundsMin && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left) {\n    data.particle.position.x = data.size + data.offset.x;\n  } else if (data.bounds.left > data.canvasSize.width && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right) {\n    data.particle.position.x = data.canvasSize.width - data.size - data.offset.x;\n  }\n  const velocity = data.particle.velocity.x;\n  let bounced = false;\n  if (data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right && data.bounds.right >= data.canvasSize.width && velocity > minVelocity || data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left && data.bounds.left <= boundsMin && velocity < minVelocity) {\n    const newVelocity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(data.particle.options.bounce.horizontal.value);\n    data.particle.velocity.x *= -newVelocity;\n    bounced = true;\n  }\n  if (!bounced) {\n    return;\n  }\n  const minPos = data.offset.x + data.size;\n  if (data.bounds.right >= data.canvasSize.width && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.right) {\n    data.particle.position.x = data.canvasSize.width - minPos;\n  } else if (data.bounds.left <= boundsMin && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.left) {\n    data.particle.position.x = minPos;\n  }\n  if (data.outMode === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.split) {\n    data.particle.destroy();\n  }\n}\nfunction bounceVertical(data) {\n  if (data.outMode !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.bounce && data.outMode !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.split || data.direction !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom && data.direction !== _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top) {\n    return;\n  }\n  if (data.bounds.bottom < boundsMin && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top) {\n    data.particle.position.y = data.size + data.offset.y;\n  } else if (data.bounds.top > data.canvasSize.height && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom) {\n    data.particle.position.y = data.canvasSize.height - data.size - data.offset.y;\n  }\n  const velocity = data.particle.velocity.y;\n  let bounced = false;\n  if (data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom && data.bounds.bottom >= data.canvasSize.height && velocity > minVelocity || data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top && data.bounds.top <= boundsMin && velocity < minVelocity) {\n    const newVelocity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(data.particle.options.bounce.vertical.value);\n    data.particle.velocity.y *= -newVelocity;\n    bounced = true;\n  }\n  if (!bounced) {\n    return;\n  }\n  const minPos = data.offset.y + data.size;\n  if (data.bounds.bottom >= data.canvasSize.height && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.bottom) {\n    data.particle.position.y = data.canvasSize.height - minPos;\n  } else if (data.bounds.top <= boundsMin && data.direction === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutModeDirection.top) {\n    data.particle.position.y = minPos;\n  }\n  if (data.outMode === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OutMode.split) {\n    data.particle.destroy();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../updaters/outModes/dist/browser/index.js":
/*!*****************************************************!*\
  !*** ../../updaters/outModes/dist/browser/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadOutModesUpdater: () => (/* binding */ loadOutModesUpdater)\n/* harmony export */ });\n/* harmony import */ var _OutOfCanvasUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OutOfCanvasUpdater.js */ \"../../updaters/outModes/dist/browser/OutOfCanvasUpdater.js\");\n\nasync function loadOutModesUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"outModes\", container => {\n    return Promise.resolve(new _OutOfCanvasUpdater_js__WEBPACK_IMPORTED_MODULE_0__.OutOfCanvasUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/outModes/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/Options/Classes/Roll.js":
/*!****************************************************************!*\
  !*** ../../updaters/roll/dist/browser/Options/Classes/Roll.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Roll: () => (/* binding */ Roll)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _RollLight_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RollLight.js */ \"../../updaters/roll/dist/browser/Options/Classes/RollLight.js\");\n/* harmony import */ var _RollMode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../RollMode.js */ \"../../updaters/roll/dist/browser/RollMode.js\");\n\n\n\nclass Roll {\n  constructor() {\n    this.darken = new _RollLight_js__WEBPACK_IMPORTED_MODULE_1__.RollLight();\n    this.enable = false;\n    this.enlighten = new _RollLight_js__WEBPACK_IMPORTED_MODULE_1__.RollLight();\n    this.mode = _RollMode_js__WEBPACK_IMPORTED_MODULE_2__.RollMode.vertical;\n    this.speed = 25;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.backColor !== undefined) {\n      this.backColor = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.backColor, data.backColor);\n    }\n    this.darken.load(data.darken);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    this.enlighten.load(data.enlighten);\n    if (data.mode !== undefined) {\n      this.mode = data.mode;\n    }\n    if (data.speed !== undefined) {\n      this.speed = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.speed);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/Options/Classes/Roll.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/Options/Classes/RollLight.js":
/*!*********************************************************************!*\
  !*** ../../updaters/roll/dist/browser/Options/Classes/RollLight.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RollLight: () => (/* binding */ RollLight)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass RollLight {\n  constructor() {\n    this.enable = false;\n    this.value = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.value !== undefined) {\n      this.value = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.value);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/Options/Classes/RollLight.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/RollMode.js":
/*!****************************************************!*\
  !*** ../../updaters/roll/dist/browser/RollMode.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RollMode: () => (/* binding */ RollMode)\n/* harmony export */ });\nvar RollMode;\n(function (RollMode) {\n  RollMode[\"both\"] = \"both\";\n  RollMode[\"horizontal\"] = \"horizontal\";\n  RollMode[\"vertical\"] = \"vertical\";\n})(RollMode || (RollMode = {}));\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/RollMode.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/RollUpdater.js":
/*!*******************************************************!*\
  !*** ../../updaters/roll/dist/browser/RollUpdater.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RollUpdater: () => (/* binding */ RollUpdater)\n/* harmony export */ });\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Utils.js */ \"../../updaters/roll/dist/browser/Utils.js\");\n/* harmony import */ var _Options_Classes_Roll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Roll.js */ \"../../updaters/roll/dist/browser/Options/Classes/Roll.js\");\n\n\nclass RollUpdater {\n  constructor(engine) {\n    this._engine = engine;\n  }\n  getTransformValues(particle) {\n    const roll = particle.roll?.enable && particle.roll,\n      rollHorizontal = roll && roll.horizontal,\n      rollVertical = roll && roll.vertical;\n    return {\n      a: rollHorizontal ? Math.cos(roll.angle) : undefined,\n      d: rollVertical ? Math.sin(roll.angle) : undefined\n    };\n  }\n  init(particle) {\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_0__.initParticle)(this._engine, particle);\n  }\n  isEnabled(particle) {\n    const roll = particle.options.roll;\n    return !particle.destroyed && !particle.spawning && !!roll?.enable;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.roll) {\n      options.roll = new _Options_Classes_Roll_js__WEBPACK_IMPORTED_MODULE_1__.Roll();\n    }\n    for (const source of sources) {\n      options.roll.load(source?.roll);\n    }\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_0__.updateRoll)(particle, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/RollUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/Utils.js":
/*!*************************************************!*\
  !*** ../../updaters/roll/dist/browser/Utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   initParticle: () => (/* binding */ initParticle),\n/* harmony export */   updateRoll: () => (/* binding */ updateRoll)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _RollMode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RollMode.js */ \"../../updaters/roll/dist/browser/RollMode.js\");\n\n\nconst double = 2,\n  doublePI = Math.PI * double,\n  maxAngle = 360;\nfunction initParticle(engine, particle) {\n  const rollOpt = particle.options.roll;\n  if (!rollOpt?.enable) {\n    particle.roll = {\n      enable: false,\n      horizontal: false,\n      vertical: false,\n      angle: 0,\n      speed: 0\n    };\n    return;\n  }\n  particle.roll = {\n    enable: rollOpt.enable,\n    horizontal: rollOpt.mode === _RollMode_js__WEBPACK_IMPORTED_MODULE_1__.RollMode.horizontal || rollOpt.mode === _RollMode_js__WEBPACK_IMPORTED_MODULE_1__.RollMode.both,\n    vertical: rollOpt.mode === _RollMode_js__WEBPACK_IMPORTED_MODULE_1__.RollMode.vertical || rollOpt.mode === _RollMode_js__WEBPACK_IMPORTED_MODULE_1__.RollMode.both,\n    angle: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * doublePI,\n    speed: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rollOpt.speed) / maxAngle\n  };\n  if (rollOpt.backColor) {\n    particle.backColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(engine, rollOpt.backColor);\n  } else if (rollOpt.darken.enable && rollOpt.enlighten.enable) {\n    const alterType = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() >= _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.half ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AlterType.darken : _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AlterType.enlighten;\n    particle.roll.alter = {\n      type: alterType,\n      value: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(alterType === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AlterType.darken ? rollOpt.darken.value : rollOpt.enlighten.value)\n    };\n  } else if (rollOpt.darken.enable) {\n    particle.roll.alter = {\n      type: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AlterType.darken,\n      value: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rollOpt.darken.value)\n    };\n  } else if (rollOpt.enlighten.enable) {\n    particle.roll.alter = {\n      type: _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AlterType.enlighten,\n      value: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rollOpt.enlighten.value)\n    };\n  }\n}\nfunction updateRoll(particle, delta) {\n  const roll = particle.options.roll,\n    data = particle.roll;\n  if (!data || !roll?.enable) {\n    return;\n  }\n  const speed = data.speed * delta.factor,\n    max = doublePI;\n  data.angle += speed;\n  if (data.angle > max) {\n    data.angle -= max;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../updaters/roll/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../updaters/roll/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadRollUpdater: () => (/* binding */ loadRollUpdater)\n/* harmony export */ });\n/* harmony import */ var _RollUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RollUpdater.js */ \"../../updaters/roll/dist/browser/RollUpdater.js\");\n\nasync function loadRollUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"roll\", () => {\n    return Promise.resolve(new _RollUpdater_js__WEBPACK_IMPORTED_MODULE_0__.RollUpdater(engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/roll/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/rotate/dist/browser/Options/Classes/Rotate.js":
/*!********************************************************************!*\
  !*** ../../updaters/rotate/dist/browser/Options/Classes/Rotate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Rotate: () => (/* binding */ Rotate)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _RotateAnimation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RotateAnimation.js */ \"../../updaters/rotate/dist/browser/Options/Classes/RotateAnimation.js\");\n\n\nclass Rotate extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _RotateAnimation_js__WEBPACK_IMPORTED_MODULE_1__.RotateAnimation();\n    this.direction = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise;\n    this.path = false;\n    this.value = 0;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    super.load(data);\n    if (data.direction !== undefined) {\n      this.direction = data.direction;\n    }\n    this.animation.load(data.animation);\n    if (data.path !== undefined) {\n      this.path = data.path;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/rotate/dist/browser/Options/Classes/Rotate.js?\n}");

/***/ }),

/***/ "../../updaters/rotate/dist/browser/Options/Classes/RotateAnimation.js":
/*!*****************************************************************************!*\
  !*** ../../updaters/rotate/dist/browser/Options/Classes/RotateAnimation.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RotateAnimation: () => (/* binding */ RotateAnimation)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass RotateAnimation {\n  constructor() {\n    this.enable = false;\n    this.speed = 0;\n    this.decay = 0;\n    this.sync = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.speed !== undefined) {\n      this.speed = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.speed);\n    }\n    if (data.decay !== undefined) {\n      this.decay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.decay);\n    }\n    if (data.sync !== undefined) {\n      this.sync = data.sync;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/rotate/dist/browser/Options/Classes/RotateAnimation.js?\n}");

/***/ }),

/***/ "../../updaters/rotate/dist/browser/RotateUpdater.js":
/*!***********************************************************!*\
  !*** ../../updaters/rotate/dist/browser/RotateUpdater.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RotateUpdater: () => (/* binding */ RotateUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Rotate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Rotate.js */ \"../../updaters/rotate/dist/browser/Options/Classes/Rotate.js\");\n\n\nconst double = 2,\n  doublePI = Math.PI * double,\n  identity = 1,\n  doublePIDeg = 360;\nclass RotateUpdater {\n  constructor(container) {\n    this.container = container;\n  }\n  init(particle) {\n    const rotateOptions = particle.options.rotate;\n    if (!rotateOptions) {\n      return;\n    }\n    particle.rotate = {\n      enable: rotateOptions.animation.enable,\n      value: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rotateOptions.value)),\n      min: 0,\n      max: doublePI\n    };\n    particle.pathRotation = rotateOptions.path;\n    let rotateDirection = rotateOptions.direction;\n    if (rotateDirection === _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.random) {\n      const index = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * double),\n        minIndex = 0;\n      rotateDirection = index > minIndex ? _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.counterClockwise : _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise;\n    }\n    switch (rotateDirection) {\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.counterClockwise:\n      case \"counterClockwise\":\n        particle.rotate.status = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AnimationStatus.decreasing;\n        break;\n      case _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.RotateDirection.clockwise:\n        particle.rotate.status = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AnimationStatus.increasing;\n        break;\n    }\n    const rotateAnimation = rotateOptions.animation;\n    if (rotateAnimation.enable) {\n      particle.rotate.decay = identity - (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rotateAnimation.decay);\n      particle.rotate.velocity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(rotateAnimation.speed) / doublePIDeg * this.container.retina.reduceFactor;\n      if (!rotateAnimation.sync) {\n        particle.rotate.velocity *= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n      }\n    }\n    particle.rotation = particle.rotate.value;\n  }\n  isEnabled(particle) {\n    const rotate = particle.options.rotate;\n    if (!rotate) {\n      return false;\n    }\n    return !particle.destroyed && !particle.spawning && (!!rotate.value || rotate.animation.enable || rotate.path);\n  }\n  loadOptions(options, ...sources) {\n    if (!options.rotate) {\n      options.rotate = new _Options_Classes_Rotate_js__WEBPACK_IMPORTED_MODULE_1__.Rotate();\n    }\n    for (const source of sources) {\n      options.rotate.load(source?.rotate);\n    }\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    particle.isRotating = !!particle.rotate;\n    if (!particle.rotate) {\n      return;\n    }\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateAnimation)(particle, particle.rotate, false, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DestroyType.none, delta);\n    particle.rotation = particle.rotate.value;\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/rotate/dist/browser/RotateUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/rotate/dist/browser/index.js":
/*!***************************************************!*\
  !*** ../../updaters/rotate/dist/browser/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadRotateUpdater: () => (/* binding */ loadRotateUpdater)\n/* harmony export */ });\n/* harmony import */ var _RotateUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RotateUpdater.js */ \"../../updaters/rotate/dist/browser/RotateUpdater.js\");\n\nasync function loadRotateUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"rotate\", container => {\n    return Promise.resolve(new _RotateUpdater_js__WEBPACK_IMPORTED_MODULE_0__.RotateUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/rotate/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/size/dist/browser/SizeUpdater.js":
/*!*******************************************************!*\
  !*** ../../updaters/size/dist/browser/SizeUpdater.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SizeUpdater: () => (/* binding */ SizeUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst minLoops = 0;\nclass SizeUpdater {\n  init(particle) {\n    const container = particle.container,\n      sizeOptions = particle.options.size,\n      sizeAnimation = sizeOptions.animation;\n    if (sizeAnimation.enable) {\n      particle.size.velocity = (particle.retina.sizeAnimationSpeed ?? container.retina.sizeAnimationSpeed) / _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.percentDenominator * container.retina.reduceFactor;\n      if (!sizeAnimation.sync) {\n        particle.size.velocity *= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n      }\n    }\n  }\n  isEnabled(particle) {\n    return !particle.destroyed && !particle.spawning && particle.size.enable && ((particle.size.maxLoops ?? minLoops) <= minLoops || (particle.size.maxLoops ?? minLoops) > minLoops && (particle.size.loops ?? minLoops) < (particle.size.maxLoops ?? minLoops));\n  }\n  reset(particle) {\n    particle.size.loops = minLoops;\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateAnimation)(particle, particle.size, true, particle.options.size.animation.destroy, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/size/dist/browser/SizeUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/size/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../updaters/size/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadSizeUpdater: () => (/* binding */ loadSizeUpdater)\n/* harmony export */ });\n/* harmony import */ var _SizeUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SizeUpdater.js */ \"../../updaters/size/dist/browser/SizeUpdater.js\");\n\nasync function loadSizeUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"size\", () => {\n    return Promise.resolve(new _SizeUpdater_js__WEBPACK_IMPORTED_MODULE_0__.SizeUpdater());\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/size/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/strokeColor/dist/browser/StrokeColorUpdater.js":
/*!*********************************************************************!*\
  !*** ../../updaters/strokeColor/dist/browser/StrokeColorUpdater.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StrokeColorUpdater: () => (/* binding */ StrokeColorUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst defaultOpacity = 1;\nclass StrokeColorUpdater {\n  constructor(container, engine) {\n    this._container = container;\n    this._engine = engine;\n  }\n  init(particle) {\n    const container = this._container,\n      options = particle.options;\n    const stroke = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.itemFromSingleOrMultiple)(options.stroke, particle.id, options.reduceDuplicates);\n    particle.strokeWidth = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(stroke.width) * container.retina.pixelRatio;\n    particle.strokeOpacity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(stroke.opacity ?? defaultOpacity);\n    particle.strokeAnimation = stroke.color?.animation;\n    const strokeHslColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, stroke.color) ?? particle.getFillColor();\n    if (strokeHslColor) {\n      particle.strokeColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getHslAnimationFromHsl)(strokeHslColor, particle.strokeAnimation, container.retina.reduceFactor);\n    }\n  }\n  isEnabled(particle) {\n    const color = particle.strokeAnimation,\n      {\n        strokeColor\n      } = particle;\n    return !particle.destroyed && !particle.spawning && !!color && (strokeColor?.h.value !== undefined && strokeColor.h.enable || strokeColor?.s.value !== undefined && strokeColor.s.enable || strokeColor?.l.value !== undefined && strokeColor.l.enable);\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateColor)(particle.strokeColor, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/strokeColor/dist/browser/StrokeColorUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/strokeColor/dist/browser/index.js":
/*!********************************************************!*\
  !*** ../../updaters/strokeColor/dist/browser/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadStrokeColorUpdater: () => (/* binding */ loadStrokeColorUpdater)\n/* harmony export */ });\n/* harmony import */ var _StrokeColorUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StrokeColorUpdater.js */ \"../../updaters/strokeColor/dist/browser/StrokeColorUpdater.js\");\n\nasync function loadStrokeColorUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"strokeColor\", container => {\n    return Promise.resolve(new _StrokeColorUpdater_js__WEBPACK_IMPORTED_MODULE_0__.StrokeColorUpdater(container, engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/strokeColor/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/tilt/dist/browser/Options/Classes/Tilt.js":
/*!****************************************************************!*\
  !*** ../../updaters/tilt/dist/browser/Options/Classes/Tilt.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Tilt: () => (/* binding */ Tilt)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _TiltDirection_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../TiltDirection.js */ \"../../updaters/tilt/dist/browser/TiltDirection.js\");\n/* harmony import */ var _TiltAnimation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TiltAnimation.js */ \"../../updaters/tilt/dist/browser/Options/Classes/TiltAnimation.js\");\n\n\n\nclass Tilt extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ValueWithRandom {\n  constructor() {\n    super();\n    this.animation = new _TiltAnimation_js__WEBPACK_IMPORTED_MODULE_2__.TiltAnimation();\n    this.direction = _TiltDirection_js__WEBPACK_IMPORTED_MODULE_1__.TiltDirection.clockwise;\n    this.enable = false;\n    this.value = 0;\n  }\n  load(data) {\n    super.load(data);\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    this.animation.load(data.animation);\n    if (data.direction !== undefined) {\n      this.direction = data.direction;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/tilt/dist/browser/Options/Classes/Tilt.js?\n}");

/***/ }),

/***/ "../../updaters/tilt/dist/browser/Options/Classes/TiltAnimation.js":
/*!*************************************************************************!*\
  !*** ../../updaters/tilt/dist/browser/Options/Classes/TiltAnimation.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TiltAnimation: () => (/* binding */ TiltAnimation)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass TiltAnimation {\n  constructor() {\n    this.enable = false;\n    this.speed = 0;\n    this.decay = 0;\n    this.sync = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.speed !== undefined) {\n      this.speed = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.speed);\n    }\n    if (data.decay !== undefined) {\n      this.decay = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.decay);\n    }\n    if (data.sync !== undefined) {\n      this.sync = data.sync;\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/tilt/dist/browser/Options/Classes/TiltAnimation.js?\n}");

/***/ }),

/***/ "../../updaters/tilt/dist/browser/TiltDirection.js":
/*!*********************************************************!*\
  !*** ../../updaters/tilt/dist/browser/TiltDirection.js ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TiltDirection: () => (/* binding */ TiltDirection)\n/* harmony export */ });\nvar TiltDirection;\n(function (TiltDirection) {\n  TiltDirection[\"clockwise\"] = \"clockwise\";\n  TiltDirection[\"counterClockwise\"] = \"counter-clockwise\";\n  TiltDirection[\"random\"] = \"random\";\n})(TiltDirection || (TiltDirection = {}));\n\n//# sourceURL=webpack://tsparticles/../../updaters/tilt/dist/browser/TiltDirection.js?\n}");

/***/ }),

/***/ "../../updaters/tilt/dist/browser/TiltUpdater.js":
/*!*******************************************************!*\
  !*** ../../updaters/tilt/dist/browser/TiltUpdater.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TiltUpdater: () => (/* binding */ TiltUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Tilt_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Tilt.js */ \"../../updaters/tilt/dist/browser/Options/Classes/Tilt.js\");\n/* harmony import */ var _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TiltDirection.js */ \"../../updaters/tilt/dist/browser/TiltDirection.js\");\n\n\n\nconst identity = 1,\n  double = 2,\n  doublePI = Math.PI * double,\n  maxAngle = 360;\nclass TiltUpdater {\n  constructor(container) {\n    this.container = container;\n  }\n  getTransformValues(particle) {\n    const tilt = particle.tilt?.enable && particle.tilt;\n    return {\n      b: tilt ? Math.cos(tilt.value) * tilt.cosDirection : undefined,\n      c: tilt ? Math.sin(tilt.value) * tilt.sinDirection : undefined\n    };\n  }\n  init(particle) {\n    const tiltOptions = particle.options.tilt;\n    if (!tiltOptions) {\n      return;\n    }\n    particle.tilt = {\n      enable: tiltOptions.enable,\n      value: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(tiltOptions.value)),\n      sinDirection: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() >= _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.half ? identity : -identity,\n      cosDirection: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() >= _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.half ? identity : -identity,\n      min: 0,\n      max: doublePI\n    };\n    let tiltDirection = tiltOptions.direction;\n    if (tiltDirection === _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__.TiltDirection.random) {\n      const index = Math.floor((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * double),\n        minIndex = 0;\n      tiltDirection = index > minIndex ? _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__.TiltDirection.counterClockwise : _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__.TiltDirection.clockwise;\n    }\n    switch (tiltDirection) {\n      case _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__.TiltDirection.counterClockwise:\n      case \"counterClockwise\":\n        particle.tilt.status = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AnimationStatus.decreasing;\n        break;\n      case _TiltDirection_js__WEBPACK_IMPORTED_MODULE_2__.TiltDirection.clockwise:\n        particle.tilt.status = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.AnimationStatus.increasing;\n        break;\n    }\n    const tiltAnimation = particle.options.tilt?.animation;\n    if (tiltAnimation?.enable) {\n      particle.tilt.decay = identity - (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(tiltAnimation.decay);\n      particle.tilt.velocity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(tiltAnimation.speed) / maxAngle * this.container.retina.reduceFactor;\n      if (!tiltAnimation.sync) {\n        particle.tilt.velocity *= (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n      }\n    }\n  }\n  isEnabled(particle) {\n    const tiltAnimation = particle.options.tilt?.animation;\n    return !particle.destroyed && !particle.spawning && !!tiltAnimation?.enable;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.tilt) {\n      options.tilt = new _Options_Classes_Tilt_js__WEBPACK_IMPORTED_MODULE_1__.Tilt();\n    }\n    for (const source of sources) {\n      options.tilt.load(source?.tilt);\n    }\n  }\n  async update(particle, delta) {\n    if (!this.isEnabled(particle) || !particle.tilt) {\n      return;\n    }\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.updateAnimation)(particle, particle.tilt, false, _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.DestroyType.none, delta);\n    await Promise.resolve();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/tilt/dist/browser/TiltUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/tilt/dist/browser/index.js":
/*!*************************************************!*\
  !*** ../../updaters/tilt/dist/browser/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadTiltUpdater: () => (/* binding */ loadTiltUpdater)\n/* harmony export */ });\n/* harmony import */ var _TiltUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TiltUpdater.js */ \"../../updaters/tilt/dist/browser/TiltUpdater.js\");\n\nasync function loadTiltUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"tilt\", container => {\n    return Promise.resolve(new _TiltUpdater_js__WEBPACK_IMPORTED_MODULE_0__.TiltUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/tilt/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/twinkle/dist/browser/Options/Classes/Twinkle.js":
/*!**********************************************************************!*\
  !*** ../../updaters/twinkle/dist/browser/Options/Classes/Twinkle.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Twinkle: () => (/* binding */ Twinkle)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _TwinkleValues_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TwinkleValues.js */ \"../../updaters/twinkle/dist/browser/Options/Classes/TwinkleValues.js\");\n\n\nclass Twinkle {\n  constructor() {\n    this.lines = new _TwinkleValues_js__WEBPACK_IMPORTED_MODULE_1__.TwinkleValues();\n    this.particles = new _TwinkleValues_js__WEBPACK_IMPORTED_MODULE_1__.TwinkleValues();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    this.lines.load(data.lines);\n    this.particles.load(data.particles);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/twinkle/dist/browser/Options/Classes/Twinkle.js?\n}");

/***/ }),

/***/ "../../updaters/twinkle/dist/browser/Options/Classes/TwinkleValues.js":
/*!****************************************************************************!*\
  !*** ../../updaters/twinkle/dist/browser/Options/Classes/TwinkleValues.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TwinkleValues: () => (/* binding */ TwinkleValues)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass TwinkleValues {\n  constructor() {\n    this.enable = false;\n    this.frequency = 0.05;\n    this.opacity = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.frequency !== undefined) {\n      this.frequency = data.frequency;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.opacity);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/twinkle/dist/browser/Options/Classes/TwinkleValues.js?\n}");

/***/ }),

/***/ "../../updaters/twinkle/dist/browser/TwinkleUpdater.js":
/*!*************************************************************!*\
  !*** ../../updaters/twinkle/dist/browser/TwinkleUpdater.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TwinkleUpdater: () => (/* binding */ TwinkleUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Twinkle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Twinkle.js */ \"../../updaters/twinkle/dist/browser/Options/Classes/Twinkle.js\");\n\n\nclass TwinkleUpdater {\n  constructor(engine) {\n    this._engine = engine;\n  }\n  getColorStyles(particle, context, radius, opacity) {\n    const pOptions = particle.options,\n      twinkleOptions = pOptions.twinkle;\n    if (!twinkleOptions) {\n      return {};\n    }\n    const twinkle = twinkleOptions.particles,\n      twinkling = twinkle.enable && (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() < twinkle.frequency,\n      zIndexOptions = particle.options.zIndex,\n      zOffset = 1,\n      zOpacityFactor = (zOffset - particle.zIndexFactor) ** zIndexOptions.opacityRate,\n      twinklingOpacity = twinkling ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(twinkle.opacity) * zOpacityFactor : opacity,\n      twinkleRgb = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToHsl)(this._engine, twinkle.color),\n      twinkleStyle = twinkleRgb ? (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromHsl)(twinkleRgb, twinklingOpacity) : undefined,\n      res = {},\n      needsTwinkle = twinkling && twinkleStyle;\n    res.fill = needsTwinkle ? twinkleStyle : undefined;\n    res.stroke = needsTwinkle ? twinkleStyle : undefined;\n    return res;\n  }\n  async init() {\n    await Promise.resolve();\n  }\n  isEnabled(particle) {\n    const pOptions = particle.options,\n      twinkleOptions = pOptions.twinkle;\n    if (!twinkleOptions) {\n      return false;\n    }\n    return twinkleOptions.particles.enable;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.twinkle) {\n      options.twinkle = new _Options_Classes_Twinkle_js__WEBPACK_IMPORTED_MODULE_1__.Twinkle();\n    }\n    for (const source of sources) {\n      options.twinkle.load(source?.twinkle);\n    }\n  }\n  async update() {\n    await Promise.resolve();\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/twinkle/dist/browser/TwinkleUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/twinkle/dist/browser/index.js":
/*!****************************************************!*\
  !*** ../../updaters/twinkle/dist/browser/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadTwinkleUpdater: () => (/* binding */ loadTwinkleUpdater)\n/* harmony export */ });\n/* harmony import */ var _TwinkleUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TwinkleUpdater.js */ \"../../updaters/twinkle/dist/browser/TwinkleUpdater.js\");\n\nasync function loadTwinkleUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"twinkle\", () => {\n    return Promise.resolve(new _TwinkleUpdater_js__WEBPACK_IMPORTED_MODULE_0__.TwinkleUpdater(engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/twinkle/dist/browser/index.js?\n}");

/***/ }),

/***/ "../../updaters/wobble/dist/browser/Options/Classes/Wobble.js":
/*!********************************************************************!*\
  !*** ../../updaters/wobble/dist/browser/Options/Classes/Wobble.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Wobble: () => (/* binding */ Wobble)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _WobbleSpeed_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./WobbleSpeed.js */ \"../../updaters/wobble/dist/browser/Options/Classes/WobbleSpeed.js\");\n\n\nclass Wobble {\n  constructor() {\n    this.distance = 5;\n    this.enable = false;\n    this.speed = new _WobbleSpeed_js__WEBPACK_IMPORTED_MODULE_1__.WobbleSpeed();\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.distance !== undefined) {\n      this.distance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.distance);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.speed !== undefined) {\n      if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNumber)(data.speed)) {\n        this.speed.load({\n          angle: data.speed\n        });\n      } else {\n        const rangeSpeed = data.speed;\n        if (rangeSpeed.min !== undefined) {\n          this.speed.load({\n            angle: rangeSpeed\n          });\n        } else {\n          this.speed.load(data.speed);\n        }\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/wobble/dist/browser/Options/Classes/Wobble.js?\n}");

/***/ }),

/***/ "../../updaters/wobble/dist/browser/Options/Classes/WobbleSpeed.js":
/*!*************************************************************************!*\
  !*** ../../updaters/wobble/dist/browser/Options/Classes/WobbleSpeed.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   WobbleSpeed: () => (/* binding */ WobbleSpeed)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nclass WobbleSpeed {\n  constructor() {\n    this.angle = 50;\n    this.move = 10;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.angle !== undefined) {\n      this.angle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.angle);\n    }\n    if (data.move !== undefined) {\n      this.move = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.setRangeValue)(data.move);\n    }\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/wobble/dist/browser/Options/Classes/WobbleSpeed.js?\n}");

/***/ }),

/***/ "../../updaters/wobble/dist/browser/Utils.js":
/*!***************************************************!*\
  !*** ../../updaters/wobble/dist/browser/Utils.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   updateWobble: () => (/* binding */ updateWobble)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n\nconst defaultDistance = 0,\n  double = 2,\n  doublePI = Math.PI * double,\n  distanceFactor = 60;\nfunction updateWobble(particle, delta) {\n  const {\n      wobble: wobbleOptions\n    } = particle.options,\n    {\n      container,\n      wobble\n    } = particle;\n  if (!wobbleOptions?.enable || !wobble) {\n    return;\n  }\n  const reduceFactor = container.retina.reduceFactor,\n    angleSpeed = wobble.angleSpeed * delta.factor * reduceFactor,\n    moveSpeed = wobble.moveSpeed * delta.factor * reduceFactor,\n    distance = moveSpeed * (particle.retina.wobbleDistance ?? defaultDistance) / (_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.millisecondsToSeconds / distanceFactor),\n    max = doublePI,\n    {\n      position\n    } = particle;\n  wobble.angle += angleSpeed;\n  if (wobble.angle > max) {\n    wobble.angle -= max;\n  }\n  position.x += distance * Math.cos(wobble.angle);\n  position.y += distance * Math.abs(Math.sin(wobble.angle));\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/wobble/dist/browser/Utils.js?\n}");

/***/ }),

/***/ "../../updaters/wobble/dist/browser/WobbleUpdater.js":
/*!***********************************************************!*\
  !*** ../../updaters/wobble/dist/browser/WobbleUpdater.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   WobbleUpdater: () => (/* binding */ WobbleUpdater)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"../../engine/dist/browser/index.js\");\n/* harmony import */ var _Options_Classes_Wobble_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Options/Classes/Wobble.js */ \"../../updaters/wobble/dist/browser/Options/Classes/Wobble.js\");\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Utils.js */ \"../../updaters/wobble/dist/browser/Utils.js\");\n\n\n\nconst double = 2,\n  doublePI = Math.PI * double,\n  maxAngle = 360,\n  moveSpeedFactor = 10,\n  defaultDistance = 0;\nclass WobbleUpdater {\n  constructor(container) {\n    this.container = container;\n  }\n  init(particle) {\n    const wobbleOpt = particle.options.wobble;\n    if (wobbleOpt?.enable) {\n      particle.wobble = {\n        angle: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() * doublePI,\n        angleSpeed: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(wobbleOpt.speed.angle) / maxAngle,\n        moveSpeed: (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(wobbleOpt.speed.move) / moveSpeedFactor\n      };\n    } else {\n      particle.wobble = {\n        angle: 0,\n        angleSpeed: 0,\n        moveSpeed: 0\n      };\n    }\n    particle.retina.wobbleDistance = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(wobbleOpt?.distance ?? defaultDistance) * this.container.retina.pixelRatio;\n  }\n  isEnabled(particle) {\n    return !particle.destroyed && !particle.spawning && !!particle.options.wobble?.enable;\n  }\n  loadOptions(options, ...sources) {\n    if (!options.wobble) {\n      options.wobble = new _Options_Classes_Wobble_js__WEBPACK_IMPORTED_MODULE_1__.Wobble();\n    }\n    for (const source of sources) {\n      options.wobble.load(source?.wobble);\n    }\n  }\n  update(particle, delta) {\n    if (!this.isEnabled(particle)) {\n      return;\n    }\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_2__.updateWobble)(particle, delta);\n  }\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/wobble/dist/browser/WobbleUpdater.js?\n}");

/***/ }),

/***/ "../../updaters/wobble/dist/browser/index.js":
/*!***************************************************!*\
  !*** ../../updaters/wobble/dist/browser/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadWobbleUpdater: () => (/* binding */ loadWobbleUpdater)\n/* harmony export */ });\n/* harmony import */ var _WobbleUpdater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./WobbleUpdater.js */ \"../../updaters/wobble/dist/browser/WobbleUpdater.js\");\n\nasync function loadWobbleUpdater(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addParticleUpdater(\"wobble\", container => {\n    return Promise.resolve(new _WobbleUpdater_js__WEBPACK_IMPORTED_MODULE_0__.WobbleUpdater(container));\n  }, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../../updaters/wobble/dist/browser/index.js?\n}");

/***/ }),

/***/ "../basic/dist/browser/index.js":
/*!**************************************!*\
  !*** ../basic/dist/browser/index.js ***!
  \**************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadBasic: () => (/* binding */ loadBasic)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_move_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/move-base */ \"../../move/base/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_circle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tsparticles/shape-circle */ \"../../shapes/circle/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @tsparticles/updater-color */ \"../../updaters/color/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_plugin_hex_color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @tsparticles/plugin-hex-color */ \"../../plugins/colors/hexColor/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_plugin_hsl_color__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @tsparticles/plugin-hsl-color */ \"../../plugins/colors/hslColor/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_opacity__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @tsparticles/updater-opacity */ \"../../updaters/opacity/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_out_modes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @tsparticles/updater-out-modes */ \"../../updaters/outModes/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_plugin_rgb_color__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @tsparticles/plugin-rgb-color */ \"../../plugins/colors/rgbColor/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_size__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @tsparticles/updater-size */ \"../../updaters/size/dist/browser/index.js\");\n\n\n\n\n\n\n\n\n\nasync function loadBasic(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await (0,_tsparticles_plugin_hex_color__WEBPACK_IMPORTED_MODULE_3__.loadHexColorPlugin)(engine, false);\n  await (0,_tsparticles_plugin_hsl_color__WEBPACK_IMPORTED_MODULE_4__.loadHslColorPlugin)(engine, false);\n  await (0,_tsparticles_plugin_rgb_color__WEBPACK_IMPORTED_MODULE_7__.loadRgbColorPlugin)(engine, false);\n  await (0,_tsparticles_move_base__WEBPACK_IMPORTED_MODULE_0__.loadBaseMover)(engine, false);\n  await (0,_tsparticles_shape_circle__WEBPACK_IMPORTED_MODULE_1__.loadCircleShape)(engine, false);\n  await (0,_tsparticles_updater_color__WEBPACK_IMPORTED_MODULE_2__.loadColorUpdater)(engine, false);\n  await (0,_tsparticles_updater_opacity__WEBPACK_IMPORTED_MODULE_5__.loadOpacityUpdater)(engine, false);\n  await (0,_tsparticles_updater_out_modes__WEBPACK_IMPORTED_MODULE_6__.loadOutModesUpdater)(engine, false);\n  await (0,_tsparticles_updater_size__WEBPACK_IMPORTED_MODULE_8__.loadSizeUpdater)(engine, false);\n  await engine.refresh(refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../basic/dist/browser/index.js?\n}");

/***/ }),

/***/ "../slim/dist/browser/index.js":
/*!*************************************!*\
  !*** ../slim/dist/browser/index.js ***!
  \*************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadSlim: () => (/* binding */ loadSlim)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_basic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/basic */ \"../basic/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_plugin_easing_quad__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tsparticles/plugin-easing-quad */ \"../../plugins/easings/quad/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_emoji__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @tsparticles/shape-emoji */ \"../../shapes/emoji/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_attract__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @tsparticles/interaction-external-attract */ \"../../interactions/external/attract/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_bounce__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @tsparticles/interaction-external-bounce */ \"../../interactions/external/bounce/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_bubble__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @tsparticles/interaction-external-bubble */ \"../../interactions/external/bubble/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_connect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @tsparticles/interaction-external-connect */ \"../../interactions/external/connect/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_grab__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @tsparticles/interaction-external-grab */ \"../../interactions/external/grab/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_pause__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @tsparticles/interaction-external-pause */ \"../../interactions/external/pause/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_push__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @tsparticles/interaction-external-push */ \"../../interactions/external/push/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_remove__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @tsparticles/interaction-external-remove */ \"../../interactions/external/remove/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_repulse__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @tsparticles/interaction-external-repulse */ \"../../interactions/external/repulse/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_external_slow__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @tsparticles/interaction-external-slow */ \"../../interactions/external/slow/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_image__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @tsparticles/shape-image */ \"../../shapes/image/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_life__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @tsparticles/updater-life */ \"../../updaters/life/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_line__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @tsparticles/shape-line */ \"../../shapes/line/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_move_parallax__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @tsparticles/move-parallax */ \"../../move/parallax/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_particles_attract__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @tsparticles/interaction-particles-attract */ \"../../interactions/particles/attract/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_particles_collisions__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @tsparticles/interaction-particles-collisions */ \"../../interactions/particles/collisions/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_interaction_particles_links__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @tsparticles/interaction-particles-links */ \"../../interactions/particles/links/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_polygon__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @tsparticles/shape-polygon */ \"../../shapes/polygon/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_rotate__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @tsparticles/updater-rotate */ \"../../updaters/rotate/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_square__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @tsparticles/shape-square */ \"../../shapes/square/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_shape_star__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @tsparticles/shape-star */ \"../../shapes/star/dist/browser/index.js\");\n/* harmony import */ var _tsparticles_updater_stroke_color__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @tsparticles/updater-stroke-color */ \"../../updaters/strokeColor/dist/browser/index.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nasync function loadSlim(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await (0,_tsparticles_move_parallax__WEBPACK_IMPORTED_MODULE_16__.loadParallaxMover)(engine, false);\n  await (0,_tsparticles_interaction_external_attract__WEBPACK_IMPORTED_MODULE_3__.loadExternalAttractInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_bounce__WEBPACK_IMPORTED_MODULE_4__.loadExternalBounceInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_bubble__WEBPACK_IMPORTED_MODULE_5__.loadExternalBubbleInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_connect__WEBPACK_IMPORTED_MODULE_6__.loadExternalConnectInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_grab__WEBPACK_IMPORTED_MODULE_7__.loadExternalGrabInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_pause__WEBPACK_IMPORTED_MODULE_8__.loadExternalPauseInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_push__WEBPACK_IMPORTED_MODULE_9__.loadExternalPushInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_remove__WEBPACK_IMPORTED_MODULE_10__.loadExternalRemoveInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_repulse__WEBPACK_IMPORTED_MODULE_11__.loadExternalRepulseInteraction)(engine, false);\n  await (0,_tsparticles_interaction_external_slow__WEBPACK_IMPORTED_MODULE_12__.loadExternalSlowInteraction)(engine, false);\n  await (0,_tsparticles_interaction_particles_attract__WEBPACK_IMPORTED_MODULE_17__.loadParticlesAttractInteraction)(engine, false);\n  await (0,_tsparticles_interaction_particles_collisions__WEBPACK_IMPORTED_MODULE_18__.loadParticlesCollisionsInteraction)(engine, false);\n  await (0,_tsparticles_interaction_particles_links__WEBPACK_IMPORTED_MODULE_19__.loadParticlesLinksInteraction)(engine, false);\n  await (0,_tsparticles_plugin_easing_quad__WEBPACK_IMPORTED_MODULE_1__.loadEasingQuadPlugin)(engine, false);\n  await (0,_tsparticles_shape_emoji__WEBPACK_IMPORTED_MODULE_2__.loadEmojiShape)(engine, false);\n  await (0,_tsparticles_shape_image__WEBPACK_IMPORTED_MODULE_13__.loadImageShape)(engine, false);\n  await (0,_tsparticles_shape_line__WEBPACK_IMPORTED_MODULE_15__.loadLineShape)(engine, false);\n  await (0,_tsparticles_shape_polygon__WEBPACK_IMPORTED_MODULE_20__.loadPolygonShape)(engine, false);\n  await (0,_tsparticles_shape_square__WEBPACK_IMPORTED_MODULE_22__.loadSquareShape)(engine, false);\n  await (0,_tsparticles_shape_star__WEBPACK_IMPORTED_MODULE_23__.loadStarShape)(engine, false);\n  await (0,_tsparticles_updater_life__WEBPACK_IMPORTED_MODULE_14__.loadLifeUpdater)(engine, false);\n  await (0,_tsparticles_updater_rotate__WEBPACK_IMPORTED_MODULE_21__.loadRotateUpdater)(engine, false);\n  await (0,_tsparticles_updater_stroke_color__WEBPACK_IMPORTED_MODULE_24__.loadStrokeColorUpdater)(engine, false);\n  await (0,_tsparticles_basic__WEBPACK_IMPORTED_MODULE_0__.loadBasic)(engine, refresh);\n}\n\n//# sourceURL=webpack://tsparticles/../slim/dist/browser/index.js?\n}");

/***/ }),

/***/ "./dist/browser/bundle.js":
/*!********************************!*\
  !*** ./dist/browser/bundle.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AlterType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AlterType),\n/* harmony export */   AnimatableColor: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AnimatableColor),\n/* harmony export */   AnimationMode: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AnimationMode),\n/* harmony export */   AnimationOptions: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AnimationOptions),\n/* harmony export */   AnimationStatus: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AnimationStatus),\n/* harmony export */   AnimationValueWithRandom: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.AnimationValueWithRandom),\n/* harmony export */   Background: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Background),\n/* harmony export */   BackgroundMask: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.BackgroundMask),\n/* harmony export */   BackgroundMaskCover: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.BackgroundMaskCover),\n/* harmony export */   BaseRange: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.BaseRange),\n/* harmony export */   Circle: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Circle),\n/* harmony export */   ClickEvent: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.ClickEvent),\n/* harmony export */   CollisionMode: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.CollisionMode),\n/* harmony export */   Collisions: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Collisions),\n/* harmony export */   CollisionsAbsorb: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.CollisionsAbsorb),\n/* harmony export */   CollisionsOverlap: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.CollisionsOverlap),\n/* harmony export */   ColorAnimation: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.ColorAnimation),\n/* harmony export */   DestroyType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.DestroyType),\n/* harmony export */   DivEvent: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.DivEvent),\n/* harmony export */   DivType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.DivType),\n/* harmony export */   EasingType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.EasingType),\n/* harmony export */   EventType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.EventType),\n/* harmony export */   Events: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Events),\n/* harmony export */   ExternalInteractorBase: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.ExternalInteractorBase),\n/* harmony export */   FullScreen: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.FullScreen),\n/* harmony export */   GradientType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.GradientType),\n/* harmony export */   HoverEvent: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.HoverEvent),\n/* harmony export */   HslAnimation: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.HslAnimation),\n/* harmony export */   Interactivity: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Interactivity),\n/* harmony export */   InteractivityDetect: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.InteractivityDetect),\n/* harmony export */   InteractorType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.InteractorType),\n/* harmony export */   LimitMode: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.LimitMode),\n/* harmony export */   ManualParticle: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.ManualParticle),\n/* harmony export */   Modes: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Modes),\n/* harmony export */   Move: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Move),\n/* harmony export */   MoveAngle: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveAngle),\n/* harmony export */   MoveAttract: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveAttract),\n/* harmony export */   MoveCenter: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveCenter),\n/* harmony export */   MoveDirection: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveDirection),\n/* harmony export */   MoveGravity: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveGravity),\n/* harmony export */   MovePath: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MovePath),\n/* harmony export */   MoveTrail: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.MoveTrail),\n/* harmony export */   Opacity: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Opacity),\n/* harmony export */   OpacityAnimation: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.OpacityAnimation),\n/* harmony export */   Options: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Options),\n/* harmony export */   OptionsColor: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.OptionsColor),\n/* harmony export */   OutMode: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.OutMode),\n/* harmony export */   OutModeDirection: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.OutModeDirection),\n/* harmony export */   OutModes: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.OutModes),\n/* harmony export */   Parallax: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.Parallax),\n/* harmony export */   ParticleOutType: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORTED_MODULE_1__.ParticleOutType),\n/* harmony export */   ParticlesBounce: () => (/* reexport safe */ _tsparticles_engine__WEBPACK_IMPORT