<p align="center">
  <a href="https://vuetifyjs.com" target="_blank">
    <img alt="Vuetify Logo" width="100" src="https://cdn.vuetifyjs.com/images/logos/logo.svg">
  </a>
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/vuetify">
    <img src="https://img.shields.io/npm/dt/vuetify.svg" alt="Downloads">
  </a>
  <a href="https://www.npmjs.com/package/vuetify">
    <img src="https://img.shields.io/npm/dm/vuetify.svg" alt="Downloads">
  </a>
  <br>
  <a href="https://github.com/vuetifyjs/vuetify/blob/master/LICENSE.md">
    <img src="https://img.shields.io/npm/l/vuetify.svg" alt="License">
  </a>
  <a href="https://community.vuetifyjs.com">
    <img src="https://discordapp.com/api/guilds/340160225338195969/widget.png" alt="Chat">
  </a>
  <br>
  <a href="https://www.npmjs.com/package/vuetify">
    <img src="https://img.shields.io/npm/v/vuetify.svg" alt="Version">
  </a>
  <a href="https://cdnjs.com/libraries/vuetify">
    <img src="https://img.shields.io/cdnjs/v/vuetify.svg" alt="CDN">
  </a>
</p>

### 🖥️ Documentation

To check out the documentation, visit [vuetifyjs.com](https://vuetifyjs.com).

![Crowdin Uploads](https://github.com/vuetifyjs/vuetify/workflows/Crowdin%20Uploads/badge.svg?branch=master)

### ⚡ Quick Start

Getting started with Vuetify is easy. To create a new project, choose your package manager and run one of the following commands:

Using [pnpm](https://pnpm.io/)

```bash
pnpm create vuetify
```

Using [yarn](https://yarnpkg.com/)

```bash
yarn create vuetify
```

Using [npm](https://npmjs.com/)

```bash
npm create vuetify@latest
```

Using [bun](https://bun.sh/)

```bash
bun create vuetify
```

For more information on how to get started, such as using Nuxt or Laravel, check out the official [Installation guide](https://vuetifyjs.com/getting-started/installation/).

### 💖 Supporting Vuetify

Vuetify is a [MIT licensed](http://opensource.org/licenses/MIT) project that is developed and maintained by the [Core Team](https://vuetifyjs.com/about/meet-the-team/). Sponsor Vuetify and receive some **awesome perks** and support Open Source Software at the same time! 🎉

<ul>
  <li>
    <a href="https://github.com/users/johnleider/sponsorship">Become a backer or sponsor on GitHub</a>
  </li>
  <li>
    <a href="https://opencollective.com/vuetify">Become a backer or sponsor on Open Collective</a>
    <strong><small>(supports the Core team)</small></strong>
  </li>
  <li>
    <a href="https://tidelift.com/subscription/request-a-demo?utm_source=npm-vuetify&utm_medium=referral&utm_campaign=enterprise">Become a subscriber on Tidelift</a>
  </li>
  <li>
    <a href="https://paypal.me/vuetify">Make a one-time payment with Paypal</a>
  </li>
</ul>

### What's the difference between GitHub Sponsors and OpenCollective?

Funds donated through GitHub Sponsors directly support [John Leider](https://github.com/sponsors/johnleider) and the ongoing development and maintenance of Vuetify. Funds donated via Open Collective are managed with transparent expenses and will be used for compensating work and expenses for Core team members. Your name/logo will receive proper recognition and exposure by donating on either platform.

<h3><b>Special Sponsor</b></h3>

<table>
  <tbody>
    <tr>
      <td>
        <a href="https://www.deepcloud.swiss/" target="_blank">
          <img height="65px" src="https://cdn.cosmicjs.com/20504e40-6cbc-11ef-b5ae-a594bb4a8e67-deepcloud-light.svg">
        </a>
      </td>
    </tr>
  </tbody>
</table>

<h3><b>Diamond Sponsors</b></h3>

<table>
  <tbody>
    <tr>
      <td>
        <a href="https://route4me.com/">
          <img height="40px" src="https://cdn.cosmicjs.com/3b7a95b0-5360-11ef-b1ea-f56c65dfade9-route-4-me-light.png">
        </a>
      </td>
      <td>
        <a href="https://www.abacus.ch/">
          <img height="40px" src="https://cdn.cosmicjs.com/0b978be0-6cbb-11ef-b5ae-a594bb4a8e67-abacus-light.svg">
        </a>
      </td>
      <td>
        <a href="https://www.hoop.swiss/">
          <img height="40px" src="https://cdn.cosmicjs.com/94012850-6cbc-11ef-b5ae-a594bb4a8e67-hoop-light.svg">
        </a>
      </td>
    </tr>
  </tbody>
</table>

<h3><b>Platinum Sponsors</b></h3>

<table>
  <tbody>
    <tr>
      <td style="text-align: center;">
        <a href="https://www.muenchen.de/">
          <img height="30px" src="https://imgix.cosmicjs.com/af2ce530-eaa2-11ed-ba82-019c4666da06-itm-logo.png">
        </a>
      </td>
      <td>
        <a href="https://views4you.com/buy-instagram-followers/">
          <img height="30px" src="https://cdn.cosmicjs.com/861b0ce0-50e4-11ef-b1ea-f56c65dfade9-views-4-you-light.png">
        </a>
      </td>
      <td>
        <a href="https://word.tips/">
          <img height="30px" src="https://cdn.cosmicjs.com/5b16bd20-afab-11ef-bee4-3bb1d3c55332-wordtips-light.svg">
        </a>
      </td>
    </tr>
    <tr></tr>
    <tr>
      <td>
        <a href="https://www.vso.org.uk/">
          <img height="30px" src="https://cdn.cosmicjs.com/64287760-e7c2-11ef-b333-e101bec29f3d-horizontal_logo.svg">
        </a>
      </td>
      </td>
      <td style="text-align: center;">
        <a href="https://haircenterofturkey.com/">
          <img height="30px" src="https://cdn.cosmicjs.com/ba1af160-1a27-11f0-a229-dfe84053cfeb-hcof-logo-light-1.png">
        </a>
      </td>
      <td></td>
    </tr>
  </tbody>
</table>

---

### 🚀 Introduction

Vuetify is a no design skills required UI Library with beautifully handcrafted Vue Components. No design skills required — everything you need to create amazing applications is at your fingertips. Vuetify has a massive API that supports any use-case. Some highlights include:

- **Customizable:** Extensive customization options with [SASS/SCSS](https://vuetifyjs.com/features/sass-variables/) and [Default configuration](https://vuetifyjs.com/features/presets/) and [Blueprints](https://vuetifyjs.com/features/blueprints/)
- **Responsive Layout:** The default configuration of Vuetify components is responsive, allowing your application to adapt to different screen sizes.
- **Theme System:** A powerful color system that makes it easy to style your application with a consistent color palette.
- **Vite Support:** _Smaller_ bundle sizes with **automatic** tree-shaking
- **6 months** Long-term support for [Major releases](https://vuetifyjs.com/introduction/long-term-support/)
- **Internationalization:** 42+ supported languages

#### Browser Support

Vuetify supports all **modern browsers**, including Safari 13+ (using [polyfills](https://vuetifyjs.com/getting-started/browser-support)). Components are designed for a minimum width of _320px_.

### 🌎 Vuetify Ecosystem

#### Resources

<table>
  <thead>
    <tr>
      <th>Name</th>
      <th>Description</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <a href="https://github.com/vuetifyjs/awesome/">
          🕶️&nbsp;Vuetify&nbsp;Awesome
        </a>
      </td>
      <td>Awesome stuff built with Vuetify.</td>
    </tr>
    <tr>
      <td>
        <a href="https://bin.vuetifyjs.com/">
          🗑️&nbsp;Vuetify&nbsp;Bin
        </a>
      </td>
      <td>A pastebin for saving code snippets.</td>
    </tr>
    <tr>
      <td>
        <a href="https://bin.vuetifyjs.com/">
          🫧&nbsp;Vuetify&nbsp;Create
        </a>
      </td>
      <td>Scaffolding tools for creating new Vuetify projects.</td>
    </tr>
    <tr>
      <td>
        <a href="https://community.vuetifyjs.com/">
          💭&nbsp;Vuetify&nbsp;Discord
        </a>
      </td>
      <td>Our massive and inclusive Discord server where you can ask questions, share feedback, and connect with other Vuetify developers.</td>
    </tr>
    <tr>
      <td>
        <a href="https://github.com/vuetifyjs/eslint-config-vuetify">
          🧹&nbsp;Vuetify&nbsp;ESLint
        </a>
      </td>
      <td>An opinionated [ESLint config](https://github.com/vuetifyjs/eslint-config-vuetify) for styling and an [ESLint plugin](https://github.com/vuetifyjs/eslint-plugin-vuetify) for upgrading Vuetify version.</td>
    </tr>
    <tr>
      <td>
        <a href="https://issues.vuetifyjs.com/">
          🐛&nbsp;Vuetify&nbsp;Issues
        </a>
      </td>
      <td>A web application for reporting bugs and issues with Vuetify, Documentation, or one of our other packages.</td>
    </tr>
    <tr>
      <td>
        <a href="https://github.com/vuetifyjs/vuetify-loader">
          📦&nbsp;Vuetify&nbsp;Loader
        </a>
      </td>
      <td>A monorepo of compiler plugins for autoloading Vuetify components and configuring styles.</td>
    </tr>
    <tr>
      <td>
        <a href="https://github.com/vuetifyjs/mcp/">
          🧠&nbsp;Vuetify&nbsp;MCP
        </a>
      </td>
      <td>A Model Context Protocol server for developing with Vuetify and Agents.</td>
    </tr>
    <tr>
      <td>
        <a href="https://play.vuetifyjs.com/">
          🎮&nbsp;Vuetify&nbsp;Playground
        </a>
      </td>
      <td>A Vuetify 3 playground built using <a href="https://github.com/vuejs/repl">vuejs/repl</a> where you can play with our components.</td>
    </tr>
    <tr>
      <td>
        <a href="https://snips.vuetifyjs.com">
          ✂️&nbsp;Vuetify&nbsp;Snips
        </a>
      </td>
      <td>Pre-built code snippets for Vuetify components that you can use in your projects</td>
    </tr>
    <tr>
      <td>
        <a href="https://store.vuetifyjs.com/">
          🛒&nbsp;Vuetify&nbsp;Store
        </a>
      </td>
      <td>The official Vuetify Store where you can download free digital products, purchase pre-made themes, and more.</td>
    </tr>
  </tbody>
</table>

### 🙋‍♂️ Questions

For help and support questions, please use our [Discord community](https://community.vuetifyjs.com). This issue list of this repo is **exclusively** for bug reports and feature requests.

### 🐛 Issues

Use our [Issue generator](https://issues.vuetifyjs.com) to report bugs and request new features.

Please make sure to read the [Important Information](https://github.com/vuetifyjs/vuetify/blob/master/.github/CONTRIBUTING.md#important-information) before opening an issue. Issues not confirming to the guidelines may be closed immediately.

2️⃣ Vuetify 2 Support
Vuetify 2 is now End Of Life (EOL) and is no longer supported, even for security issues. Commercial support for this version is available from our partner, [HeroDevs](https://www.herodevs.com/support/vuetify-nes?utm_source=partnership&utm_medium=partnership&utm_campaign=partnership&utm_id=vuetify2).

### 📝 Changelog

Detailed changes for each release are documented in the [release notes](https://vuetifyjs.com/getting-started/release-notes/).

### 💁‍♂️ Contributing

Developers interested in contributing should read the [Code of Conduct](./CODE_OF_CONDUCT.md) and the [Contribution Guide](https://vuetifyjs.com/getting-started/contributing/).

> Please do **not** ask general questions in an issue. Issues are only to report bugs, suggest
  enhancements, or request new features. For general questions and discussions, ask in the [community chat](https://community.vuetifyjs.com/).

To help you get you familiar with our contribution process, we have a list of [good first issues](https://github.com/vuetifyjs/vuetify/labels/good%20first%20issue) that contain bugs which have a relatively limited scope. This is a great place to get started. If you have any questions, please join us on the [community chat](https://community.vuetifyjs.com).

We also have a list of [help wanted](https://github.com/vuetifyjs/vuetify/labels/help%20wanted) issues that you might want to check.

### 📑 License

Vuetify is available under the [MIT](http://opensource.org/licenses/MIT) software license.

Copyright (c) 2016-present Vuetify, LLC

---

This project exists thanks to all the people who contribute 😍!

<a href="https://github.com/vuetifyjs/vuetify/graphs/contributors"><img src="https://opencollective.com/vuetify/contributors.svg?width=890&button=false" /></a>
