// Types
import type { CalendarTimestamp } from './types.js';
export declare const VCalendarDaily: {
    new (...args: any[]): import("vue").CreateComponentPublicInstanceWithMixins<Readonly<import("vue").ExtractPropTypes<{
        start: {
            type: (DateConstructor | NumberConstructor | StringConstructor)[];
            validate: typeof import("./util/timestamp.js").validateTimestamp;
            default: () => string;
        };
        end: {
            type: (DateConstructor | NumberConstructor | StringConstructor)[];
            validate: typeof import("./util/timestamp.js").validateTimestamp;
        };
        weekdays: {
            type: import("vue").PropType<string | number[]>;
            default: () => number[];
            validate: typeof import("./util/timestamp.js").validateWeekdays;
        };
        weekdayFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        dayFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        locale: StringConstructor;
        now: {
            type: StringConstructor;
            validator: typeof import("./util/timestamp.js").validateTimestamp;
        };
        type: {
            type: import("vue").PropType<"4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week">;
            default: string;
        };
        maxDays: {
            type: NumberConstructor;
            default: number;
        };
        intervalHeight: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalWidth: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalMinutes: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        firstInterval: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        firstTime: {
            type: import("vue").PropType<import("./util/timestamp.js").VTime>;
            validate: typeof import("./util/timestamp.js").validateTime;
        };
        intervalCount: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        intervalStyle: {
            type: import("vue").PropType<(interval: CalendarTimestamp) => import("vue").StyleValue>;
            default: null;
        };
        showIntervalLabel: {
            type: import("vue").PropType<(interval: CalendarTimestamp) => boolean>;
            default: null;
        };
        color: StringConstructor;
        shortWeekdays: {
            type: BooleanConstructor;
            default: boolean;
        };
        shortIntervals: {
            type: BooleanConstructor;
            default: boolean;
        };
        hideHeader: BooleanConstructor;
    }>>, {
        times: {
            now: {
                date: string;
                time: string;
                year: number;
                month: number;
                day: number;
                weekday: number;
                hour: number;
                minute: number;
                hasDay: boolean;
                hasTime: boolean;
                past: boolean;
                present: boolean;
                future: boolean;
                category?: string | {
                    [x: string]: any;
                    name?: string | undefined;
                    categoryName?: string | undefined;
                } | undefined;
            };
            today: {
                date: string;
                time: string;
                year: number;
                month: number;
                day: number;
                weekday: number;
                hour: number;
                minute: number;
                hasDay: boolean;
                hasTime: boolean;
                past: boolean;
                present: boolean;
                future: boolean;
                category?: string | {
                    [x: string]: any;
                    name?: string | undefined;
                    categoryName?: string | undefined;
                } | undefined;
            };
        };
        locale: {
            name: string;
            decimalSeparator: import("vue").ShallowRef<string>;
            messages: import("vue").Ref<import("../../types.js").LocaleMessages, import("../../types.js").LocaleMessages>;
            current: import("vue").Ref<string, string>;
            fallback: import("vue").Ref<string, string>;
            t: (key: string, ...params: unknown[]) => string;
            n: (value: number) => string;
            provide: (props: import("../../types.js").LocaleOptions) => import("../../types.js").LocaleInstance;
            isRtl: import("vue").Ref<boolean, boolean>;
            rtl: import("vue").Ref<Record<string, boolean>, Record<string, boolean>>;
            rtlClasses: import("vue").Ref<string, string>;
        };
        parsedValue: import("vue").ComputedRef<CalendarTimestamp>;
        parsedWeekdays: import("vue").ComputedRef<number[]>;
        effectiveWeekdays: import("vue").ComputedRef<number[]>;
        weekdaySkips: import("vue").ComputedRef<number[]>;
        parsedStart: import("vue").ComputedRef<CalendarTimestamp>;
        parsedEnd: import("vue").ComputedRef<CalendarTimestamp>;
        dayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        weekdayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        getColorProps: (colors: {
            background?: import("../../composables/color.js").ColorValue;
            text?: import("../../composables/color.js").ColorValue;
        }) => {
            class: string[];
            style: import("vue").CSSProperties;
        };
        getRelativeClasses: (timestamp: CalendarTimestamp, outside?: boolean) => {
            "v-present": boolean;
            "v-past": boolean;
            "v-future": boolean;
            "v-outside": boolean;
        };
        getStartOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
        getEndOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
        getFormatter: (options: Intl.DateTimeFormatOptions) => import("./types.js").CalendarFormatter;
        scrollAreaRef: import("vue").ShallowRef<HTMLElement | undefined, HTMLElement | undefined>;
        parsedFirstInterval: import("vue").ComputedRef<number>;
        parsedIntervalMinutes: import("vue").ComputedRef<number>;
        parsedIntervalCount: import("vue").ComputedRef<number>;
        parsedIntervalHeight: import("vue").ComputedRef<number>;
        parsedFirstTime: import("vue").ComputedRef<number | false>;
        firstMinute: import("vue").ComputedRef<number>;
        bodyHeight: import("vue").ComputedRef<number>;
        days: import("vue").ComputedRef<CalendarTimestamp[]>;
        intervals: import("vue").ComputedRef<CalendarTimestamp[][]>;
        intervalFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        showIntervalLabelDefault: (interval: CalendarTimestamp) => boolean;
        intervalStyleDefault: (_interval: CalendarTimestamp) => import("vue").StyleValue;
        getTimestampAtEvent: (e: Event, day: CalendarTimestamp) => CalendarTimestamp;
        getSlotScope: (timestamp: CalendarTimestamp) => import("./types.js").CalendarDayBodySlotScope;
        scrollToTime: (time: import("./util/timestamp.js").VTime) => boolean;
        minutesToPixels: (minutes: number) => number;
        timeToY: (time: import("./util/timestamp.js").VTime, clamp?: boolean) => number | false;
        timeDelta: (time: import("./util/timestamp.js").VTime) => number | false;
        scrollPush: import("vue").Ref<number, number>;
        scrollArea: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
        pane: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
        init: () => void;
        onResize: () => void;
        getScrollPush: () => number;
    }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, import("vue").PublicProps, {
        start: string | number | Date;
        weekdays: string | number[];
        weekdayFormat: import("./types.js").CalendarFormatter;
        dayFormat: import("./types.js").CalendarFormatter;
        type: "4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week";
        maxDays: number;
        intervalHeight: string | number;
        intervalWidth: string | number;
        intervalMinutes: string | number;
        firstInterval: string | number;
        intervalCount: string | number;
        intervalFormat: import("./types.js").CalendarFormatter;
        intervalStyle: (interval: CalendarTimestamp) => import("vue").StyleValue;
        showIntervalLabel: (interval: CalendarTimestamp) => boolean;
        shortWeekdays: boolean;
        shortIntervals: boolean;
        hideHeader: boolean;
    }, true, {}, {}, import("vue").GlobalComponents, import("vue").GlobalDirectives, string, {}, any, import("vue").ComponentProvideOptions, {
        P: {};
        B: {};
        D: {};
        C: {};
        M: {};
        Defaults: {};
    }, Readonly<import("vue").ExtractPropTypes<{
        start: {
            type: (DateConstructor | NumberConstructor | StringConstructor)[];
            validate: typeof import("./util/timestamp.js").validateTimestamp;
            default: () => string;
        };
        end: {
            type: (DateConstructor | NumberConstructor | StringConstructor)[];
            validate: typeof import("./util/timestamp.js").validateTimestamp;
        };
        weekdays: {
            type: import("vue").PropType<string | number[]>;
            default: () => number[];
            validate: typeof import("./util/timestamp.js").validateWeekdays;
        };
        weekdayFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        dayFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        locale: StringConstructor;
        now: {
            type: StringConstructor;
            validator: typeof import("./util/timestamp.js").validateTimestamp;
        };
        type: {
            type: import("vue").PropType<"4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week">;
            default: string;
        };
        maxDays: {
            type: NumberConstructor;
            default: number;
        };
        intervalHeight: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalWidth: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalMinutes: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        firstInterval: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        firstTime: {
            type: import("vue").PropType<import("./util/timestamp.js").VTime>;
            validate: typeof import("./util/timestamp.js").validateTime;
        };
        intervalCount: {
            type: (NumberConstructor | StringConstructor)[];
            default: number;
            validate: typeof import("./util/timestamp.js").validateNumber;
        };
        intervalFormat: {
            type: import("vue").PropType<import("./types.js").CalendarFormatter>;
            default: null;
        };
        intervalStyle: {
            type: import("vue").PropType<(interval: CalendarTimestamp) => import("vue").StyleValue>;
            default: null;
        };
        showIntervalLabel: {
            type: import("vue").PropType<(interval: CalendarTimestamp) => boolean>;
            default: null;
        };
        color: StringConstructor;
        shortWeekdays: {
            type: BooleanConstructor;
            default: boolean;
        };
        shortIntervals: {
            type: BooleanConstructor;
            default: boolean;
        };
        hideHeader: BooleanConstructor;
    }>>, {
        times: {
            now: {
                date: string;
                time: string;
                year: number;
                month: number;
                day: number;
                weekday: number;
                hour: number;
                minute: number;
                hasDay: boolean;
                hasTime: boolean;
                past: boolean;
                present: boolean;
                future: boolean;
                category?: string | {
                    [x: string]: any;
                    name?: string | undefined;
                    categoryName?: string | undefined;
                } | undefined;
            };
            today: {
                date: string;
                time: string;
                year: number;
                month: number;
                day: number;
                weekday: number;
                hour: number;
                minute: number;
                hasDay: boolean;
                hasTime: boolean;
                past: boolean;
                present: boolean;
                future: boolean;
                category?: string | {
                    [x: string]: any;
                    name?: string | undefined;
                    categoryName?: string | undefined;
                } | undefined;
            };
        };
        locale: {
            name: string;
            decimalSeparator: import("vue").ShallowRef<string>;
            messages: import("vue").Ref<import("../../types.js").LocaleMessages, import("../../types.js").LocaleMessages>;
            current: import("vue").Ref<string, string>;
            fallback: import("vue").Ref<string, string>;
            t: (key: string, ...params: unknown[]) => string;
            n: (value: number) => string;
            provide: (props: import("../../types.js").LocaleOptions) => import("../../types.js").LocaleInstance;
            isRtl: import("vue").Ref<boolean, boolean>;
            rtl: import("vue").Ref<Record<string, boolean>, Record<string, boolean>>;
            rtlClasses: import("vue").Ref<string, string>;
        };
        parsedValue: import("vue").ComputedRef<CalendarTimestamp>;
        parsedWeekdays: import("vue").ComputedRef<number[]>;
        effectiveWeekdays: import("vue").ComputedRef<number[]>;
        weekdaySkips: import("vue").ComputedRef<number[]>;
        parsedStart: import("vue").ComputedRef<CalendarTimestamp>;
        parsedEnd: import("vue").ComputedRef<CalendarTimestamp>;
        dayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        weekdayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        getColorProps: (colors: {
            background?: import("../../composables/color.js").ColorValue;
            text?: import("../../composables/color.js").ColorValue;
        }) => {
            class: string[];
            style: import("vue").CSSProperties;
        };
        getRelativeClasses: (timestamp: CalendarTimestamp, outside?: boolean) => {
            "v-present": boolean;
            "v-past": boolean;
            "v-future": boolean;
            "v-outside": boolean;
        };
        getStartOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
        getEndOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
        getFormatter: (options: Intl.DateTimeFormatOptions) => import("./types.js").CalendarFormatter;
        scrollAreaRef: import("vue").ShallowRef<HTMLElement | undefined, HTMLElement | undefined>;
        parsedFirstInterval: import("vue").ComputedRef<number>;
        parsedIntervalMinutes: import("vue").ComputedRef<number>;
        parsedIntervalCount: import("vue").ComputedRef<number>;
        parsedIntervalHeight: import("vue").ComputedRef<number>;
        parsedFirstTime: import("vue").ComputedRef<number | false>;
        firstMinute: import("vue").ComputedRef<number>;
        bodyHeight: import("vue").ComputedRef<number>;
        days: import("vue").ComputedRef<CalendarTimestamp[]>;
        intervals: import("vue").ComputedRef<CalendarTimestamp[][]>;
        intervalFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
        showIntervalLabelDefault: (interval: CalendarTimestamp) => boolean;
        intervalStyleDefault: (_interval: CalendarTimestamp) => import("vue").StyleValue;
        getTimestampAtEvent: (e: Event, day: CalendarTimestamp) => CalendarTimestamp;
        getSlotScope: (timestamp: CalendarTimestamp) => import("./types.js").CalendarDayBodySlotScope;
        scrollToTime: (time: import("./util/timestamp.js").VTime) => boolean;
        minutesToPixels: (minutes: number) => number;
        timeToY: (time: import("./util/timestamp.js").VTime, clamp?: boolean) => number | false;
        timeDelta: (time: import("./util/timestamp.js").VTime) => number | false;
        scrollPush: import("vue").Ref<number, number>;
        scrollArea: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
        pane: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
        init: () => void;
        onResize: () => void;
        getScrollPush: () => number;
    }, {}, {}, {}, {
        start: string | number | Date;
        weekdays: string | number[];
        weekdayFormat: import("./types.js").CalendarFormatter;
        dayFormat: import("./types.js").CalendarFormatter;
        type: "4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week";
        maxDays: number;
        intervalHeight: string | number;
        intervalWidth: string | number;
        intervalMinutes: string | number;
        firstInterval: string | number;
        intervalCount: string | number;
        intervalFormat: import("./types.js").CalendarFormatter;
        intervalStyle: (interval: CalendarTimestamp) => import("vue").StyleValue;
        showIntervalLabel: (interval: CalendarTimestamp) => boolean;
        shortWeekdays: boolean;
        shortIntervals: boolean;
        hideHeader: boolean;
    }>;
    __isFragment?: undefined;
    __isTeleport?: undefined;
    __isSuspense?: undefined;
} & import("vue").ComponentOptionsBase<Readonly<import("vue").ExtractPropTypes<{
    start: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
        default: () => string;
    };
    end: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
    };
    weekdays: {
        type: import("vue").PropType<string | number[]>;
        default: () => number[];
        validate: typeof import("./util/timestamp.js").validateWeekdays;
    };
    weekdayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    dayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    locale: StringConstructor;
    now: {
        type: StringConstructor;
        validator: typeof import("./util/timestamp.js").validateTimestamp;
    };
    type: {
        type: import("vue").PropType<"4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week">;
        default: string;
    };
    maxDays: {
        type: NumberConstructor;
        default: number;
    };
    intervalHeight: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalWidth: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalMinutes: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstInterval: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstTime: {
        type: import("vue").PropType<import("./util/timestamp.js").VTime>;
        validate: typeof import("./util/timestamp.js").validateTime;
    };
    intervalCount: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    intervalStyle: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => import("vue").StyleValue>;
        default: null;
    };
    showIntervalLabel: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => boolean>;
        default: null;
    };
    color: StringConstructor;
    shortWeekdays: {
        type: BooleanConstructor;
        default: boolean;
    };
    shortIntervals: {
        type: BooleanConstructor;
        default: boolean;
    };
    hideHeader: BooleanConstructor;
}>>, {
    times: {
        now: {
            date: string;
            time: string;
            year: number;
            month: number;
            day: number;
            weekday: number;
            hour: number;
            minute: number;
            hasDay: boolean;
            hasTime: boolean;
            past: boolean;
            present: boolean;
            future: boolean;
            category?: string | {
                [x: string]: any;
                name?: string | undefined;
                categoryName?: string | undefined;
            } | undefined;
        };
        today: {
            date: string;
            time: string;
            year: number;
            month: number;
            day: number;
            weekday: number;
            hour: number;
            minute: number;
            hasDay: boolean;
            hasTime: boolean;
            past: boolean;
            present: boolean;
            future: boolean;
            category?: string | {
                [x: string]: any;
                name?: string | undefined;
                categoryName?: string | undefined;
            } | undefined;
        };
    };
    locale: {
        name: string;
        decimalSeparator: import("vue").ShallowRef<string>;
        messages: import("vue").Ref<import("../../types.js").LocaleMessages, import("../../types.js").LocaleMessages>;
        current: import("vue").Ref<string, string>;
        fallback: import("vue").Ref<string, string>;
        t: (key: string, ...params: unknown[]) => string;
        n: (value: number) => string;
        provide: (props: import("../../types.js").LocaleOptions) => import("../../types.js").LocaleInstance;
        isRtl: import("vue").Ref<boolean, boolean>;
        rtl: import("vue").Ref<Record<string, boolean>, Record<string, boolean>>;
        rtlClasses: import("vue").Ref<string, string>;
    };
    parsedValue: import("vue").ComputedRef<CalendarTimestamp>;
    parsedWeekdays: import("vue").ComputedRef<number[]>;
    effectiveWeekdays: import("vue").ComputedRef<number[]>;
    weekdaySkips: import("vue").ComputedRef<number[]>;
    parsedStart: import("vue").ComputedRef<CalendarTimestamp>;
    parsedEnd: import("vue").ComputedRef<CalendarTimestamp>;
    dayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
    weekdayFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
    getColorProps: (colors: {
        background?: import("../../composables/color.js").ColorValue;
        text?: import("../../composables/color.js").ColorValue;
    }) => {
        class: string[];
        style: import("vue").CSSProperties;
    };
    getRelativeClasses: (timestamp: CalendarTimestamp, outside?: boolean) => {
        "v-present": boolean;
        "v-past": boolean;
        "v-future": boolean;
        "v-outside": boolean;
    };
    getStartOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
    getEndOfWeek: (timestamp: CalendarTimestamp) => CalendarTimestamp;
    getFormatter: (options: Intl.DateTimeFormatOptions) => import("./types.js").CalendarFormatter;
    scrollAreaRef: import("vue").ShallowRef<HTMLElement | undefined, HTMLElement | undefined>;
    parsedFirstInterval: import("vue").ComputedRef<number>;
    parsedIntervalMinutes: import("vue").ComputedRef<number>;
    parsedIntervalCount: import("vue").ComputedRef<number>;
    parsedIntervalHeight: import("vue").ComputedRef<number>;
    parsedFirstTime: import("vue").ComputedRef<number | false>;
    firstMinute: import("vue").ComputedRef<number>;
    bodyHeight: import("vue").ComputedRef<number>;
    days: import("vue").ComputedRef<CalendarTimestamp[]>;
    intervals: import("vue").ComputedRef<CalendarTimestamp[][]>;
    intervalFormatter: import("vue").ComputedRef<import("./types.js").CalendarFormatter>;
    showIntervalLabelDefault: (interval: CalendarTimestamp) => boolean;
    intervalStyleDefault: (_interval: CalendarTimestamp) => import("vue").StyleValue;
    getTimestampAtEvent: (e: Event, day: CalendarTimestamp) => CalendarTimestamp;
    getSlotScope: (timestamp: CalendarTimestamp) => import("./types.js").CalendarDayBodySlotScope;
    scrollToTime: (time: import("./util/timestamp.js").VTime) => boolean;
    minutesToPixels: (minutes: number) => number;
    timeToY: (time: import("./util/timestamp.js").VTime, clamp?: boolean) => number | false;
    timeDelta: (time: import("./util/timestamp.js").VTime) => number | false;
    scrollPush: import("vue").Ref<number, number>;
    scrollArea: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
    pane: import("vue").Ref<HTMLElement | undefined, HTMLElement | undefined>;
    init: () => void;
    onResize: () => void;
    getScrollPush: () => number;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, {
    start: string | number | Date;
    weekdays: string | number[];
    weekdayFormat: import("./types.js").CalendarFormatter;
    dayFormat: import("./types.js").CalendarFormatter;
    type: "4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week";
    maxDays: number;
    intervalHeight: string | number;
    intervalWidth: string | number;
    intervalMinutes: string | number;
    firstInterval: string | number;
    intervalCount: string | number;
    intervalFormat: import("./types.js").CalendarFormatter;
    intervalStyle: (interval: CalendarTimestamp) => import("vue").StyleValue;
    showIntervalLabel: (interval: CalendarTimestamp) => boolean;
    shortWeekdays: boolean;
    shortIntervals: boolean;
    hideHeader: boolean;
}, {}, string, {}, import("vue").GlobalComponents, import("vue").GlobalDirectives, string, import("vue").ComponentProvideOptions> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps & import("../../util/index.js").FilterPropsOptions<{
    start: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
        default: () => string;
    };
    end: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
    };
    weekdays: {
        type: import("vue").PropType<string | number[]>;
        default: () => number[];
        validate: typeof import("./util/timestamp.js").validateWeekdays;
    };
    weekdayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    dayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    locale: StringConstructor;
    now: {
        type: StringConstructor;
        validator: typeof import("./util/timestamp.js").validateTimestamp;
    };
    type: {
        type: import("vue").PropType<"4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week">;
        default: string;
    };
    maxDays: {
        type: NumberConstructor;
        default: number;
    };
    intervalHeight: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalWidth: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalMinutes: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstInterval: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstTime: {
        type: import("vue").PropType<import("./util/timestamp.js").VTime>;
        validate: typeof import("./util/timestamp.js").validateTime;
    };
    intervalCount: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    intervalStyle: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => import("vue").StyleValue>;
        default: null;
    };
    showIntervalLabel: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => boolean>;
        default: null;
    };
    color: StringConstructor;
    shortWeekdays: {
        type: BooleanConstructor;
        default: boolean;
    };
    shortIntervals: {
        type: BooleanConstructor;
        default: boolean;
    };
    hideHeader: BooleanConstructor;
}, import("vue").ExtractPropTypes<{
    start: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
        default: () => string;
    };
    end: {
        type: (DateConstructor | NumberConstructor | StringConstructor)[];
        validate: typeof import("./util/timestamp.js").validateTimestamp;
    };
    weekdays: {
        type: import("vue").PropType<string | number[]>;
        default: () => number[];
        validate: typeof import("./util/timestamp.js").validateWeekdays;
    };
    weekdayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    dayFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    locale: StringConstructor;
    now: {
        type: StringConstructor;
        validator: typeof import("./util/timestamp.js").validateTimestamp;
    };
    type: {
        type: import("vue").PropType<"4day" | "category" | "custom-daily" | "custom-weekly" | "day" | "month" | "week">;
        default: string;
    };
    maxDays: {
        type: NumberConstructor;
        default: number;
    };
    intervalHeight: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalWidth: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalMinutes: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstInterval: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    firstTime: {
        type: import("vue").PropType<import("./util/timestamp.js").VTime>;
        validate: typeof import("./util/timestamp.js").validateTime;
    };
    intervalCount: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
        validate: typeof import("./util/timestamp.js").validateNumber;
    };
    intervalFormat: {
        type: import("vue").PropType<import("./types.js").CalendarFormatter>;
        default: null;
    };
    intervalStyle: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => import("vue").StyleValue>;
        default: null;
    };
    showIntervalLabel: {
        type: import("vue").PropType<(interval: CalendarTimestamp) => boolean>;
        default: null;
    };
    color: StringConstructor;
    shortWeekdays: {
        type: BooleanConstructor;
        default: boolean;
    };
    shortIntervals: {
        type: BooleanConstructor;
        default: boolean;
    };
    hideHeader: BooleanConstructor;
}>>;
export type VCalendarDaily = InstanceType<typeof VCalendarDaily>;
