<?php Theme::set('pageName', $category->name) ?>

<div class="section">
    <form action="<?php echo e($category->url); ?>" method="GET">
        <?php if(request()->has('q')): ?>
            <input type="hidden" name="q" value="<?php echo e(BaseHelper::stringify(request()->query('q'))); ?>">
        <?php endif; ?>

        <?php if(request()->has('categories')): ?>
            <input type="hidden" name="categories[]" value="<?php echo e(Arr::first(request()->query('categories', []))); ?>">
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="row align-items-center mb-4 pb-1">
                        <div class="col-12">
                            <div class="product_header">
                                <?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.includes.sort', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row shop_container grid">
                        <?php if($products->count() > 0): ?>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 col-6">
                                    <?php echo Theme::partial('product-item-grid', compact('product')); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="mt-3 justify-content-center pagination_style1">
                                <?php echo $products->appends(request()->query())->onEachSide(1)->links(); ?>

                            </div>
                        <?php else: ?>
                            <br>
                            <div class="col-12 text-center"><?php echo e(__('No products!')); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-3 order-lg-first mt-4 pt-2 mt-lg-0 pt-lg-0">
                    <div class="sidebar">
                        <?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.includes.filters', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<!-- END SECTION SHOP -->
<?php /**PATH /home/idevelop/public_html/smart.idevelopgroup.com/platform/themes/shopwise/views/ecommerce/product-category.blade.php ENDPATH**/ ?>