<?php Theme::set('pageName', __('Shopping Cart')); ?>

<div class="section">
    <div class="container">
        <?php if(Cart::instance('cart')->count() > 0): ?>
            <?php if(session()->has('success_msg')): ?>
                <div class="alert alert-success">
                    <span><?php echo e(session('success_msg')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(session()->has('error_msg')): ?>
                <div class="alert alert-warning">
                    <span><?php echo e(session('error_msg')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(isset($errors) && count($errors->all()) > 0): ?>
                <div class="alert alert-warning">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($error); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <form class="form--shopping-cart" method="post" action="<?php echo e(route('public.cart.update')); ?>">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-12">
                        <div class="table-responsive shop_cart_table">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th class="product-thumbnail"><?php echo e(__('Image')); ?></th>
                                    <th class="product-name"><?php echo e(__('Product')); ?></th>
                                    <th class="product-price"><?php echo e(__('Price')); ?></th>
                                    <th class="product-quantity"><?php echo e(__('Quantity')); ?></th>
                                    <th class="product-subtotal"><?php echo e(__('Total')); ?></th>
                                    <th class="product-remove"><?php echo e(__('Remove')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(isset($products) && $products): ?>
                                    <?php $__currentLoopData = Cart::instance('cart')->content(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $product = $products->where('id', $cartItem->id)->first();
                                        ?>

                                        <?php if(!empty($product)): ?>
                                            <tr>
                                                <td class="product-thumbnail">
                                                    <a href="<?php echo e($product->original_product->url); ?>">
                                                        <img src="<?php echo e(RvMedia::getImageUrl($cartItem->options->image, 'thumb', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($product->name); ?>" loading="lazy" />
                                                    </a>
                                                </td>
                                                <td class="product-name" data-title="<?php echo e(__('Product')); ?>">
                                                    <a href="<?php echo e($product->original_product->url); ?>" title="<?php echo e($product->name); ?>"><?php echo e($product->name); ?>  <?php if($product->isOutOfStock()): ?> <span class="stock-status-label">(<?php echo $product->stock_status_html; ?>)</span> <?php endif; ?></a>
                                                    <p style="margin-bottom: 0">
                                                        <small><?php echo e($cartItem->options['attributes'] ?? ''); ?></small>
                                                    </p>

                                                    <?php if(!empty($cartItem->options['options'])): ?>
                                                        <?php echo render_product_options_info($cartItem->options['options'], $product, true); ?>

                                                    <?php endif; ?>

                                                    <?php if(!empty($cartItem->options['extras']) && is_array($cartItem->options['extras'])): ?>
                                                        <?php $__currentLoopData = $cartItem->options['extras']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!empty($option['key']) && !empty($option['value'])): ?>
                                                                <p style="margin-bottom: 0;"><small><?php echo e($option['key']); ?>: <strong> <?php echo e($option['value']); ?></strong></small></p>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="product-price" data-title="<?php echo e(__('Price')); ?>">
                                                    <div class="product__price <?php if($product->front_sale_price != $product->price): ?> sale <?php endif; ?>">
                                                        <span><?php echo e(format_price($cartItem->price)); ?></span>
                                                        <?php if($product->front_sale_price != $product->price): ?>
                                                            <small><del><?php echo e(format_price($product->price)); ?></del></small>
                                                        <?php endif; ?>
                                                    </div>
                                                    <input type="hidden" name="items[<?php echo e($key); ?>][rowId]" value="<?php echo e($cartItem->rowId); ?>">
                                                </td>
                                                <td class="product-quantity" data-title="<?php echo e(__('Quantity')); ?>">
                                                    <div class="quantity">
                                                        <input type="button" value="-" class="minus">
                                                        <input type="text" value="<?php echo e($cartItem->qty); ?>" title="Qty" class="qty" size="4" name="items[<?php echo e($key); ?>][values][qty]">
                                                        <input type="button" value="+" class="plus">
                                                    </div>
                                                </td>
                                                <td class="product-subtotal" data-title="<?php echo e(__('Total')); ?>"><?php echo e(format_price($cartItem->price * $cartItem->qty)); ?></td>
                                                <td class="product-remove" data-title="<?php echo e(__('Remove')); ?>"><a href="<?php echo e(route('public.cart.remove', $cartItem->rowId)); ?>" class="remove-cart-button"><i class="ti-close"></i></a></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="6" class="px-0">
                                        <div class="row no-gutters align-items-center">
                                            <div class="col-lg-4 col-md-6 mb-3 mb-md-0">
                                                <?php if(!session()->has('applied_coupon_code')): ?>
                                                    <div class="coupon field_form input-group form-coupon-wrapper">
                                                        <input type="text" name="coupon_code" value="<?php echo e(old('coupon_code')); ?>" class="form-control form-control-sm coupon-code" placeholder="<?php echo e(__('Enter Coupon Code...')); ?>">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-fill-out btn-sm btn-apply-coupon-code" type="button" data-url="<?php echo e(route('public.coupon.apply')); ?>"><?php echo e(__('Apply Coupon')); ?></button>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if(session('applied_coupon_code')): ?>
                                                    <div class="mt-2 text-left">
                                                        <small><strong><?php echo e(__('Coupon code: :code', ['code' => session('applied_coupon_code')])); ?></strong> <a class="btn-remove-coupon-code text-danger" data-url="<?php echo e(route('public.coupon.remove')); ?>" href="javascript:void(0)"><i class="ti-close"></i></a></small>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="coupon-error-msg text-left">
                                                    <small><span class="text-danger"></span></small>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="medium_divider"></div>
                        <div class="divider center_icon"><i class="ti-shopping-cart-full"></i></div>
                        <div class="medium_divider"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="border p-3 p-md-4">
                            <div class="heading_s1 mb-3">
                                <h6><?php echo e(__('Cart Totals')); ?></h6>
                            </div>
                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        <td class="cart_total_label"><?php echo e(__('Subtotal')); ?></td>
                                        <td class="cart_total_amount"><?php echo e(format_price(Cart::instance('cart')->rawSubTotal())); ?></td>
                                    </tr>
                                    <?php if($couponDiscountAmount > 0): ?>
                                        <tr>
                                            <td class="cart_total_label"><?php echo e(__('Coupon code discount amount')); ?></td>
                                            <td class="cart_total_amount"><?php echo e(format_price($couponDiscountAmount)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php if($promotionDiscountAmount): ?>
                                        <tr>
                                            <td class="cart_total_label"><?php echo e(__('Discount promotion')); ?></td>
                                            <td class="cart_total_amount"><?php echo e(format_price($promotionDiscountAmount)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td class="cart_total_label"><?php echo e(__('Tax')); ?></td>
                                        <td class="cart_total_amount"><?php echo e(format_price(Cart::instance('cart')->rawTax())); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="cart_total_label"><?php echo e(__('Total')); ?> (<?php echo e(__('Shipping fees not included')); ?>)</td>
                                        <td class="cart_total_amount"><strong><?php echo e(format_price(Cart::instance('cart')->rawTotal() - $promotionDiscountAmount - $couponDiscountAmount)); ?></strong></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <button type="submit" class="btn btn-fill-out" name="checkout"><?php echo e(__('Proceed To CheckOut')); ?></button>
                        </div>
                    </div>
                </div>
            </form>

            <?php if(count($crossSellProducts) > 0): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="small_divider"></div>
                        <div class="divider"></div>
                        <div class="medium_divider"></div>
                    </div>
                </div>
                <div class="row shop_container grid">
                    <div class="col-12">
                        <div class="heading_s1">
                            <h3><?php echo e(__('Customers who bought this item also bought')); ?></h3>
                        </div>
                        <div class="releted_product_slider carousel_slider owl-carousel owl-theme" data-margin="20" data-responsive='{"0":{"items": "1"}, "481":{"items": "2"}, "768":{"items": "3"}, "1199":{"items": "4"}}'>
                            <?php $__currentLoopData = $crossSellProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crossSellProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo Theme::partial('product-item-grid', ['product' => $crossSellProduct]); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <p class="text-center"><?php echo e(__('Your cart is empty!')); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/idevelop/public_html/smart.idevelopgroup.com/platform/themes/shopwise/views/ecommerce/cart.blade.php ENDPATH**/ ?>